/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.WindowRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexWindow;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowRel
extends WindowRelBase {
    public WindowRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelDataType rowType, List<WindowRelBase.Window> windows) {
        super(cluster, traits, child, rowType, windows);
    }

    @Override
    public WindowRel copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new WindowRel(this.getCluster(), traitSet, WindowRel.sole(inputs), this.rowType, (List<WindowRelBase.Window>)this.windows);
    }

    public static RelNode create(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, final RexProgram program, RelDataType outRowType) {
        LinkedListMultimap windowMap = LinkedListMultimap.create();
        for (RexNode agg : program.getExprList()) {
            if (!(agg instanceof RexOver)) continue;
            WindowRel.addWindows((Multimap<WindowKey, RexOver>)windowMap, (RexOver)agg);
        }
        final HashMap<RexOver, WindowRelBase.RexWinAggCall> aggMap = new HashMap<RexOver, WindowRelBase.RexWinAggCall>();
        ArrayList<WindowRelBase.Window> windowList = new ArrayList<WindowRelBase.Window>();
        for (Map.Entry entry : windowMap.asMap().entrySet()) {
            WindowKey windowKey = (WindowKey)entry.getKey();
            ArrayList<WindowRelBase.RexWinAggCall> aggCalls = new ArrayList<WindowRelBase.RexWinAggCall>();
            for (RexOver over : (Collection)entry.getValue()) {
                WindowRelBase.RexWinAggCall aggCall = new WindowRelBase.RexWinAggCall(over.getAggOperator(), over.getType(), WindowRel.toInputRefs((List<RexNode>)over.operands), aggMap.size());
                aggCalls.add(aggCall);
                aggMap.put(over, aggCall);
            }
            windowList.add(new WindowRelBase.Window(windowKey.groupSet, windowKey.isRows, windowKey.lowerBound, windowKey.upperBound, windowKey.orderKeys, aggCalls));
        }
        final ArrayList<WindowRelBase.RexWinAggCall> flattenedAggCallList = new ArrayList<WindowRelBase.RexWinAggCall>();
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>(child.getRowType().getFieldList());
        int offset = fieldList.size();
        HashMap<Integer, String> fieldNames = new HashMap<Integer, String>();
        for (Ord ref : Ord.zip(program.getProjectList())) {
            int index = ((RexLocalRef)ref.e).getIndex();
            if (index < offset) continue;
            fieldNames.put(index - offset, outRowType.getFieldNames().get(ref.i));
        }
        for (Ord window : Ord.zip(windowList)) {
            for (Ord over : Ord.zip(((WindowRelBase.Window)window.e).aggCalls)) {
                String name = (String)fieldNames.get(over.i);
                if (name == null || name.startsWith("$")) {
                    name = "w" + window.i + "$o" + over.i;
                }
                fieldList.add((RelDataTypeField)((Object)Pair.of(name, ((WindowRelBase.RexWinAggCall)over.e).getType())));
                flattenedAggCallList.add((WindowRelBase.RexWinAggCall)over.e);
            }
        }
        final RelDataType intermediateRowType = cluster.getTypeFactory().createStructType(fieldList);
        final int inputFieldCount = child.getRowType().getFieldCount();
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitOver(RexOver over) {
                WindowRelBase.RexWinAggCall aggCall = (WindowRelBase.RexWinAggCall)aggMap.get(over);
                if (!$assertionsDisabled && aggCall == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !RelOptUtil.eq("over", over.getType(), "aggCall", aggCall.getType(), true)) {
                    throw new AssertionError();
                }
                int aggCallIndex = flattenedAggCallList.indexOf(aggCall);
                if (!$assertionsDisabled && aggCallIndex < 0) {
                    throw new AssertionError();
                }
                int index = inputFieldCount + aggCallIndex;
                if (!$assertionsDisabled && !RelOptUtil.eq("over", over.getType(), "intermed", intermediateRowType.getFieldList().get(index).getType(), true)) {
                    throw new AssertionError();
                }
                return new RexInputRef(index, over.getType());
            }

            public RexNode visitLocalRef(RexLocalRef localRef) {
                int index = localRef.getIndex();
                if (index < inputFieldCount) {
                    return localRef;
                }
                return new RexLocalRef(flattenedAggCallList.size() + index, localRef.getType());
            }
        };
        WindowRel window = new WindowRel(cluster, traitSet, child, intermediateRowType, windowList);
        return CalcRel.createProject((RelNode)window, (List<RexNode>)new AbstractList<RexNode>(){

            @Override
            public RexNode get(int index) {
                RexLocalRef ref = program.getProjectList().get(index);
                return new RexInputRef(ref.getIndex(), ref.getType());
            }

            @Override
            public int size() {
                return program.getProjectList().size();
            }
        }, outRowType.getFieldNames());
    }

    private static List<RexNode> toInputRefs(final List<RexNode> operands) {
        return new AbstractList<RexNode>(){

            @Override
            public int size() {
                return operands.size();
            }

            @Override
            public RexNode get(int index) {
                RexNode operand = (RexNode)operands.get(index);
                if (!$assertionsDisabled && !(operand instanceof RexLocalRef)) {
                    throw new AssertionError();
                }
                RexLocalRef ref = (RexLocalRef)operand;
                return new RexInputRef(ref.getIndex(), ref.getType());
            }
        };
    }

    private static void addWindows(Multimap<WindowKey, RexOver> windowMap, RexOver over) {
        RexWindow aggWindow = over.getWindow();
        RelCollation orderKeys = WindowRel.getCollation(aggWindow.orderKeys);
        BitSet groupSet = BitSets.of(WindowRel.getProjectOrdinals(aggWindow.partitionKeys));
        WindowKey windowKey = new WindowKey(groupSet, orderKeys, aggWindow.isRows(), aggWindow.getLowerBound(), aggWindow.getUpperBound());
        windowMap.put((Object)windowKey, (Object)over);
    }

    private static class WindowKey {
        private final BitSet groupSet;
        private final RelCollation orderKeys;
        private final boolean isRows;
        private final SqlNode lowerBound;
        private final SqlNode upperBound;

        public WindowKey(BitSet groupSet, RelCollation orderKeys, boolean isRows, SqlNode lowerBound, SqlNode upperBound) {
            this.groupSet = groupSet;
            this.orderKeys = orderKeys;
            this.isRows = isRows;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public int hashCode() {
            return Util.hashV(this.groupSet, this.orderKeys, this.isRows, this.lowerBound, this.upperBound);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof WindowKey && this.groupSet.equals(((WindowKey)obj).groupSet) && this.orderKeys.equals(((WindowKey)obj).orderKeys) && Util.equal(this.lowerBound, ((WindowKey)obj).lowerBound) && Util.equal(this.upperBound, ((WindowKey)obj).upperBound) && this.isRows == ((WindowKey)obj).isRows;
        }
    }
}

