/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Permutation;
import org.eigenbase.util.mapping.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CalcRel
extends CalcRelBase {
    public static final boolean DEPRECATE_PROJECT_AND_FILTER = false;

    public CalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelDataType rowType, RexProgram program, List<RelCollation> collationList) {
        super(cluster, traits, child, rowType, program, collationList);
    }

    @Override
    public CalcRelBase copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        return new CalcRel(this.getCluster(), traitSet, child, program.getOutputRowType(), program, collationList);
    }

    public static RelNode createProject(RelNode child, List<RexNode> exprList, List<String> fieldNameList) {
        return CalcRel.createProject(child, exprList, fieldNameList, false);
    }

    public static RelNode createProject(RelNode child, List<Pair<RexNode, String>> projectList, boolean optimize) {
        return CalcRel.createProject(child, Pair.left(projectList), Pair.right(projectList), optimize);
    }

    public static RelNode createProject(RelNode child, List<Integer> posList) {
        return RelFactories.createProject(RelFactories.DEFAULT_PROJECT_FACTORY, child, posList);
    }

    public static RelNode createProject(RelNode child, List<RexNode> exprs, List<String> fieldNames, boolean optimize) {
        RelOptCluster cluster = child.getCluster();
        RexProgram program = RexProgram.create(child.getRowType(), exprs, null, fieldNames, cluster.getRexBuilder());
        List<RelCollation> collationList = program.getCollations(child.getCollationList());
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), exprs, fieldNames == null ? null : SqlValidatorUtil.uniquify(fieldNames, SqlValidatorUtil.F_SUGGESTER));
        if (optimize && RemoveTrivialProjectRule.isIdentity(exprs, rowType, child.getRowType())) {
            return child;
        }
        return new ProjectRel(cluster, cluster.traitSetOf(collationList.isEmpty() ? RelCollationImpl.EMPTY : collationList.get(0)), child, exprs, rowType, 1);
    }

    public static RelNode createFilter(RelNode child, RexNode condition) {
        return new FilterRel(child.getCluster(), child, condition);
    }

    public static RelNode createRename(RelNode rel, List<String> fieldNames) {
        final List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        assert (fieldNames.size() == fields.size());
        AbstractList<Pair<RexNode, String>> refs = new AbstractList<Pair<RexNode, String>>(){

            @Override
            public int size() {
                return fields.size();
            }

            @Override
            public Pair<RexNode, String> get(int index) {
                return RexInputRef.of2(index, fields);
            }
        };
        return CalcRel.createProject(rel, (List<Pair<RexNode, String>>)refs, true);
    }

    @Override
    public void collectVariablesUsed(Set<String> variableSet) {
        RelOptUtil.VariableUsedVisitor vuv = new RelOptUtil.VariableUsedVisitor();
        for (RexNode expr : this.program.getExprList()) {
            expr.accept(vuv);
        }
        variableSet.addAll(vuv.variables);
    }

    public static RelNode permute(RelNode rel, Permutation permutation, List<String> fieldNames) {
        Permutation permutation1;
        CalcRel calcRel;
        Permutation permutation12;
        if (permutation.isIdentity()) {
            return rel;
        }
        if (rel instanceof CalcRel && (permutation12 = (calcRel = (CalcRel)rel).getProgram().getPermutation()) != null) {
            Permutation permutation2 = permutation.product(permutation12);
            return CalcRel.permute(rel, permutation2, null);
        }
        if (rel instanceof ProjectRel && (permutation1 = ((ProjectRel)rel).getPermutation()) != null) {
            Permutation permutation2 = permutation.product(permutation1);
            return CalcRel.permute(rel, permutation2, null);
        }
        ArrayList<RelDataType> outputTypeList = new ArrayList<RelDataType>();
        ArrayList<String> outputNameList = new ArrayList<String>();
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        ArrayList<RexLocalRef> projectRefList = new ArrayList<RexLocalRef>();
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        int i = 0;
        while (i < permutation.getTargetCount()) {
            int target = permutation.getTarget(i);
            RelDataTypeField targetField = fields.get(target);
            outputTypeList.add(targetField.getType());
            outputNameList.add(fieldNames == null || fieldNames.size() <= i || fieldNames.get(i) == null ? targetField.getName() : fieldNames.get(i));
            exprList.add(rel.getCluster().getRexBuilder().makeInputRef(fields.get(i).getType(), i));
            int source = permutation.getSource(i);
            projectRefList.add(new RexLocalRef(source, fields.get(source).getType()));
            ++i;
        }
        RexProgram program = new RexProgram(rel.getRowType(), exprList, projectRefList, null, rel.getCluster().getTypeFactory().createStructType(outputTypeList, outputNameList));
        return new CalcRel(rel.getCluster(), rel.getTraitSet(), rel, program.getOutputRowType(), program, Collections.<RelCollation>emptyList());
    }

    public static RelNode projectMapping(RelNode rel, Mapping mapping, List<String> fieldNames) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return rel;
        }
        ArrayList<RelDataType> outputTypeList = new ArrayList<RelDataType>();
        ArrayList<String> outputNameList = new ArrayList<String>();
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        ArrayList<RexLocalRef> projectRefList = new ArrayList<RexLocalRef>();
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        int i = 0;
        while (i < fields.size()) {
            exprList.add(rexBuilder.makeInputRef(rel, i));
            ++i;
        }
        i = 0;
        while (i < mapping.getTargetCount()) {
            int source = mapping.getSource(i);
            RelDataTypeField sourceField = fields.get(source);
            outputTypeList.add(sourceField.getType());
            outputNameList.add(fieldNames == null || fieldNames.size() <= i || fieldNames.get(i) == null ? sourceField.getName() : fieldNames.get(i));
            projectRefList.add(new RexLocalRef(source, sourceField.getType()));
            ++i;
        }
        RexProgram program = new RexProgram(rel.getRowType(), exprList, projectRefList, null, rel.getCluster().getTypeFactory().createStructType(outputTypeList, outputNameList));
        return new CalcRel(rel.getCluster(), rel.getTraitSet(), rel, program.getOutputRowType(), program, Collections.<RelCollation>emptyList());
    }
}

