/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompatibleGuava11 {
    private CompatibleGuava11() {
    }

    public static <K, V> Map<K, V> asMap(Set<K> set, Function<? super K, V> function) {
        return new AsMapView<K, V>(set, function);
    }

    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= set.remove(iterator.next());
        }
        return changed;
    }

    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            Iterator<?> setIterator = set.iterator();
            boolean changed = false;
            while (setIterator.hasNext()) {
                if (!collection.contains(setIterator.next())) continue;
                changed = true;
                setIterator.remove();
            }
            return changed;
        }
        return CompatibleGuava11.removeAllImpl(set, collection.iterator());
    }

    static <K, V> Iterator<K> keyIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return new TransformedIterator<Map.Entry<K, V>, K>(entryIterator){

            @Override
            K transform(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        };
    }

    private static <E> Set<E> removeOnlySet(final Set<E> set) {
        return new ForwardingSet<E>(){

            protected Set<E> delegate() {
                return set;
            }

            public boolean add(E element) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection<? extends E> es) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <K, V> Iterator<Map.Entry<K, V>> asSetEntryIterator(Set<K> set, final Function<? super K, V> function) {
        return new TransformedIterator<K, Map.Entry<K, V>>(set.iterator()){

            @Override
            Map.Entry<K, V> transform(K key) {
                return Maps.immutableEntry(key, (Object)function.apply(key));
            }
        };
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return new TransformedIterator<Map.Entry<K, V>, V>(entryIterator){

            @Override
            V transform(Map.Entry<K, V> entry) {
                return entry.getValue();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsMapView<K, V>
    extends ImprovedAbstractMap<K, V> {
        private final Set<K> set;
        final Function<? super K, V> function;

        Set<K> backingSet() {
            return this.set;
        }

        AsMapView(Set<K> set, Function<? super K, V> function) {
            this.set = (Set)Preconditions.checkNotNull(set);
            this.function = (Function)Preconditions.checkNotNull(function);
        }

        @Override
        public Set<K> keySet() {
            return CompatibleGuava11.removeOnlySet(this.backingSet());
        }

        @Override
        public Collection<V> values() {
            return Collections2.transform(this.set, this.function);
        }

        @Override
        public int size() {
            return this.backingSet().size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.backingSet().contains(key);
        }

        @Override
        public V get(Object key) {
            if (this.backingSet().contains(key)) {
                Object k = key;
                return (V)this.function.apply(k);
            }
            return null;
        }

        @Override
        public V remove(Object key) {
            if (this.backingSet().remove(key)) {
                Object k = key;
                return (V)this.function.apply(k);
            }
            return null;
        }

        @Override
        public void clear() {
            this.backingSet().clear();
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new EntrySet<K, V>(){

                @Override
                Map<K, V> map() {
                    return AsMapView.this;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return CompatibleGuava11.asSetEntryIterator(AsMapView.this.backingSet(), AsMapView.this.function);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EntrySet<K, V>
    extends ImprovedAbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                V value = this.map().get(key);
                return Objects.equal(value, entry.getValue()) && (value != null || this.map().containsKey(key));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll((Collection)Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException e) {
                changed = true;
                ** for (o : c)
            }
lbl-1000:
            // 1 sources

            {
                changed |= this.remove(o);
                continue;
            }
lbl8:
            // 1 sources

            return changed;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll((Collection)Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException e) {
                keys = Sets.newHashSetWithExpectedSize((int)c.size());
                ** for (o : c)
            }
lbl-1000:
            // 1 sources

            {
                if (!this.contains(o)) continue;
                entry = (Map.Entry)o;
                keys.add(entry.getKey());
                continue;
            }
lbl11:
            // 1 sources

            return this.map().keySet().retainAll(keys);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ImprovedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private Set<Map.Entry<K, V>> entrySet;
        private Set<K> keySet;
        private Collection<V> values;

        ImprovedAbstractMap() {
        }

        protected abstract Set<Map.Entry<K, V>> createEntrySet();

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = result = this.createEntrySet();
            }
            return result;
        }

        @Override
        public Set<K> keySet() {
            Set<K> result = this.keySet;
            if (result == null) {
                this.keySet = new KeySet<K, V>(){

                    @Override
                    Map<K, V> map() {
                        return ImprovedAbstractMap.this;
                    }
                };
                return this.keySet;
            }
            return result;
        }

        @Override
        public Collection<V> values() {
            Collection<V> result = this.values;
            if (result == null) {
                this.values = new Values<K, V>(){

                    @Override
                    Map<K, V> map() {
                        return ImprovedAbstractMap.this;
                    }
                };
                return this.values;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return CompatibleGuava11.removeAllImpl(this, c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return super.retainAll((Collection)Preconditions.checkNotNull(c));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class KeySet<K, V>
    extends ImprovedAbstractSet<K> {
        KeySet() {
        }

        abstract Map<K, V> map();

        @Override
        public Iterator<K> iterator() {
            return CompatibleGuava11.keyIterator(this.map().entrySet().iterator());
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map().containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                this.map().remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TransformedIterator<F, T>
    implements Iterator<T> {
        final Iterator<? extends F> backingIterator;

        TransformedIterator(Iterator<? extends F> backingIterator) {
            this.backingIterator = (Iterator)Preconditions.checkNotNull(backingIterator);
        }

        abstract T transform(F var1);

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final T next() {
            return this.transform(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Values<K, V>
    extends AbstractCollection<V> {
        Values() {
        }

        abstract Map<K, V> map();

        @Override
        public Iterator<V> iterator() {
            return CompatibleGuava11.valueIterator(this.map().entrySet().iterator());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean remove(Object o) {
            try {
                return super.remove(o);
            }
            catch (UnsupportedOperationException e) {
                ** for (entry : this.map().entrySet())
            }
lbl-1000:
            // 1 sources

            {
                if (!Objects.equal((Object)o, entry.getValue())) continue;
                this.map().remove(entry.getKey());
                return true;
            }
lbl9:
            // 1 sources

            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll((Collection)Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException e) {
                toRemove = Sets.newHashSet();
                ** for (entry : this.map().entrySet())
            }
lbl-1000:
            // 1 sources

            {
                if (!c.contains(entry.getValue())) continue;
                toRemove.add(entry.getKey());
                continue;
            }
lbl10:
            // 1 sources

            return this.map().keySet().removeAll(toRemove);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll((Collection)Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException e) {
                toRetain = Sets.newHashSet();
                ** for (entry : this.map().entrySet())
            }
lbl-1000:
            // 1 sources

            {
                if (!c.contains(entry.getValue())) continue;
                toRetain.add(entry.getKey());
                continue;
            }
lbl10:
            // 1 sources

            return this.map().keySet().retainAll(toRetain);
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map().containsValue(o);
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }
}

