/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.impl.StarTable;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.runtime.Bindable;
import net.hydromatic.optiq.runtime.Typed;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.TableModificationRelBase;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.DefaultRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.rules.FilterToCalcRule;
import org.eigenbase.rel.rules.MergeCalcRule;
import org.eigenbase.rel.rules.MergeFilterOntoCalcRule;
import org.eigenbase.rel.rules.MergeProjectOntoCalcRule;
import org.eigenbase.rel.rules.ProjectToCalcRule;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelImplementor;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptMaterialization;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexExecutorImpl;
import org.eigenbase.sql.SqlExplain;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorTable;
import org.eigenbase.sql2rel.SqlToRelConverter;
import org.eigenbase.trace.EigenbaseTimingTracer;
import org.eigenbase.trace.EigenbaseTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Prepare {
    protected static final Logger LOGGER = EigenbaseTrace.getStatementTracer();
    protected final OptiqPrepare.Context context;
    protected final CatalogReader catalogReader;
    protected String queryString = null;
    protected final Convention resultConvention;
    protected EigenbaseTimingTracer timingTracer;
    protected List<List<String>> fieldOrigins;
    protected RelDataType parameterRowType;
    public static boolean trim = false;

    public Prepare(OptiqPrepare.Context context, CatalogReader catalogReader, Convention resultConvention) {
        assert (context != null);
        this.context = context;
        this.catalogReader = catalogReader;
        this.resultConvention = resultConvention;
    }

    protected abstract PreparedResult createPreparedExplanation(RelDataType var1, RelDataType var2, RelNode var3, boolean var4, SqlExplainLevel var5);

    protected RelNode optimize(RelDataType logicalRowType, RelNode rootRel, List<Materialization> materializations) {
        final RelOptPlanner planner = rootRel.getCluster().getPlanner();
        DataContext dataContext = this.context.getDataContext();
        planner.setExecutor(new RexExecutorImpl(dataContext));
        RelVisitor visitor = new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                planner.registerClass(node);
                super.visit(node, ordinal, parent);
            }
        };
        visitor.go(rootRel);
        planner.setRoot(rootRel);
        for (Materialization materialization : materializations) {
            planner.addMaterialization(new RelOptMaterialization(materialization.tableRel, materialization.queryRel, materialization.starRelOptTable));
        }
        RelTraitSet desiredTraits = this.getDesiredRootTraitSet(rootRel);
        RelNode rootRel2 = planner.changeTraits(rootRel, desiredTraits);
        assert (rootRel2 != null);
        planner.setRoot(rootRel2);
        RelOptPlanner planner2 = planner.chooseDelegate();
        RelNode rootRel3 = planner2.findBestExp();
        assert (rootRel3 != null) : "could not implement exp";
        HepProgram program = HepProgram.builder().addRuleInstance(JavaRules.ENUMERABLE_CALC_RULE).addRuleInstance(JavaRules.ENUMERABLE_FILTER_TO_CALC_RULE).addRuleInstance(JavaRules.ENUMERABLE_PROJECT_TO_CALC_RULE).addRuleInstance(MergeCalcRule.INSTANCE).addRuleInstance(MergeFilterOntoCalcRule.INSTANCE).addRuleInstance(MergeProjectOntoCalcRule.INSTANCE).addRuleInstance(FilterToCalcRule.INSTANCE).addRuleInstance(ProjectToCalcRule.INSTANCE).addRuleInstance(MergeCalcRule.INSTANCE).addRuleInstance(MergeFilterOntoCalcRule.INSTANCE).addRuleInstance(MergeProjectOntoCalcRule.INSTANCE).build();
        HepPlanner planner3 = new HepPlanner(program, null, true, (Function2<RelNode, RelNode, Void>)Functions.ignore2(), RelOptCostImpl.FACTORY);
        ArrayList list = Lists.newArrayList();
        DefaultRelMetadataProvider defaultProvider = new DefaultRelMetadataProvider();
        list.add(defaultProvider);
        planner3.registerMetadataProviders(list);
        RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
        rootRel3.getCluster().setMetadataProvider(plannerChain);
        planner3.setRoot(rootRel3);
        RelNode rootRel4 = planner3.findBestExp();
        return rootRel4;
    }

    protected RelTraitSet getDesiredRootTraitSet(RelNode rootRel) {
        return rootRel.getTraitSet().replace(this.resultConvention);
    }

    protected abstract PreparedResult implement(RelDataType var1, RelNode var2, SqlKind var3);

    public PreparedResult prepareSql(SqlNode sqlQuery, Class runtimeContextClass, SqlValidator validator, boolean needsValidation, List<Materialization> materializations) {
        return this.prepareSql(sqlQuery, sqlQuery, runtimeContextClass, validator, needsValidation, materializations);
    }

    public PreparedResult prepareSql(SqlNode sqlQuery, SqlNode sqlNodeOriginal, Class runtimeContextClass, SqlValidator validator, boolean needsValidation, List<Materialization> materializations) {
        SqlKind kind;
        SqlExplainLevel detailLevel;
        boolean explainAsXml;
        SqlExplain.Depth explainDepth;
        this.queryString = sqlQuery.toString();
        this.init(runtimeContextClass);
        SqlToRelConverter sqlToRelConverter = this.getSqlToRelConverter(validator, this.catalogReader);
        SqlExplain sqlExplain = null;
        if (sqlQuery.getKind() == SqlKind.EXPLAIN) {
            sqlExplain = (SqlExplain)sqlQuery;
            sqlQuery = sqlExplain.getExplicandum();
            sqlToRelConverter.setIsExplain(sqlExplain.getDynamicParamCount());
        }
        RelNode rootRel = sqlToRelConverter.convertQuery(sqlQuery, needsValidation, true);
        if (this.timingTracer != null) {
            this.timingTracer.traceTime("end sql2rel");
        }
        RelDataType resultType = validator.getValidatedNodeType(sqlQuery);
        this.fieldOrigins = validator.getFieldOrigins(sqlQuery);
        assert (this.fieldOrigins.size() == resultType.getFieldCount());
        this.parameterRowType = validator.getParameterRowType(sqlQuery);
        if (sqlExplain != null) {
            explainDepth = sqlExplain.getDepth();
            explainAsXml = sqlExplain.isXml();
            detailLevel = sqlExplain.getDetailLevel();
            switch (explainDepth) {
                case TYPE: {
                    return this.createPreparedExplanation(resultType, this.parameterRowType, null, explainAsXml, detailLevel);
                }
                case LOGICAL: {
                    return this.createPreparedExplanation(null, this.parameterRowType, rootRel, explainAsXml, detailLevel);
                }
            }
        }
        rootRel = this.flattenTypes(rootRel, true);
        rootRel = this.decorrelate(sqlToRelConverter, sqlQuery, rootRel);
        rootRel = this.trimUnusedFields(rootRel);
        if (sqlExplain != null) {
            explainDepth = sqlExplain.getDepth();
            explainAsXml = sqlExplain.isXml();
            detailLevel = sqlExplain.getDetailLevel();
            switch (explainDepth) {
                default: 
            }
            rootRel = this.optimize(rootRel.getRowType(), rootRel, materializations);
            return this.createPreparedExplanation(null, this.parameterRowType, rootRel, explainAsXml, detailLevel);
        }
        rootRel = this.optimize(resultType, rootRel, materializations);
        if (this.timingTracer != null) {
            this.timingTracer.traceTime("end optimization");
        }
        if (!(kind = sqlQuery.getKind()).belongsTo(SqlKind.DML)) {
            kind = sqlNodeOriginal.getKind();
        }
        return this.implement(resultType, rootRel, kind);
    }

    protected TableModificationRelBase.Operation mapTableModOp(boolean isDml, SqlKind sqlKind) {
        if (!isDml) {
            return null;
        }
        switch (sqlKind) {
            case INSERT: {
                return TableModificationRelBase.Operation.INSERT;
            }
            case DELETE: {
                return TableModificationRelBase.Operation.DELETE;
            }
            case MERGE: {
                return TableModificationRelBase.Operation.MERGE;
            }
            case UPDATE: {
                return TableModificationRelBase.Operation.UPDATE;
            }
        }
        return null;
    }

    protected abstract SqlToRelConverter getSqlToRelConverter(SqlValidator var1, CatalogReader var2);

    protected abstract RelImplementor getRelImplementor(RexBuilder var1);

    protected abstract boolean shouldAlwaysWriteJavaFile();

    public abstract RelNode flattenTypes(RelNode var1, boolean var2);

    protected abstract RelNode decorrelate(SqlToRelConverter var1, SqlNode var2, RelNode var3);

    protected RelNode trimUnusedFields(RelNode rootRel) {
        SqlToRelConverter converter = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader);
        converter.setTrimUnusedFields(this.shouldTrim(rootRel));
        return converter.trimUnusedFields(rootRel);
    }

    private boolean shouldTrim(RelNode rootRel) {
        return trim || Prepare.countJoins(rootRel) < 2;
    }

    private static int countJoins(RelNode rootRel) {
        class JoinCounter
        extends RelVisitor {
            int joinCount;

            JoinCounter() {
            }

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof JoinRelBase) {
                    ++this.joinCount;
                }
                super.visit(node, ordinal, parent);
            }

            int run(RelNode node) {
                this.go(node);
                return this.joinCount;
            }
        }
        return new JoinCounter().run(rootRel);
    }

    public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
        throw new UnsupportedOperationException();
    }

    protected abstract void init(Class var1);

    protected abstract SqlValidator getSqlValidator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CatalogReader
    extends RelOptSchema,
    SqlValidatorCatalogReader {
        @Override
        public PreparingTable getTableForMember(List<String> var1);

        public CatalogReader withSchemaPath(List<String> var1);

        @Override
        public PreparingTable getTable(List<String> var1);
    }

    public static class Materialization {
        final OptiqSchema.TableEntry materializedTable;
        final String sql;
        RelNode tableRel;
        RelNode queryRel;
        private RelOptTable starRelOptTable;

        public Materialization(OptiqSchema.TableEntry materializedTable, String sql) {
            assert (materializedTable != null);
            assert (sql != null);
            this.materializedTable = materializedTable;
            this.sql = sql;
        }

        public void materialize(RelNode queryRel, RelOptTable starRelOptTable) {
            this.queryRel = queryRel;
            this.starRelOptTable = starRelOptTable;
            assert (starRelOptTable.unwrap(StarTable.class) != null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PreparedExplain
    implements PreparedResult {
        private final RelDataType rowType;
        private final RelDataType parameterRowType;
        private final RelNode rel;
        private final boolean asXml;
        private final SqlExplainLevel detailLevel;

        public PreparedExplain(RelDataType rowType, RelDataType parameterRowType, RelNode rel, boolean asXml, SqlExplainLevel detailLevel) {
            this.rowType = rowType;
            this.parameterRowType = parameterRowType;
            this.rel = rel;
            this.asXml = asXml;
            this.detailLevel = detailLevel;
        }

        @Override
        public String getCode() {
            if (this.rel == null) {
                return RelOptUtil.dumpType(this.rowType);
            }
            return RelOptUtil.dumpPlan("", this.rel, this.asXml, this.detailLevel);
        }

        @Override
        public RelDataType getParameterRowType() {
            return this.parameterRowType;
        }

        @Override
        public boolean isDml() {
            return false;
        }

        @Override
        public TableModificationRelBase.Operation getTableModOp() {
            return null;
        }

        @Override
        public List<List<String>> getFieldOrigins() {
            return Collections.singletonList(Collections.nCopies(4, null));
        }

        public RelNode getRel() {
            return this.rel;
        }

        @Override
        public abstract Bindable getBindable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PreparedResult {
        public String getCode();

        public boolean isDml();

        public TableModificationRelBase.Operation getTableModOp();

        public List<List<String>> getFieldOrigins();

        public RelDataType getParameterRowType();

        public Bindable getBindable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PreparedResultImpl
    implements PreparedResult,
    Typed {
        protected final RelNode rootRel;
        protected final RelDataType parameterRowType;
        protected final RelDataType rowType;
        protected final boolean isDml;
        protected final TableModificationRelBase.Operation tableModOp;
        protected final List<List<String>> fieldOrigins;

        public PreparedResultImpl(RelDataType rowType, RelDataType parameterRowType, List<List<String>> fieldOrigins, RelNode rootRel, TableModificationRelBase.Operation tableModOp, boolean isDml) {
            assert (rowType != null);
            assert (parameterRowType != null);
            assert (fieldOrigins != null);
            assert (rootRel != null);
            this.rowType = rowType;
            this.parameterRowType = parameterRowType;
            this.fieldOrigins = fieldOrigins;
            this.rootRel = rootRel;
            this.tableModOp = tableModOp;
            this.isDml = isDml;
        }

        @Override
        public boolean isDml() {
            return this.isDml;
        }

        @Override
        public TableModificationRelBase.Operation getTableModOp() {
            return this.tableModOp;
        }

        @Override
        public List<List<String>> getFieldOrigins() {
            return this.fieldOrigins;
        }

        @Override
        public RelDataType getParameterRowType() {
            return this.parameterRowType;
        }

        public RelDataType getPhysicalRowType() {
            return this.rowType;
        }

        @Override
        public abstract Type getElementType();

        public RelNode getRootRel() {
            return this.rootRel;
        }

        @Override
        public abstract Bindable getBindable();
    }

    public static interface PreparingTable
    extends RelOptTable,
    SqlValidatorTable {
    }
}

