/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.BuiltInConnectionProperty;
import net.hydromatic.avatica.ConnectionProperty;
import net.hydromatic.avatica.DriverVersion;
import net.hydromatic.avatica.Handler;
import net.hydromatic.avatica.HandlerImpl;
import net.hydromatic.avatica.UnregisteredDriver;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.optiq.config.OptiqConnectionProperty;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqFactory;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.model.ModelHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:optiq:";
    final Function0<OptiqPrepare> prepareFactory = this.createPrepareFactory();

    static {
        new Driver().register();
    }

    protected Function0<OptiqPrepare> createPrepareFactory() {
        return OptiqPrepare.DEFAULT_FACTORY;
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "net.hydromatic.optiq.jdbc.OptiqJdbc3Factory";
            }
            case JDBC_40: {
                return "net.hydromatic.optiq.jdbc.OptiqJdbc40Factory";
            }
        }
        return "net.hydromatic.optiq.jdbc.OptiqJdbc41Factory";
    }

    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, (String)"net-hydromatic-optiq-jdbc.properties", (String)"Optiq JDBC Driver", (String)"unknown version", (String)"Optiq", (String)"unknown version");
    }

    protected Handler createHandler() {
        return new HandlerImpl(){

            public void onConnectionInit(AvaticaConnection connection_) throws SQLException {
                OptiqConnectionImpl connection = (OptiqConnectionImpl)connection_;
                super.onConnectionInit((AvaticaConnection)connection);
                String model = connection.config().model();
                if (model != null) {
                    try {
                        new ModelHandler(connection, model);
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
            }
        };
    }

    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, OptiqConnectionProperty.values());
        return list;
    }

    OptiqConnection connect(OptiqRootSchema rootSchema, JavaTypeFactory typeFactory) {
        return (OptiqConnection)((OptiqFactory)this.factory).newConnection(this, this.factory, CONNECT_STRING_PREFIX, new Properties(), rootSchema, typeFactory);
    }
}

