/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.Frameworks;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexExecutable;
import org.eigenbase.rex.RexExecutorImpl;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.NlsString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RexExecutorTest {
    protected void check(final Action action) throws Exception {
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, OptiqServerStatement statement) {
                RexBuilder rexBuilder = cluster.getRexBuilder();
                DataContext dataContext = Schemas.createDataContext((Connection)statement.getConnection());
                RexExecutorImpl executor = new RexExecutorImpl(dataContext);
                action.check(rexBuilder, executor);
                return null;
            }
        });
    }

    @Test
    public void testVariableExecution() throws Exception {
        this.check(new Action(){

            public void check(RexBuilder rexBuilder, RexExecutorImpl executor) {
                Object[] values = new Object[1];
                TestDataContext testContext = new TestDataContext(values);
                RelDataType varchar = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
                RelDataType integer = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER);
                RexInputRef input = rexBuilder.makeInputRef(varchar, 0);
                RexNode lengthArg = rexBuilder.makeLiteral((Object)3, integer, true);
                RexNode substr = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{input, lengthArg});
                ImmutableList constExps = ImmutableList.of((Object)substr);
                RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
                RelDataType rowType = typeFactory.builder().add("someStr", varchar).build();
                RexExecutable exec = executor.getExecutable(rexBuilder, (List)constExps, rowType);
                exec.setDataContext((DataContext)testContext);
                values[0] = "Hello World";
                Object[] result = exec.execute();
                Assert.assertTrue((boolean)(result[0] instanceof String));
                Assert.assertThat((Object)((String)result[0]), (Matcher)CoreMatchers.equalTo((Object)"llo World"));
                values[0] = "Optiq";
                result = exec.execute();
                Assert.assertTrue((boolean)(result[0] instanceof String));
                Assert.assertThat((Object)((String)result[0]), (Matcher)CoreMatchers.equalTo((Object)"tiq"));
            }
        });
    }

    @Test
    public void testConstant() throws Exception {
        this.check(new Action(){

            public void check(RexBuilder rexBuilder, RexExecutorImpl executor) {
                ArrayList reducedValues = new ArrayList();
                RexLiteral ten = rexBuilder.makeExactLiteral(BigDecimal.TEN);
                executor.reduce(rexBuilder, (List)ImmutableList.of((Object)ten), reducedValues);
                Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
                Assert.assertThat((Object)((RexNode)reducedValues.get(0)), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
                Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)10L));
            }
        });
    }

    @Test
    public void testSubstring() throws Exception {
        this.check(new Action(){

            public void check(RexBuilder rexBuilder, RexExecutorImpl executor) {
                ArrayList reducedValues = new ArrayList();
                RexLiteral hello = rexBuilder.makeCharLiteral(new NlsString("Hello world!", null, null));
                RexNode plus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
                RexLiteral four = rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
                RexNode substring = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{hello, plus, four});
                executor.reduce(rexBuilder, (List)ImmutableList.of((Object)substring, (Object)plus), reducedValues);
                Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)2));
                Assert.assertThat((Object)((RexNode)reducedValues.get(0)), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
                Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)"ello"));
                Assert.assertThat((Object)((RexNode)reducedValues.get(1)), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
                Assert.assertThat((Object)((RexLiteral)reducedValues.get(1)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)2L));
            }
        });
    }

    static interface Action {
        public void check(RexBuilder var1, RexExecutorImpl var2);
    }

    public static class TestDataContext
    implements DataContext {
        private final Object[] values;

        public TestDataContext(Object[] values) {
            this.values = values;
        }

        public SchemaPlus getRootSchema() {
            throw new RuntimeException("Unsupported");
        }

        public JavaTypeFactory getTypeFactory() {
            throw new RuntimeException("Unsupported");
        }

        public QueryProvider getQueryProvider() {
            throw new RuntimeException("Unsupported");
        }

        public Object get(String name) {
            if (name.equals("inputRecord")) {
                return this.values;
            }
            Assert.fail((String)"Wrong DataContext access");
            return null;
        }
    }
}

