/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.hydromatic.avatica.ByteString;
import net.hydromatic.optiq.runtime.SqlFunctions;
import net.hydromatic.optiq.runtime.Utilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SqlFunctionsTest {
    @Test
    public void testCharLength() {
        Assert.assertEquals((long)3L, (long)SqlFunctions.charLength((String)"xyz"));
    }

    @Test
    public void testConcat() {
        Assert.assertEquals((Object)"a bcd", (Object)SqlFunctions.concat((String)"a b", (String)"cd"));
        Assert.assertEquals((Object)"anull", (Object)SqlFunctions.concat((String)"a", null));
        Assert.assertEquals((Object)"nullnull", (Object)SqlFunctions.concat(null, null));
        Assert.assertEquals((Object)"nullb", (Object)SqlFunctions.concat(null, (String)"b"));
    }

    @Test
    public void testLower() {
        Assert.assertEquals((Object)"a bcd", (Object)SqlFunctions.lower((String)"A bCd"));
    }

    @Test
    public void testUpper() {
        Assert.assertEquals((Object)"A BCD", (Object)SqlFunctions.upper((String)"A bCd"));
    }

    @Test
    public void testInitcap() {
        Assert.assertEquals((Object)"Aa", (Object)SqlFunctions.initcap((String)"aA"));
        Assert.assertEquals((Object)"Zz", (Object)SqlFunctions.initcap((String)"zz"));
        Assert.assertEquals((Object)"Az", (Object)SqlFunctions.initcap((String)"AZ"));
        Assert.assertEquals((Object)"Try A Little  ", (Object)SqlFunctions.initcap((String)"tRy a littlE  "));
        Assert.assertEquals((Object)"Won'T It?No", (Object)SqlFunctions.initcap((String)"won't it?no"));
        Assert.assertEquals((Object)"1a", (Object)SqlFunctions.initcap((String)"1A"));
        Assert.assertEquals((Object)" B0123b", (Object)SqlFunctions.initcap((String)" b0123B"));
    }

    @Test
    public void testLesser() {
        Assert.assertEquals((Object)"a", (Object)SqlFunctions.lesser((Comparable)((Object)"a"), (Comparable)((Object)"bc")));
        Assert.assertEquals((Object)"ac", (Object)SqlFunctions.lesser((Comparable)((Object)"bc"), (Comparable)((Object)"ac")));
        try {
            Comparable o = SqlFunctions.lesser((Comparable)((Object)"a"), null);
            Assert.fail((String)("Expected NPE, got " + o));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"a", (Object)SqlFunctions.lesser(null, (Comparable)((Object)"a")));
        Assert.assertNull((Object)SqlFunctions.lesser(null, null));
    }

    @Test
    public void testGreater() {
        Assert.assertEquals((Object)"bc", (Object)SqlFunctions.greater((Comparable)((Object)"a"), (Comparable)((Object)"bc")));
        Assert.assertEquals((Object)"bc", (Object)SqlFunctions.greater((Comparable)((Object)"bc"), (Comparable)((Object)"ac")));
        try {
            Comparable o = SqlFunctions.greater((Comparable)((Object)"a"), null);
            Assert.fail((String)("Expected NPE, got " + o));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"a", (Object)SqlFunctions.greater(null, (Comparable)((Object)"a")));
        Assert.assertNull((Object)SqlFunctions.greater(null, null));
    }

    @Test
    public void testRtrim() {
        Assert.assertEquals((Object)"", (Object)SqlFunctions.rtrim((String)""));
        Assert.assertEquals((Object)"", (Object)SqlFunctions.rtrim((String)"    "));
        Assert.assertEquals((Object)"   x", (Object)SqlFunctions.rtrim((String)"   x  "));
        Assert.assertEquals((Object)"   x", (Object)SqlFunctions.rtrim((String)"   x "));
        Assert.assertEquals((Object)"   x y", (Object)SqlFunctions.rtrim((String)"   x y "));
        Assert.assertEquals((Object)"   x", (Object)SqlFunctions.rtrim((String)"   x"));
        Assert.assertEquals((Object)"x", (Object)SqlFunctions.rtrim((String)"x"));
    }

    @Test
    public void testLtrim() {
        Assert.assertEquals((Object)"", (Object)SqlFunctions.ltrim((String)""));
        Assert.assertEquals((Object)"", (Object)SqlFunctions.ltrim((String)"    "));
        Assert.assertEquals((Object)"x  ", (Object)SqlFunctions.ltrim((String)"   x  "));
        Assert.assertEquals((Object)"x ", (Object)SqlFunctions.ltrim((String)"   x "));
        Assert.assertEquals((Object)"x y ", (Object)SqlFunctions.ltrim((String)"x y "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctions.ltrim((String)"   x"));
        Assert.assertEquals((Object)"x", (Object)SqlFunctions.ltrim((String)"x"));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)"", (Object)SqlFunctionsTest.trimSpacesBoth(""));
        Assert.assertEquals((Object)"", (Object)SqlFunctionsTest.trimSpacesBoth("    "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("   x  "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("   x "));
        Assert.assertEquals((Object)"x y", (Object)SqlFunctionsTest.trimSpacesBoth("   x y "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("   x"));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("x"));
    }

    static String trimSpacesBoth(String s) {
        return SqlFunctions.trim((boolean)true, (boolean)true, (String)" ", (String)s);
    }

    @Test
    public void testUnixDateToString() {
        Assert.assertEquals((Object)"2000-01-01", (Object)SqlFunctions.unixDateToString((int)10957));
        Assert.assertEquals((Object)"1970-01-01", (Object)SqlFunctions.unixDateToString((int)0));
        Assert.assertEquals((Object)"1970-01-02", (Object)SqlFunctions.unixDateToString((int)1));
        Assert.assertEquals((Object)"1971-01-01", (Object)SqlFunctions.unixDateToString((int)365));
        Assert.assertEquals((Object)"1972-01-01", (Object)SqlFunctions.unixDateToString((int)730));
        Assert.assertEquals((Object)"1972-02-28", (Object)SqlFunctions.unixDateToString((int)788));
        Assert.assertEquals((Object)"1972-02-29", (Object)SqlFunctions.unixDateToString((int)789));
        Assert.assertEquals((Object)"1972-03-01", (Object)SqlFunctions.unixDateToString((int)790));
        Assert.assertEquals((Object)"1969-01-01", (Object)SqlFunctions.unixDateToString((int)-365));
        Assert.assertEquals((Object)"2000-01-01", (Object)SqlFunctions.unixDateToString((int)10957));
        Assert.assertEquals((Object)"2000-02-28", (Object)SqlFunctions.unixDateToString((int)11015));
        Assert.assertEquals((Object)"2000-02-29", (Object)SqlFunctions.unixDateToString((int)11016));
        Assert.assertEquals((Object)"2000-03-01", (Object)SqlFunctions.unixDateToString((int)11017));
        Assert.assertEquals((Object)"1945-02-24", (Object)SqlFunctions.unixDateToString((int)-9077));
    }

    @Test
    public void testYmdToUnixDate() {
        Assert.assertEquals((long)0L, (long)SqlFunctions.ymdToUnixDate((int)1970, (int)1, (int)1));
        Assert.assertEquals((long)365L, (long)SqlFunctions.ymdToUnixDate((int)1971, (int)1, (int)1));
        Assert.assertEquals((long)-365L, (long)SqlFunctions.ymdToUnixDate((int)1969, (int)1, (int)1));
        Assert.assertEquals((long)11017L, (long)SqlFunctions.ymdToUnixDate((int)2000, (int)3, (int)1));
        Assert.assertEquals((long)-9077L, (long)SqlFunctions.ymdToUnixDate((int)1945, (int)2, (int)24));
    }

    @Test
    public void testDateToString() {
        Assert.assertEquals((Object)"1970-01-01", (Object)SqlFunctions.unixDateToString((int)0));
        Assert.assertEquals((Object)"1971-02-03", (Object)SqlFunctions.unixDateToString((int)398));
    }

    @Test
    public void testTimeToString() {
        Assert.assertEquals((Object)"00:00:00", (Object)SqlFunctions.unixTimeToString((int)0));
        Assert.assertEquals((Object)"23:59:59", (Object)SqlFunctions.unixTimeToString((int)86399999));
    }

    @Test
    public void testTimestampToString() {
        Assert.assertEquals((Object)"1970-01-01 00:00:00", (Object)SqlFunctions.unixTimestampToString((long)0L));
        Assert.assertEquals((Object)"1970-02-01 23:59:59", (Object)SqlFunctions.unixTimestampToString((long)2764799999L));
    }

    @Test
    public void testIntervalYearMonthToString() {
        SqlFunctions.TimeUnitRange range = SqlFunctions.TimeUnitRange.YEAR_TO_MONTH;
        Assert.assertEquals((Object)"+0-00", (Object)SqlFunctions.intervalYearMonthToString((int)0, (SqlFunctions.TimeUnitRange)range));
        Assert.assertEquals((Object)"+1-00", (Object)SqlFunctions.intervalYearMonthToString((int)12, (SqlFunctions.TimeUnitRange)range));
        Assert.assertEquals((Object)"+1-01", (Object)SqlFunctions.intervalYearMonthToString((int)13, (SqlFunctions.TimeUnitRange)range));
        Assert.assertEquals((Object)"-1-01", (Object)SqlFunctions.intervalYearMonthToString((int)-13, (SqlFunctions.TimeUnitRange)range));
    }

    @Test
    public void testIntervalDayTimeToString() {
        Assert.assertEquals((Object)"+0", (Object)SqlFunctions.intervalYearMonthToString((int)0, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR));
        Assert.assertEquals((Object)"+0-00", (Object)SqlFunctions.intervalYearMonthToString((int)0, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR_TO_MONTH));
        Assert.assertEquals((Object)"+0", (Object)SqlFunctions.intervalYearMonthToString((int)0, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MONTH));
        Assert.assertEquals((Object)"+0", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.DAY, (int)0));
        Assert.assertEquals((Object)"+0 00", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.DAY_TO_HOUR, (int)0));
        Assert.assertEquals((Object)"+0 00:00", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.DAY_TO_MINUTE, (int)0));
        Assert.assertEquals((Object)"+0 00:00:00", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.DAY_TO_SECOND, (int)0));
        Assert.assertEquals((Object)"+0", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.HOUR, (int)0));
        Assert.assertEquals((Object)"+0:00", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.HOUR_TO_MINUTE, (int)0));
        Assert.assertEquals((Object)"+0:00:00", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.HOUR_TO_SECOND, (int)0));
        Assert.assertEquals((Object)"+0", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MINUTE, (int)0));
        Assert.assertEquals((Object)"+0:00", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MINUTE_TO_SECOND, (int)0));
        Assert.assertEquals((Object)"+0", (Object)SqlFunctions.intervalDayTimeToString((long)0L, (SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.SECOND, (int)0));
    }

    @Test
    public void testYmdToJulian() {
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)2014, (int)4, (int)3), (Matcher)CoreMatchers.equalTo((Object)2456751));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)2000, (int)1, (int)1), (Matcher)CoreMatchers.equalTo((Object)2451545));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1970, (int)1, (int)1), (Matcher)CoreMatchers.equalTo((Object)2440588));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1970, (int)1, (int)1), (Matcher)CoreMatchers.equalTo((Object)2440588));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1901, (int)1, (int)1), (Matcher)CoreMatchers.equalTo((Object)2415386));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1900, (int)10, (int)17), (Matcher)CoreMatchers.equalTo((Object)2415310));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1900, (int)3, (int)1), (Matcher)CoreMatchers.equalTo((Object)2415080));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1900, (int)2, (int)28), (Matcher)CoreMatchers.equalTo((Object)2415079));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1900, (int)2, (int)1), (Matcher)CoreMatchers.equalTo((Object)2415052));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1900, (int)1, (int)1), (Matcher)CoreMatchers.equalTo((Object)2415021));
        Assert.assertThat((Object)SqlFunctions.ymdToJulian((int)1777, (int)7, (int)4), (Matcher)CoreMatchers.equalTo((Object)2370281));
    }

    @Test
    public void testExtract() {
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR, (long)0L), (Matcher)CoreMatchers.equalTo((Object)1970));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR, (long)-1L), (Matcher)CoreMatchers.equalTo((Object)1969));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR, (long)364L), (Matcher)CoreMatchers.equalTo((Object)1970));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR, (long)365L), (Matcher)CoreMatchers.equalTo((Object)1971));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MONTH, (long)0L), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MONTH, (long)-1L), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MONTH, (long)364L), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MONTH, (long)365L), (Matcher)CoreMatchers.equalTo((Object)1));
        this.thereAndBack(2000, 1, 1);
        this.thereAndBack(2000, 2, 28);
        this.thereAndBack(2000, 2, 29);
        this.thereAndBack(2000, 3, 1);
        this.thereAndBack(1964, 1, 1);
        this.thereAndBack(1964, 2, 28);
        this.thereAndBack(1964, 2, 29);
        this.thereAndBack(1964, 3, 1);
        this.thereAndBack(1864, 1, 1);
        this.thereAndBack(1864, 2, 28);
        this.thereAndBack(1864, 2, 29);
        this.thereAndBack(1864, 3, 1);
        this.thereAndBack(1900, 1, 1);
        this.thereAndBack(1900, 2, 28);
        this.thereAndBack(1900, 3, 1);
        this.thereAndBack(2004, 2, 28);
        this.thereAndBack(2004, 2, 29);
        this.thereAndBack(2004, 3, 1);
    }

    private void thereAndBack(int year, int month, int day) {
        int unixDate = SqlFunctions.ymdToUnixDate((int)year, (int)month, (int)day);
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.YEAR, (long)unixDate), (Matcher)CoreMatchers.equalTo((Object)year));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.MONTH, (long)unixDate), (Matcher)CoreMatchers.equalTo((Object)month));
        Assert.assertThat((Object)SqlFunctions.unixDateExtract((SqlFunctions.TimeUnitRange)SqlFunctions.TimeUnitRange.DAY, (long)unixDate), (Matcher)CoreMatchers.equalTo((Object)day));
    }

    @Test
    public void testCompare() {
        List<String> ac = Arrays.asList("a", "c");
        List<String> abc = Arrays.asList("a", "b", "c");
        List<String> a = Arrays.asList("a");
        List empty = Collections.emptyList();
        Assert.assertEquals((long)0L, (long)Utilities.compare(ac, ac));
        Assert.assertEquals((long)0L, (long)Utilities.compare(ac, new ArrayList<String>(ac)));
        Assert.assertEquals((long)-1L, (long)Utilities.compare(a, ac));
        Assert.assertEquals((long)-1L, (long)Utilities.compare(empty, ac));
        Assert.assertEquals((long)1L, (long)Utilities.compare(ac, a));
        Assert.assertEquals((long)1L, (long)Utilities.compare(ac, abc));
        Assert.assertEquals((long)1L, (long)Utilities.compare(ac, empty));
        Assert.assertEquals((long)0L, (long)Utilities.compare(empty, empty));
    }

    @Test
    public void testTruncateLong() {
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((long)12345L, (long)1000L));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((long)12000L, (long)1000L));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((long)12001L, (long)1000L));
        Assert.assertEquals((long)11000L, (long)SqlFunctions.truncate((long)11999L, (long)1000L));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((long)-12345L, (long)1000L));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((long)-12000L, (long)1000L));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((long)-12001L, (long)1000L));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((long)-11999L, (long)1000L));
    }

    @Test
    public void testTruncateInt() {
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((int)12345, (int)1000));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((int)12000, (int)1000));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((int)12001, (int)1000));
        Assert.assertEquals((long)11000L, (long)SqlFunctions.truncate((int)11999, (int)1000));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((int)-12345, (int)1000));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((int)-12000, (int)1000));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((int)-12001, (int)1000));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((int)-11999, (int)1000));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.round((int)12345, (int)1000));
        Assert.assertEquals((long)13000L, (long)SqlFunctions.round((int)12845, (int)1000));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.round((int)-12345, (int)1000));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.round((int)-12845, (int)1000));
    }

    @Test
    public void testByteString() {
        byte[] bytes = new byte[]{-85, -1};
        ByteString byteString = new ByteString(bytes);
        Assert.assertEquals((long)2L, (long)byteString.length());
        Assert.assertEquals((Object)"abff", (Object)byteString.toString());
        Assert.assertEquals((Object)"abff", (Object)byteString.toString(16));
        Assert.assertEquals((Object)"1010101111111111", (Object)byteString.toString(2));
        ByteString emptyByteString = new ByteString(new byte[0]);
        Assert.assertEquals((long)0L, (long)emptyByteString.length());
        Assert.assertEquals((Object)"", (Object)emptyByteString.toString());
        Assert.assertEquals((Object)"", (Object)emptyByteString.toString(16));
        Assert.assertEquals((Object)"", (Object)emptyByteString.toString(2));
        Assert.assertEquals((Object)emptyByteString, (Object)ByteString.EMPTY);
        Assert.assertEquals((Object)"ff", (Object)byteString.substring(1, 2).toString());
        Assert.assertEquals((Object)"abff", (Object)byteString.substring(0, 2).toString());
        Assert.assertEquals((Object)"", (Object)byteString.substring(2, 2).toString());
        Assert.assertSame((Object)byteString.concat(emptyByteString), (Object)byteString);
        ByteString byteString1 = new ByteString(new byte[]{12});
        Assert.assertEquals((Object)"abff0c", (Object)byteString.concat(byteString1).toString());
        byte[] bytes3 = new byte[]{-1};
        ByteString byteString3 = new ByteString(bytes3);
        Assert.assertEquals((long)0L, (long)byteString.indexOf(emptyByteString));
        Assert.assertEquals((long)-1L, (long)byteString.indexOf(byteString1));
        Assert.assertEquals((long)1L, (long)byteString.indexOf(byteString3));
        Assert.assertEquals((long)-1L, (long)byteString3.indexOf(byteString));
    }

    @Test
    public void testEasyLog10() {
        Assert.assertEquals((long)1L, (long)SqlFunctions.digitCount((int)0));
        Assert.assertEquals((long)1L, (long)SqlFunctions.digitCount((int)1));
        Assert.assertEquals((long)1L, (long)SqlFunctions.digitCount((int)9));
        Assert.assertEquals((long)2L, (long)SqlFunctions.digitCount((int)10));
        Assert.assertEquals((long)2L, (long)SqlFunctions.digitCount((int)11));
        Assert.assertEquals((long)2L, (long)SqlFunctions.digitCount((int)99));
        Assert.assertEquals((long)3L, (long)SqlFunctions.digitCount((int)100));
    }
}

