/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJdbcSchemaJoinTest {
    @Test
    public void test() throws SQLException, ClassNotFoundException {
        String db1 = TempDb.INSTANCE.getUrl();
        Connection c1 = DriverManager.getConnection(db1, "", "");
        Statement stmt1 = c1.createStatement();
        stmt1.execute("create table table1(id varchar(10) not null primary key, field1 varchar(10))");
        stmt1.execute("insert into table1 values('a', 'aaaa')");
        c1.close();
        String db2 = TempDb.INSTANCE.getUrl();
        Connection c2 = DriverManager.getConnection(db2, "", "");
        Statement stmt2 = c2.createStatement();
        stmt2.execute("create table table2(id varchar(10) not null primary key, field1 varchar(10))");
        stmt2.execute("insert into table2 values('a', 'aaaa')");
        c2.close();
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        DataSource ds1 = JdbcSchema.dataSource((String)db1, (String)"org.hsqldb.jdbcDriver", (String)"", (String)"");
        rootSchema.add("DB1", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB1", (DataSource)ds1, null, null));
        DataSource ds2 = JdbcSchema.dataSource((String)db2, (String)"org.hsqldb.jdbcDriver", (String)"", (String)"");
        rootSchema.add("DB2", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB2", (DataSource)ds2, null, null));
        Statement stmt3 = connection.createStatement();
        ResultSet rs = stmt3.executeQuery("select table1.id, table1.field1 from db1.table1 join db2.table2 on table1.id = table2.id");
        Assert.assertThat((Object)OptiqAssert.toString(rs), (Matcher)CoreMatchers.equalTo((Object)"ID=a; FIELD1=aaaa\n"));
    }

    @Test
    public void test2() throws SQLException, ClassNotFoundException {
        this.test();
    }

    private Connection setup() throws SQLException {
        String db = TempDb.INSTANCE.getUrl();
        Connection c1 = DriverManager.getConnection(db, "", "");
        Statement stmt1 = c1.createStatement();
        stmt1.execute("create table table1(id integer not null primary key, field1 varchar(10))");
        stmt1.execute("insert into table1 values(100, 'foo')");
        stmt1.execute("insert into table1 values(200, 'bar')");
        c1.close();
        Connection optiqConn = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = optiqConn.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("DB", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"DB", (DataSource)JdbcSchema.dataSource((String)db, (String)"org.hsqldb.jdbcDriver", (String)"", (String)""), null, null));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        return optiqConn;
    }

    @Test
    public void testJdbcWithEnumerableJoin() throws SQLException {
        String query = "select t.id, t.field1 from db.table1 t join \"hr\".\"emps\" e on e.\"empid\" = t.id";
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{100, 200});
        Assert.assertThat(this.runQuery(this.setup(), query), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testEnumerableWithJdbcJoin() throws SQLException {
        String query = "select t.id, t.field1 from \"hr\".\"emps\" e join db.table1 t on e.\"empid\" = t.id";
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{100, 200});
        Assert.assertThat(this.runQuery(this.setup(), query), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testEnumerableWithJdbcJoinWithWhereClause() throws SQLException {
        String query = "select t.id, t.field1 from \"hr\".\"emps\" e join db.table1 t on e.\"empid\" = t.id where e.\"name\" = 'Bill'";
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{100});
        Assert.assertThat(this.runQuery(this.setup(), query), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private Set<Integer> runQuery(Connection optiqConn, String query) throws SQLException {
        Statement stmt = optiqConn.createStatement();
        try {
            ResultSet rs;
            if (OptiqPrepareImpl.DEBUG) {
                rs = stmt.executeQuery("explain plan for " + query);
                rs.next();
                System.out.println(rs.getString(1));
            }
            rs = stmt.executeQuery(query);
            HashSet ids = Sets.newHashSet();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
            HashSet hashSet = ids;
            return hashSet;
        }
        finally {
            stmt.close();
        }
    }

    static class TempDb {
        public static final TempDb INSTANCE = new TempDb();
        private final AtomicInteger id = new AtomicInteger(1);

        TempDb() {
        }

        public String getUrl() {
            return "jdbc:hsqldb:mem:db" + this.id.getAndIncrement();
        }
    }
}

