/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import net.hydromatic.optiq.test.OptiqAssert;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcFrontJdbcBackLinqMiddleTest {
    @Test
    public void testTable() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select * from \"foodmart\".\"days\"").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\nday=5; week_day=Thursday\nday=4; week_day=Wednesday\nday=3; week_day=Tuesday\nday=6; week_day=Friday\nday=7; week_day=Saturday\n");
    }

    @Test
    public void testWhere() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select * from \"foodmart\".\"days\" where \"day\" < 3").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\n");
    }

    @Test
    public void testWhere2() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select * from \"foodmart\".\"days\"\nwhere not (lower(\"week_day\") = 'wednesday')").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\nday=5; week_day=Thursday\nday=3; week_day=Tuesday\nday=6; week_day=Friday\nday=7; week_day=Saturday\n");
    }

    @Test
    public void testCase() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select \"day\",\n \"week_day\",\n case when \"day\" < 3 then upper(\"week_day\")\n      when \"day\" < 5 then lower(\"week_day\")\n      else \"week_day\" end as d\nfrom \"foodmart\".\"days\"\nwhere \"day\" <> 1\norder by \"day\"").returns("day=2; week_day=Monday; D=MONDAY\nday=3; week_day=Tuesday; D=tuesday\nday=4; week_day=Wednesday; D=wednesday\nday=5; week_day=Thursday; D=Thursday\nday=6; week_day=Friday; D=Friday\nday=7; week_day=Saturday; D=Saturday\n");
    }

    @Test
    public void testGroup() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select s, count(*) as c, min(\"week_day\") as mw from (\nselect \"week_day\",\n  substring(\"week_day\" from 1 for 1) as s\nfrom \"foodmart\".\"days\")\ngroup by s").returnsUnordered("S=T; C=2; MW=Thursday", "S=F; C=1; MW=Friday", "S=W; C=1; MW=Wednesday", "S=S; C=2; MW=Saturday", "S=M; C=1; MW=Monday");
    }

    @Test
    public void testGroupEmpty() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) as c\nfrom \"foodmart\".\"days\"").returns("C=7\n");
    }

    @Test
    public void testJoinTheta() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) from (\n  select *\n  from \"foodmart\".\"sales_fact_1997\" as s\n  join \"foodmart\".\"customer\" as c\n  on s.\"customer_id\" - c.\"customer_id\" = 0)").throws_(" could not be implemented");
    }

    @Test
    public void testJoinGroupByEmpty() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) from (\n  select *\n  from \"foodmart\".\"sales_fact_1997\" as s\n  join \"foodmart\".\"customer\" as c\n  on s.\"customer_id\" = c.\"customer_id\")").returns("EXPR$0=86837\n");
    }

    @Test
    public void testJoinGroupByOrderBy() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*), c.\"state_province\", sum(s.\"unit_sales\") as s\nfrom \"foodmart\".\"sales_fact_1997\" as s\n  join \"foodmart\".\"customer\" as c\n  on s.\"customer_id\" = c.\"customer_id\"\ngroup by c.\"state_province\"\norder by c.\"state_province\"").returns("EXPR$0=24442; state_province=CA; S=74748.0000\nEXPR$0=21611; state_province=OR; S=67659.0000\nEXPR$0=40784; state_province=WA; S=124366.0000\n");
    }

    @Test
    public void testCompositeGroupBy() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) as c, c.\"state_province\"\nfrom \"foodmart\".\"customer\" as c\ngroup by c.\"state_province\", c.\"country\"\norder by c, 1").returns("C=78; state_province=Sinaloa\nC=90; state_province=Oaxaca\nC=93; state_province=Veracruz\nC=97; state_province=Mexico\nC=99; state_province=Yucatan\nC=104; state_province=Jalisco\nC=106; state_province=Guerrero\nC=191; state_province=Zacatecas\nC=347; state_province=DF\nC=1051; state_province=OR\nC=1717; state_province=BC\nC=2086; state_province=WA\nC=4222; state_province=CA\n");
    }

    @Ignore
    @Test
    public void testDistinctCount() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select c.\"state_province\",\n  sum(s.\"unit_sales\") as s,\n  count(distinct c.\"customer_id\") as dc\nfrom \"foodmart\".\"sales_fact_1997\" as s\n  join \"foodmart\".\"customer\" as c\n  on s.\"customer_id\" = c.\"customer_id\"\ngroup by c.\"state_province\", c.\"country\"\norder by c.\"state_province\", 2").planHasSql("SELECT `state_province`, `S`, `DC`\nFROM (SELECT `customer`.`state_province`, `customer`.`country`, SUM(`sales_fact_1997`.`unit_sales`) AS `S`, COUNT(DISTINCT `customer`.`customer_id`) AS `DC`\nFROM `foodmart`.`sales_fact_1997`\nINNER JOIN `foodmart`.`customer` ON `sales_fact_1997`.`customer_id` = `customer`.`customer_id`\nGROUP BY `customer`.`state_province`, `customer`.`country`) AS `t0`\nORDER BY `state_province`, `S`").returns("state_province=CA; S=74748.0000; DC=2716\nstate_province=OR; S=67659.0000; DC=1037\nstate_province=WA; S=124366.0000; DC=1828\n");
    }

    @Ignore
    @Test
    public void testPlan() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select c.\"state_province\"\nfrom \"foodmart\".\"customer\" as c\nwhere c.\"state_province\" = 'USA'").planContains("            public boolean moveNext() {\n              while (inputEnumerator.moveNext()) {\n                final String v = (String) ((Object[]) inputEnumerator.current())[10];\n                if (v != null && net.hydromatic.optiq.runtime.SqlFunctions.eq(v, \"USA\")) {\n                  return true;\n                }\n              }\n              return false;\n            }\n");
    }

    @Ignore
    @Test
    public void testPlan2() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).withSchema("foodmart").query("select \"customer\".\"state_province\" as \"c0\",\n \"customer\".\"country\" as \"c1\"\nfrom \"customer\" as \"customer\"\nwhere (\"customer\".\"country\" = 'USA')\nand UPPER(\"customer\".\"state_province\") = UPPER('CA')\ngroup by \"customer\".\"state_province\", \"customer\".\"country\"\norder by \"customer\".\"state_province\" ASC").planContains("          public boolean moveNext() {\n            while (inputEnumerator.moveNext()) {\n              final Object[] current12 = (Object[]) inputEnumerator.current();\n              final String v1 = (String) current12[10];\n              if (net.hydromatic.optiq.runtime.SqlFunctions.eq((String) current12[12], \"USA\") && (v1 != null && net.hydromatic.optiq.runtime.SqlFunctions.eq(net.hydromatic.optiq.runtime.SqlFunctions.upper(v1), net.hydromatic.optiq.runtime.SqlFunctions.trim(net.hydromatic.optiq.runtime.SqlFunctions.upper(\"CA\"))))) {\n                return true;\n              }\n            }\n            return false;\n          }\n");
    }

    @Test
    public void testPlan3() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store\".\"store_country\" as \"c0\", sum(\"inventory_fact_1997\".\"supply_time\") as \"m0\" from \"store\" as \"store\", \"inventory_fact_1997\" as \"inventory_fact_1997\" where \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"store\".\"store_country\"").planContains("  final net.hydromatic.linq4j.Enumerable _inputEnumerable1 = left.join(right, new net.hydromatic.linq4j.function.Function1() {\n");
    }
}

