/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUserDefinedFunction
extends SqlFunction {
    public final Function function;

    public SqlUserDefinedFunction(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, Function function) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, null, null);
        this.function = function;
    }

    public Table getTable(RelDataTypeFactory typeFactory, List<SqlNode> operandList) {
        if (!(this.function instanceof TableMacro)) {
            return null;
        }
        TableMacro tableMacro = (TableMacro)this.function;
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Pair<FunctionParameter, SqlNode> pair : Pair.zip(tableMacro.getParameters(), operandList)) {
            if (SqlUtil.isNullLiteral((SqlNode)pair.right, true)) {
                arguments.add(null);
                continue;
            }
            if (SqlUtil.isLiteral((SqlNode)pair.right)) {
                Object o = ((SqlLiteral)pair.right).getValue();
                Object o2 = this.coerce(o, ((FunctionParameter)pair.left).getType(typeFactory));
                if (o2 == null) {
                    return null;
                }
                arguments.add(o2);
                continue;
            }
            return null;
        }
        return tableMacro.apply(arguments);
    }

    private Object coerce(Object o, RelDataType type) {
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isInstance(o)) {
            return o;
        }
        if (clazz == String.class && o instanceof NlsString) {
            return ((NlsString)o).getValue();
        }
        return null;
    }
}

