/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.type.SqlReturnTypeInference;

public class SqlReturnTypeInferenceChain
implements SqlReturnTypeInference {
    private final ImmutableList<SqlReturnTypeInference> rules;

    SqlReturnTypeInferenceChain(SqlReturnTypeInference ... rules) {
        assert (rules != null);
        assert (rules.length > 1);
        SqlReturnTypeInference[] sqlReturnTypeInferenceArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            SqlReturnTypeInference rule = sqlReturnTypeInferenceArray[n2];
            assert (rule != null);
            ++n2;
        }
        this.rules = ImmutableList.copyOf((Object[])rules);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (SqlReturnTypeInference rule : this.rules) {
            RelDataType ret = rule.inferReturnType(opBinding);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

