/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.fun.SqlCase;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCaseOperator
extends SqlOperator {
    public static final SqlCaseOperator INSTANCE = new SqlCaseOperator();
    private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("CASE");

    private SqlCaseOperator() {
        super("CASE", SqlKind.CASE, 200, true, null, InferTypes.RETURN_TYPE, null);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        SqlCase sqlCase = (SqlCase)call;
        SqlNodeList whenOperands = sqlCase.getWhenOperands();
        SqlNodeList thenOperands = sqlCase.getThenOperands();
        SqlNode elseOperand = sqlCase.getElseOperand();
        for (SqlNode operand : whenOperands) {
            operand.validateExpr(validator, operandScope);
        }
        for (SqlNode operand : thenOperands) {
            operand.validateExpr(validator, operandScope);
        }
        if (elseOperand != null) {
            elseOperand.validateExpr(validator, operandScope);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlCase caseCall = (SqlCase)callBinding.getCall();
        SqlNodeList whenList = caseCall.getWhenOperands();
        SqlNodeList thenList = caseCall.getThenOperands();
        assert (whenList.size() == thenList.size());
        for (SqlNode node : whenList) {
            RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
            if (SqlTypeUtil.inBooleanFamily(type)) continue;
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.expectedBoolean());
            }
            return false;
        }
        boolean foundNotNull = false;
        for (SqlNode node : thenList) {
            if (SqlUtil.isNullLiteral(node, false)) continue;
            foundNotNull = true;
        }
        if (!SqlUtil.isNullLiteral(caseCall.getElseOperand(), false)) {
            foundNotNull = true;
        }
        if (!foundNotNull) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.mustNotNullInElse());
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        if (!(opBinding instanceof SqlCallBinding)) {
            return this.inferTypeFromOperands(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        }
        return this.inferTypeFromValidator((SqlCallBinding)opBinding);
    }

    private RelDataType inferTypeFromValidator(SqlCallBinding callBinding) {
        RelDataType ret;
        SqlCase caseCall = (SqlCase)callBinding.getCall();
        SqlNodeList thenList = caseCall.getThenOperands();
        ArrayList<SqlNode> nullList = new ArrayList<SqlNode>();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        for (SqlNode node : thenList) {
            argTypes.add(callBinding.getValidator().deriveType(callBinding.getScope(), node));
            if (!SqlUtil.isNullLiteral(node, false)) continue;
            nullList.add(node);
        }
        SqlNode elseOp = caseCall.getElseOperand();
        argTypes.add(callBinding.getValidator().deriveType(callBinding.getScope(), caseCall.getElseOperand()));
        if (SqlUtil.isNullLiteral(elseOp, false)) {
            nullList.add(elseOp);
        }
        if ((ret = callBinding.getTypeFactory().leastRestrictive(argTypes)) == null) {
            throw callBinding.newValidationError(Static.RESOURCE.illegalMixingOfTypes());
        }
        for (SqlNode node : nullList) {
            callBinding.getValidator().setValidatedNodeType(node, ret);
        }
        return ret;
    }

    private RelDataType inferTypeFromOperands(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        assert (argTypes.size() % 2 == 1) : "odd number of arguments expected: " + argTypes.size();
        assert (argTypes.size() > 1) : argTypes.size();
        ArrayList<RelDataType> thenTypes = new ArrayList<RelDataType>();
        int j = 1;
        while (j < argTypes.size() - 1) {
            thenTypes.add(argTypes.get(j));
            j += 2;
        }
        thenTypes.add((RelDataType)Iterables.getLast(argTypes));
        return typeFactory.leastRestrictive(thenTypes);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        assert (operands.length == 4);
        return new SqlCase(pos, operands[0], (SqlNodeList)operands[1], (SqlNodeList)operands[2], operands[3]);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call_, int leftPrec, int rightPrec) {
        SqlCase kase = (SqlCase)call_;
        SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "CASE", "END");
        assert (kase.whenList.size() == kase.thenList.size());
        if (kase.value != null) {
            kase.value.unparse(writer, 0, 0);
        }
        for (Pair<SqlNode, SqlNode> pair : Pair.zip(kase.whenList, kase.thenList)) {
            writer.sep("WHEN");
            ((SqlNode)pair.left).unparse(writer, 0, 0);
            writer.sep("THEN");
            ((SqlNode)pair.right).unparse(writer, 0, 0);
        }
        writer.sep("ELSE");
        kase.elseExpr.unparse(writer, 0, 0);
        writer.endList(frame);
    }
}

