/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Calendar;
import org.eigenbase.sql.SqlAbstractDateTimeLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;

public class SqlTimestampLiteral
extends SqlAbstractDateTimeLiteral {
    public SqlTimestampLiteral(Calendar cal, int precision, boolean hasTimeZone, SqlParserPos pos) {
        super(cal, hasTimeZone, SqlTypeName.TIMESTAMP, precision, "yyyy-MM-dd HH:mm:ss", pos);
    }

    public SqlTimestampLiteral(Calendar cal, int precision, boolean hasTimeZone, String format, SqlParserPos pos) {
        super(cal, hasTimeZone, SqlTypeName.TIMESTAMP, precision, format, pos);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimestampLiteral((Calendar)this.value, this.precision, this.hasTimeZone, this.formatString, pos);
    }

    public String toString() {
        return "TIMESTAMP '" + this.toFormattedString() + "'";
    }

    public String toFormattedString() {
        String result = this.getTimestamp().toString(this.formatString);
        Calendar cal = this.getCal();
        if (this.precision > 0) {
            assert (this.precision <= 3);
            String digits = Long.toString(cal.getTimeInMillis());
            result = String.valueOf(result) + "." + digits.substring(digits.length() - 3, digits.length() - 3 + this.precision);
        } else assert (cal.get(14) == 0);
        return result;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (writer.getDialect().getDatabaseProduct()) {
            case MSSQL: {
                writer.literal("'" + this.toFormattedString() + "'");
                break;
            }
            default: {
                writer.literal(this.toString());
            }
        }
    }
}

