/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlIntervalQualifier
extends SqlNode {
    private static final int USE_DEFAULT_PRECISION = -1;
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal THOUSAND = BigDecimal.valueOf(1000L);
    private static final BigDecimal INT_MAX_VALUE_PLUS_ONE = BigDecimal.valueOf(Integer.MAX_VALUE).add(BigDecimal.ONE);
    private final int startPrecision;
    private final TimeUnitRange timeUnitRange;
    private final int fractionalSecondPrecision;
    private final boolean useDefaultStartPrecision;
    private final boolean useDefaultFractionalSecondPrecision;
    private static final BigDecimal[] POWERS10 = new BigDecimal[]{ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(10000L), BigDecimal.valueOf(100000L), BigDecimal.valueOf(1000000L), BigDecimal.valueOf(10000000L), BigDecimal.valueOf(100000000L), BigDecimal.valueOf(1000000000L)};

    public SqlIntervalQualifier(TimeUnit startUnit, int startPrecision, TimeUnit endUnit, int fractionalSecondPrecision, SqlParserPos pos) {
        super(pos);
        assert (startUnit != null);
        this.timeUnitRange = TimeUnitRange.of(startUnit, endUnit);
        if (startPrecision == -1) {
            this.useDefaultStartPrecision = true;
            this.startPrecision = this.isYearMonth() ? SqlTypeName.INTERVAL_YEAR_MONTH.getDefaultPrecision() : SqlTypeName.INTERVAL_DAY_TIME.getDefaultPrecision();
        } else {
            this.useDefaultStartPrecision = false;
            this.startPrecision = startPrecision;
        }
        if (fractionalSecondPrecision == -1) {
            this.useDefaultFractionalSecondPrecision = true;
            this.fractionalSecondPrecision = this.isYearMonth() ? SqlTypeName.INTERVAL_YEAR_MONTH.getDefaultScale() : SqlTypeName.INTERVAL_DAY_TIME.getDefaultScale();
        } else {
            this.useDefaultFractionalSecondPrecision = false;
            this.fractionalSecondPrecision = fractionalSecondPrecision;
        }
    }

    public SqlIntervalQualifier(TimeUnit startUnit, TimeUnit endUnit, SqlParserPos pos) {
        this(startUnit, -1, endUnit, -1, pos);
    }

    public SqlFunctions.TimeUnitRange foo() {
        return SqlFunctions.TimeUnitRange.valueOf(this.timeUnitRange.name());
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateIntervalQualifier(this);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        String thatString;
        String thisString = this.toString();
        if (!thisString.equals(thatString = node.toString())) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return true;
    }

    public static int getDefaultPrecisionId() {
        return -1;
    }

    public int getStartPrecision() {
        return this.startPrecision;
    }

    public int getStartPrecisionPreservingDefault() {
        if (this.useDefaultStartPrecision) {
            return -1;
        }
        return this.startPrecision;
    }

    public static int combineStartPrecisionPreservingDefault(SqlIntervalQualifier qual1, SqlIntervalQualifier qual2) {
        if (qual1.getStartPrecision() > qual2.getStartPrecision()) {
            return qual1.getStartPrecisionPreservingDefault();
        }
        if (qual1.getStartPrecision() < qual2.getStartPrecision()) {
            return qual2.getStartPrecisionPreservingDefault();
        }
        if (qual1.useDefaultStartPrecision && qual2.useDefaultStartPrecision) {
            return qual1.getStartPrecisionPreservingDefault();
        }
        return qual1.getStartPrecision();
    }

    public int getFractionalSecondPrecision() {
        return this.fractionalSecondPrecision;
    }

    public int getFractionalSecondPrecisionPreservingDefault() {
        if (this.useDefaultFractionalSecondPrecision) {
            return -1;
        }
        return this.startPrecision;
    }

    public static int combineFractionalSecondPrecisionPreservingDefault(SqlIntervalQualifier qual1, SqlIntervalQualifier qual2) {
        if (qual1.getFractionalSecondPrecision() > qual2.getFractionalSecondPrecision()) {
            return qual1.getFractionalSecondPrecisionPreservingDefault();
        }
        if (qual1.getFractionalSecondPrecision() < qual2.getFractionalSecondPrecision()) {
            return qual2.getFractionalSecondPrecisionPreservingDefault();
        }
        if (qual1.useDefaultFractionalSecondPrecision && qual2.useDefaultFractionalSecondPrecision) {
            return qual1.getFractionalSecondPrecisionPreservingDefault();
        }
        return qual1.getFractionalSecondPrecision();
    }

    public TimeUnit getStartUnit() {
        return this.timeUnitRange.startUnit;
    }

    public TimeUnit getEndUnit() {
        return this.timeUnitRange.endUnit;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlIntervalQualifier(this.timeUnitRange.startUnit, this.useDefaultStartPrecision ? -1 : this.startPrecision, this.timeUnitRange.endUnit, this.useDefaultFractionalSecondPrecision ? -1 : this.fractionalSecondPrecision, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        String start = this.timeUnitRange.startUnit.name();
        if (this.timeUnitRange.startUnit == TimeUnit.SECOND) {
            if (!this.useDefaultFractionalSecondPrecision) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(this.startPrecision);
                writer.sep(",", true);
                writer.print(this.fractionalSecondPrecision);
                writer.endList(frame);
            } else if (!this.useDefaultStartPrecision) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(this.startPrecision);
                writer.endList(frame);
            } else {
                writer.keyword(start);
            }
        } else {
            if (!this.useDefaultStartPrecision) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(this.startPrecision);
                writer.endList(frame);
            } else {
                writer.keyword(start);
            }
            if (this.timeUnitRange.endUnit != null) {
                writer.keyword("TO");
                String end = this.timeUnitRange.endUnit.name();
                if (TimeUnit.SECOND == this.timeUnitRange.endUnit && !this.useDefaultFractionalSecondPrecision) {
                    SqlWriter.Frame frame = writer.startFunCall(end);
                    writer.print(this.fractionalSecondPrecision);
                    writer.endList(frame);
                } else {
                    writer.keyword(end);
                }
            }
        }
    }

    public boolean isSingleDatetimeField() {
        return this.timeUnitRange.endUnit == null;
    }

    public final boolean isYearMonth() {
        return ((TimeUnitRange)this.timeUnitRange).startUnit.yearMonth;
    }

    private int getIntervalSign(String value) {
        int sign = 1;
        if (!Util.isNullOrEmpty(value) && '-' == value.charAt(0)) {
            sign = -1;
        }
        return sign;
    }

    private String stripLeadingSign(String value) {
        String unsignedValue = value;
        if (!(Util.isNullOrEmpty(value) || '-' != value.charAt(0) && '+' != value.charAt(0))) {
            unsignedValue = value.substring(1);
        }
        return unsignedValue;
    }

    private boolean isLeadFieldInRange(BigDecimal value, TimeUnit unit) {
        assert (value.compareTo(ZERO) >= 0);
        return this.startPrecision < POWERS10.length ? value.compareTo(POWERS10[this.startPrecision]) < 0 : value.compareTo(INT_MAX_VALUE_PLUS_ONE) < 0;
    }

    private void checkLeadFieldInRange(int sign, BigDecimal value, TimeUnit unit, SqlParserPos pos) {
        if (!this.isLeadFieldInRange(value, unit)) {
            throw this.fieldExceedsPrecisionException(pos, sign, value, unit, this.startPrecision);
        }
    }

    private boolean isFractionalSecondFieldInRange(BigDecimal field) {
        assert (field.compareTo(ZERO) >= 0);
        return true;
    }

    private boolean isSecondaryFieldInRange(BigDecimal field, TimeUnit unit) {
        assert (field.compareTo(ZERO) >= 0);
        assert (unit != null);
        switch (unit) {
            default: {
                throw Util.unexpected(unit);
            }
            case MONTH: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
        }
        return unit.isValidValue(field);
    }

    private BigDecimal normalizeSecondFraction(String secondFracStr) {
        return new BigDecimal("0." + secondFracStr).multiply(THOUSAND);
    }

    private int[] fillIntervalValueArray(int sign, BigDecimal year, BigDecimal month) {
        int[] ret = new int[]{sign, year.intValue(), month.intValue()};
        return ret;
    }

    private int[] fillIntervalValueArray(int sign, BigDecimal day, BigDecimal hour, BigDecimal minute, BigDecimal second, BigDecimal secondFrac) {
        int[] ret = new int[]{sign, day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), secondFrac.intValue()};
        return ret;
    }

    private int[] evaluateIntervalLiteralAsYear(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal year;
            try {
                year = this.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, year, TimeUnit.YEAR, pos);
            return this.fillIntervalValueArray(sign, year, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsYearToMonth(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)-(\\d{1,2})";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal month;
            BigDecimal year;
            try {
                year = this.parseField(m, 1);
                month = this.parseField(m, 2);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, year, TimeUnit.YEAR, pos);
            if (!this.isSecondaryFieldInRange(month, TimeUnit.MONTH)) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, year, month);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsMonth(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal month;
            try {
                month = this.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, month, TimeUnit.MONTH, pos);
            return this.fillIntervalValueArray(sign, ZERO, month);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsDay(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal day;
            try {
                day = this.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, day, TimeUnit.DAY, pos);
            return this.fillIntervalValueArray(sign, day, ZERO, ZERO, ZERO, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsDayToHour(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+) (\\d{1,2})";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal hour;
            BigDecimal day;
            try {
                day = this.parseField(m, 1);
                hour = this.parseField(m, 2);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, day, TimeUnit.DAY, pos);
            if (!this.isSecondaryFieldInRange(hour, TimeUnit.HOUR)) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, day, hour, ZERO, ZERO, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsDayToMinute(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+) (\\d{1,2}):(\\d{1,2})";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal minute;
            BigDecimal hour;
            BigDecimal day;
            try {
                day = this.parseField(m, 1);
                hour = this.parseField(m, 2);
                minute = this.parseField(m, 3);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, day, TimeUnit.DAY, pos);
            if (!this.isSecondaryFieldInRange(hour, TimeUnit.HOUR) || !this.isSecondaryFieldInRange(minute, TimeUnit.MINUTE)) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, day, hour, minute, ZERO, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsDayToSecond(int sign, String value, String originalValue, SqlParserPos pos) {
        boolean hasFractionalSecond;
        String intervalPatternWithFracSec = "(\\d+) (\\d{1,2}):(\\d{1,2}):(\\d{1,2})\\.(\\d{1," + this.fractionalSecondPrecision + "})";
        String intervalPatternWithoutFracSec = "(\\d+) (\\d{1,2}):(\\d{1,2}):(\\d{1,2})";
        Matcher m = Pattern.compile(intervalPatternWithFracSec).matcher(value);
        if (m.matches()) {
            hasFractionalSecond = true;
        } else {
            m = Pattern.compile(intervalPatternWithoutFracSec).matcher(value);
            hasFractionalSecond = false;
        }
        if (m.matches()) {
            BigDecimal second;
            BigDecimal minute;
            BigDecimal hour;
            BigDecimal day;
            try {
                day = this.parseField(m, 1);
                hour = this.parseField(m, 2);
                minute = this.parseField(m, 3);
                second = this.parseField(m, 4);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            BigDecimal secondFrac = hasFractionalSecond ? this.normalizeSecondFraction(m.group(5)) : ZERO;
            this.checkLeadFieldInRange(sign, day, TimeUnit.DAY, pos);
            if (!(this.isSecondaryFieldInRange(hour, TimeUnit.HOUR) && this.isSecondaryFieldInRange(minute, TimeUnit.MINUTE) && this.isSecondaryFieldInRange(second, TimeUnit.SECOND) && this.isFractionalSecondFieldInRange(secondFrac))) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, day, hour, minute, second, secondFrac);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsHour(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal hour;
            try {
                hour = this.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, hour, TimeUnit.HOUR, pos);
            return this.fillIntervalValueArray(sign, ZERO, hour, ZERO, ZERO, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsHourToMinute(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+):(\\d{1,2})";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal minute;
            BigDecimal hour;
            try {
                hour = this.parseField(m, 1);
                minute = this.parseField(m, 2);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, hour, TimeUnit.HOUR, pos);
            if (!this.isSecondaryFieldInRange(minute, TimeUnit.MINUTE)) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, ZERO, hour, minute, ZERO, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsHourToSecond(int sign, String value, String originalValue, SqlParserPos pos) {
        boolean hasFractionalSecond;
        String intervalPatternWithFracSec = "(\\d+):(\\d{1,2}):(\\d{1,2})\\.(\\d{1," + this.fractionalSecondPrecision + "})";
        String intervalPatternWithoutFracSec = "(\\d+):(\\d{1,2}):(\\d{1,2})";
        Matcher m = Pattern.compile(intervalPatternWithFracSec).matcher(value);
        if (m.matches()) {
            hasFractionalSecond = true;
        } else {
            m = Pattern.compile(intervalPatternWithoutFracSec).matcher(value);
            hasFractionalSecond = false;
        }
        if (m.matches()) {
            BigDecimal second;
            BigDecimal minute;
            BigDecimal hour;
            try {
                hour = this.parseField(m, 1);
                minute = this.parseField(m, 2);
                second = this.parseField(m, 3);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            BigDecimal secondFrac = hasFractionalSecond ? this.normalizeSecondFraction(m.group(4)) : ZERO;
            this.checkLeadFieldInRange(sign, hour, TimeUnit.HOUR, pos);
            if (!(this.isSecondaryFieldInRange(minute, TimeUnit.MINUTE) && this.isSecondaryFieldInRange(second, TimeUnit.SECOND) && this.isFractionalSecondFieldInRange(secondFrac))) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, ZERO, hour, minute, second, secondFrac);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsMinute(int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal minute;
            try {
                minute = this.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            this.checkLeadFieldInRange(sign, minute, TimeUnit.MINUTE, pos);
            return this.fillIntervalValueArray(sign, ZERO, ZERO, minute, ZERO, ZERO);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsMinuteToSecond(int sign, String value, String originalValue, SqlParserPos pos) {
        boolean hasFractionalSecond;
        String intervalPatternWithFracSec = "(\\d+):(\\d{1,2})\\.(\\d{1," + this.fractionalSecondPrecision + "})";
        String intervalPatternWithoutFracSec = "(\\d+):(\\d{1,2})";
        Matcher m = Pattern.compile(intervalPatternWithFracSec).matcher(value);
        if (m.matches()) {
            hasFractionalSecond = true;
        } else {
            m = Pattern.compile(intervalPatternWithoutFracSec).matcher(value);
            hasFractionalSecond = false;
        }
        if (m.matches()) {
            BigDecimal second;
            BigDecimal minute;
            try {
                minute = this.parseField(m, 1);
                second = this.parseField(m, 2);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            BigDecimal secondFrac = hasFractionalSecond ? this.normalizeSecondFraction(m.group(3)) : ZERO;
            this.checkLeadFieldInRange(sign, minute, TimeUnit.MINUTE, pos);
            if (!this.isSecondaryFieldInRange(second, TimeUnit.SECOND) || !this.isFractionalSecondFieldInRange(secondFrac)) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, ZERO, ZERO, minute, second, secondFrac);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private int[] evaluateIntervalLiteralAsSecond(int sign, String value, String originalValue, SqlParserPos pos) {
        boolean hasFractionalSecond;
        String intervalPatternWithFracSec = "(\\d+)\\.(\\d{1," + this.fractionalSecondPrecision + "})";
        String intervalPatternWithoutFracSec = "(\\d+)";
        Matcher m = Pattern.compile(intervalPatternWithFracSec).matcher(value);
        if (m.matches()) {
            hasFractionalSecond = true;
        } else {
            m = Pattern.compile(intervalPatternWithoutFracSec).matcher(value);
            hasFractionalSecond = false;
        }
        if (m.matches()) {
            BigDecimal second;
            try {
                second = this.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            BigDecimal secondFrac = hasFractionalSecond ? this.normalizeSecondFraction(m.group(2)) : ZERO;
            this.checkLeadFieldInRange(sign, second, TimeUnit.SECOND, pos);
            if (!this.isFractionalSecondFieldInRange(secondFrac)) {
                throw this.invalidValueException(pos, originalValue);
            }
            return this.fillIntervalValueArray(sign, ZERO, ZERO, ZERO, second, secondFrac);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    public int[] evaluateIntervalLiteral(String value, SqlParserPos pos) {
        String value0 = value;
        value = value.trim();
        int sign = this.getIntervalSign(value);
        if (Util.isNullOrEmpty(value = this.stripLeadingSign(value))) {
            throw this.invalidValueException(pos, value0);
        }
        switch (this.timeUnitRange) {
            case YEAR: {
                return this.evaluateIntervalLiteralAsYear(sign, value, value0, pos);
            }
            case YEAR_TO_MONTH: {
                return this.evaluateIntervalLiteralAsYearToMonth(sign, value, value0, pos);
            }
            case MONTH: {
                return this.evaluateIntervalLiteralAsMonth(sign, value, value0, pos);
            }
            case DAY: {
                return this.evaluateIntervalLiteralAsDay(sign, value, value0, pos);
            }
            case DAY_TO_HOUR: {
                return this.evaluateIntervalLiteralAsDayToHour(sign, value, value0, pos);
            }
            case DAY_TO_MINUTE: {
                return this.evaluateIntervalLiteralAsDayToMinute(sign, value, value0, pos);
            }
            case DAY_TO_SECOND: {
                return this.evaluateIntervalLiteralAsDayToSecond(sign, value, value0, pos);
            }
            case HOUR: {
                return this.evaluateIntervalLiteralAsHour(sign, value, value0, pos);
            }
            case HOUR_TO_MINUTE: {
                return this.evaluateIntervalLiteralAsHourToMinute(sign, value, value0, pos);
            }
            case HOUR_TO_SECOND: {
                return this.evaluateIntervalLiteralAsHourToSecond(sign, value, value0, pos);
            }
            case MINUTE: {
                return this.evaluateIntervalLiteralAsMinute(sign, value, value0, pos);
            }
            case MINUTE_TO_SECOND: {
                return this.evaluateIntervalLiteralAsMinuteToSecond(sign, value, value0, pos);
            }
            case SECOND: {
                return this.evaluateIntervalLiteralAsSecond(sign, value, value0, pos);
            }
        }
        throw this.invalidValueException(pos, value0);
    }

    private BigDecimal parseField(Matcher m, int i) {
        return new BigDecimal(m.group(i));
    }

    private EigenbaseContextException invalidValueException(SqlParserPos pos, String value) {
        return SqlUtil.newContextException(pos, Static.RESOURCE.unsupportedIntervalLiteral("'" + value + "'", "INTERVAL " + this.toString()));
    }

    private EigenbaseContextException fieldExceedsPrecisionException(SqlParserPos pos, int sign, BigDecimal value, TimeUnit type, int precision) {
        if (sign == -1) {
            value = value.negate();
        }
        return SqlUtil.newContextException(pos, Static.RESOURCE.intervalFieldExceedsPrecision(value, String.valueOf(type.name()) + "(" + precision + ")"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeUnit implements SqlLiteral.SqlSymbol
    {
        YEAR(true, ' ', 12L, null),
        MONTH(true, '-', 1L, BigDecimal.valueOf(12L)),
        DAY(false, '-', 86400000L, null),
        HOUR(false, ' ', 3600000L, BigDecimal.valueOf(24L)),
        MINUTE(false, ':', 60000L, BigDecimal.valueOf(60L)),
        SECOND(false, ':', 1000L, BigDecimal.valueOf(60L));

        public final boolean yearMonth;
        public final char separator;
        public final long multiplier;
        private final BigDecimal limit;
        private static final TimeUnit[] CACHED_VALUES;
        public static final String GET_VALUE_METHOD_NAME = "getValue";

        static {
            CACHED_VALUES = TimeUnit.values();
        }

        private TimeUnit(boolean yearMonth, char separator, long multiplier, BigDecimal limit) {
            this.yearMonth = yearMonth;
            this.separator = separator;
            this.multiplier = multiplier;
            this.limit = limit;
        }

        public static TimeUnit getValue(int ordinal) {
            return ordinal < 0 || ordinal >= CACHED_VALUES.length ? null : CACHED_VALUES[ordinal];
        }

        public boolean isValidValue(BigDecimal field) {
            return field.compareTo(ZERO) >= 0 && (this.limit == null || field.compareTo(this.limit) < 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimeUnitRange
    extends Enum<TimeUnitRange> {
        public static final /* enum */ TimeUnitRange YEAR = new TimeUnitRange(TimeUnit.YEAR, null);
        public static final /* enum */ TimeUnitRange YEAR_TO_MONTH = new TimeUnitRange(TimeUnit.YEAR, TimeUnit.MONTH);
        public static final /* enum */ TimeUnitRange MONTH = new TimeUnitRange(TimeUnit.MONTH, null);
        public static final /* enum */ TimeUnitRange DAY = new TimeUnitRange(TimeUnit.DAY, null);
        public static final /* enum */ TimeUnitRange DAY_TO_HOUR = new TimeUnitRange(TimeUnit.DAY, TimeUnit.HOUR);
        public static final /* enum */ TimeUnitRange DAY_TO_MINUTE = new TimeUnitRange(TimeUnit.DAY, TimeUnit.MINUTE);
        public static final /* enum */ TimeUnitRange DAY_TO_SECOND = new TimeUnitRange(TimeUnit.DAY, TimeUnit.SECOND);
        public static final /* enum */ TimeUnitRange HOUR = new TimeUnitRange(TimeUnit.HOUR, null);
        public static final /* enum */ TimeUnitRange HOUR_TO_MINUTE = new TimeUnitRange(TimeUnit.HOUR, TimeUnit.MINUTE);
        public static final /* enum */ TimeUnitRange HOUR_TO_SECOND = new TimeUnitRange(TimeUnit.HOUR, TimeUnit.SECOND);
        public static final /* enum */ TimeUnitRange MINUTE = new TimeUnitRange(TimeUnit.MINUTE, null);
        public static final /* enum */ TimeUnitRange MINUTE_TO_SECOND = new TimeUnitRange(TimeUnit.MINUTE, TimeUnit.SECOND);
        public static final /* enum */ TimeUnitRange SECOND = new TimeUnitRange(TimeUnit.SECOND, null);
        private final TimeUnit startUnit;
        private final TimeUnit endUnit;
        private static final Map<Pair<TimeUnit, TimeUnit>, TimeUnitRange> MAP;
        private static final /* synthetic */ TimeUnitRange[] ENUM$VALUES;

        static {
            ENUM$VALUES = new TimeUnitRange[]{YEAR, YEAR_TO_MONTH, MONTH, DAY, DAY_TO_HOUR, DAY_TO_MINUTE, DAY_TO_SECOND, HOUR, HOUR_TO_MINUTE, HOUR_TO_SECOND, MINUTE, MINUTE_TO_SECOND, SECOND};
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TimeUnitRange[] timeUnitRangeArray = TimeUnitRange.values();
            int n = timeUnitRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeUnitRange value = timeUnitRangeArray[n2];
                builder.put(Pair.of(value.startUnit, value.endUnit), (Object)value);
                ++n2;
            }
            MAP = builder.build();
        }

        private TimeUnitRange(TimeUnit startUnit, TimeUnit endUnit) {
            assert (startUnit != null);
            this.startUnit = startUnit;
            this.endUnit = endUnit;
        }

        public static TimeUnitRange of(TimeUnit startUnit, TimeUnit endUnit) {
            return MAP.get(new Pair<TimeUnit, TimeUnit>(startUnit, endUnit));
        }

        public static TimeUnitRange[] values() {
            TimeUnitRange[] timeUnitRangeArray = ENUM$VALUES;
            int n = timeUnitRangeArray.length;
            TimeUnitRange[] timeUnitRangeArray2 = new TimeUnitRange[n];
            System.arraycopy(ENUM$VALUES, 0, timeUnitRangeArray2, 0, n);
            return timeUnitRangeArray2;
        }

        public static TimeUnitRange valueOf(String string) {
            return Enum.valueOf(TimeUnitRange.class, string);
        }
    }
}

