/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.reltype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeComparability;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFamily;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.reltype.RelDataTypePrecedenceList;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelDataTypeImpl
implements RelDataType,
RelDataTypeFamily {
    protected final List<RelDataTypeField> fieldList;
    protected String digest;

    protected RelDataTypeImpl(List<? extends RelDataTypeField> fieldList) {
        this.fieldList = fieldList != null ? ImmutableList.copyOf(fieldList) : null;
    }

    protected RelDataTypeImpl() {
        this(null);
    }

    @Override
    public RelDataTypeField getField(String fieldName, boolean caseSensitive) {
        RelDataTypeField lastField;
        for (RelDataTypeField field : this.fieldList) {
            if (!Util.match(caseSensitive, field.getName(), fieldName)) continue;
            return field;
        }
        if (this.fieldList.size() > 0 && (lastField = (RelDataTypeField)Iterables.getLast(this.fieldList)).getName().equals("_extra")) {
            return new RelDataTypeFieldImpl(fieldName, -1, lastField.getType());
        }
        return null;
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        assert (this.isStruct());
        return this.fieldList;
    }

    @Override
    public List<String> getFieldNames() {
        return Pair.left(this.fieldList);
    }

    @Override
    public int getFieldCount() {
        assert (this.isStruct()) : this;
        return this.fieldList.size();
    }

    @Override
    public RelDataType getComponentType() {
        return null;
    }

    @Override
    public RelDataType getKeyType() {
        return null;
    }

    @Override
    public RelDataType getValueType() {
        return null;
    }

    @Override
    public boolean isStruct() {
        return this.fieldList != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelDataTypeImpl) {
            RelDataTypeImpl that = (RelDataTypeImpl)obj;
            return this.digest.equals(that.digest);
        }
        return false;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    @Override
    public String getFullTypeString() {
        return this.digest;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Charset getCharset() {
        return null;
    }

    @Override
    public SqlCollation getCollation() {
        return null;
    }

    @Override
    public SqlIntervalQualifier getIntervalQualifier() {
        return null;
    }

    @Override
    public int getPrecision() {
        return -1;
    }

    @Override
    public int getScale() {
        return Integer.MIN_VALUE;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return null;
    }

    @Override
    public SqlIdentifier getSqlIdentifier() {
        SqlTypeName typeName = this.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return new SqlIdentifier(typeName.name(), SqlParserPos.ZERO);
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    protected abstract void generateTypeString(StringBuilder var1, boolean var2);

    protected void computeDigest() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, true);
        if (!this.isNullable()) {
            sb.append(" NOT NULL");
        }
        this.digest = sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, false);
        return sb.toString();
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            public boolean containsType(RelDataType type) {
                return RelDataTypeImpl.this.getFamily() == type.getFamily();
            }

            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                if (!$assertionsDisabled && !this.containsType(type1)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.containsType(type2)) {
                    throw new AssertionError();
                }
                return 0;
            }
        };
    }

    @Override
    public RelDataTypeComparability getComparability() {
        return RelDataTypeComparability.ALL;
    }

    public static RelProtoDataType proto(final RelDataType protoType) {
        assert (protoType != null);
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return typeFactory.copyType(protoType);
            }
        };
    }

    public static RelProtoDataType proto(final SqlTypeName typeName) {
        assert (typeName != null);
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(typeName);
            }
        };
    }

    public static RelProtoDataType proto(final SqlTypeName typeName, final int precision) {
        assert (typeName != null);
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(typeName, precision);
            }
        };
    }

    public static RelProtoDataType proto(final SqlTypeName typeName, final int precision, final int scale) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(typeName, precision, scale);
            }
        };
    }

    public static RelDataTypeField extra(RelDataType rowType) {
        return rowType.getField("_extra", true);
    }
}

