/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.volcano.RelSet;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.relopt.volcano.VolcanoPlanner;
import org.eigenbase.relopt.volcano.VolcanoRuleCall;

class VolcanoRuleMatch
extends VolcanoRuleCall {
    private final RelSet targetSet;
    private RelSubset targetSubset;
    private String digest;
    private final VolcanoPlanner volcanoPlanner;
    private double cachedImportance = Double.NaN;

    VolcanoRuleMatch(VolcanoPlanner volcanoPlanner, RelOptRuleOperand operand0, RelNode[] rels) {
        super(volcanoPlanner, operand0, (RelNode[])rels.clone());
        this.volcanoPlanner = volcanoPlanner;
        int i = 0;
        while (i < rels.length) {
            assert (rels[i] != null);
            ++i;
        }
        this.targetSet = volcanoPlanner.getSet(rels[0]);
        assert (this.targetSet != null) : String.valueOf(rels[0].toString()) + " isn't in a set";
        this.digest = this.computeDigest();
    }

    public String toString() {
        return this.digest;
    }

    void clearCachedImportance() {
        this.cachedImportance = Double.NaN;
    }

    double getImportance() {
        if (Double.isNaN(this.cachedImportance)) {
            this.cachedImportance = this.computeImportance();
        }
        return this.cachedImportance;
    }

    double computeImportance() {
        double targetImportance;
        RelSubset targetSubset;
        assert (this.rels[0] != null);
        RelSubset subset = this.volcanoPlanner.getSubset(this.rels[0]);
        double importance = 0.0;
        if (subset != null) {
            importance = this.volcanoPlanner.ruleQueue.getImportance(subset);
        }
        if ((targetSubset = this.guessSubset()) != null && targetSubset != subset && (targetImportance = this.volcanoPlanner.ruleQueue.getImportance(targetSubset)) > importance) {
            importance = targetImportance;
            if (subset != null) {
                subset.bestCost.isLt(targetSubset.bestCost);
            }
        }
        return importance;
    }

    private String computeDigest() {
        StringBuilder buf = new StringBuilder("rule [" + this.getRule() + "] rels [");
        int i = 0;
        while (i < this.rels.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.rels[i].toString());
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public void recomputeDigest() {
        this.digest = this.computeDigest();
    }

    private RelSubset guessSubset() {
        if (this.targetSubset != null) {
            return this.targetSubset;
        }
        RelTrait targetTrait = this.getRule().getOutTrait();
        if (this.targetSet != null && targetTrait != null) {
            RelTraitSet targetTraitSet = this.rels[0].getTraitSet().replace(targetTrait);
            this.targetSubset = this.targetSet.getSubset(targetTraitSet);
            return this.targetSubset;
        }
        return null;
    }
}

