/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import java.util.List;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.relopt.volcano.VolcanoPlanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractConverter
extends ConverterRelImpl {
    public AbstractConverter(RelOptCluster cluster, RelSubset rel, RelTraitDef traitDef, RelTraitSet traits) {
        super(cluster, traitDef, traits, rel);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new AbstractConverter(this.getCluster(), (RelSubset)AbstractConverter.sole(inputs), this.traitDef, traitSet);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return planner.getCostFactory().makeInfiniteCost();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (RelTrait trait : this.traitSet) {
            pw.item(trait.getTraitDef().getSimpleName(), trait);
        }
        return pw;
    }

    public static class ExpandConversionRule
    extends RelOptRule {
        public static final ExpandConversionRule INSTANCE = new ExpandConversionRule();

        private ExpandConversionRule() {
            super(ExpandConversionRule.operand(AbstractConverter.class, ExpandConversionRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            AbstractConverter converter;
            RelNode child;
            VolcanoPlanner planner = (VolcanoPlanner)call.getPlanner();
            RelNode converted = planner.changeTraitsUsingConverters(child = (converter = (AbstractConverter)call.rel(0)).getChild(), converter.traitSet);
            if (converted != null) {
                call.transformTo(converted);
            }
        }
    }
}

