/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.util.Util;

public class RelTraitPropagationVisitor
extends RelVisitor {
    private final RelTraitSet baseTraits;
    private final RelOptPlanner planner;

    public RelTraitPropagationVisitor(RelOptPlanner planner, RelTraitSet baseTraits) {
        this.planner = planner;
        this.baseTraits = baseTraits;
    }

    public void visit(RelNode rel, int ordinal, RelNode parent) {
        if (this.planner.isRegistered(rel)) {
            return;
        }
        RelTraitSet relTraits = rel.getTraitSet();
        int i = 0;
        while (i < this.baseTraits.size()) {
            if (i >= relTraits.size()) {
                Util.discard(RelOptUtil.addTrait(rel, this.baseTraits.getTrait(i)));
                throw new AssertionError();
            }
            assert (relTraits.getTrait(i).getTraitDef() == this.baseTraits.getTrait(i).getTraitDef());
            ++i;
        }
        rel.childrenAccept(this);
    }
}

