/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.RelWriterImpl;
import org.eigenbase.rel.RelXmlWriter;
import org.eigenbase.rel.rules.MultiJoinRel;
import org.eigenbase.rel.rules.PullConstantsThroughAggregatesRule;
import org.eigenbase.rel.rules.RemoveEmptyRules;
import org.eigenbase.rel.rules.WindowedAggSplitterRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.VisitorRelVisitor;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlPostfixOperator;
import org.eigenbase.sql.fun.SqlMinMaxAggFunction;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.MultisetSqlType;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mapping;
import org.eigenbase.util.mapping.MappingType;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelOptUtil {
    public static final double EPSILON = 1.0E-5;

    public static Set<String> getVariablesSet(RelNode rel) {
        VariableSetVisitor visitor = new VariableSetVisitor();
        RelOptUtil.go(visitor, rel);
        return visitor.variables;
    }

    public static List<String> getVariablesSetAndUsed(RelNode rel0, RelNode rel1) {
        Set<String> set = RelOptUtil.getVariablesSet(rel0);
        if (set.size() == 0) {
            return ImmutableList.of();
        }
        Set<String> used = RelOptUtil.getVariablesUsed(rel1);
        if (used.size() == 0) {
            return ImmutableList.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : set) {
            if (!used.contains(s) || result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static Set<String> getVariablesUsed(RelNode rel) {
        final VariableUsedVisitor vuv = new VariableUsedVisitor();
        VisitorRelVisitor visitor = new VisitorRelVisitor(vuv){

            public void visit(RelNode p, int ordinal, RelNode parent) {
                p.collectVariablesUsed(vuv.variables);
                super.visit(p, ordinal, parent);
                vuv.variables.removeAll(p.getVariablesStopped());
            }
        };
        visitor.go(rel);
        return vuv.variables;
    }

    public static void go(RelVisitor visitor, RelNode p) {
        try {
            visitor.go(p);
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "while visiting tree");
        }
    }

    public static List<RelDataType> getFieldTypeList(final RelDataType type) {
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return type.getFieldList().get(index).getType();
            }

            @Override
            public int size() {
                return type.getFieldCount();
            }
        };
    }

    public static boolean areRowTypesEqual(RelDataType rowType1, RelDataType rowType2, boolean compareNames) {
        if (rowType1 == rowType2) {
            return true;
        }
        if (compareNames) {
            return false;
        }
        if (rowType2.getFieldCount() != rowType1.getFieldCount()) {
            return false;
        }
        List<RelDataTypeField> f1 = rowType1.getFieldList();
        List<RelDataTypeField> f2 = rowType2.getFieldList();
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(f1, f2)) {
            RelDataType type1 = ((RelDataTypeField)pair.left).getType();
            RelDataType type2 = ((RelDataTypeField)pair.right).getType();
            if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static void verifyTypeEquivalence(RelNode originalRel, RelNode newRel, Object equivalenceClass) {
        RelDataType actualRowType;
        RelDataType expectedRowType = originalRel.getRowType();
        if (RelOptUtil.areRowTypesEqual(expectedRowType, actualRowType = newRel.getRowType(), false)) {
            return;
        }
        String s = "Cannot add expression of different type to set:\nset type is " + expectedRowType.getFullTypeString() + "\nexpression type is " + actualRowType.getFullTypeString() + "\nset is " + equivalenceClass.toString() + "\nexpression is " + newRel.toString();
        throw Util.newInternal(s);
    }

    public static Mappings.TargetMapping permutation(List<RexNode> nodes, RelDataType inputRowType) {
        Mapping mapping = Mappings.create(MappingType.PARTIAL_FUNCTION, nodes.size(), inputRowType.getFieldCount());
        for (Ord node : Ord.zip(nodes)) {
            RexNode operand;
            if (node.e instanceof RexInputRef) {
                mapping.set(node.i, ((RexInputRef)node.e).getIndex());
                continue;
            }
            if (!((RexNode)node.e).isA(SqlKind.CAST) || !((operand = ((RexCall)node.e).getOperands().get(0)) instanceof RexInputRef)) continue;
            mapping.set(node.i, ((RexInputRef)operand).getIndex());
        }
        return mapping;
    }

    public static RelNode createExistsPlan(RelOptCluster cluster, RelNode seekRel, List<RexNode> conditions, RexLiteral extraExpr, String extraName) {
        assert (extraExpr == null || extraName != null);
        RelNode ret = seekRel;
        if (conditions != null && conditions.size() > 0) {
            RexNode conditionExp = RexUtil.composeConjunction(cluster.getRexBuilder(), conditions, true);
            ret = CalcRel.createFilter(ret, conditionExp);
        }
        if (extraExpr != null) {
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
            assert (extraExpr == rexBuilder.makeLiteral(true));
            ret = CalcRel.createProject(ret, Collections.singletonList(extraExpr), null);
            ImmutableList argTypes = ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.BOOLEAN));
            SqlMinMaxAggFunction minFunction = new SqlMinMaxAggFunction((List<RelDataType>)argTypes, true, 1);
            RelDataType returnType = minFunction.inferReturnType(typeFactory, (List<RelDataType>)argTypes);
            AggregateCall aggCall = new AggregateCall(minFunction, false, Collections.singletonList(0), returnType, extraName);
            ret = new AggregateRel(ret.getCluster(), ret, BitSets.of(new int[0]), Collections.singletonList(aggCall));
        }
        return ret;
    }

    public static RelNode createExistsPlan(RelOptCluster cluster, RelNode seekRel, boolean isIn, boolean isExists, boolean needsOuterJoin) {
        RelNode ret = seekRel;
        if (isIn || isExists) {
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
            ArrayList<RexNode> exprs = new ArrayList<RexNode>();
            if (isIn) {
                int i = 0;
                while (i < ret.getRowType().getFieldCount()) {
                    exprs.add(rexBuilder.makeInputRef(ret, i));
                    ++i;
                }
            }
            if (needsOuterJoin) {
                RexLiteral trueExp = rexBuilder.makeLiteral(true);
                exprs.add(trueExp);
                ret = CalcRel.createProject(ret, exprs, null);
                ImmutableList argTypes = ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.BOOLEAN));
                SqlMinMaxAggFunction minFunction = new SqlMinMaxAggFunction((List<RelDataType>)argTypes, true, 1);
                RelDataType returnType = minFunction.inferReturnType(typeFactory, (List<RelDataType>)argTypes);
                int newProjFieldCount = ret.getRowType().getFieldCount();
                AggregateCall aggCall = new AggregateCall(minFunction, false, Collections.singletonList(newProjFieldCount - 1), returnType, null);
                ret = new AggregateRel(ret.getCluster(), ret, BitSets.range(newProjFieldCount - 1), Collections.singletonList(aggCall));
            } else {
                ret = new AggregateRel(ret.getCluster(), ret, BitSets.range(ret.getRowType().getFieldCount()), Collections.<AggregateCall>emptyList());
            }
        }
        return ret;
    }

    public static RelNode createRenameRel(RelDataType outputType, RelNode rel) {
        RelDataType inputType = rel.getRowType();
        List<RelDataTypeField> inputFields = inputType.getFieldList();
        int n = inputFields.size();
        List<RelDataTypeField> outputFields = outputType.getFieldList();
        assert (outputFields.size() == n) : "rename: field count mismatch: in=" + inputType + ", out" + outputType;
        ArrayList<Pair<RexInputRef, String>> renames = new ArrayList<Pair<RexInputRef, String>>();
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(inputFields, outputFields)) {
            RelDataTypeField inputField = (RelDataTypeField)pair.left;
            RelDataTypeField outputField = (RelDataTypeField)pair.right;
            assert (inputField.getType().equals(outputField.getType()));
            renames.add(Pair.of(rel.getCluster().getRexBuilder().makeInputRef(inputField.getType(), inputField.getIndex()), outputField.getName()));
        }
        return CalcRel.createProject(rel, Pair.left(renames), Pair.right(renames));
    }

    public static RelNode createNullFilter(RelNode rel, Integer[] fieldOrdinals) {
        RexNode condition = null;
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RelDataType rowType = rel.getRowType();
        int n = fieldOrdinals != null ? fieldOrdinals.length : rowType.getFieldCount();
        List<RelDataTypeField> fields = rowType.getFieldList();
        int i = 0;
        while (i < n) {
            int iField = fieldOrdinals != null ? fieldOrdinals[i] : i;
            RelDataType type = fields.get(iField).getType();
            if (type.isNullable()) {
                RexNode newCondition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, rexBuilder.makeInputRef(type, iField));
                condition = condition == null ? newCondition : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, condition, newCondition);
            }
            ++i;
        }
        if (condition == null) {
            return rel;
        }
        return CalcRel.createFilter(rel, condition);
    }

    public static RelNode createCastRel(RelNode rel, RelDataType castRowType, boolean rename) {
        RelDataType rowType = rel.getRowType();
        if (RelOptUtil.areRowTypesEqual(rowType, castRowType, rename)) {
            return rel;
        }
        List<RexNode> castExps = RexUtil.generateCastExpressions(rel.getCluster().getRexBuilder(), castRowType, rowType);
        if (rename) {
            return CalcRel.createProject(rel, castExps, castRowType.getFieldNames());
        }
        return CalcRel.createProject(rel, castExps, rowType.getFieldNames());
    }

    public static RelNode createSingleValueAggRel(RelOptCluster cluster, RelNode rel) {
        int aggCallCnt = rel.getRowType().getFieldCount();
        ArrayList<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        int i = 0;
        while (i < aggCallCnt) {
            RelDataType returnType = SqlStdOperatorTable.SINGLE_VALUE.inferReturnType(cluster.getRexBuilder().getTypeFactory(), (List<RelDataType>)ImmutableList.of((Object)rel.getRowType().getFieldList().get(i).getType()));
            aggCalls.add(new AggregateCall(SqlStdOperatorTable.SINGLE_VALUE, false, Collections.singletonList(i), returnType, null));
            ++i;
        }
        return new AggregateRel(rel.getCluster(), rel, BitSets.of(new int[0]), aggCalls);
    }

    public static RelNode createDistinctRel(RelNode rel) {
        return new AggregateRel(rel.getCluster(), rel, BitSets.range(rel.getRowType().getFieldCount()), (List<AggregateCall>)ImmutableList.of());
    }

    public static boolean analyzeSimpleEquiJoin(JoinRel joinRel, int[] joinFieldOrdinals) {
        RexNode joinExp = joinRel.getCondition();
        if (joinExp.getKind() != SqlKind.EQUALS) {
            return false;
        }
        RexCall binaryExpression = (RexCall)joinExp;
        RexNode leftComparand = (RexNode)binaryExpression.operands.get(0);
        RexNode rightComparand = (RexNode)binaryExpression.operands.get(1);
        if (!(leftComparand instanceof RexInputRef)) {
            return false;
        }
        if (!(rightComparand instanceof RexInputRef)) {
            return false;
        }
        int leftFieldCount = joinRel.getLeft().getRowType().getFieldCount();
        RexInputRef leftFieldAccess = (RexInputRef)leftComparand;
        if (leftFieldAccess.getIndex() >= leftFieldCount) {
            return false;
        }
        RexInputRef rightFieldAccess = (RexInputRef)rightComparand;
        if (rightFieldAccess.getIndex() < leftFieldCount) {
            return false;
        }
        joinFieldOrdinals[0] = leftFieldAccess.getIndex();
        joinFieldOrdinals[1] = rightFieldAccess.getIndex() - leftFieldCount;
        return true;
    }

    public static RexNode splitJoinCondition(RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(left.getRowType().getFieldCount(), condition, leftKeys, rightKeys, nonEquiList);
        return RexUtil.composeConjunction(left.getCluster().getRexBuilder(), nonEquiList, false);
    }

    public static boolean isEqui(RelNode left, RelNode right, RexNode condition) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(left.getRowType().getFieldCount(), condition, leftKeys, rightKeys, nonEquiList);
        return nonEquiList.size() == 0;
    }

    public static RexNode splitJoinCondition(List<RelDataTypeField> sysFieldList, RelNode leftRel, RelNode rightRel, RexNode condition, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(sysFieldList, leftRel, rightRel, condition, leftJoinKeys, rightJoinKeys, filterNulls, rangeOp, nonEquiList);
        return RexUtil.composeConjunction(leftRel.getCluster().getRexBuilder(), nonEquiList, false);
    }

    public static RexNode splitCorrelatedFilterCondition(FilterRel filterRel, List<RexInputRef> joinKeys, List<RexNode> correlatedJoinKeys) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitCorrelatedFilterCondition(filterRel, filterRel.getCondition(), joinKeys, correlatedJoinKeys, nonEquiList);
        return RexUtil.composeConjunction(filterRel.getCluster().getRexBuilder(), nonEquiList, true);
    }

    public static RexNode splitCorrelatedFilterCondition(FilterRel filterRel, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, boolean extractCorrelatedFieldAccess) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitCorrelatedFilterCondition(filterRel, filterRel.getCondition(), joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
        return RexUtil.composeConjunction(filterRel.getCluster().getRexBuilder(), nonEquiList, true);
    }

    private static void splitJoinCondition(List<RelDataTypeField> sysFieldList, RelNode leftRel, RelNode rightRel, RexNode condition, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp, List<RexNode> nonEquiList) {
        int sysFieldCount = sysFieldList.size();
        int leftFieldCount = leftRel.getRowType().getFieldCount();
        int rightFieldCount = rightRel.getRowType().getFieldCount();
        int firstLeftField = sysFieldCount;
        int firstRightField = sysFieldCount + leftFieldCount;
        int totalFieldCount = firstRightField + rightFieldCount;
        List<RelDataTypeField> leftFields = leftRel.getRowType().getFieldList();
        List<RelDataTypeField> rightFields = rightRel.getRowType().getFieldList();
        RexBuilder rexBuilder = leftRel.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = leftRel.getCluster().getTypeFactory();
        int[] adjustments = new int[totalFieldCount];
        int i = firstLeftField;
        while (i < firstRightField) {
            adjustments[i] = -firstLeftField;
            ++i;
        }
        i = firstRightField;
        while (i < totalFieldCount) {
            adjustments[i] = -firstRightField;
            ++i;
        }
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitJoinCondition(sysFieldList, leftRel, rightRel, operand, leftJoinKeys, rightJoinKeys, filterNulls, rangeOp, nonEquiList);
                }
                return;
            }
            RexNode leftKey = null;
            RexNode rightKey = null;
            boolean reverse = false;
            SqlKind kind = call.getKind();
            if (kind == SqlKind.EQUALS || filterNulls != null && kind == SqlKind.IS_NOT_DISTINCT_FROM || rangeOp != null && rangeOp.isEmpty() && (kind == SqlKind.GREATER_THAN || kind == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL)) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                BitSet projRefs0 = InputFinder.bits(op0);
                BitSet projRefs1 = InputFinder.bits(op1);
                if (projRefs0.nextSetBit(firstRightField) < 0 && projRefs1.nextSetBit(firstLeftField) >= firstRightField) {
                    leftKey = op0;
                    rightKey = op1;
                } else if (projRefs1.nextSetBit(firstRightField) < 0 && projRefs0.nextSetBit(firstLeftField) >= firstRightField) {
                    leftKey = op1;
                    rightKey = op0;
                    reverse = true;
                }
                if (leftKey != null && rightKey != null) {
                    RelDataType rightKeyType;
                    rightKey = rightKey.accept(new RexInputConverter(rexBuilder, rightFields, rightFields, adjustments));
                    RelDataType leftKeyType = (leftKey = leftKey.accept(new RexInputConverter(rexBuilder, leftFields, leftFields, adjustments))).getType();
                    if (leftKeyType != (rightKeyType = rightKey.getType())) {
                        RelDataType targetKeyType = typeFactory.leastRestrictive((List<RelDataType>)ImmutableList.of((Object)leftKeyType, (Object)rightKeyType));
                        if (targetKeyType == null) {
                            throw Util.newInternal("Cannot find common type for join keys " + leftKey + " (type " + leftKeyType + ") and " + rightKey + " (type " + rightKeyType + ")");
                        }
                        if (leftKeyType != targetKeyType) {
                            leftKey = rexBuilder.makeCast(targetKeyType, leftKey);
                        }
                        if (rightKeyType != targetKeyType) {
                            rightKey = rexBuilder.makeCast(targetKeyType, rightKey);
                        }
                    }
                }
            }
            if (rangeOp == null && (leftKey == null || rightKey == null)) {
                BitSet projRefs = InputFinder.bits(condition);
                leftKey = null;
                rightKey = null;
                if (projRefs.nextSetBit(firstRightField) < 0) {
                    leftKey = condition.accept(new RexInputConverter(rexBuilder, leftFields, leftFields, adjustments));
                    rightKey = rexBuilder.makeLiteral(true);
                    kind = SqlKind.EQUALS;
                } else if (projRefs.nextSetBit(firstLeftField) >= firstRightField) {
                    leftKey = rexBuilder.makeLiteral(true);
                    rightKey = condition.accept(new RexInputConverter(rexBuilder, rightFields, rightFields, adjustments));
                    kind = SqlKind.EQUALS;
                }
            }
            if (leftKey != null && rightKey != null) {
                RelOptUtil.addJoinKey(leftJoinKeys, leftKey, rangeOp != null && !rangeOp.isEmpty());
                RelOptUtil.addJoinKey(rightJoinKeys, rightKey, rangeOp != null && !rangeOp.isEmpty());
                if (filterNulls != null && kind == SqlKind.EQUALS) {
                    filterNulls.add(leftJoinKeys.size() - 1);
                }
                if (rangeOp != null && kind != SqlKind.EQUALS && kind != SqlKind.IS_DISTINCT_FROM) {
                    if (reverse) {
                        kind = RelOptUtil.reverse(kind);
                    }
                    rangeOp.add(RelOptUtil.op(kind, call.getOperator()));
                }
                return;
            }
        }
        nonEquiList.add(condition);
    }

    private static SqlKind reverse(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return kind;
    }

    private static SqlOperator op(SqlKind kind, SqlOperator operator) {
        switch (kind) {
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
            }
        }
        return operator;
    }

    private static void addJoinKey(List<RexNode> joinKeyList, RexNode key, boolean preserveLastElementInList) {
        if (!joinKeyList.isEmpty() && preserveLastElementInList) {
            joinKeyList.add(joinKeyList.size() - 1, key);
        } else {
            joinKeyList.add(key);
        }
    }

    private static void splitCorrelatedFilterCondition(FilterRel filterRel, RexNode condition, List<RexInputRef> joinKeys, List<RexNode> correlatedJoinKeys, List<RexNode> nonEquiList) {
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitCorrelatedFilterCondition(filterRel, operand, joinKeys, correlatedJoinKeys, nonEquiList);
                }
                return;
            }
            if (call.getOperator() == SqlStdOperatorTable.EQUALS) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                if (!RexUtil.containsInputRef(op0) && op1 instanceof RexInputRef) {
                    correlatedJoinKeys.add(op0);
                    joinKeys.add((RexInputRef)op1);
                    return;
                }
                if (op0 instanceof RexInputRef && !RexUtil.containsInputRef(op1)) {
                    joinKeys.add((RexInputRef)op0);
                    correlatedJoinKeys.add(op1);
                    return;
                }
            }
        }
        nonEquiList.add(condition);
    }

    private static void splitCorrelatedFilterCondition(FilterRel filterRel, RexNode condition, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, List<RexNode> nonEquiList, boolean extractCorrelatedFieldAccess) {
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitCorrelatedFilterCondition(filterRel, operand, joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
                }
                return;
            }
            if (call.getOperator() == SqlStdOperatorTable.EQUALS) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                if (extractCorrelatedFieldAccess) {
                    if (!RexUtil.containsFieldAccess(op0) && op1 instanceof RexFieldAccess) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexFieldAccess && !RexUtil.containsFieldAccess(op1)) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                } else {
                    if (!RexUtil.containsInputRef(op0) && op1 instanceof RexInputRef) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexInputRef && !RexUtil.containsInputRef(op1)) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                }
            }
        }
        nonEquiList.add(condition);
    }

    private static void splitJoinCondition(int leftFieldCount, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys, List<RexNode> nonEquiList) {
        if (condition instanceof RexCall) {
            List<RexNode> operands;
            RexCall call = (RexCall)condition;
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitJoinCondition(leftFieldCount, operand, leftKeys, rightKeys, nonEquiList);
                }
                return;
            }
            if ((operator == SqlStdOperatorTable.EQUALS || operator == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) && (operands = call.getOperands()).get(0) instanceof RexInputRef && operands.get(1) instanceof RexInputRef) {
                RexInputRef rightField;
                RexInputRef leftField;
                RexInputRef op0 = (RexInputRef)operands.get(0);
                RexInputRef op1 = (RexInputRef)operands.get(1);
                if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                    leftField = op0;
                    rightField = op1;
                } else if (op1.getIndex() < leftFieldCount && op0.getIndex() >= leftFieldCount) {
                    leftField = op1;
                    rightField = op0;
                } else {
                    nonEquiList.add(condition);
                    return;
                }
                leftKeys.add(leftField.getIndex());
                rightKeys.add(rightField.getIndex() - leftFieldCount);
                return;
            }
        }
        if (!condition.isAlwaysTrue()) {
            nonEquiList.add(condition);
        }
    }

    public static void projectJoinInputs(RelNode[] inputRels, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, int systemColCount, List<Integer> leftKeys, List<Integer> rightKeys, List<Integer> outputProj) {
        RelNode leftRel = inputRels[0];
        RelNode rightRel = inputRels[1];
        RexBuilder rexBuilder = leftRel.getCluster().getRexBuilder();
        int origLeftInputSize = leftRel.getRowType().getFieldCount();
        int origRightInputSize = rightRel.getRowType().getFieldCount();
        ArrayList<RexNode> newLeftFields = new ArrayList<RexNode>();
        ArrayList<String> newLeftFieldNames = new ArrayList<String>();
        ArrayList<RexNode> newRightFields = new ArrayList<RexNode>();
        ArrayList<String> newRightFieldNames = new ArrayList<String>();
        int leftKeyCount = leftJoinKeys.size();
        int rightKeyCount = rightJoinKeys.size();
        int i = 0;
        while (i < systemColCount) {
            outputProj.add(i);
            ++i;
        }
        i = 0;
        while (i < origLeftInputSize) {
            RelDataTypeField field = leftRel.getRowType().getFieldList().get(i);
            newLeftFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newLeftFieldNames.add(field.getName());
            outputProj.add(systemColCount + i);
            ++i;
        }
        int newLeftKeyCount = 0;
        i = 0;
        while (i < leftKeyCount) {
            RexNode leftKey = leftJoinKeys.get(i);
            if (leftKey instanceof RexInputRef) {
                leftKeys.add(((RexInputRef)leftKey).getIndex());
            } else {
                newLeftFields.add(leftKey);
                newLeftFieldNames.add(null);
                leftKeys.add(origLeftInputSize + newLeftKeyCount);
                ++newLeftKeyCount;
            }
            ++i;
        }
        int leftFieldCount = origLeftInputSize + newLeftKeyCount;
        i = 0;
        while (i < origRightInputSize) {
            RelDataTypeField field = rightRel.getRowType().getFieldList().get(i);
            newRightFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newRightFieldNames.add(field.getName());
            outputProj.add(systemColCount + leftFieldCount + i);
            ++i;
        }
        int newRightKeyCount = 0;
        i = 0;
        while (i < rightKeyCount) {
            RexNode rightKey = rightJoinKeys.get(i);
            if (rightKey instanceof RexInputRef) {
                rightKeys.add(((RexInputRef)rightKey).getIndex());
            } else {
                newRightFields.add(rightKey);
                newRightFieldNames.add(null);
                rightKeys.add(origRightInputSize + newRightKeyCount);
                ++newRightKeyCount;
            }
            ++i;
        }
        if (newLeftKeyCount > 0) {
            leftRel = CalcRel.createProject(leftRel, newLeftFields, SqlValidatorUtil.uniquify(newLeftFieldNames));
        }
        if (newRightKeyCount > 0) {
            rightRel = CalcRel.createProject(rightRel, newRightFields, SqlValidatorUtil.uniquify(newRightFieldNames));
        }
        inputRels[0] = leftRel;
        inputRels[1] = rightRel;
    }

    public static RelNode createProjectJoinRel(List<Integer> outputProj, RelNode joinRel) {
        int newProjectOutputSize = outputProj.size();
        List<RelDataTypeField> joinOutputFields = joinRel.getRowType().getFieldList();
        if (newProjectOutputSize > 0 && newProjectOutputSize < joinOutputFields.size()) {
            ArrayList<Pair<RexInputRef, String>> newProjects = new ArrayList<Pair<RexInputRef, String>>();
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            for (int fieldIndex : outputProj) {
                RelDataTypeField field = joinOutputFields.get(fieldIndex);
                newProjects.add(Pair.of(rexBuilder.makeInputRef(field.getType(), fieldIndex), field.getName()));
            }
            return CalcRel.createProject(joinRel, Pair.left(newProjects), Pair.right(newProjects));
        }
        return joinRel;
    }

    public static void registerAbstractRels(RelOptPlanner planner) {
        planner.addRule(PullConstantsThroughAggregatesRule.INSTANCE);
        planner.addRule(RemoveEmptyRules.UNION_INSTANCE);
        planner.addRule(RemoveEmptyRules.PROJECT_INSTANCE);
        planner.addRule(RemoveEmptyRules.FILTER_INSTANCE);
        planner.addRule(RemoveEmptyRules.SORT_INSTANCE);
        planner.addRule(RemoveEmptyRules.AGGREGATE_INSTANCE);
        planner.addRule(RemoveEmptyRules.JOIN_LEFT_INSTANCE);
        planner.addRule(RemoveEmptyRules.JOIN_RIGHT_INSTANCE);
        planner.addRule(RemoveEmptyRules.SORT_FETCH_ZERO_INSTANCE);
        planner.addRule(WindowedAggSplitterRule.PROJECT);
    }

    public static String dumpPlan(String header, RelNode rel, boolean asXml, SqlExplainLevel detailLevel) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (!header.equals("")) {
            pw.println(header);
        }
        RelWriterImpl planWriter = asXml ? new RelXmlWriter(pw, detailLevel) : new RelWriterImpl(pw, detailLevel, false);
        rel.explain(planWriter);
        pw.flush();
        return sw.toString();
    }

    public static RelDataType createDmlRowType(SqlKind kind, RelDataTypeFactory typeFactory) {
        switch (kind) {
            case INSERT: {
                return typeFactory.createStructType(Collections.singletonList(Pair.of("ROWCOUNT", typeFactory.createSqlType(SqlTypeName.BIGINT))));
            }
            case EXPLAIN: {
                return typeFactory.createStructType(Collections.singletonList(Pair.of("PLAN", typeFactory.createSqlType(SqlTypeName.VARCHAR, -1))));
            }
        }
        throw Util.unexpected(kind);
    }

    public static boolean eq(String desc1, RelDataType type1, String desc2, RelDataType type2, boolean fail) {
        if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY) {
            return true;
        }
        if (type1 != type2) {
            assert (!fail) : "type mismatch:\n" + desc1 + ":\n" + type1.getFullTypeString() + "\n" + desc2 + ":\n" + type2.getFullTypeString();
            return false;
        }
        return true;
    }

    public static boolean equal(String desc1, RelDataType type1, String desc2, RelDataType type2, boolean fail) {
        if (!RelOptUtil.areRowTypesEqual(type1, type2, false)) {
            if (fail) {
                throw new AssertionError((Object)("Type mismatch:\n" + desc1 + ":\n" + type1.getFullTypeString() + "\n" + desc2 + ":\n" + type2.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    public static boolean equalType(String desc0, RelNode rel0, String desc1, RelNode rel1, boolean fail) {
        return RelOptUtil.equal(desc0, rel0.getRowType(), desc1, rel1.getRowType(), fail);
    }

    public static RexNode isDistinctFrom(RexBuilder rexBuilder, RexNode x, RexNode y, boolean neg) {
        RexNode ret = null;
        if (x.getType().isStruct()) {
            assert (y.getType().isStruct());
            List<RelDataTypeField> xFields = x.getType().getFieldList();
            List<RelDataTypeField> yFields = y.getType().getFieldList();
            assert (xFields.size() == yFields.size());
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(xFields, yFields)) {
                RelDataTypeField xField = (RelDataTypeField)pair.left;
                RelDataTypeField yField = (RelDataTypeField)pair.right;
                RexNode newX = rexBuilder.makeFieldAccess(x, xField.getIndex());
                RexNode newY = rexBuilder.makeFieldAccess(y, yField.getIndex());
                RexNode newCall = RelOptUtil.isDistinctFromInternal(rexBuilder, newX, newY, neg);
                ret = ret == null ? newCall : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ret, newCall);
            }
        } else {
            ret = RelOptUtil.isDistinctFromInternal(rexBuilder, x, y, neg);
        }
        ret = rexBuilder.makeCast(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN), ret);
        return ret;
    }

    private static RexNode isDistinctFromInternal(RexBuilder rexBuilder, RexNode x, RexNode y, boolean neg) {
        SqlBinaryOperator eqOp;
        SqlPostfixOperator nullOp;
        if (neg) {
            nullOp = SqlStdOperatorTable.IS_NULL;
            eqOp = SqlStdOperatorTable.EQUALS;
        } else {
            nullOp = SqlStdOperatorTable.IS_NOT_NULL;
            eqOp = SqlStdOperatorTable.NOT_EQUALS;
        }
        RexNode[] whenThenElse = new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, x), rexBuilder.makeCall((SqlOperator)nullOp, y), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, y), rexBuilder.makeCall((SqlOperator)nullOp, x), rexBuilder.makeCall((SqlOperator)eqOp, x, y)};
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, whenThenElse);
    }

    public static String toString(RelNode rel) {
        return RelOptUtil.toString(rel, SqlExplainLevel.EXPPLAN_ATTRIBUTES);
    }

    public static String toString(RelNode rel, SqlExplainLevel detailLevel) {
        if (rel == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        RelWriterImpl planWriter = new RelWriterImpl(new PrintWriter(sw), detailLevel, false);
        rel.explain(planWriter);
        return sw.toString();
    }

    public static RelNode renameIfNecessary(RelNode rel, RelDataType desiredRowType) {
        RelDataType rowType = rel.getRowType();
        if (rowType == desiredRowType) {
            return rel;
        }
        assert (!rowType.equals(desiredRowType));
        if (!RelOptUtil.areRowTypesEqual(rowType, desiredRowType, false)) {
            return rel;
        }
        rel = CalcRel.createRename(rel, desiredRowType.getFieldNames());
        return rel;
    }

    public static String dumpType(RelDataType type) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TypeDumper typeDumper = new TypeDumper(pw);
        if (type.isStruct()) {
            typeDumper.acceptFields(type.getFieldList());
        } else {
            typeDumper.accept(type);
        }
        pw.flush();
        return sw.toString();
    }

    public static void decomposeConjunction(RexNode rexPredicate, List<RexNode> rexList) {
        if (rexPredicate == null || rexPredicate.isAlwaysTrue()) {
            return;
        }
        if (rexPredicate.isA(SqlKind.AND)) {
            for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                RelOptUtil.decomposeConjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    public static void decomposeConjunction(RexNode rexPredicate, List<RexNode> rexList, List<RexNode> notList) {
        if (rexPredicate == null || rexPredicate.isAlwaysTrue()) {
            return;
        }
        switch (rexPredicate.getKind()) {
            case AND: {
                for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                    RelOptUtil.decomposeConjunction(operand, rexList, notList);
                }
                break;
            }
            case NOT: {
                RexNode e = ((RexCall)rexPredicate).getOperands().get(0);
                if (e.isAlwaysFalse()) {
                    return;
                }
                notList.add(e);
                break;
            }
            default: {
                rexList.add(rexPredicate);
            }
        }
    }

    public static void decomposeDisjunction(RexNode rexPredicate, List<RexNode> rexList) {
        if (rexPredicate == null || rexPredicate.isAlwaysFalse()) {
            return;
        }
        if (rexPredicate.isA(SqlKind.OR)) {
            for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                RelOptUtil.decomposeDisjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    public static List<RexNode> conjunctions(RexNode rexPredicate) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(rexPredicate, list);
        return list;
    }

    public static List<RexNode> disjunctions(RexNode rexPredicate) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.decomposeDisjunction(rexPredicate, list);
        return list;
    }

    public static RexNode andJoinFilters(RexBuilder rexBuilder, RexNode left, RexNode right) {
        if (left != null && !left.isAlwaysTrue()) {
            if (right != null && !right.isAlwaysTrue()) {
                left = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, left, right);
            }
        } else {
            left = right;
        }
        if (left == null) {
            left = rexBuilder.makeLiteral(true);
        }
        return left;
    }

    public static List<Integer> adjustKeys(List<Integer> keys, int adjustment) {
        if (adjustment == 0) {
            return keys;
        }
        ArrayList<Integer> newKeys = new ArrayList<Integer>();
        for (int key : keys) {
            newKeys.add(key + adjustment);
        }
        return newKeys;
    }

    public static boolean classifyFilters(RelNode joinRel, List<RexNode> filters, boolean pushJoin, boolean pushLeft, boolean pushRight, List<RexNode> joinFilters, List<RexNode> leftFilters, List<RexNode> rightFilters) {
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        boolean filterPushed = false;
        List<RelDataTypeField> joinFields = joinRel.getRowType().getFieldList();
        int nTotalFields = joinFields.size();
        boolean nSysFields = false;
        List<RelDataTypeField> leftFields = joinRel.getInputs().get(0).getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        List<RelDataTypeField> rightFields = joinRel.getInputs().get(1).getRowType().getFieldList();
        int nFieldsRight = rightFields.size();
        assert (nTotalFields == 0 + nFieldsLeft + nFieldsRight);
        BitSet leftBitmap = BitSets.range(0, 0 + nFieldsLeft);
        BitSet rightBitmap = BitSets.range(0 + nFieldsLeft, nTotalFields);
        ListIterator<RexNode> filterIter = filters.listIterator();
        while (filterIter.hasNext()) {
            RexNode filter = filterIter.next();
            BitSet filterBitmap = InputFinder.bits(filter);
            if (pushLeft && BitSets.contains(leftBitmap, filterBitmap)) {
                filterPushed = true;
                if (!filter.isAlwaysTrue()) {
                    RexNode shiftedFilter = RelOptUtil.shiftFilter(0, 0 + nFieldsLeft, 0, rexBuilder, joinFields, nTotalFields, leftFields, filter);
                    leftFilters.add(shiftedFilter);
                }
                filterIter.remove();
                continue;
            }
            if (pushRight && BitSets.contains(rightBitmap, filterBitmap)) {
                filterPushed = true;
                if (!filter.isAlwaysTrue()) {
                    RexNode shilftedFilter = RelOptUtil.shiftFilter(0 + nFieldsLeft, nTotalFields, -(0 + nFieldsLeft), rexBuilder, joinFields, nTotalFields, rightFields, filter);
                    rightFilters.add(shilftedFilter);
                }
                filterIter.remove();
                continue;
            }
            if (!pushJoin) continue;
            filterPushed = true;
            joinFilters.add(filter);
            filterIter.remove();
        }
        return filterPushed;
    }

    private static RexNode shiftFilter(int start, int end, int offset, RexBuilder rexBuilder, List<RelDataTypeField> joinFields, int nTotalFields, List<RelDataTypeField> rightFields, RexNode filter) {
        int[] adjustments = new int[nTotalFields];
        int i = start;
        while (i < end) {
            adjustments[i] = offset;
            ++i;
        }
        return filter.accept(new RexInputConverter(rexBuilder, joinFields, rightFields, adjustments));
    }

    public static void splitFilters(BitSet childBitmap, RexNode predicate, List<RexNode> pushable, List<RexNode> notPushable) {
        for (RexNode filter : RelOptUtil.conjunctions(predicate)) {
            BitSet filterRefs = InputFinder.bits(filter);
            if (BitSets.contains(childBitmap, filterRefs)) {
                pushable.add(filter);
                continue;
            }
            notPushable.add(filter);
        }
    }

    public static RexNode[] splitJoinCondition(RelNode left, RelNode right, RexNode condition) {
        RexBuilder rexBuilder = left.getCluster().getRexBuilder();
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode nonEquiCondition = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys);
        assert (nonEquiCondition != null);
        RexNode equiCondition = rexBuilder.makeLiteral(true);
        assert (leftKeys.size() == rightKeys.size());
        int keyCount = leftKeys.size();
        int offset = left.getRowType().getFieldCount();
        int i = 0;
        while (i < keyCount) {
            int leftKey = (Integer)leftKeys.get(i);
            int rightKey = (Integer)rightKeys.get(i);
            RexNode equi = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef(left, leftKey), rexBuilder.makeInputRef(right.getRowType().getFieldList().get(rightKey).getType(), rightKey + offset));
            equiCondition = i == 0 ? equi : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, equiCondition, equi);
            ++i;
        }
        return new RexNode[]{equiCondition, nonEquiCondition};
    }

    public static boolean checkProjAndChildInputs(ProjectRelBase project, boolean checkNames) {
        if (!project.isBoxed()) {
            return false;
        }
        int n = project.getProjects().size();
        RelDataType inputType = project.getChild().getRowType();
        if (inputType.getFieldList().size() != n) {
            return false;
        }
        List<RelDataTypeField> projFields = project.getRowType().getFieldList();
        List<RelDataTypeField> inputFields = inputType.getFieldList();
        boolean namesDifferent = false;
        int i = 0;
        while (i < n) {
            RexNode exp = project.getProjects().get(i);
            if (!(exp instanceof RexInputRef)) {
                return false;
            }
            RexInputRef fieldAccess = (RexInputRef)exp;
            if (i != fieldAccess.getIndex()) {
                return false;
            }
            if (checkNames) {
                String inputFieldName = inputFields.get(i).getName();
                String projFieldName = projFields.get(i).getName();
                if (!projFieldName.equals(inputFieldName)) {
                    namesDifferent = true;
                }
            }
            ++i;
        }
        return !checkNames || namesDifferent;
    }

    public static List<RexNode> createSwappedJoinExprs(RelNode newJoin, JoinRelBase origJoin, boolean origOrder) {
        List<RelDataTypeField> newJoinFields = newJoin.getRowType().getFieldList();
        RexBuilder rexBuilder = newJoin.getCluster().getRexBuilder();
        ArrayList<RexNode> exps = new ArrayList<RexNode>();
        int nFields = origOrder ? origJoin.getRight().getRowType().getFieldCount() : origJoin.getLeft().getRowType().getFieldCount();
        int i = 0;
        while (i < newJoinFields.size()) {
            int source = (i + nFields) % newJoinFields.size();
            RelDataTypeField field = origOrder ? newJoinFields.get(source) : newJoinFields.get(i);
            exps.add(rexBuilder.makeInputRef(field.getType(), source));
            ++i;
        }
        return exps;
    }

    public static RexNode pushFilterPastProject(RexNode filter, ProjectRelBase projRel) {
        RexBuilder rexBuilder = projRel.getCluster().getRexBuilder();
        RexProgram bottomProgram = RexProgram.create(projRel.getChild().getRowType(), projRel.getProjects(), null, projRel.getRowType(), rexBuilder);
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(projRel.getRowType(), rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(filter);
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        return mergedProgram.expandLocalRef(mergedProgram.getCondition());
    }

    /*
     * Unable to fully structure code
     */
    public static MultiJoinRel projectMultiJoin(MultiJoinRel multiJoin, ProjectRel project) {
        inputRefs = InputFinder.bits(project.getProjects(), multiJoin.getPostJoinFilter());
        multiJoinInputs = multiJoin.getInputs();
        newProjFields = new ArrayList<BitSet>();
        for (RelNode multiJoinInput : multiJoinInputs) {
            newProjFields.add(new BitSet(multiJoinInput.getRowType().getFieldCount()));
        }
        currInput = -1;
        startField = 0;
        nFields = 0;
        bit = inputRefs.nextSetBit(0);
        ** GOTO lbl21
        {
            startField += nFields;
            if (!RelOptUtil.$assertionsDisabled && ++currInput >= multiJoinInputs.size()) {
                throw new AssertionError();
            }
            nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            do {
                if (bit >= startField + nFields) continue block1;
                ((BitSet)newProjFields.get(currInput)).set(bit - startField);
                bit = inputRefs.nextSetBit(bit + 1);
lbl21:
                // 2 sources

            } while (bit >= 0);
        }
        return new MultiJoinRel(multiJoin.getCluster(), multiJoin.getInputs(), multiJoin.getJoinFilter(), multiJoin.getRowType(), multiJoin.isFullOuterJoin(), multiJoin.getOuterJoinConditions(), multiJoin.getJoinTypes(), newProjFields, multiJoin.getJoinFieldRefCountsMap(), multiJoin.getPostJoinFilter());
    }

    public static <T extends RelNode> T addTrait(T rel, RelTrait trait) {
        return (T)rel.copy(rel.getTraitSet().replace(trait), rel.getInputs());
    }

    public static RelNode replaceInput(RelNode parent, int ordinal, RelNode newInput) {
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(parent.getInputs());
        if (inputs.get(ordinal) == newInput) {
            return parent;
        }
        inputs.set(ordinal, newInput);
        return parent.copy(parent.getTraitSet(), inputs);
    }

    public static ProjectRel project(RelNode child, Mappings.TargetMapping mapping) {
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        ArrayList<String> names = new ArrayList<String>();
        List<RelDataTypeField> fields = child.getRowType().getFieldList();
        int i = 0;
        while (i < mapping.getTargetCount()) {
            int source = mapping.getSourceOpt(i);
            RelDataTypeField field = fields.get(source);
            nodes.add(new RexInputRef(source, field.getType()));
            names.add(field.getName());
            ++i;
        }
        return new ProjectRel(child.getCluster(), child, nodes, names, 1);
    }

    public static boolean contains(RelNode ancestor, final RelNode target) {
        if (ancestor == target) {
            return true;
        }
        try {
            new RelVisitor(){

                public void visit(RelNode node, int ordinal, RelNode parent) {
                    if (node == target) {
                        throw Util.FoundOne.NULL;
                    }
                    super.visit(node, ordinal, parent);
                }
            }.go(ancestor);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static RelNode replace(RelNode query, RelNode find, RelNode replace) {
        if (find == replace) {
            return query;
        }
        assert (RelOptUtil.equalType("find", find, "replace", replace, true));
        if (query == find) {
            return replace;
        }
        return RelOptUtil.replaceRecurse(query, find, replace);
    }

    private static RelNode replaceRecurse(RelNode query, RelNode find, RelNode replace) {
        if (query == find) {
            return replace;
        }
        List<RelNode> inputs = query.getInputs();
        if (!inputs.isEmpty()) {
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : inputs) {
                newInputs.add(RelOptUtil.replaceRecurse(input, find, replace));
            }
            if (!newInputs.equals(inputs)) {
                return query.copy(query.getTraitSet(), newInputs);
            }
        }
        return query;
    }

    public static RelOptTable.ToRelContext getContext(final RelOptCluster cluster) {
        return new RelOptTable.ToRelContext(){

            @Override
            public RelOptCluster getCluster() {
                return cluster;
            }

            @Override
            public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputFinder
    extends RexVisitorImpl<Void> {
        private final BitSet rexRefSet;
        private final Set<RelDataTypeField> extraFields;

        public InputFinder(BitSet rexRefSet) {
            this(rexRefSet, null);
        }

        public InputFinder(BitSet rexRefSet, Set<RelDataTypeField> extraFields) {
            super(true);
            this.rexRefSet = rexRefSet;
            this.extraFields = extraFields;
        }

        public static BitSet bits(RexNode node) {
            BitSet inputBitSet = new BitSet();
            node.accept(new InputFinder(inputBitSet));
            return inputBitSet;
        }

        public static BitSet bits(List<RexNode> exprs, RexNode expr) {
            BitSet inputBitSet = new BitSet();
            RexProgram.apply(new InputFinder(inputBitSet), exprs, expr);
            return inputBitSet;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.rexRefSet.set(inputRef.getIndex());
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            if (call.getOperator() == RexBuilder.GET_OPERATOR) {
                RexLiteral literal = (RexLiteral)call.getOperands().get(1);
                this.extraFields.add(new RelDataTypeFieldImpl((String)literal.getValue2(), -1, call.getType()));
            }
            return (Void)super.visitCall(call);
        }
    }

    public static class InputReferencedVisitor
    extends RexShuttle {
        public final SortedSet<Integer> inputPosReferenced = new TreeSet<Integer>();

        public RexNode visitInputRef(RexInputRef inputRef) {
            this.inputPosReferenced.add(inputRef.getIndex());
            return inputRef;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RexInputConverter
    extends RexShuttle {
        protected final RexBuilder rexBuilder;
        private final List<RelDataTypeField> srcFields;
        protected final List<RelDataTypeField> destFields;
        private final RelDataTypeField[] leftDestFields;
        private final RelDataTypeField[] rightDestFields;
        private final int nLeftDestFields;
        private final int[] adjustments;

        private RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, RelDataTypeField[] leftDestFields, RelDataTypeField[] rightDestFields, int[] adjustments) {
            this.rexBuilder = rexBuilder;
            this.srcFields = srcFields;
            this.destFields = destFields;
            this.adjustments = adjustments;
            this.leftDestFields = leftDestFields;
            this.rightDestFields = rightDestFields;
            if (leftDestFields == null) {
                this.nLeftDestFields = 0;
            } else {
                assert (destFields == null);
                this.nLeftDestFields = leftDestFields.length;
            }
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, RelDataTypeField[] leftDestFields, RelDataTypeField[] rightDestFields, int[] adjustments) {
            this(rexBuilder, srcFields, null, leftDestFields, rightDestFields, adjustments);
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, int[] adjustments) {
            this(rexBuilder, srcFields, destFields, null, null, adjustments);
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, int[] adjustments) {
            this(rexBuilder, srcFields, null, null, null, adjustments);
        }

        @Override
        public RexNode visitInputRef(RexInputRef var) {
            int srcIndex = var.getIndex();
            int destIndex = srcIndex + this.adjustments[srcIndex];
            RelDataType type = this.destFields != null ? this.destFields.get(destIndex).getType() : (this.leftDestFields != null ? (destIndex < this.nLeftDestFields ? this.leftDestFields[destIndex].getType() : this.rightDestFields[destIndex - this.nLeftDestFields].getType()) : this.srcFields.get(srcIndex).getType());
            if (this.adjustments[srcIndex] != 0 || this.srcFields == null || type != this.srcFields.get(srcIndex).getType()) {
                return this.rexBuilder.makeInputRef(type, destIndex);
            }
            return var;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeDumper {
        private final String extraIndent = "  ";
        private String indent;
        private final PrintWriter pw;

        TypeDumper(PrintWriter pw) {
            this.pw = pw;
            this.indent = "";
        }

        void accept(RelDataType type) {
            if (type.isStruct()) {
                List<RelDataTypeField> fields = type.getFieldList();
                this.pw.println("RECORD (");
                String prevIndent = this.indent;
                this.indent = String.valueOf(this.indent) + "  ";
                this.acceptFields(fields);
                this.indent = prevIndent;
                this.pw.print(")");
                if (!type.isNullable()) {
                    this.pw.print(" NOT NULL");
                }
            } else if (type instanceof MultisetSqlType) {
                this.accept(type.getComponentType());
                this.pw.print(" MULTISET");
                if (!type.isNullable()) {
                    this.pw.print(" NOT NULL");
                }
            } else {
                this.pw.print(type.getFullTypeString());
            }
        }

        private void acceptFields(List<RelDataTypeField> fields) {
            int i = 0;
            while (i < fields.size()) {
                RelDataTypeField field = fields.get(i);
                if (i > 0) {
                    this.pw.println(",");
                }
                this.pw.print(this.indent);
                this.pw.print(field.getName());
                this.pw.print(" ");
                this.accept(field.getType());
                ++i;
            }
        }
    }

    private static class VariableSetVisitor
    extends RelVisitor {
        final Set<String> variables = new HashSet<String>();

        private VariableSetVisitor() {
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            p.collectVariablesUsed(this.variables);
            this.variables.removeAll(p.getVariablesStopped());
        }
    }

    public static class VariableUsedVisitor
    extends RexShuttle {
        public final Set<String> variables = new LinkedHashSet<String>();

        public RexNode visitCorrelVariable(RexCorrelVariable p) {
            this.variables.add(p.getName());
            return p;
        }
    }
}

