/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableAccessRelBase
extends AbstractRelNode {
    protected final RelOptTable table;

    protected TableAccessRelBase(RelOptCluster cluster, RelTraitSet traits, RelOptTable table) {
        super(cluster, traits);
        this.table = table;
        if (table.getRelOptSchema() != null) {
            cluster.getPlanner().registerSchema(table.getRelOptSchema());
        }
    }

    protected TableAccessRelBase(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getTable("table"));
    }

    @Override
    public double getRows() {
        return this.table.getRowCount();
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return this.table.getCollationList();
    }

    @Override
    public boolean isKey(BitSet columns) {
        return this.table.isKey(columns);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows = this.table.getRowCount();
        double dCpu = dRows + 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.table.getRowType();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName());
    }

    public RelNode project(BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldsUsed.equals(BitSets.range(fieldCount)) && extraFields.isEmpty()) {
            return this;
        }
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        ArrayList<String> nameList = new ArrayList<String>();
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        List<RelDataTypeField> fields = this.getRowType().getFieldList();
        Iterator<Object> iterator = BitSets.toIter(fieldsUsed).iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            RelDataTypeField field = fields.get(i);
            exprList.add(rexBuilder.makeInputRef(this, i));
            nameList.add(field.getName());
        }
        for (RelDataTypeField extraField : extraFields) {
            exprList.add(rexBuilder.ensureType(extraField.getType(), rexBuilder.constantNull(), true));
            nameList.add(extraField.getName());
        }
        return new ProjectRel(this.getCluster(), this, exprList, nameList, 1);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }
}

