/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelImplementor;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.trace.EigenbaseTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelImplementorImpl
implements RelImplementor {
    protected static final Logger LOGGER = EigenbaseTrace.getRelImplementorTracer();
    protected final Map<String, Frame> mapCorrel2Frame = new HashMap<String, Frame>();
    protected final Map<RelNode, Frame> mapRel2Frame = new HashMap<RelNode, Frame>();
    protected final RexBuilder rexBuilder;

    public RelImplementorImpl(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.rexBuilder.getTypeFactory();
    }

    @Override
    public final Object visitChild(RelNode parent, int ordinal, RelNode child) {
        if (parent != null) assert (child == parent.getInputs().get(ordinal));
        this.createFrame(parent, ordinal, child);
        return this.visitChildInternal(child, ordinal, null);
    }

    protected void createFrame(RelNode parent, int ordinal, RelNode child) {
        Frame frame = new Frame(child, parent, ordinal);
        this.mapRel2Frame.put(child, frame);
        String correl = child.getCorrelVariable();
        if (correl != null && this.mapCorrel2Frame.get(correl) == null) {
            this.mapCorrel2Frame.put(correl, frame);
        }
    }

    @Override
    public Object visitChildInternal(RelNode child, int ordinal, Object arg) {
        throw new UnsupportedOperationException();
    }

    protected RelNode findInputRel(RelNode rel, int offset) {
        return this.findInputRel(rel, offset, new int[1]);
    }

    private RelNode findInputRel(RelNode rel, int offset, int[] offsets) {
        if (rel instanceof JoinRel) {
            List<RelNode> inputs = rel.getInputs();
            for (RelNode input : inputs) {
                RelNode result = this.findInputRel(input, offset, offsets);
                if (result == null) continue;
                return result;
            }
        } else {
            if (offset == offsets[0]) {
                return rel;
            }
            offsets[0] = offsets[0] + 1;
        }
        return null;
    }

    public List<RelNode> getAncestorRels(RelNode rel) {
        ArrayList<RelNode> ancestorList;
        block2: {
            ancestorList = new ArrayList<RelNode>();
            Frame frame = this.mapRel2Frame.get(rel);
            assert (frame != null) : "rel must be on the current implementation stack";
            while (true) {
                ancestorList.add(frame.rel);
                RelNode parentRel = frame.parent;
                if (parentRel == null) break block2;
                frame = this.mapRel2Frame.get(parentRel);
                assert (frame != null) : "ancestor rel must have frame";
            }
        }
        return ancestorList;
    }

    protected static class Frame {
        public final RelNode parent;
        public final RelNode rel;
        public final int ordinal;

        Frame(RelNode child, RelNode parent, int ordinal) {
            this.rel = child;
            this.parent = parent;
            this.ordinal = ordinal;
        }
    }
}

