/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ByteString;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.ControlFlowException;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexToLixTranslator {
    public static final Map<Method, SqlOperator> JAVA_TO_SQL_METHOD_MAP = Util.mapOf(RexToLixTranslator.findMethod(String.class, "toUpperCase", new Class[0]), SqlStdOperatorTable.UPPER, RexToLixTranslator.findMethod(SqlFunctions.class, "substring", String.class, Integer.TYPE, Integer.TYPE), SqlStdOperatorTable.SUBSTRING, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHARACTER_LENGTH, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHAR_LENGTH);
    private static final long MILLIS_IN_DAY = 86400000L;
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    private final RexProgram program;
    private final InputGetter inputGetter;
    private final BlockBuilder list;
    private final Map<RexNode, Boolean> exprNullableMap;

    private static Method findMethod(Class<?> clazz, String name, Class ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, InputGetter inputGetter, BlockBuilder list) {
        this(program, typeFactory, inputGetter, list, Collections.emptyMap(), new RexBuilder(typeFactory));
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, InputGetter inputGetter, BlockBuilder list, Map<RexNode, Boolean> exprNullableMap, RexBuilder builder) {
        this.program = program;
        this.typeFactory = typeFactory;
        this.inputGetter = inputGetter;
        this.list = list;
        this.exprNullableMap = exprNullableMap;
        this.builder = builder;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter) {
        return new RexToLixTranslator(program, typeFactory, inputGetter, list).translateList(program.getProjectList());
    }

    public static RexToLixTranslator forAggregation(JavaTypeFactory typeFactory) {
        return new RexToLixTranslator(null, typeFactory, null, null);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        Expression expression = this.translate0(expr, nullAs);
        assert (expression != null);
        return this.list.append("v", expression);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand) {
        Expression convert = null;
        block0 : switch (targetType.getSqlTypeName()) {
            case ANY: {
                convert = operand;
                break;
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltinMethod.STRING_TO_BOOLEAN.method, (Expression[])new Expression[]{operand});
                    }
                }
                break;
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltinMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break block0;
                    }
                    case TIME: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltinMethod.UNIX_TIME_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltinMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltinMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)((Object)interval.foo()))}));
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltinMethod.INTERVAL_DAY_TIME_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)((Object)interval.foo())), Expressions.constant((Object)interval.getFractionalSecondPrecision())}));
                        break block0;
                    }
                    case BOOLEAN: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltinMethod.BOOLEAN_TO_STRING.method, (Expression[])new Expression[]{operand}));
                    }
                }
            }
        }
        if (convert == null) {
            convert = RexToLixTranslator.convert(operand, this.typeFactory.getJavaClass(targetType));
        }
        switch (sourceType.getSqlTypeName()) {
            case CHAR: {
                switch (targetType.getSqlTypeName()) {
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltinMethod.RTRIM.method, (Expression[])new Expression[]{convert});
                    }
                }
                break;
            }
            case BINARY: {
                switch (targetType.getSqlTypeName()) {
                    case VARBINARY: {
                        convert = Expressions.call((Method)BuiltinMethod.RTRIM.method, (Expression[])new Expression[]{convert});
                    }
                }
            }
        }
        switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) break;
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: 
                    case VARBINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (sourcePrecision < 0 || sourcePrecision >= 0 && sourcePrecision <= targetPrecision) break;
                    }
                    default: {
                        convert = Expressions.call((Method)BuiltinMethod.TRUNCATE.method, (Expression[])new Expression[]{convert, Expressions.constant((Object)targetPrecision)});
                        break;
                    }
                }
                break;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale >= sourceType.getScale()) break;
                convert = Expressions.call((Method)BuiltinMethod.ROUND_LONG.method, (Expression[])new Expression[]{convert, Expressions.constant((Object)((long)Math.pow(10.0, 3 - targetScale)))});
            }
        }
        return convert;
    }

    private Expression translate0(RexNode expr, RexImpTable.NullAs nullAs) {
        if (nullAs == RexImpTable.NullAs.NULL && !expr.getType().isNullable()) {
            nullAs = RexImpTable.NullAs.NOT_POSSIBLE;
        }
        switch (expr.getKind()) {
            case INPUT_REF: {
                int index = ((RexInputRef)expr).getIndex();
                Expression x = this.inputGetter.field(this.list, index);
                Expression input = this.list.append("inp" + index + "_", x);
                Expression nullHandled = nullAs.handle(input);
                if (nullHandled instanceof ConstantExpression) {
                    return nullHandled;
                }
                if (nullHandled == input) {
                    return input;
                }
                String unboxVarName = "v_unboxed";
                if (input instanceof ParameterExpression) {
                    unboxVarName = String.valueOf(((ParameterExpression)input).name) + "_unboxed";
                }
                ParameterExpression unboxed = Expressions.parameter((Type)nullHandled.getType(), (String)this.list.newName(unboxVarName));
                this.list.add((Statement)Expressions.declare((int)0, (ParameterExpression)unboxed, (Expression)nullHandled));
                return unboxed;
            }
            case LOCAL_REF: {
                return this.translate(this.program.getExprList().get(((RexLocalRef)expr).getIndex()), nullAs);
            }
            case LITERAL: {
                return RexToLixTranslator.translateLiteral(expr, this.nullifyType(expr.getType(), this.isNullable(expr) && nullAs != RexImpTable.NullAs.NOT_POSSIBLE), this.typeFactory, nullAs);
            }
            case DYNAMIC_PARAM: {
                return this.translateParameter((RexDynamicParam)expr, nullAs);
            }
        }
        if (expr instanceof RexCall) {
            return this.translateCall((RexCall)expr, nullAs);
        }
        throw new RuntimeException("cannot translate expression " + expr);
    }

    private Expression translateCall(RexCall call, RexImpTable.NullAs nullAs) {
        SqlOperator operator = call.getOperator();
        RexImpTable.CallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        return implementor.implement(this, call, nullAs);
    }

    private Expression translateParameter(RexDynamicParam expr, RexImpTable.NullAs nullAs) {
        return nullAs.handle(RexToLixTranslator.convert((Expression)Expressions.call((Expression)DataContext.ROOT, (Method)BuiltinMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)("?" + expr.getIndex()))}), this.typeFactory.getJavaClass(expr.getType())));
    }

    public static Expression translateLiteral(RexNode expr, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        RexLiteral literal = (RexLiteral)expr;
        Comparable value = literal.getValue();
        if (value == null) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw AlwaysNull.INSTANCE;
                }
                case NULL: {
                    return RexImpTable.NULL_EXPR;
                }
            }
        } else {
            switch (nullAs) {
                case IS_NOT_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case IS_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
            }
        }
        Class<Object> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                assert (javaClass == BigDecimal.class);
                return value == null ? Expressions.constant(null) : Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.constant((Object)value.toString())});
            }
            case DATE: {
                value2 = value == null ? null : Integer.valueOf((int)(((Calendar)value).getTimeInMillis() / 86400000L));
                break;
            }
            case TIME: {
                value2 = value == null ? null : Integer.valueOf((int)(((Calendar)value).getTimeInMillis() % 86400000L));
                break;
            }
            case TIMESTAMP: {
                value2 = value == null ? null : Long.valueOf(((Calendar)value).getTimeInMillis());
                break;
            }
            case INTERVAL_DAY_TIME: {
                if (value == null) {
                    value2 = null;
                    javaClass = Long.class;
                    break;
                }
                value2 = ((BigDecimal)value).longValue();
                javaClass = Long.TYPE;
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                if (value == null) {
                    value2 = null;
                    javaClass = Integer.class;
                    break;
                }
                value2 = ((BigDecimal)value).intValue();
                javaClass = Integer.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = value == null ? null : ((NlsString)value).getValue();
                break;
            }
            case BINARY: 
            case VARBINARY: {
                return Expressions.new_(ByteString.class, (Expression[])new Expression[]{Expressions.constant((Object)((ByteString)value).getBytes(), byte[].class)});
            }
            case SYMBOL: {
                value2 = value;
                javaClass = value.getClass();
                break;
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr((Type)javaClass);
                value2 = primitive != null && value instanceof Number ? primitive.number((Number)((Object)value)) : value;
            }
        }
        return Expressions.constant((Object)value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (RexNode rex : operandList) {
            list.add(this.translate(rex, nullAs));
        }
        return list;
    }

    List<Expression> translateList(List<? extends RexNode> operandList) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (RexNode rexNode : operandList) {
            Expression translate = this.translate(rexNode);
            list.add(translate);
            if (!this.isNullable(rexNode)) assert (!Primitive.isBox((Type)translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rexNode + ", " + translate.getType();
        }
        return list;
    }

    public static Expression translateCondition(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter) {
        if (program.getCondition() == null) {
            return RexImpTable.TRUE_EXPR;
        }
        RexToLixTranslator translator = new RexToLixTranslator(program, typeFactory, inputGetter, list);
        return translator.translate(program.getCondition(), RexImpTable.NullAs.FALSE);
    }

    public static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        if (fromType.equals(toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of((Type)toType);
        Primitive toBox = Primitive.ofBox((Type)toType);
        Primitive fromBox = Primitive.ofBox((Type)fromType);
        Primitive fromPrimitive = Primitive.of((Type)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, (String)("parse" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toBox.primitiveName) + "Boxed"), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, (String)"valueOf", (Expression[])new Expression[]{operand});
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_((Expression)operand, (Type)toPrimitive.primitiveClass);
            }
            if (fromBox != null) {
                return Expressions.unbox((Expression)operand, (Primitive)toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
        }
        if (fromBox != null && toBox != null) {
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.box((Expression)Expressions.unbox((Expression)operand, (Primitive)toBox), (Primitive)toBox));
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.unbox((Expression)operand, (Primitive)fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{operand});
            }
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{operand}));
        }
        if (toType == String.class) {
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.boxClass, (String)"toString", (Expression[])new Expression[]{operand});
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand}));
            }
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call((Expression)operand, (String)"toString", (Expression[])new Expression[0]));
        }
        return Expressions.convert_((Expression)operand, (Type)toType);
    }

    private static <T> T elvis(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    private static <T> T elvis(T t0, T t1, T t2) {
        return t0 != null ? t0 : (t1 != null ? t1 : t2);
    }

    public Expression translateConstructor(List<RexNode> operandList, SqlKind kind) {
        switch (kind) {
            case MAP_VALUE_CONSTRUCTOR: {
                Expression map = this.list.append("map", (Expression)Expressions.new_(LinkedHashMap.class), false);
                int i = 0;
                while (i < operandList.size()) {
                    RexNode key = operandList.get(i++);
                    RexNode value = operandList.get(i);
                    this.list.add(Expressions.statement((Expression)Expressions.call((Expression)map, (Method)BuiltinMethod.MAP_PUT.method, (Expression[])new Expression[]{Expressions.box((Expression)this.translate(key)), Expressions.box((Expression)this.translate(value))})));
                    ++i;
                }
                return map;
            }
            case ARRAY_VALUE_CONSTRUCTOR: {
                Expression lyst = this.list.append("list", (Expression)Expressions.new_(ArrayList.class), false);
                for (RexNode value : operandList) {
                    this.list.add(Expressions.statement((Expression)Expressions.call((Expression)lyst, (Method)BuiltinMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Expressions.box((Expression)this.translate(value))})));
                }
                return lyst;
            }
        }
        throw new AssertionError((Object)("unexpected: " + (Object)((Object)kind)));
    }

    public boolean isNullable(RexNode e) {
        Boolean b = this.exprNullableMap.get(e);
        if (b != null) {
            return b;
        }
        return e.getType().isNullable();
    }

    public RexToLixTranslator setNullable(RexNode e, boolean nullable) {
        HashMap<RexNode, Boolean> map = new HashMap<RexNode, Boolean>(this.exprNullableMap);
        map.put(e, nullable);
        return new RexToLixTranslator(this.program, this.typeFactory, this.inputGetter, this.list, map, this.builder);
    }

    public RelDataType nullifyType(RelDataType type, boolean nullable) {
        Primitive primitive;
        if (!nullable && (primitive = this.javaPrimitive(type)) != null) {
            return this.typeFactory.createJavaType(primitive.primitiveClass);
        }
        return this.typeFactory.createTypeWithNullability(type, nullable);
    }

    private Primitive javaPrimitive(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return Primitive.ofBox((Type)((RelDataTypeFactoryImpl.JavaType)type).getJavaClass());
        }
        return null;
    }

    static class AlwaysNull
    extends ControlFlowException {
        public static final AlwaysNull INSTANCE = new AlwaysNull();

        private AlwaysNull() {
        }
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputGetterImpl
    implements InputGetter {
        private List<Pair<Expression, PhysType>> inputs;

        public InputGetterImpl(List<Pair<Expression, PhysType>> inputs) {
            this.inputs = inputs;
        }

        @Override
        public Expression field(BlockBuilder list, int index) {
            Pair<Expression, PhysType> input = this.inputs.get(0);
            PhysType physType = (PhysType)input.right;
            Expression left = list.append("current", (Expression)input.left);
            return physType.fieldReference(left, index);
        }
    }
}

