/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.MethodDeclaration;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.ModifiableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.rules.java.AggImplementor;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.rules.java.WinAggImplementor;
import net.hydromatic.optiq.runtime.SortedMultiMap;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.EmptyRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.IntersectRelBase;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.MinusRelBase;
import org.eigenbase.rel.OneRowRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.TableModificationRelBase;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.WindowRel;
import org.eigenbase.rel.WindowRelBase;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexMultisetUtil;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Pair;

public class JavaRules {
    protected static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    public static final boolean BRIDGE_METHODS = true;
    private static final List<ParameterExpression> NO_PARAMS = Collections.emptyList();
    private static final List<Expression> NO_EXPRS = Collections.emptyList();
    public static final RelOptRule ENUMERABLE_JOIN_RULE = new EnumerableJoinRule();
    public static final String[] LEFT_RIGHT = new String[]{"left", "right"};
    public static final EnumerableProjectRule ENUMERABLE_PROJECT_RULE = new EnumerableProjectRule();
    public static final EnumerableFilterRule ENUMERABLE_FILTER_RULE = new EnumerableFilterRule();
    public static final EnumerableCalcRule ENUMERABLE_CALC_RULE = new EnumerableCalcRule();
    public static final EnumerableAggregateRule ENUMERABLE_AGGREGATE_RULE = new EnumerableAggregateRule();
    public static final EnumerableSortRule ENUMERABLE_SORT_RULE = new EnumerableSortRule();
    public static final EnumerableLimitRule ENUMERABLE_LIMIT_RULE = new EnumerableLimitRule();
    public static final EnumerableUnionRule ENUMERABLE_UNION_RULE = new EnumerableUnionRule();
    public static final EnumerableIntersectRule ENUMERABLE_INTERSECT_RULE = new EnumerableIntersectRule();
    public static final EnumerableMinusRule ENUMERABLE_MINUS_RULE = new EnumerableMinusRule();
    public static final EnumerableTableModificationRule ENUMERABLE_TABLE_MODIFICATION_RULE = new EnumerableTableModificationRule();
    public static final EnumerableValuesRule ENUMERABLE_VALUES_RULE = new EnumerableValuesRule();
    public static final EnumerableOneRowRule ENUMERABLE_ONE_ROW_RULE = new EnumerableOneRowRule();
    public static final EnumerableEmptyRule ENUMERABLE_EMPTY_RULE = new EnumerableEmptyRule();
    public static final EnumerableWindowRule ENUMERABLE_WINDOW_RULE = new EnumerableWindowRule();
    public static final EnumerableFilterToCalcRule ENUMERABLE_FILTER_TO_CALC_RULE = new EnumerableFilterToCalcRule();
    public static final EnumerableProjectToCalcRule ENUMERABLE_PROJECT_TO_CALC_RULE = new EnumerableProjectToCalcRule();

    private JavaRules() {
    }

    public static interface AggCallContext {
        public BlockBuilder builder();

        public Expression index();

        public Expression current();

        public Expression isFirst();

        public Expression isLast();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumUtil {
        public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
            return Expressions.methodDecl((int)(method.getModifiers() & 0xFFFFFBFF), method.getReturnType(), (String)method.getName(), parameters, (BlockStatement)body);
        }

        static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
            Type clazz = typeFactory.getJavaClass(type);
            return clazz instanceof Class ? clazz : Object[].class;
        }

        static Class javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            Type clazz;
            if (type.isStruct() && type.getFieldCount() == 1) {
                type = type.getFieldList().get(0).getType();
            }
            return (clazz = typeFactory.getJavaClass(type)) instanceof Class ? (Class)clazz : Object[].class;
        }

        static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final RelDataType inputRowType, final List<Integer> argList) {
            return new AbstractList<Type>(){

                @Override
                public Type get(int index) {
                    return EnumUtil.javaClass(typeFactory, inputRowType.getFieldList().get((Integer)argList.get(index)).getType());
                }

                @Override
                public int size() {
                    return argList.size();
                }
            };
        }

        static List<AggImplementor> getImplementors(List<AggregateCall> aggCalls) {
            ArrayList<AggImplementor> implementors = new ArrayList<AggImplementor>();
            for (AggregateCall aggCall : aggCalls) {
                AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation());
                if (implementor2 == null) {
                    throw new RuntimeException("cannot implement aggregate " + aggCall);
                }
                implementors.add(implementor2);
            }
            return implementors;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableAggregateRel
    extends AggregateRelBase
    implements EnumerableRel {
        private static final List<Aggregation> SUPPORTED_AGGREGATIONS = Arrays.asList(SqlStdOperatorTable.COUNT, SqlStdOperatorTable.MIN, SqlStdOperatorTable.MAX, SqlStdOperatorTable.SUM);

        public EnumerableAggregateRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, child, groupSet, aggCalls);
            assert (this.getConvention() instanceof EnumerableConvention);
            for (AggregateCall aggCall : aggCalls) {
                if (aggCall.isDistinct()) {
                    throw new InvalidRelException("distinct aggregation not supported");
                }
                AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation());
                if (implementor2 != null) continue;
                throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
            }
        }

        @Override
        public EnumerableAggregateRel copy(RelTraitSet traitSet, RelNode input, BitSet groupSet, List<AggregateCall> aggCalls) {
            try {
                return new EnumerableAggregateRel(this.getCluster(), traitSet, input, groupSet, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            Expression resultSelector;
            ParameterExpression key_;
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            RexToLixTranslator translator = RexToLixTranslator.forAggregation(typeFactory);
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            Expression childExp = builder.append("child", result.block);
            RelDataType inputRowType = this.getChild().getRowType();
            PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferCustom());
            PhysType inputPhysType = result.physType;
            ParameterExpression parameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"a0");
            Expressions.FluentList keyExpressions = Expressions.list();
            PhysType keyPhysType = inputPhysType.project(BitSets.toList(this.groupSet), JavaRowFormat.LIST);
            int keyArity = this.groupSet.cardinality();
            for (int groupKey : BitSets.toIter(this.groupSet)) {
                keyExpressions.add(inputPhysType.fieldReference((Expression)parameter, groupKey));
            }
            Expression keySelector = builder.append("keySelector", inputPhysType.generateSelector(parameter, BitSets.toList(this.groupSet), keyPhysType.getFormat()));
            List<AggImplementor> implementors = EnumUtil.getImplementors(this.aggCalls);
            final ArrayList<Expression> initExpressions = new ArrayList<Expression>();
            for (Ord ord : Ord.zip(Pair.zip(this.aggCalls, implementors))) {
                initExpressions.add(((AggImplementor)((Pair)ord.e).right).implementInit(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), physType.fieldClass(keyArity + ord.i), EnumUtil.fieldTypes(typeFactory, inputRowType, ((AggregateCall)((Pair)ord.e).left).getArgList())));
            }
            PhysType accPhysType = PhysTypeImpl.of(typeFactory, typeFactory.createSyntheticType((List<Type>)new AbstractList<Type>(){

                @Override
                public Type get(int index) {
                    return ((Expression)initExpressions.get(index)).getType();
                }

                @Override
                public int size() {
                    return initExpressions.size();
                }
            }));
            Expression accumulatorInitializer = builder.append("accumulatorInitializer", (Expression)Expressions.lambda(Function0.class, (Expression)accPhysType.record(initExpressions), (ParameterExpression[])new ParameterExpression[0]));
            BlockBuilder builder2 = new BlockBuilder();
            ParameterExpression inParameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"in");
            ParameterExpression acc_ = Expressions.parameter((Type)accPhysType.getJavaRowType(), (String)"acc");
            for (Ord ord : Ord.zip(Pair.zip(this.aggCalls, implementors))) {
                Type type = ((Expression)initExpressions.get((int)ord.i)).type;
                Expression accumulator = accPhysType.fieldReference((Expression)acc_, ord.i);
                ArrayList<BinaryExpression> conditions = new ArrayList<BinaryExpression>();
                for (int arg : ((AggregateCall)((Pair)ord.e).left).getArgList()) {
                    if (!inputPhysType.fieldNullable(arg)) continue;
                    conditions.add(Expressions.notEqual((Expression)inputPhysType.fieldReference((Expression)inParameter, arg), (Expression)Expressions.constant(null)));
                }
                Statement assign = Expressions.statement((Expression)Expressions.assign((Expression)accumulator, (Expression)((AggImplementor)((Pair)ord.e).right).implementAdd(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), Types.castIfNecessary((Type)type, (Expression)accumulator), inputPhysType.accessors((Expression)inParameter, ((AggregateCall)((Pair)ord.e).left).getArgList()))));
                if (conditions.isEmpty()) {
                    builder2.add(assign);
                    continue;
                }
                builder2.add((Statement)Expressions.ifThen((Expression)Expressions.foldAnd(conditions), (Node)assign));
            }
            builder2.add((Expression)acc_);
            Expression accumulatorAdder = builder.append("accumulatorAdder", (Expression)Expressions.lambda(Function2.class, (BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{acc_, inParameter}));
            Expressions.FluentList results = Expressions.list();
            if (keyArity == 0) {
                key_ = null;
            } else {
                Type keyType = keyPhysType.getJavaRowType();
                key_ = Expressions.parameter((Type)keyType, (String)"key");
                int j = 0;
                while (j < keyArity) {
                    results.add(keyPhysType.fieldReference((Expression)key_, j));
                    ++j;
                }
            }
            for (Ord ord : Ord.zip(Pair.zip(this.aggCalls, implementors))) {
                results.add(((AggImplementor)((Pair)ord.e).right).implementResult(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), accPhysType.fieldReference((Expression)acc_, ord.i)));
            }
            PhysType resultPhysType = physType;
            if (keyArity == 0) {
                resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function1.class, (Expression)resultPhysType.record((List<Expression>)results), (ParameterExpression[])new ParameterExpression[]{acc_}));
                builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)childExp, (Method)BuiltinMethod.AGGREGATE.method, (Expression[])new Expression[]{Expressions.call((Expression)accumulatorInitializer, (String)"apply", (Expression[])new Expression[0]), accumulatorAdder, resultSelector})})));
            } else if (this.aggCalls.isEmpty()) {
                builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.DISTINCT.method, (Iterable)Expressions.list().appendIfNotNull((Object)keyPhysType.comparer()))));
            } else {
                resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function2.class, (Expression)resultPhysType.record((List<Expression>)results), (ParameterExpression[])new ParameterExpression[]{key_, acc_}));
                builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.GROUP_BY2.method, (Iterable)Expressions.list((Object[])new Expression[]{keySelector, accumulatorInitializer, accumulatorAdder, resultSelector}).appendIfNotNull((Object)keyPhysType.comparer()))));
            }
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableAggregateRule
    extends ConverterRule {
        private EnumerableAggregateRule() {
            super(AggregateRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            AggregateRel agg = (AggregateRel)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace(EnumerableConvention.INSTANCE);
            try {
                return new EnumerableAggregateRel(rel.getCluster(), traitSet, EnumerableAggregateRule.convert(agg.getChild(), traitSet), agg.getGroupSet(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableCalcRel
    extends CalcRelBase
    implements EnumerableRel {
        private final RexProgram program;

        public EnumerableCalcRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelDataType rowType, RexProgram program, List<RelCollation> collationList) {
            super(cluster, traitSet, child, rowType, program, collationList);
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (!program.containsAggs());
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Override
        public EnumerableCalcRel copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
            return new EnumerableCalcRel(this.getCluster(), traitSet, child, program.getOutputRowType(), program, collationList);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockStatement moveNextBody;
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
            Type outputJavaType = physType.getJavaRowType();
            Type enumeratorType = Types.of(Enumerator.class, (Type[])new Type[]{outputJavaType});
            Type inputJavaType = result.physType.getJavaRowType();
            ParameterExpression inputEnumerator = Expressions.parameter((Type)Types.of(Enumerator.class, (Type[])new Type[]{inputJavaType}), (String)"inputEnumerator");
            Expression input = RexToLixTranslator.convert((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_CURRENT.method, (Expression[])new Expression[0]), inputJavaType);
            if (this.program.getCondition() == null) {
                moveNextBody = Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]));
            } else {
                BlockBuilder builder2 = new BlockBuilder();
                Expression condition = RexToLixTranslator.translateCondition(this.program, typeFactory, builder2, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))));
                builder2.add((Statement)Expressions.ifThen((Expression)condition, (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)true))));
                moveNextBody = Expressions.block((Statement[])new Statement[]{Expressions.while_((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]), (Statement)builder2.toBlock()), Expressions.return_(null, (Expression)Expressions.constant((Object)false))});
            }
            BlockBuilder builder3 = new BlockBuilder();
            List<Expression> expressions = RexToLixTranslator.translateProjects(this.program, typeFactory, builder3, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))));
            builder3.add((Statement)Expressions.return_(null, (Expression)physType.record(expressions)));
            BlockStatement currentBody = builder3.toBlock();
            Expression inputEnumerable = builder.append("inputEnumerable", result.block, false);
            NewExpression body = Expressions.new_((Type)enumeratorType, (Iterable)NO_EXPRS, (Iterable)Expressions.list((Object[])new MemberDeclaration[]{Expressions.fieldDecl((int)17, (ParameterExpression)inputEnumerator, (Expression)Expressions.call((Expression)inputEnumerable, (Method)BuiltinMethod.ENUMERABLE_ENUMERATOR.method, (Expression[])new Expression[0])), EnumUtil.overridingMethodDecl(BuiltinMethod.ENUMERATOR_RESET.method, NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_RESET.method, (Expression[])new Expression[0]))), EnumUtil.overridingMethodDecl(BuiltinMethod.ENUMERATOR_MOVE_NEXT.method, NO_PARAMS, moveNextBody), EnumUtil.overridingMethodDecl(BuiltinMethod.ENUMERATOR_CLOSE.method, NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_CLOSE.method, (Expression[])new Expression[0]))), Expressions.methodDecl((int)1, Object.class, (String)"current", (Iterable)NO_PARAMS, (BlockStatement)currentBody)}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.new_((Constructor)BuiltinMethod.ABSTRACT_ENUMERABLE_CTOR.constructor, (Iterable)NO_EXPRS, Arrays.asList(Expressions.methodDecl((int)1, (Type)enumeratorType, (String)BuiltinMethod.ENUMERABLE_ENUMERATOR.method.getName(), (Iterable)NO_PARAMS, (BlockStatement)Blocks.toFunctionBlock((Node)body))))));
            return implementor.result(physType, builder.toBlock());
        }

        @Override
        public RexProgram getProgram() {
            return this.program;
        }
    }

    private static class EnumerableCalcRule
    extends ConverterRule {
        private EnumerableCalcRule() {
            super(CalcRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableCalcRule");
        }

        public RelNode convert(RelNode rel) {
            CalcRel calc = (CalcRel)rel;
            RexProgram program = calc.getProgram();
            if (RexMultisetUtil.containsMultiset(program) || program.containsAggs()) {
                return null;
            }
            return new EnumerableCalcRel(rel.getCluster(), rel.getTraitSet().replace(EnumerableConvention.INSTANCE), EnumerableCalcRule.convert(calc.getChild(), calc.getChild().getTraitSet().replace(EnumerableConvention.INSTANCE)), calc.getRowType(), program, calc.getCollationList());
        }
    }

    public static class EnumerableEmptyRule
    extends ConverterRule {
        private EnumerableEmptyRule() {
            super(EmptyRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableEmptyRule");
        }

        public RelNode convert(RelNode rel) {
            EmptyRel empty = (EmptyRel)rel;
            return new EnumerableValuesRel(empty.getCluster(), empty.getRowType(), (List<List<RexLiteral>>)ImmutableList.of(), empty.getTraitSet().replace(EnumerableConvention.INSTANCE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableFilterRel
    extends FilterRelBase
    implements EnumerableRel {
        public EnumerableFilterRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
            super(cluster, traitSet, child, condition);
            assert (this.getConvention() instanceof EnumerableConvention);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableFilterRel(this.getCluster(), traitSet, EnumerableFilterRel.sole(inputs), this.condition);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EnumerableFilterRule
    extends ConverterRule {
        private EnumerableFilterRule() {
            super(FilterRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableFilterRule");
        }

        public RelNode convert(RelNode rel) {
            FilterRel filter = (FilterRel)rel;
            if (RexMultisetUtil.containsMultiset(filter.getCondition(), true) || RexOver.containsOver(filter.getCondition())) {
                return null;
            }
            return new EnumerableFilterRel(rel.getCluster(), rel.getTraitSet().replace(EnumerableConvention.INSTANCE), EnumerableFilterRule.convert(filter.getChild(), filter.getChild().getTraitSet().replace(EnumerableConvention.INSTANCE)), filter.getCondition());
        }
    }

    public static class EnumerableFilterToCalcRule
    extends RelOptRule {
        private EnumerableFilterToCalcRule() {
            super(EnumerableFilterToCalcRule.operand(EnumerableFilterRel.class, EnumerableFilterToCalcRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            EnumerableFilterRel filter = (EnumerableFilterRel)call.rel(0);
            RelNode rel = filter.getChild();
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            RelDataType inputRowType = rel.getRowType();
            RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
            programBuilder.addIdentity();
            programBuilder.addCondition(filter.getCondition());
            RexProgram program = programBuilder.getProgram();
            EnumerableCalcRel calc = new EnumerableCalcRel(filter.getCluster(), filter.getTraitSet(), rel, inputRowType, program, (List<RelCollation>)ImmutableList.of());
            call.transformTo(calc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableIntersectRel
    extends IntersectRelBase
    implements EnumerableRel {
        public EnumerableIntersectRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public EnumerableIntersectRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new EnumerableIntersectRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            Object intersectExp = null;
            for (Ord ord : Ord.zip((List)this.inputs)) {
                EnumerableRel input = (EnumerableRel)ord.e;
                EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
                Expression childExp = builder.append("child" + ord.i, result.block);
                intersectExp = intersectExp == null ? childExp : Expressions.call((Expression)intersectExp, (Method)(this.all ? BuiltinMethod.CONCAT.method : BuiltinMethod.INTERSECT.method), (Expression[])new Expression[]{childExp});
                pref = pref.of(result.format);
            }
            builder.add(intersectExp);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableIntersectRule
    extends ConverterRule {
        private EnumerableIntersectRule() {
            super(IntersectRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableIntersectRule");
        }

        public RelNode convert(RelNode rel) {
            IntersectRel intersect = (IntersectRel)rel;
            if (intersect.all) {
                return null;
            }
            EnumerableConvention out = EnumerableConvention.INSTANCE;
            RelTraitSet traitSet = intersect.getTraitSet().replace(out);
            return new EnumerableIntersectRel(rel.getCluster(), traitSet, EnumerableIntersectRule.convertList(intersect.getInputs(), out), intersect.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableJoinRel
    extends JoinRelBase
    implements EnumerableRel {
        final ImmutableIntList leftKeys;
        final ImmutableIntList rightKeys;

        protected EnumerableJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            super(cluster, traits, left, right, condition, joinType, variablesStopped);
            ArrayList<Integer> leftKeys = new ArrayList<Integer>();
            ArrayList<Integer> rightKeys = new ArrayList<Integer>();
            RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys);
            if (!remaining.isAlwaysTrue()) {
                throw new InvalidRelException("EnumerableJoinRel only supports equi-join");
            }
            this.leftKeys = ImmutableIntList.copyOf(leftKeys);
            this.rightKeys = ImmutableIntList.copyOf(rightKeys);
        }

        @Override
        public EnumerableJoinRel copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType) {
            try {
                return new EnumerableJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, joinType, (Set<String>)this.variablesStopped);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double rowCount = RelMetadataQuery.getRowCount(this);
            switch (this.joinType) {
                case RIGHT: {
                    rowCount = this.addEpsilon(rowCount);
                    break;
                }
                default: {
                    if (this.left.getId() <= this.right.getId()) break;
                    rowCount = this.addEpsilon(rowCount);
                }
            }
            double rightRowCount = this.right.getRows();
            double leftRowCount = this.left.getRows();
            if (rightRowCount > leftRowCount && !Double.isInfinite(rightRowCount)) {
                rowCount *= rightRowCount / (leftRowCount + 1.0);
            }
            if (this.condition.isAlwaysTrue()) {
                rowCount *= 10.0;
            }
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        private double addEpsilon(double d) {
            assert (d >= 0.0);
            double d0 = d;
            if (d < 10.0 && (d *= 1.001) != d0) {
                return d;
            }
            if ((d += 1.0) != d0) {
                return d;
            }
            return d *= 1.001;
        }

        @Override
        public double getRows() {
            boolean leftKey = this.left.isKey(BitSets.of(this.leftKeys));
            boolean rightKey = this.right.isKey(BitSets.of(this.rightKeys));
            double leftRowCount = this.left.getRows();
            double rightRowCount = this.right.getRows();
            if (leftKey && rightKey) {
                return Math.min(leftRowCount, rightRowCount);
            }
            if (leftKey) {
                return rightRowCount;
            }
            if (rightKey) {
                return leftRowCount;
            }
            return leftRowCount * rightRowCount;
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
            Expression leftExpression = builder.append("left", leftResult.block);
            EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
            Expression rightExpression = builder.append("right", rightResult.block);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
            PhysType keyPhysType = leftResult.physType.project(this.leftKeys, JavaRowFormat.LIST);
            return implementor.result(physType, builder.append((Expression)Expressions.call((Expression)leftExpression, (Method)BuiltinMethod.JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys), this.generateSelector(physType, (List<PhysType>)ImmutableList.of((Object)leftResult.physType, (Object)rightResult.physType))}).appendIfNotNull((Object)keyPhysType.comparer()))).toBlock());
        }

        Expression generateSelector(PhysType physType, List<PhysType> inputPhysTypes) {
            ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (Ord inputPhysType : Ord.zip(inputPhysTypes)) {
                ParameterExpression parameter = Expressions.parameter((Type)((PhysType)inputPhysType.e).getJavaRowType(), (String)LEFT_RIGHT[inputPhysType.i]);
                parameters.add(parameter);
                int fieldCount = ((PhysType)inputPhysType.e).getRowType().getFieldCount();
                int i = 0;
                while (i < fieldCount) {
                    expressions.add(Types.castIfNecessary((Type)((PhysType)inputPhysType.e).fieldClass(i), (Expression)((PhysType)inputPhysType.e).fieldReference((Expression)parameter, i)));
                    ++i;
                }
            }
            return Expressions.lambda(Function2.class, (Expression)physType.record(expressions), parameters);
        }
    }

    private static class EnumerableJoinRule
    extends ConverterRule {
        private EnumerableJoinRule() {
            super(JoinRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableJoinRule");
        }

        public RelNode convert(RelNode rel) {
            JoinRel join = (JoinRel)rel;
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (!(input.getConvention() instanceof EnumerableConvention)) {
                    input = EnumerableJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
                }
                newInputs.add(input);
            }
            try {
                return new EnumerableJoinRel(join.getCluster(), join.getTraitSet().replace(EnumerableConvention.INSTANCE), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition(), join.getJoinType(), join.getVariablesStopped());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableLimitRel
    extends SingleRel
    implements EnumerableRel {
        private final RexNode offset;
        private final RexNode fetch;

        public EnumerableLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, child);
            this.offset = offset;
            this.fetch = fetch;
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        @Override
        public EnumerableLimitRel copy(RelTraitSet traitSet, List<RelNode> newInputs) {
            return new EnumerableLimitRel(this.getCluster(), traitSet, EnumerableLimitRel.sole(newInputs), this.offset, this.fetch);
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).itemIf("offset", this.offset, this.offset != null).itemIf("fetch", this.fetch, this.fetch != null);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            Expression childExp;
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
            Expression v = childExp = builder.append("child", result.block);
            if (this.offset != null) {
                v = builder.append("offset", (Expression)Expressions.call((Expression)v, (Method)BuiltinMethod.SKIP.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.offset))}));
            }
            if (this.fetch != null) {
                v = builder.append("fetch", (Expression)Expressions.call((Expression)v, (Method)BuiltinMethod.TAKE.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.fetch))}));
            }
            builder.add((Statement)Expressions.return_(null, (Expression)v));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableLimitRule
    extends RelOptRule {
        private EnumerableLimitRule() {
            super(EnumerableLimitRule.operand(SortRel.class, EnumerableLimitRule.any()), "EnumerableLimitRule");
        }

        public void onMatch(RelOptRuleCall call) {
            SortRel sort = (SortRel)call.rel(0);
            if (sort.offset == null && sort.fetch == null) {
                return;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode input = sort.getChild();
            if (!sort.getCollation().getFieldCollations().isEmpty()) {
                input = sort.copy(sort.getTraitSet(), input, sort.getCollation(), null, null);
            }
            RelNode x = EnumerableLimitRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            call.transformTo(new EnumerableLimitRel(sort.getCluster(), traitSet, x, sort.offset, sort.fetch));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableMinusRel
    extends MinusRelBase
    implements EnumerableRel {
        public EnumerableMinusRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public EnumerableMinusRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new EnumerableMinusRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            Object minusExp = null;
            for (Ord ord : Ord.zip((List)this.inputs)) {
                EnumerableRel input = (EnumerableRel)ord.e;
                EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
                Expression childExp = builder.append("child" + ord.i, result.block);
                minusExp = minusExp == null ? childExp : Expressions.call((Expression)minusExp, (Method)BuiltinMethod.EXCEPT.method, (Expression[])new Expression[]{childExp});
                pref = pref.of(result.format);
            }
            builder.add(minusExp);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableMinusRule
    extends ConverterRule {
        private EnumerableMinusRule() {
            super(MinusRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableMinusRule");
        }

        public RelNode convert(RelNode rel) {
            MinusRel minus = (MinusRel)rel;
            if (minus.all) {
                return null;
            }
            EnumerableConvention out = EnumerableConvention.INSTANCE;
            RelTraitSet traitSet = rel.getTraitSet().replace(EnumerableConvention.INSTANCE);
            return new EnumerableMinusRel(rel.getCluster(), traitSet, EnumerableMinusRule.convertList(minus.getInputs(), out), minus.all);
        }
    }

    public static class EnumerableOneRowRule
    extends ConverterRule {
        private EnumerableOneRowRule() {
            super(OneRowRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableOneRowRule");
        }

        public RelNode convert(RelNode rel) {
            OneRowRel oneRow = (OneRowRel)rel;
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            return new EnumerableValuesRel(oneRow.getCluster(), oneRow.getRowType(), Collections.singletonList(Collections.singletonList(rexBuilder.makeExactLiteral(BigDecimal.ZERO))), oneRow.getTraitSet().replace(EnumerableConvention.INSTANCE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableProjectRel
    extends ProjectRelBase
    implements EnumerableRel {
        public EnumerableProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
            super(cluster, traitSet, child, exps, rowType, flags);
            assert (this.getConvention() instanceof EnumerableConvention);
        }

        @Override
        public EnumerableProjectRel copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
            return new EnumerableProjectRel(this.getCluster(), traitSet, input, exps, rowType, this.flags);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EnumerableProjectRule
    extends ConverterRule {
        private EnumerableProjectRule() {
            super(ProjectRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableProjectRule");
        }

        public RelNode convert(RelNode rel) {
            ProjectRel project = (ProjectRel)rel;
            if (RexMultisetUtil.containsMultiset(project.getProjects(), true) || RexOver.containsOver(project.getProjects(), null)) {
                return null;
            }
            return new EnumerableProjectRel(rel.getCluster(), rel.getTraitSet().replace(EnumerableConvention.INSTANCE), EnumerableProjectRule.convert(project.getChild(), project.getChild().getTraitSet().replace(EnumerableConvention.INSTANCE)), project.getProjects(), project.getRowType(), 1);
        }
    }

    public static class EnumerableProjectToCalcRule
    extends RelOptRule {
        private EnumerableProjectToCalcRule() {
            super(EnumerableProjectToCalcRule.operand(EnumerableProjectRel.class, EnumerableProjectToCalcRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            EnumerableProjectRel project = (EnumerableProjectRel)call.rel(0);
            RelNode child = project.getChild();
            RelDataType rowType = project.getRowType();
            RexProgram program = RexProgram.create(child.getRowType(), project.getProjects(), null, project.getRowType(), project.getCluster().getRexBuilder());
            EnumerableCalcRel calc = new EnumerableCalcRel(project.getCluster(), project.getTraitSet(), child, rowType, program, (List<RelCollation>)ImmutableList.of());
            call.transformTo(calc);
        }
    }

    public static class EnumerableSortRel
    extends SortRel
    implements EnumerableRel {
        public EnumerableSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, child, collation, offset, fetch);
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        public EnumerableSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new EnumerableSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
            Expression childExp = builder.append("child", result.block);
            PhysType inputPhysType = result.physType;
            Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(this.collation.getFieldCollations());
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.ORDER_BY.method, (Iterable)Expressions.list((Object[])new Expression[]{builder.append("keySelector", (Expression)pair.left)}).appendIfNotNull((Object)builder.appendIfNotNull("comparator", (Expression)pair.right)))));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableSortRule
    extends ConverterRule {
        private EnumerableSortRule() {
            super(SortRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSortRule");
        }

        public RelNode convert(RelNode rel) {
            SortRel sort = (SortRel)rel;
            if (sort.offset != null || sort.fetch != null) {
                return null;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode input = sort.getChild();
            return new EnumerableSortRel(rel.getCluster(), traitSet, EnumerableSortRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)), sort.getCollation(), null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableTableAccessRel
    extends TableAccessRelBase
    implements EnumerableRel {
        private final Class elementType;

        public EnumerableTableAccessRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Class elementType) {
            super(cluster, traitSet, table);
            assert (this.getConvention() instanceof EnumerableConvention);
            this.elementType = elementType;
        }

        private Expression getExpression() {
            Expression expression = this.table.getExpression(Queryable.class);
            Type type = expression.getType();
            if (Types.isArray((Type)type)) {
                if (Types.toClass((Type)type).getComponentType().isPrimitive()) {
                    expression = Expressions.call((Method)BuiltinMethod.AS_LIST.method, (Expression[])new Expression[]{expression});
                }
                expression = Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{expression});
            } else if (Types.isAssignableFrom(Iterable.class, (Type)type) && !Types.isAssignableFrom(Enumerable.class, (Type)type)) {
                expression = Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE2.method, (Expression[])new Expression[]{expression});
            } else if (Types.isAssignableFrom(Queryable.class, (Type)type)) {
                expression = Expressions.call((Expression)expression, (Method)BuiltinMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
            }
            return expression;
        }

        private JavaRowFormat format() {
            if (Object[].class.isAssignableFrom(this.elementType)) {
                return JavaRowFormat.ARRAY;
            }
            return JavaRowFormat.CUSTOM;
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableTableAccessRel(this.getCluster(), traitSet, this.table, this.elementType);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.format());
            Expression expression = this.getExpression();
            return implementor.result(physType, Blocks.toBlock((Node)expression));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableTableModificationRel
    extends TableModificationRelBase
    implements EnumerableRel {
        public EnumerableTableModificationRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModificationRelBase.Operation operation, List<String> updateColumnList, boolean flattened) {
            super(cluster, traits, table, catalogReader, child, operation, updateColumnList, flattened);
            assert (child.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() instanceof EnumerableConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableTableModificationRel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), EnumerableTableModificationRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.isFlattened());
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            Expression convertedChildExp;
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel.Result result = implementor.visitChild(this, 0, (EnumerableRel)this.getChild(), pref);
            Expression childExp = builder.append("child", result.block);
            ParameterExpression collectionParameter = Expressions.parameter(Collection.class, (String)builder.newName("collection"));
            Expression expression = this.table.getExpression(ModifiableTable.class);
            assert (expression != null);
            assert (ModifiableTable.class.isAssignableFrom(Types.toClass((Type)expression.getType()))) : expression.getType();
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)collectionParameter, (Expression)Expressions.call((Expression)expression, (Method)BuiltinMethod.MODIFIABLE_TABLE_GET_MODIFIABLE_COLLECTION.method, (Expression[])new Expression[0])));
            Expression countParameter = builder.append("count", (Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), false);
            if (!this.getChild().getRowType().equals(this.getRowType())) {
                JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
                PhysType physType = PhysTypeImpl.of(typeFactory, this.table.getRowType(), JavaRowFormat.CUSTOM);
                ArrayList<Expression> expressionList = new ArrayList<Expression>();
                PhysType childPhysType = result.physType;
                ParameterExpression o_ = Expressions.parameter((Type)childPhysType.getJavaRowType(), (String)"o");
                int fieldCount = childPhysType.getRowType().getFieldCount();
                int i = 0;
                while (i < fieldCount) {
                    expressionList.add(childPhysType.fieldReference((Expression)o_, i));
                    ++i;
                }
                convertedChildExp = builder.append("convertedChild", (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.SELECT.method, (Expression[])new Expression[]{Expressions.lambda((Expression)physType.record(expressionList), (ParameterExpression[])new ParameterExpression[]{o_})}));
            } else {
                convertedChildExp = childExp;
            }
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)convertedChildExp, (String)"into", (Expression[])new Expression[]{collectionParameter})));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)Expressions.subtract((Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), (Expression)countParameter), Long.TYPE)})));
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref == EnumerableRel.Prefer.ARRAY ? JavaRowFormat.ARRAY : JavaRowFormat.SCALAR);
            return implementor.result(physType, builder.toBlock());
        }
    }

    public static class EnumerableTableModificationRule
    extends ConverterRule {
        private EnumerableTableModificationRule() {
            super(TableModificationRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableModificationRule");
        }

        public RelNode convert(RelNode rel) {
            TableModificationRel modify = (TableModificationRel)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(EnumerableConvention.INSTANCE);
            return new EnumerableTableModificationRel(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), EnumerableTableModificationRule.convert(modify.getChild(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.isFlattened());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableUnionRel
    extends UnionRelBase
    implements EnumerableRel {
        public EnumerableUnionRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public EnumerableUnionRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new EnumerableUnionRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            Object unionExp = null;
            for (Ord ord : Ord.zip((List)this.inputs)) {
                EnumerableRel input = (EnumerableRel)ord.e;
                EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
                Expression childExp = builder.append("child" + ord.i, result.block);
                unionExp = unionExp == null ? childExp : Expressions.call((Expression)unionExp, (Method)(this.all ? BuiltinMethod.CONCAT.method : BuiltinMethod.UNION.method), (Expression[])new Expression[]{childExp});
                pref = pref.of(result.format);
            }
            builder.add(unionExp);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableUnionRule
    extends ConverterRule {
        private EnumerableUnionRule() {
            super(UnionRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableUnionRule");
        }

        public RelNode convert(RelNode rel) {
            UnionRel union = (UnionRel)rel;
            EnumerableConvention out = EnumerableConvention.INSTANCE;
            RelTraitSet traitSet = union.getTraitSet().replace(out);
            return new EnumerableUnionRel(rel.getCluster(), traitSet, EnumerableUnionRule.convertList(union.getInputs(), out), union.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableValuesRel
    extends ValuesRelBase
    implements EnumerableRel {
        EnumerableValuesRel(RelOptCluster cluster, RelDataType rowType, List<List<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new EnumerableValuesRel(this.getCluster(), this.rowType, this.tuples, traitSet);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferCustom());
            Type rowClass = physType.getJavaRowType();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            List<RelDataTypeField> fields = this.rowType.getFieldList();
            for (List tuple : this.tuples) {
                ArrayList<Expression> literals = new ArrayList<Expression>();
                for (Pair pair : Pair.zip(fields, tuple)) {
                    literals.add(RexToLixTranslator.translateLiteral((RexNode)pair.right, ((RelDataTypeField)pair.left).getType(), typeFactory, RexImpTable.NullAs.NULL));
                }
                expressions.add(physType.record(literals));
            }
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)Primitive.box((Type)rowClass), expressions)})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    public static class EnumerableValuesRule
    extends ConverterRule {
        private EnumerableValuesRule() {
            super(ValuesRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableValuesRule");
        }

        public RelNode convert(RelNode rel) {
            ValuesRel valuesRel = (ValuesRel)rel;
            return new EnumerableValuesRel(valuesRel.getCluster(), valuesRel.getRowType(), valuesRel.getTuples(), valuesRel.getTraitSet().replace(EnumerableConvention.INSTANCE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableWindowRel
    extends WindowRelBase
    implements EnumerableRel {
        EnumerableWindowRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelDataType rowType, List<WindowRelBase.Window> windows) {
            super(cluster, traits, child, rowType, windows);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableWindowRel(this.getCluster(), traitSet, EnumerableWindowRel.sole(inputs), this.rowType, (List<WindowRelBase.Window>)this.windows);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double rowsIn = RelMetadataQuery.getRowCount(this.getChild());
            int count = this.windows.size();
            for (WindowRelBase.Window window : this.windows) {
                count += window.aggCalls.size();
            }
            return planner.getCostFactory().makeCost(rowsIn, rowsIn * (double)count, 0.0);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            EnumerableRel child = (EnumerableRel)this.getChild();
            final RexToLixTranslator translator = RexToLixTranslator.forAggregation(typeFactory);
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            Expression source_ = builder.append("source", result.block);
            PhysType inputPhysType = result.physType;
            for (WindowRelBase.Window window : this.windows) {
                Expression collectionExpr;
                Expression iterator_;
                Expression comparator_ = builder.append("comparator", inputPhysType.generateComparator(window.collation()));
                if (window.groupSet.isEmpty()) {
                    Expression tempList_ = builder.append("tempList", (Expression)Expressions.convert_((Expression)Expressions.call((Expression)source_, (Method)BuiltinMethod.INTO.method, (Expression[])new Expression[]{Expressions.new_(ArrayList.class)}), List.class));
                    iterator_ = builder.append("iterator", (Expression)Expressions.call(null, (Method)BuiltinMethod.SORTED_MULTI_MAP_SINGLETON.method, (Expression[])new Expression[]{comparator_, tempList_}));
                    collectionExpr = tempList_;
                } else {
                    Expression multiMap_ = builder.append("multiMap", (Expression)Expressions.new_(SortedMultiMap.class));
                    BlockBuilder builder2 = new BlockBuilder();
                    ParameterExpression v_ = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)builder2.newName("v"));
                    DeclarationStatement declare = Expressions.declare((int)0, (String)"key", (Expression)inputPhysType.selector(v_, BitSets.toList(window.groupSet), JavaRowFormat.CUSTOM));
                    builder2.add((Statement)declare);
                    ParameterExpression key_ = declare.parameter;
                    builder2.add(Expressions.statement((Expression)Expressions.call((Expression)multiMap_, (Method)BuiltinMethod.SORTED_MULTI_MAP_PUT_MULTI.method, (Expression[])new Expression[]{key_, v_})));
                    builder2.add((Statement)Expressions.return_(null, (Expression)Expressions.constant(null)));
                    builder.add(Expressions.statement((Expression)Expressions.call((Expression)source_, (Method)BuiltinMethod.ENUMERABLE_FOREACH.method, (Expression[])new Expression[]{Expressions.lambda((BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{v_})})));
                    iterator_ = builder.append("iterator", (Expression)Expressions.call((Expression)multiMap_, (Method)BuiltinMethod.SORTED_MULTI_MAP_ARRAYS.method, (Expression[])new Expression[]{comparator_}));
                    collectionExpr = multiMap_;
                }
                RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
                typeBuilder.addAll(inputPhysType.getRowType().getFieldList());
                int offset = typeBuilder.getFieldCount();
                final List<AggregateCall> aggregateCalls = window.getAggregateCalls(this);
                for (AggregateCall aggregateCall : aggregateCalls) {
                    typeBuilder.add(aggregateCall.name, aggregateCall.type);
                }
                RelDataType outputRowType = typeBuilder.build();
                PhysType outputPhysType = PhysTypeImpl.of(typeFactory, outputRowType, pref.prefer(result.format));
                Expression list_ = builder.append("list", (Expression)Expressions.new_(ArrayList.class, (Expression[])new Expression[]{Expressions.call((Expression)collectionExpr, (Method)BuiltinMethod.COLLECTION_SIZE.method, (Expression[])new Expression[0])}), false);
                BlockBuilder builder3 = new BlockBuilder();
                Expression rows_ = builder3.append("rows", (Expression)Expressions.convert_((Expression)Expressions.call((Expression)iterator_, (Method)BuiltinMethod.ITERATOR_NEXT.method, (Expression[])new Expression[0]), Object[].class), false);
                BlockBuilder builder4 = new BlockBuilder();
                ParameterExpression i_ = Expressions.parameter(Integer.TYPE, (String)builder4.newName("i"));
                final Expression row_ = builder4.append("row", (Expression)Expressions.convert_((Expression)Expressions.arrayIndex((Expression)rows_, (Expression)i_), (Type)inputPhysType.getJavaRowType()));
                final List<AggImplementor> implementors = EnumUtil.getImplementors(aggregateCalls);
                final ArrayList<ParameterExpression> variables = new ArrayList<ParameterExpression>();
                for (Ord ord : Ord.zip(Pair.zip(aggregateCalls, implementors))) {
                    ParameterExpression parameter = Expressions.parameter((Type)outputPhysType.fieldClass(offset + ord.i), (String)builder4.newName(((AggregateCall)((Pair)ord.e).left).name));
                    Expression initExpression = ((AggImplementor)((Pair)ord.e).right).implementInit(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), parameter.type, EnumUtil.fieldTypes(typeFactory, inputPhysType.getRowType(), ((AggregateCall)((Pair)ord.e).left).getArgList()));
                    variables.add(parameter);
                    builder4.add((Statement)Expressions.declare((int)0, (ParameterExpression)parameter, (Expression)initExpression));
                }
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                int i = 0;
                while (i < offset) {
                    expressions.add(Types.castIfNecessary((Type)inputPhysType.fieldClass(i), (Expression)inputPhysType.fieldReference(row_, i)));
                    ++i;
                }
                final PhysType finalInputPhysType = inputPhysType;
                this.generateWindowLoop(translator, builder4, window, aggregateCalls, implementors, variables, rows_, i_, row_, expressions, new Function1<AggCallContext, Void>(){

                    public Void apply(AggCallContext a0) {
                        for (Ord ord : Ord.zip(Pair.zip(aggregateCalls, implementors))) {
                            Expression accumulator = (Expression)variables.get(ord.i);
                            ArrayList<BinaryExpression> conditions = new ArrayList<BinaryExpression>();
                            for (int arg : ((AggregateCall)((Pair)ord.e).left).getArgList()) {
                                if (!finalInputPhysType.fieldNullable(arg)) continue;
                                conditions.add(Expressions.notEqual((Expression)finalInputPhysType.fieldReference(row_, arg), (Expression)Expressions.constant(null)));
                            }
                            Statement assign = Expressions.statement((Expression)Expressions.assign((Expression)accumulator, (Expression)((AggImplementor)((Pair)ord.e).right).implementAdd(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), accumulator, finalInputPhysType.accessors(row_, ((AggregateCall)((Pair)ord.e).left).getArgList()))));
                            if (conditions.isEmpty()) {
                                a0.builder().add(assign);
                                continue;
                            }
                            a0.builder().add((Statement)Expressions.ifThen((Expression)Expressions.foldAnd(conditions), (Node)assign));
                        }
                        return null;
                    }
                });
                builder4.add(Expressions.statement((Expression)Expressions.call((Expression)list_, (Method)BuiltinMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{outputPhysType.record(expressions)})));
                builder3.add((Statement)Expressions.for_((DeclarationStatement)Expressions.declare((int)0, (ParameterExpression)i_, (Expression)Expressions.constant((Object)0)), (Expression)Expressions.lessThan((Expression)i_, (Expression)Expressions.field((Expression)rows_, (String)"length")), (Expression)Expressions.preIncrementAssign((Expression)i_), (Statement)builder4.toBlock()));
                builder.add((Statement)Expressions.while_((Expression)Expressions.call((Expression)iterator_, (Method)BuiltinMethod.ITERATOR_HAS_NEXT.method, (Expression[])new Expression[0]), (Statement)builder3.toBlock()));
                builder.add(Expressions.statement((Expression)Expressions.call((Expression)collectionExpr, (Method)BuiltinMethod.MAP_CLEAR.method, (Expression[])new Expression[0])));
                source_ = builder.append("source", (Expression)Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{list_}));
                inputPhysType = outputPhysType;
            }
            builder.add((Statement)Expressions.return_(null, (Expression)source_));
            return implementor.result(inputPhysType, builder.toBlock());
        }

        private void generateWindowLoop(RexToLixTranslator translator, BlockBuilder builder, WindowRelBase.Window window, List<AggregateCall> aggregateCalls, List<AggImplementor> implementors, List<ParameterExpression> variables, Expression rows_, ParameterExpression i_, Expression row_, List<Expression> expressions, Function1<AggCallContext, Void> f3) {
            ConstantExpression min_ = Expressions.constant((Object)0);
            BinaryExpression max_ = Expressions.subtract((Expression)Expressions.field((Expression)rows_, (String)"length"), (Expression)Expressions.constant((Object)1));
            SqlWindow.OffsetRange offsetAndRange = SqlWindow.getOffsetAndRange(window.lowerBound, window.upperBound, window.isRows);
            final Expression start_ = builder.append("start", this.optimizeAdd((Expression)i_, (int)offsetAndRange.offset - (int)offsetAndRange.range, (Expression)min_, (Expression)max_), false);
            final Expression end_ = builder.append("end", this.optimizeAdd((Expression)i_, (int)offsetAndRange.offset, (Expression)min_, (Expression)max_), false);
            DeclarationStatement jDecl = Expressions.declare((int)0, (String)"j", (Expression)start_);
            final ParameterExpression j_ = jDecl.parameter;
            final Expression row2_ = builder.append("row2", (Expression)Expressions.convert_((Expression)Expressions.arrayIndex((Expression)rows_, (Expression)j_), (Type)row_.getType()));
            final BlockBuilder builder5 = new BlockBuilder();
            f3.apply((Object)new AggCallContext(){

                public BlockBuilder builder() {
                    return builder5;
                }

                public Expression index() {
                    return j_;
                }

                public Expression current() {
                    return row2_;
                }

                public Expression isFirst() {
                    return Expressions.equal((Expression)j_, (Expression)start_);
                }

                public Expression isLast() {
                    return Expressions.equal((Expression)j_, (Expression)end_);
                }
            });
            builder.add((Statement)Expressions.for_((DeclarationStatement)jDecl, (Expression)Expressions.lessThanOrEqual((Expression)j_, (Expression)end_), (Expression)Expressions.preIncrementAssign((Expression)j_), (Statement)builder5.toBlock()));
            for (Ord ord : Ord.zip(Pair.zip(aggregateCalls, implementors))) {
                AggImplementor implementor2 = (AggImplementor)((Pair)ord.e).right;
                expressions.add(implementor2 instanceof WinAggImplementor ? ((WinAggImplementor)implementor2).implementResultPlus(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), (Expression)variables.get(ord.i), start_, end_, rows_, (Expression)i_) : implementor2.implementResult(translator, ((AggregateCall)((Pair)ord.e).left).getAggregation(), (Expression)variables.get(ord.i)));
            }
        }

        private Expression optimizeAdd(Expression i_, int offset, Expression min_, Expression max_) {
            if (offset == 0) {
                return i_;
            }
            if (offset < 0) {
                return Expressions.call(null, (Method)BuiltinMethod.MATH_MAX.method, (Expression[])new Expression[]{min_, Expressions.subtract((Expression)i_, (Expression)Expressions.constant((Object)(-offset)))});
            }
            return Expressions.call(null, (Method)BuiltinMethod.MATH_MIN.method, (Expression[])new Expression[]{max_, Expressions.add((Expression)i_, (Expression)Expressions.constant((Object)offset))});
        }
    }

    private static class EnumerableWindowRule
    extends ConverterRule {
        private EnumerableWindowRule() {
            super(WindowRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableWindowRule");
        }

        public RelNode convert(RelNode rel) {
            WindowRel winAgg = (WindowRel)rel;
            RelTraitSet traitSet = winAgg.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode child = winAgg.getChild();
            RelNode convertedChild = EnumerableWindowRule.convert(child, child.getTraitSet().replace(EnumerableConvention.INSTANCE));
            return new EnumerableWindowRel(rel.getCluster(), traitSet, convertedChild, winAgg.getRowType(), (List<WindowRelBase.Window>)winAgg.windows);
        }
    }
}

