/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.java;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaFactory;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Statistic;
import net.hydromatic.optiq.Statistics;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveSchema
extends AbstractSchema {
    final Class clazz;
    private Object target;

    public ReflectiveSchema(Object target) {
        this.clazz = target.getClass();
        this.target = target;
    }

    public String toString() {
        return "ReflectiveSchema(target=" + this.target + ")";
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Field[] fieldArray = this.clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            Table table = this.fieldRelation(field);
            if (table != null) {
                builder.put((Object)fieldName, (Object)table);
            }
            ++n2;
        }
        return builder.build();
    }

    @Override
    protected Multimap<String, Function> getFunctionMultimap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        Method[] methodArray = this.clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (method.getDeclaringClass() != Object.class && !methodName.equals("toString")) {
                TableMacro tableMacro = this.methodMember(method);
                builder.put((Object)methodName, (Object)tableMacro);
            }
            ++n2;
        }
        return builder.build();
    }

    private TableMacro methodMember(Method method) {
        Type elementType = ReflectiveSchema.getElementType(method.getReturnType());
        Class<?>[] parameterTypes = method.getParameterTypes();
        return new MethodTableMacro(this, method, elementType, parameterTypes);
    }

    Expression getTargetExpression(SchemaPlus parentSchema, String name) {
        return Types.castIfNecessary(this.target.getClass(), (Expression)Expressions.call((Expression)Schemas.unwrap(this.getExpression(parentSchema, name), ReflectiveSchema.class), (Method)BuiltinMethod.REFLECTIVE_SCHEMA_GET_TARGET.method, (Expression[])new Expression[0]));
    }

    private <T> Table fieldRelation(Field field) {
        Object o;
        Type elementType = ReflectiveSchema.getElementType(field.getType());
        if (elementType == null) {
            return null;
        }
        try {
            o = field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while accessing field " + field, e);
        }
        Enumerable enumerable = ReflectiveSchema.toEnumerable(o);
        return new FieldTable(field, elementType, enumerable);
    }

    private static Type getElementType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    private static Enumerable toEnumerable(Object o) {
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                return Linq4j.asEnumerable((Object[])((Object[])o));
            }
            return Linq4j.asEnumerable((List)Primitive.asList((Object)o));
        }
        if (o instanceof Iterable) {
            return Linq4j.asEnumerable((Iterable)((Iterable)o));
        }
        throw new RuntimeException("Cannot convert " + o.getClass() + " into a Enumerable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            Object target;
            Class<?> clazz;
            Object className = operand.get("class");
            if (className != null) {
                try {
                    clazz = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + className, e);
                }
            } else {
                throw new RuntimeException("Operand 'class' is required");
            }
            Object methodName = operand.get("staticMethod");
            if (methodName != null) {
                try {
                    Method method = clazz.getMethod((String)methodName, new Class[0]);
                    target = method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking method " + methodName, e);
                }
            }
            try {
                target = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class " + className, e);
            }
            return new ReflectiveSchema(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldTable<T>
    extends ReflectiveTable {
        private final Field field;

        public FieldTable(Field field, Type elementType, Enumerable<T> enumerable) {
            super(elementType, enumerable);
            this.field = field;
        }

        public String toString() {
            return "Relation {field=" + this.field.getName() + "}";
        }

        @Override
        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Expressions.field((Expression)schema.unwrap(ReflectiveSchema.class).getTargetExpression(schema.getParentSchema(), schema.getName()), (Field)this.field);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodTableMacro
    implements TableMacro {
        private final ReflectiveSchema schema;
        private final Method method;
        private final Type elementType;
        private final Class<?>[] parameterTypes;

        public MethodTableMacro(ReflectiveSchema schema, Method method, Type elementType, Class<?>[] parameterTypes) {
            this.schema = schema;
            this.method = method;
            this.elementType = elementType;
            this.parameterTypes = parameterTypes;
        }

        public String toString() {
            return "Member {method=" + this.method + "}";
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public List<FunctionParameter> getParameters() {
            return new AbstractList<FunctionParameter>(){

                @Override
                public FunctionParameter get(final int index) {
                    return new FunctionParameter(){

                        public int getOrdinal() {
                            return index;
                        }

                        public String getName() {
                            return "arg" + index;
                        }

                        public RelDataType getType(RelDataTypeFactory typeFactory) {
                            return typeFactory.createJavaType(MethodTableMacro.this.parameterTypes[index]);
                        }
                    };
                }

                @Override
                public int size() {
                    return MethodTableMacro.this.parameterTypes.length;
                }
            };
        }

        @Override
        public Table apply(List<Object> arguments) {
            final ArrayList<ConstantExpression> list = new ArrayList<ConstantExpression>();
            for (Object argument : arguments) {
                list.add(Expressions.constant((Object)argument));
            }
            try {
                Object o = this.method.invoke((Object)this.schema, arguments.toArray());
                Enumerable enumerable = ReflectiveSchema.toEnumerable(o);
                return new ReflectiveTable(this.elementType, enumerable){

                    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
                        return Expressions.call((Expression)schema.unwrap(ReflectiveSchema.class).getTargetExpression(schema.getParentSchema(), schema.getName()), (Method)MethodTableMacro.this.method, (Iterable)list);
                    }
                };
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectiveTable
    extends AbstractQueryableTable
    implements Table {
        private final Type elementType;
        private final Enumerable enumerable;

        public ReflectiveTable(Type elementType, Enumerable enumerable) {
            super(elementType);
            this.elementType = elementType;
            this.enumerable = enumerable;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                public Enumerator<T> enumerator() {
                    return ReflectiveTable.this.enumerable.enumerator();
                }
            };
        }
    }
}

