/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.AggregateFunction;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.impl.ScalarFunctionImpl;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateFunctionImpl
implements AggregateFunction {
    public final Method initMethod;
    public final Method initAddMethod;
    public final Method addMethod;
    public final Method mergeMethod;
    public final Method resultMethod;
    public final ImmutableList<Class<?>> valueTypes;
    public final Class<?> accumulatorType;
    public final Class<?> resultType;
    public final Class<?> declaringClass;

    private AggregateFunctionImpl(List<Class<?>> valueTypes, Class<?> accumulatorType, Class<?> resultType, Method initMethod, Method initAddMethod, Method addMethod, Method mergeMethod, Method resultMethod) {
        this.valueTypes = ImmutableList.copyOf(valueTypes);
        this.accumulatorType = accumulatorType;
        this.resultType = resultType;
        this.initMethod = initMethod;
        this.initAddMethod = initAddMethod;
        this.addMethod = addMethod;
        this.mergeMethod = mergeMethod;
        this.resultMethod = resultMethod;
        this.declaringClass = initMethod.getDeclaringClass();
        assert (initMethod != null);
        assert (addMethod != null);
        assert (resultMethod != null || accumulatorType == resultType);
        assert (addMethod.getDeclaringClass() == this.declaringClass);
        assert (initAddMethod == null || initAddMethod.getDeclaringClass() == this.declaringClass);
        assert (mergeMethod == null || mergeMethod.getDeclaringClass() == this.declaringClass);
        assert (resultMethod == null || resultMethod.getDeclaringClass() == this.declaringClass);
    }

    public static AggregateFunction create(Class<?> clazz) {
        Method initMethod = ScalarFunctionImpl.findMethod(clazz, "init");
        Method initAddMethod = ScalarFunctionImpl.findMethod(clazz, "initAdd");
        Method addMethod = ScalarFunctionImpl.findMethod(clazz, "add");
        Method mergeMethod = null;
        Method resultMethod = ScalarFunctionImpl.findMethod(clazz, "result");
        if (initMethod != null && addMethod != null) {
            List<Class<?>> initAddParams;
            Class<?> accumulatorType = initMethod.getReturnType();
            Class<?> resultType = resultMethod != null ? resultMethod.getReturnType() : accumulatorType;
            List<Class<?>> addParamTypes = Arrays.asList(addMethod.getParameterTypes());
            if (addParamTypes.isEmpty() || addParamTypes.get(0) != accumulatorType) {
                throw Static.RESOURCE.firstParameterOfAdd(clazz.getName()).ex();
            }
            List<Class<?>> valueTypes = Util.skip(addParamTypes, 1);
            if (initAddMethod != null && !(initAddParams = Arrays.asList(initAddMethod.getParameterTypes())).equals(valueTypes)) {
                throw Static.RESOURCE.initAddWrongParamTypes(clazz.getName()).ex();
            }
            return new AggregateFunctionImpl(valueTypes, accumulatorType, resultType, initMethod, initAddMethod, addMethod, mergeMethod, resultMethod);
        }
        return null;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return new AbstractList<FunctionParameter>(){

            @Override
            public FunctionParameter get(final int index) {
                return new FunctionParameter(){

                    public int getOrdinal() {
                        return index;
                    }

                    public String getName() {
                        return "arg" + index;
                    }

                    public RelDataType getType(RelDataTypeFactory typeFactory) {
                        return typeFactory.createJavaType((Class)(this).AggregateFunctionImpl.this.valueTypes.get(index));
                    }
                };
            }

            @Override
            public int size() {
                return AggregateFunctionImpl.this.valueTypes.size();
            }
        };
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.resultType);
    }
}

