/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.advise;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.OverScope;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Util;

public class SqlAdvisorValidator
extends SqlValidatorImpl {
    private final Set<SqlValidatorNamespace> activeNamespaces = new HashSet<SqlValidatorNamespace>();
    private final RelDataType emptyStructType = SqlTypeUtil.createEmptyStructType(this.typeFactory);

    public SqlAdvisorValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
        super(opTab, catalogReader, typeFactory, conformance);
        assert (opTab != null);
        assert (catalogReader != null);
        assert (typeFactory != null);
    }

    public void validateIdentifier(SqlIdentifier id, SqlValidatorScope scope) {
        this.registerId(id, scope);
        try {
            super.validateIdentifier(id, scope);
        }
        catch (EigenbaseException e) {
            Util.swallow(e, TRACER);
        }
    }

    private void registerId(SqlIdentifier id, SqlValidatorScope scope) {
        for (int i = 0; i < id.names.size(); ++i) {
            SqlParserPos subPos = id.getComponentParserPosition(i);
            SqlIdentifier subId = i == id.names.size() - 1 ? id : new SqlIdentifier((List<String>)id.names.subList(0, i + 1), subPos);
            this.idPositions.put(subPos.toString(), new SqlValidatorImpl.IdInfo(scope, subId));
        }
    }

    public SqlNode expand(SqlNode expr, SqlValidatorScope scope) {
        return expr;
    }

    public SqlNode expandOrderExpr(SqlSelect select, SqlNode orderExpr) {
        return orderExpr;
    }

    public RelDataType deriveType(SqlValidatorScope scope, SqlNode operand) {
        try {
            return super.deriveType(scope, operand);
        }
        catch (EigenbaseException e) {
            return this.unknownType;
        }
        catch (UnsupportedOperationException e) {
            return this.unknownType;
        }
        catch (Error e) {
            return this.unknownType;
        }
    }

    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        try {
            super.validateFrom(node, targetRowType, scope);
        }
        catch (EigenbaseException e) {
            Util.swallow(e, TRACER);
        }
    }

    protected void validateWhereClause(SqlSelect select) {
        try {
            super.validateWhereClause(select);
        }
        catch (EigenbaseException e) {
            Util.swallow(e, TRACER);
        }
    }

    protected void validateHavingClause(SqlSelect select) {
        try {
            super.validateHavingClause(select);
        }
        catch (EigenbaseException e) {
            Util.swallow(e, TRACER);
        }
    }

    protected void validateOver(SqlCall call, SqlValidatorScope scope) {
        try {
            OverScope overScope = (OverScope)this.getOverScope(call);
            Object relation = call.operand(0);
            this.validateFrom((SqlNode)relation, this.unknownType, scope);
            Object window = call.operand(1);
            SqlValidatorScope opScope = (SqlValidatorScope)this.scopes.get(relation);
            if (opScope == null) {
                opScope = overScope;
            }
            this.validateWindow((SqlNode)window, opScope, null);
        }
        catch (EigenbaseException e) {
            Util.swallow(e, TRACER);
        }
    }

    protected void validateNamespace(SqlValidatorNamespace namespace) {
        if (this.activeNamespaces.add(namespace)) {
            super.validateNamespace(namespace);
        } else {
            namespace.setRowType(this.emptyStructType);
        }
    }

    protected boolean shouldAllowOverRelation() {
        return true;
    }
}

