/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexMultisetUtil {
    private static final Set<SqlOperator> MULTISET_OPERATORS = ImmutableSet.of((Object)SqlStdOperatorTable.CARDINALITY, (Object)SqlStdOperatorTable.CAST, (Object)SqlStdOperatorTable.ELEMENT, (Object)SqlStdOperatorTable.ELEMENT_SLICE, (Object)SqlStdOperatorTable.MULTISET_EXCEPT_ALL, (Object)SqlStdOperatorTable.MULTISET_EXCEPT, (Object[])new SqlOperator[]{SqlStdOperatorTable.MULTISET_INTERSECT_ALL, SqlStdOperatorTable.MULTISET_INTERSECT, SqlStdOperatorTable.MULTISET_UNION_ALL, SqlStdOperatorTable.MULTISET_UNION, SqlStdOperatorTable.IS_A_SET, SqlStdOperatorTable.MEMBER_OF, SqlStdOperatorTable.SUBMULTISET_OF});

    private RexMultisetUtil() {
    }

    public static boolean containsMixing(RexProgram program) {
        RexCallMultisetOperatorCounter counter = new RexCallMultisetOperatorCounter();
        for (RexNode expr : program.getExprList()) {
            counter.reset();
            expr.accept(counter);
            if (counter.totalCount == counter.multisetCount || 0 == counter.multisetCount) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMixing(RexNode node) {
        RexCallMultisetOperatorCounter counter = new RexCallMultisetOperatorCounter();
        node.accept(counter);
        return counter.totalCount != counter.multisetCount && 0 != counter.multisetCount;
    }

    public static boolean containsMultiset(RexNode node, boolean deep) {
        return null != RexMultisetUtil.findFirstMultiset(node, deep);
    }

    public static boolean containsMultiset(List<RexNode> nodes, boolean deep) {
        for (RexNode node : nodes) {
            if (!RexMultisetUtil.containsMultiset(node, deep)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMultiset(RexProgram program) {
        return RexMultisetUtil.containsMultiset(program.getExprList(), true);
    }

    public static boolean isMultisetCast(RexCall call) {
        if (!call.getOperator().equals(SqlStdOperatorTable.CAST)) {
            return false;
        }
        return call.getType().getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static RexCall findFirstMultiset(RexNode node, boolean deep) {
        if (node instanceof RexFieldAccess) {
            return RexMultisetUtil.findFirstMultiset(((RexFieldAccess)node).getReferenceExpr(), deep);
        }
        if (!(node instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)node;
        RexCall firstOne = null;
        for (SqlOperator op : MULTISET_OPERATORS) {
            firstOne = RexUtil.findOperatorCall(op, call);
            if (null == firstOne) continue;
            if (!firstOne.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(firstOne)) break;
            firstOne = null;
        }
        if (!deep && firstOne != call) {
            return null;
        }
        return firstOne;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RexCallMultisetOperatorCounter
    extends RexVisitorImpl<Void> {
        int totalCount = 0;
        int multisetCount = 0;

        RexCallMultisetOperatorCounter() {
            super(true);
        }

        void reset() {
            this.totalCount = 0;
            this.multisetCount = 0;
        }

        @Override
        public Void visitCall(RexCall call) {
            ++this.totalCount;
            if (MULTISET_OPERATORS.contains(call.getOperator()) && (!call.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(call))) {
                ++this.multisetCount;
            }
            return (Void)super.visitCall(call);
        }
    }
}

