/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.fun.SqlStdOperatorTable;

public final class RemoveIsNotDistinctFromRule
extends RelOptRule {
    public static final RemoveIsNotDistinctFromRule INSTANCE = new RemoveIsNotDistinctFromRule();

    private RemoveIsNotDistinctFromRule() {
        super(RemoveIsNotDistinctFromRule.operand(FilterRel.class, RemoveIsNotDistinctFromRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRel oldFilterRel = (FilterRel)call.rel(0);
        RexNode oldFilterCond = oldFilterRel.getCondition();
        if (RexUtil.findOperatorCall(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, oldFilterCond) == null) {
            return;
        }
        RemoveIsNotDistinctFromRexShuttle rewriteShuttle = new RemoveIsNotDistinctFromRexShuttle(oldFilterRel.getCluster().getRexBuilder());
        RelNode newFilterRel = CalcRel.createFilter(oldFilterRel.getChild(), oldFilterCond.accept(rewriteShuttle));
        call.transformTo(newFilterRel);
    }

    private class RemoveIsNotDistinctFromRexShuttle
    extends RexShuttle {
        RexBuilder rexBuilder;

        public RemoveIsNotDistinctFromRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            RexNode newCall = super.visitCall(call);
            if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
                RexCall tmpCall = (RexCall)newCall;
                newCall = RelOptUtil.isDistinctFrom(this.rexBuilder, (RexNode)tmpCall.operands.get(0), (RexNode)tmpCall.operands.get(1), true);
            }
            return newCall;
        }
    }
}

