/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.ArrayList;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;

public class RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.SELECTIVITY.method, new RelMdSelectivity());

    protected RelMdSelectivity() {
    }

    public Double getSelectivity(UnionRelBase rel, RexNode predicate) {
        if (rel.getInputs().size() == 0 || predicate == null) {
            return 1.0;
        }
        double sumRows = 0.0;
        double sumSelectedRows = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            Double nRows = RelMetadataQuery.getRowCount(input);
            if (nRows == null) {
                return null;
            }
            RexNode modifiedPred = predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments));
            double sel = RelMetadataQuery.getSelectivity(input, modifiedPred);
            sumRows += nRows.doubleValue();
            sumSelectedRows += nRows * sel;
        }
        if (sumRows < 1.0) {
            sumRows = 1.0;
        }
        return sumSelectedRows / sumRows;
    }

    public Double getSelectivity(SortRel rel, RexNode predicate) {
        return RelMetadataQuery.getSelectivity(rel.getChild(), predicate);
    }

    public Double getSelectivity(FilterRelBase rel, RexNode predicate) {
        if (predicate != null) {
            return RelMetadataQuery.getSelectivity(rel.getChild(), RelMdUtil.minusPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition()));
        }
        return RelMetadataQuery.getSelectivity(rel.getChild(), rel.getCondition());
    }

    public Double getSelectivity(SemiJoinRel rel, RexNode predicate) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        if (predicate != null) {
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return RelMetadataQuery.getSelectivity(rel.getLeft(), newPred);
    }

    public Double getSelectivity(AggregateRelBase rel, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        Double selectivity = RelMetadataQuery.getSelectivity(rel.getChild(), childPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(ProjectRelBase rel, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(BitSets.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushFilterPastProject(childPred, rel);
        Double selectivity = RelMetadataQuery.getSelectivity(rel.getChild(), modifiedPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(RelNode rel, RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate);
    }
}

