/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.FrameworkContext;
import net.hydromatic.optiq.tools.RuleSet;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.sql2rel.StandardConvertletTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdFrameworkConfig
implements FrameworkConfig {
    private final FrameworkContext context;
    private final SqlRexConvertletTable convertletTable;
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<RuleSet> ruleSets;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final Lex lex;
    private final SchemaPlus defaultSchema;
    private final RelOptCostFactory costFactory;
    private final SqlParserImplFactory parserFactory;

    public StdFrameworkConfig(FrameworkContext context, SqlRexConvertletTable convertletTable, SqlOperatorTable operatorTable, ImmutableList<RuleSet> ruleSets, ImmutableList<RelTraitDef> traitDefs, Lex lex, SchemaPlus defaultSchema, RelOptCostFactory costFactory, SqlParserImplFactory parserFactory) {
        this.context = context;
        this.convertletTable = convertletTable;
        this.operatorTable = operatorTable;
        this.ruleSets = ruleSets;
        this.traitDefs = traitDefs;
        this.lex = lex;
        this.defaultSchema = defaultSchema;
        this.costFactory = costFactory;
        this.parserFactory = parserFactory;
    }

    @Override
    public Lex getLex() {
        return this.lex;
    }

    @Override
    public SqlParserImplFactory getParserFactory() {
        return this.parserFactory;
    }

    @Override
    public SchemaPlus getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public ImmutableList<RuleSet> getRuleSets() {
        return this.ruleSets;
    }

    @Override
    public RelOptCostFactory getCostFactory() {
        return this.costFactory;
    }

    @Override
    public ImmutableList<RelTraitDef> getTraitDefs() {
        return this.traitDefs;
    }

    @Override
    public SqlRexConvertletTable getConvertletTable() {
        return this.convertletTable;
    }

    @Override
    public FrameworkContext getFrameworkContext() {
        return this.context;
    }

    @Override
    public SqlOperatorTable getOperatorTable() {
        return this.operatorTable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private SqlRexConvertletTable convertletTable = StandardConvertletTable.INSTANCE;
        private SqlOperatorTable operatorTable = SqlStdOperatorTable.instance();
        private ImmutableList<RuleSet> ruleSets = ImmutableList.of();
        private FrameworkContext context;
        private ImmutableList<RelTraitDef> traitDefs;
        private Lex lex = Lex.ORACLE;
        private SchemaPlus defaultSchema;
        private RelOptCostFactory costFactory;
        private SqlParserImplFactory parserFactory = SqlParserImpl.FACTORY;

        private Builder() {
        }

        public StdFrameworkConfig build() {
            return new StdFrameworkConfig(this.context, this.convertletTable, this.operatorTable, this.ruleSets, this.traitDefs, this.lex, this.defaultSchema, this.costFactory, this.parserFactory);
        }

        public Builder context(FrameworkContext c) {
            Preconditions.checkNotNull((Object)c);
            this.context = c;
            return this;
        }

        public Builder convertletTable(SqlRexConvertletTable table) {
            Preconditions.checkNotNull((Object)table);
            this.convertletTable = table;
            return this;
        }

        public Builder operatorTable(SqlOperatorTable table) {
            Preconditions.checkNotNull((Object)table);
            this.operatorTable = table;
            return this;
        }

        public Builder traitDefs(List<RelTraitDef> traitDefs) {
            this.traitDefs = traitDefs == null ? null : ImmutableList.copyOf(traitDefs);
            return this;
        }

        public Builder traitDefs(RelTraitDef ... traitDefs) {
            this.traitDefs = ImmutableList.copyOf((Object[])traitDefs);
            return this;
        }

        public Builder lex(Lex lex) {
            Preconditions.checkNotNull((Object)((Object)lex));
            this.lex = lex;
            return this;
        }

        public Builder defaultSchema(SchemaPlus defaultSchema) {
            this.defaultSchema = defaultSchema;
            return this;
        }

        public Builder costFactory(RelOptCostFactory costFactory) {
            this.costFactory = costFactory;
            return this;
        }

        public Builder ruleSets(List<RuleSet> ruleSets) {
            Preconditions.checkNotNull(ruleSets);
            this.ruleSets = ImmutableList.copyOf(ruleSets);
            return this;
        }

        public Builder ruleSets(RuleSet ... ruleSets) {
            this.ruleSets = ImmutableList.copyOf((Object[])ruleSets);
            return this;
        }

        public Builder parserFactory(SqlParserImplFactory parserFactory) {
            Preconditions.checkNotNull((Object)parserFactory);
            this.parserFactory = parserFactory;
            return this;
        }
    }
}

