/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.MaterializedViewTable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String viewSql;
    private final List<String> schemaPath;
    private final RelProtoDataType protoRowType;

    public ViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath) {
        super(elementType);
        this.viewSql = viewSql;
        this.schemaPath = ImmutableList.copyOf(schemaPath);
        this.protoRowType = rowType;
    }

    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath) {
        return new ViewTableMacro(OptiqSchema.from(schema), viewSql, schemaPath);
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return queryProvider.createQuery(this.getExpression(schema, tableName, Queryable.class), this.elementType);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.expandView(context, relOptTable.getRowType(), this.viewSql);
    }

    private RelNode expandView(RelOptTable.ToRelContext preparingStmt, RelDataType rowType, String queryString) {
        try {
            RelNode rel = preparingStmt.expandView(rowType, queryString, this.schemaPath);
            rel = RelOptUtil.createCastRel(rel, rowType, true);
            return rel;
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while parsing view definition:  " + queryString);
        }
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ViewTableMacro
    implements TableMacro {
        protected final String viewSql;
        protected final OptiqSchema schema;
        protected final List<String> schemaPath;

        ViewTableMacro(OptiqSchema schema, String viewSql, List<String> schemaPath) {
            this.viewSql = viewSql;
            this.schema = schema;
            this.schemaPath = schemaPath == null ? null : ImmutableList.copyOf(schemaPath);
        }

        @Override
        public List<FunctionParameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public Table apply(List<Object> arguments) {
            OptiqPrepare.ParseResult parsed = Schemas.parse(MaterializedViewTable.MATERIALIZATION_CONNECTION, this.schema, this.schemaPath, this.viewSql);
            List<String> schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
            JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
            return new ViewTable(typeFactory.getJavaClass(parsed.rowType), RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1);
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.apply(Collections.<Object>emptyList()).getRowType(typeFactory);
        }
    }
}

