/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test.concurrent;

import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.hydromatic.optiq.jdbc.SqlTimeoutException;
import org.eigenbase.test.concurrent.ConcurrentTestCommand;
import org.eigenbase.test.concurrent.ConcurrentTestCommandExecutor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTestCommandGenerator {
    private static final char APOS = '\'';
    private static final char COMMA = ',';
    private static final char LEFT_BRACKET = '{';
    private static final char RIGHT_BRACKET = '}';
    protected boolean debug = false;
    protected PrintStream debugStream = System.out;
    protected String jdbcURL;
    protected Properties jdbcProps;
    private TreeMap<Integer, TreeMap<Integer, ConcurrentTestCommand>> threadMap = new TreeMap();
    private TreeMap<Integer, String> threadNameMap = new TreeMap();
    private List<FailedThread> failedThreads = new ArrayList<FailedThread>();

    public ConcurrentTestCommand addSynchronizationCommand(int threadId, int order) {
        return this.addCommand(threadId, order, new SynchronizationCommand());
    }

    public ConcurrentTestCommand addSleepCommand(int threadId, int order, long millis) {
        return this.addCommand(threadId, order, new SleepCommand(millis));
    }

    public ConcurrentTestCommand addExplainCommand(int threadId, int order, String sql) {
        assert (sql != null);
        ExplainCommand command = new ExplainCommand(sql);
        return this.addCommand(threadId, order, command);
    }

    public ConcurrentTestCommand addPrepareCommand(int threadId, int order, String sql) {
        assert (sql != null);
        PrepareCommand command = new PrepareCommand(sql);
        return this.addCommand(threadId, order, command);
    }

    public ConcurrentTestCommand addFetchAndCompareCommand(int threadId, int order, int timeout, String expected) {
        FetchAndCompareCommand command = new FetchAndCompareCommand(timeout, expected);
        return this.addCommand(threadId, order, command);
    }

    public ConcurrentTestCommand addCloseCommand(int threadId, int order) {
        return this.addCommand(threadId, order, new CloseCommand());
    }

    public ConcurrentTestCommand addInsertCommand(int threadId, int order, int timeout, String sql) {
        InsertCommand command = new InsertCommand(timeout, sql);
        return this.addCommand(threadId, order, command);
    }

    public ConcurrentTestCommand addCommitCommand(int threadId, int order) {
        return this.addCommand(threadId, order, new CommitCommand());
    }

    public ConcurrentTestCommand addRollbackCommand(int threadId, int order) {
        return this.addCommand(threadId, order, new RollbackCommand());
    }

    public ConcurrentTestCommand addDdlCommand(int threadId, int order, String ddl) {
        return this.addCommand(threadId, order, new DdlCommand(ddl));
    }

    protected ConcurrentTestCommand addCommand(int threadId, int order, ConcurrentTestCommand command) {
        assert (threadId > 0);
        assert (order > 0);
        TreeMap<Integer, ConcurrentTestCommand> commandMap = this.threadMap.get(threadId);
        if (commandMap == null) {
            commandMap = new TreeMap();
            this.threadMap.put(threadId, commandMap);
        }
        assert (!commandMap.containsKey(order));
        commandMap.put(order, command);
        return command;
    }

    public void setThreadName(int threadId, String name) {
        this.threadNameMap.put(threadId, name);
    }

    protected void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    protected void setDebug(boolean enabled, PrintStream alternatePrintStream) {
        this.debug = enabled;
        this.debugStream = alternatePrintStream;
    }

    public void setDataSource(String jdbcURL, Properties jdbcProps) {
        this.jdbcURL = jdbcURL;
        this.jdbcProps = jdbcProps;
    }

    public void execute() throws Exception {
        ConcurrentTestCommandExecutor[] threads = this.innerExecute();
        this.postExecute(threads);
    }

    protected ConcurrentTestCommandExecutor[] innerExecute() throws Exception {
        this.failedThreads.clear();
        Set<Integer> threadIds = this.getThreadIds();
        ConcurrentTestCommandExecutor.Sync sync = new ConcurrentTestCommandExecutor.Sync(threadIds.size());
        ConcurrentTestCommandExecutor[] threads = new ConcurrentTestCommandExecutor[threadIds.size()];
        int threadIndex = 0;
        for (int threadId : threadIds) {
            Iterable<ConcurrentTestCommand> commands = this.getCommandIterable(threadId);
            if (this.debug) {
                this.debugStream.println("Thread ID: " + threadId + " (" + this.getThreadName(threadId) + ")");
                this.printCommands(this.debugStream, threadId);
            }
            threads[threadIndex++] = new ConcurrentTestCommandExecutor(threadId, this.getThreadName(threadId), this.jdbcURL, this.jdbcProps, commands, sync, this.debug ? this.debugStream : null);
        }
        for (ConcurrentTestCommandExecutor thread : threads) {
            thread.start();
        }
        for (ConcurrentTestCommandExecutor thread : threads) {
            thread.join();
        }
        return threads;
    }

    protected void postExecute(ConcurrentTestCommandExecutor[] threads) throws Exception {
        if (this.requiresCustomErrorHandling()) {
            for (ConcurrentTestCommandExecutor executor : threads) {
                if (executor.getFailureCause() == null) continue;
                this.customErrorHandler(executor);
            }
        } else {
            for (ConcurrentTestCommandExecutor thread : threads) {
                Throwable cause = thread.getFailureCause();
                if (cause == null) continue;
                this.failedThreads.add(new FailedThread(thread.getName(), thread.getFailureLocation(), cause));
            }
        }
    }

    public boolean failed() {
        return !this.failedThreads.isEmpty();
    }

    public List<FailedThread> getFailedThreads() {
        return ImmutableList.copyOf(this.failedThreads);
    }

    public void synchronizeCommandSets() {
        int j;
        int maxCommands = 0;
        for (TreeMap<Integer, ConcurrentTestCommand> treeMap : this.threadMap.values()) {
            for (j = 1; j < treeMap.lastKey(); ++j) {
                if (treeMap.containsKey(j)) continue;
                treeMap.put(j, null);
            }
            maxCommands = Math.max(maxCommands, treeMap.size());
        }
        for (TreeMap<Integer, ConcurrentTestCommand> treeMap : this.threadMap.values()) {
            if (treeMap.size() >= maxCommands) continue;
            for (j = treeMap.size() + 1; j <= maxCommands; ++j) {
                treeMap.put(j, null);
            }
        }
        for (Map.Entry entry : this.threadMap.entrySet()) {
            TreeMap commands = (TreeMap)entry.getValue();
            TreeMap<Integer, ConcurrentTestCommand> synchronizedCommands = new TreeMap<Integer, ConcurrentTestCommand>();
            for (Map.Entry commandEntry : commands.entrySet()) {
                int orderKey = (Integer)commandEntry.getKey();
                ConcurrentTestCommand command = (ConcurrentTestCommand)commandEntry.getValue();
                synchronizedCommands.put(orderKey * 2 - 1, new AutoSynchronizationCommand());
                synchronizedCommands.put(orderKey * 2, command);
            }
            entry.setValue(synchronizedCommands);
        }
    }

    public boolean hasValidSynchronization() {
        int numSyncs = -1;
        for (Map.Entry<Integer, TreeMap<Integer, ConcurrentTestCommand>> entry : this.threadMap.entrySet()) {
            TreeMap<Integer, ConcurrentTestCommand> commands = entry.getValue();
            int numSyncsThisThread = 0;
            for (ConcurrentTestCommand concurrentTestCommand : commands.values()) {
                if (!(concurrentTestCommand instanceof SynchronizationCommand)) continue;
                ++numSyncsThisThread;
            }
            if (numSyncs < 0) {
                numSyncs = numSyncsThisThread;
            }
            if (numSyncs == numSyncsThisThread) continue;
            return false;
        }
        return true;
    }

    protected Set<Integer> getThreadIds() {
        return this.threadMap.keySet();
    }

    protected String getThreadName(Integer threadId) {
        if (this.threadNameMap.containsKey(threadId)) {
            return this.threadNameMap.get(threadId);
        }
        return "#" + threadId;
    }

    boolean requiresCustomErrorHandling() {
        return false;
    }

    void customErrorHandler(ConcurrentTestCommandExecutor executor) {
    }

    Collection<ConcurrentTestCommand> getCommands(int threadId) {
        assert (this.threadMap.containsKey(threadId));
        return this.threadMap.get(threadId).values();
    }

    Iterable<ConcurrentTestCommand> getCommandIterable(int threadId) {
        return this.getCommands(threadId);
    }

    void printCommands(PrintStream out, Integer threadId) {
        int stepNumber = 1;
        for (ConcurrentTestCommand command : this.getCommandIterable(threadId)) {
            out.println("\tStep " + stepNumber++ + ": " + command.getClass().getName());
        }
    }

    private static class DdlCommand
    extends AbstractCommand {
        private String sql;

        private DdlCommand(String sql) {
            this.sql = sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            Statement stmt = executor.getConnection().createStatement();
            try {
                stmt.execute(this.sql);
            }
            finally {
                stmt.close();
            }
        }
    }

    private static class RollbackCommand
    extends AbstractCommand {
        private RollbackCommand() {
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            executor.getConnection().rollback();
        }
    }

    private static class CommitCommand
    extends AbstractCommand {
        private CommitCommand() {
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            executor.getConnection().commit();
        }
    }

    private static class InsertCommand
    extends CommandWithTimeout {
        private String sql;

        private InsertCommand(int timeout, String sql) {
            super(timeout);
            this.sql = sql;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            Statement stmt = executor.getConnection().createStatement();
            this.setTimeout(stmt);
            stmt.executeUpdate(this.sql);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FetchAndCompareCommand
    extends CommandWithTimeout {
        private List<List<Object>> expected;
        private List<List<Object>> result;
        private static final int STATE_ROW_START = 0;
        private static final int STATE_VALUE_START = 1;
        private static final int STATE_STRING_VALUE = 2;
        private static final int STATE_OTHER_VALUE = 3;
        private static final int STATE_VALUE_END = 4;

        private FetchAndCompareCommand(int timeout, String expected) {
            super(timeout);
            this.parseExpected(expected.trim());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            PreparedStatement stmt = (PreparedStatement)executor.getStatement();
            boolean timeoutSet = this.setTimeout(stmt);
            ResultSet rset = stmt.executeQuery();
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            try {
                int rsetColumnCount = rset.getMetaData().getColumnCount();
                while (rset.next()) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (int i = 1; i <= rsetColumnCount; ++i) {
                        Object value = rset.getObject(i);
                        if (rset.wasNull()) {
                            value = null;
                        }
                        row.add(value);
                    }
                    rows.add(row);
                }
            }
            catch (SqlTimeoutException e) {
                if (!timeoutSet) {
                    throw e;
                }
                Util.swallow((Throwable)e, null);
            }
            finally {
                rset.close();
            }
            this.result = rows;
            this.testValues();
        }

        private void parseExpected(String expected) {
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            int state = 0;
            ArrayList<Object> row = null;
            StringBuilder value = new StringBuilder();
            block7: for (int i = 0; i < expected.length(); ++i) {
                char ch = expected.charAt(i);
                char nextCh = i + 1 < expected.length() ? expected.charAt(i + 1) : (char)'\u0000';
                switch (state) {
                    case 0: {
                        if (ch != '{') continue block7;
                        row = new ArrayList<Object>();
                        state = 1;
                        continue block7;
                    }
                    case 1: {
                        if (Character.isWhitespace(ch)) continue block7;
                        value.setLength(0);
                        if (ch == '\'') {
                            state = 2;
                            continue block7;
                        }
                        value.append(ch);
                        state = 3;
                        continue block7;
                    }
                    case 2: {
                        if (ch == '\'') {
                            if (nextCh == '\'') {
                                value.append('\'');
                                ++i;
                                continue block7;
                            }
                            row.add(value.toString());
                            state = 4;
                            continue block7;
                        }
                        value.append(ch);
                        continue block7;
                    }
                    case 3: {
                        if (ch != ',' && ch != '}') {
                            value.append(ch);
                            continue block7;
                        }
                        String stringValue = value.toString().trim();
                        if (stringValue.matches("^-?[0-9]+$")) {
                            row.add(new BigInteger(stringValue));
                        } else if (stringValue.matches("^-?[0-9]*\\.[0-9]+$")) {
                            row.add(new BigDecimal(stringValue));
                        } else if (stringValue.equals("true")) {
                            row.add(Boolean.TRUE);
                        } else if (stringValue.equals("false")) {
                            row.add(Boolean.FALSE);
                        } else if (stringValue.equals("null")) {
                            row.add(null);
                        } else {
                            throw new IllegalStateException("unknown value type '" + stringValue + "' for FetchAndCompare command");
                        }
                        state = 4;
                    }
                    case 4: {
                        if (ch == ',') {
                            state = 1;
                            continue block7;
                        }
                        if (ch == '}') {
                            rows.add(row);
                            state = 0;
                            continue block7;
                        }
                        if (Character.isWhitespace(ch)) continue block7;
                        throw new IllegalStateException("unexpected character '" + ch + "' at position " + i + " of expected values");
                    }
                }
            }
            if (state != 0) {
                throw new IllegalStateException("unterminated data in expected values");
            }
            if (rows.size() > 1) {
                Iterator rowIter = rows.iterator();
                int expectedNumColumns = ((ArrayList)rowIter.next()).size();
                while (rowIter.hasNext()) {
                    int numColumns = ((ArrayList)rowIter.next()).size();
                    if (numColumns == expectedNumColumns) continue;
                    throw new IllegalStateException("all rows in expected values must have the same number of columns");
                }
            }
            this.expected = rows;
        }

        private void testValues() {
            if (this.expected.size() != this.result.size()) {
                this.dumpData("Expected " + this.expected.size() + " rows, got " + this.result.size());
            }
            Iterator<List<Object>> expectedIter = this.expected.iterator();
            Iterator<List<Object>> resultIter = this.result.iterator();
            int rowNum = 1;
            while (expectedIter.hasNext() && resultIter.hasNext()) {
                List<Object> expectedRow = expectedIter.next();
                List<Object> resultRow = resultIter.next();
                this.testValues(expectedRow, resultRow, rowNum++);
            }
        }

        private void testValues(List<Object> expectedRow, List<Object> resultRow, int rowNum) {
            if (expectedRow.size() != resultRow.size()) {
                this.dumpData("Row " + rowNum + " Expected " + this.expected.size() + " columns, got " + this.result.size());
            }
            Iterator<Object> expectedIter = expectedRow.iterator();
            Iterator<Object> resultIter = resultRow.iterator();
            int colNum = 1;
            while (expectedIter.hasNext() && resultIter.hasNext()) {
                Object expectedValue = expectedIter.next();
                Object resultValue = resultIter.next();
                if (expectedValue == null || expectedValue instanceof String || expectedValue instanceof Boolean) {
                    this.test(expectedValue, resultValue, rowNum, colNum);
                } else if (expectedValue instanceof BigInteger) {
                    BigInteger expectedInt = (BigInteger)expectedValue;
                    if (expectedInt.bitLength() <= 31) {
                        this.test(expectedInt.intValue(), ((Number)resultValue).intValue(), rowNum, colNum);
                    } else if (expectedInt.bitLength() <= 63) {
                        this.test(expectedInt.longValue(), ((Number)resultValue).longValue(), rowNum, colNum);
                    } else {
                        this.test(expectedInt, resultValue, rowNum, colNum);
                    }
                } else if (expectedValue instanceof BigDecimal) {
                    BigDecimal expectedReal = (BigDecimal)expectedValue;
                    float asFloat = expectedReal.floatValue();
                    double asDouble = expectedReal.doubleValue();
                    if (asFloat != Float.POSITIVE_INFINITY && asFloat != Float.NEGATIVE_INFINITY) {
                        this.test(asFloat, ((Number)resultValue).floatValue(), rowNum, colNum);
                    } else if (asDouble != Double.POSITIVE_INFINITY && asDouble != Double.NEGATIVE_INFINITY) {
                        this.test(asDouble, ((Number)resultValue).doubleValue(), rowNum, colNum);
                    } else {
                        this.test(expectedReal, resultValue, rowNum, colNum);
                    }
                } else {
                    throw new IllegalStateException("unknown type of expected value: " + expectedValue.getClass().getName());
                }
                ++colNum;
            }
        }

        private void test(Object expected, Object got, int rowNum, int colNum) {
            if (expected == null && got == null) {
                return;
            }
            if (expected == null || !expected.equals(got)) {
                this.reportError(String.valueOf(expected), String.valueOf(got), rowNum, colNum);
            }
        }

        private void test(int expected, int got, int rowNum, int colNum) {
            if (expected != got) {
                this.reportError(String.valueOf(expected), String.valueOf(got), rowNum, colNum);
            }
        }

        private void test(long expected, long got, int rowNum, int colNum) {
            if (expected != got) {
                this.reportError(String.valueOf(expected), String.valueOf(got), rowNum, colNum);
            }
        }

        private void test(float expected, float got, int rowNum, int colNum) {
            if (expected != got) {
                this.reportError(String.valueOf(expected), String.valueOf(got), rowNum, colNum);
            }
        }

        private void test(double expected, double got, int rowNum, int colNum) {
            if (expected != got) {
                this.reportError(String.valueOf(expected), String.valueOf(got), rowNum, colNum);
            }
        }

        private void reportError(String expected, String got, int rowNum, int colNum) {
            this.dumpData("Row " + rowNum + ", column " + colNum + ": expected <" + expected + ">, got <" + got + ">");
        }

        private void dumpData(String message) {
            Iterator<List<Object>> expectedIter = this.expected.iterator();
            Iterator<List<Object>> resultIter = this.result.iterator();
            StringBuilder fullMessage = new StringBuilder(message);
            int rowNum = 1;
            while (expectedIter.hasNext() || resultIter.hasNext()) {
                StringBuilder expectedOut = new StringBuilder();
                expectedOut.append("Row ").append(rowNum).append(" exp:");
                StringBuilder resultOut = new StringBuilder();
                resultOut.append("Row ").append(rowNum).append(" got:");
                Iterator<Object> expectedRowIter = null;
                if (expectedIter.hasNext()) {
                    List<Object> expectedRow = expectedIter.next();
                    expectedRowIter = expectedRow.iterator();
                }
                Iterator<Object> resultRowIter = null;
                if (resultIter.hasNext()) {
                    List<Object> resultRow = resultIter.next();
                    resultRowIter = resultRow.iterator();
                }
                while (expectedRowIter != null && expectedRowIter.hasNext() || resultRowIter != null && resultRowIter.hasNext()) {
                    int i;
                    Object expectedObject = expectedRowIter != null ? expectedRowIter.next() : "";
                    Object resultObject = resultRowIter != null ? resultRowIter.next() : "";
                    String expectedValue = expectedObject == null ? "<null>" : expectedObject.toString();
                    String resultValue = resultObject == null ? "<null>" : resultObject.toString();
                    int width = Math.max(expectedValue.length(), resultValue.length());
                    expectedOut.append(" | ").append(expectedValue);
                    for (i = 0; i < width - expectedValue.length(); ++i) {
                        expectedOut.append(' ');
                    }
                    resultOut.append(" | ").append(resultValue);
                    for (i = 0; i < width - resultValue.length(); ++i) {
                        resultOut.append(' ');
                    }
                }
                if (expectedRowIter == null && resultRowIter == null) {
                    expectedOut.append('|');
                    resultOut.append('|');
                }
                expectedOut.append(" |");
                resultOut.append(" |");
                fullMessage.append('\n').append(expectedOut.toString()).append('\n').append(resultOut.toString());
                ++rowNum;
            }
            throw new RuntimeException(fullMessage.toString());
        }
    }

    private static abstract class CommandWithTimeout
    extends AbstractCommand {
        private int timeout;

        private CommandWithTimeout(int timeout) {
            this.timeout = timeout;
        }

        protected boolean setTimeout(Statement stmt) throws SQLException {
            assert (this.timeout >= 0);
            if (this.timeout > 0) {
                stmt.setQueryTimeout(this.timeout);
                return true;
            }
            return false;
        }
    }

    private static class CloseCommand
    extends AbstractCommand {
        private CloseCommand() {
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            Statement stmt = executor.getStatement();
            if (stmt != null) {
                stmt.close();
            }
            executor.clearStatement();
        }
    }

    private static class PrepareCommand
    extends AbstractCommand {
        private String sql;

        private PrepareCommand(String sql) {
            this.sql = sql;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            PreparedStatement stmt = executor.getConnection().prepareStatement(this.sql);
            executor.setStatement(stmt);
        }
    }

    private static class ExplainCommand
    extends AbstractCommand {
        private String sql;

        private ExplainCommand(String sql) {
            this.sql = sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            Statement stmt = executor.getConnection().createStatement();
            try {
                ResultSet rset = stmt.executeQuery(this.sql);
                try {
                    int rowCount = 0;
                    while (rset.next()) {
                        ++rowCount;
                    }
                    assert (rowCount > 0);
                }
                finally {
                    rset.close();
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    private static class SleepCommand
    extends AbstractCommand {
        private long millis;

        private SleepCommand(long millis) {
            this.millis = millis;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws Exception {
            Thread.sleep(this.millis);
        }
    }

    static class AutoSynchronizationCommand
    extends SynchronizationCommand {
        private AutoSynchronizationCommand() {
        }
    }

    static class SynchronizationCommand
    extends AbstractCommand {
        private SynchronizationCommand() {
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws Exception {
            executor.getSynchronizer().waitForOthers();
        }
    }

    protected static abstract class AbstractCommand
    implements ConcurrentTestCommand {
        private boolean shouldFail = false;
        private String failComment = null;
        private Pattern failPattern = null;
        private boolean failureExpected = false;

        protected AbstractCommand() {
        }

        public ConcurrentTestCommand markToFail(String comment, String pattern) {
            this.shouldFail = true;
            this.failComment = comment;
            this.failPattern = Pattern.compile(pattern);
            return this;
        }

        public boolean isFailureExpected() {
            return this.failureExpected;
        }

        public ConcurrentTestCommand markToFail() {
            this.failureExpected = true;
            return this;
        }

        protected abstract void doExecute(ConcurrentTestCommandExecutor var1) throws Exception;

        public void execute(ConcurrentTestCommandExecutor exec) throws Exception {
            try {
                this.doExecute(exec);
                if (this.shouldFail) {
                    throw new ConcurrentTestCommand.ShouldHaveFailedException(this.failComment);
                }
            }
            catch (SQLException err) {
                if (!this.shouldFail) {
                    throw err;
                }
                boolean matches = false;
                if (this.failPattern == null) {
                    matches = true;
                } else {
                    for (SQLException err2 = err; err2 != null; err2 = err2.getNextException()) {
                        String msg = err2.getMessage();
                        if (msg != null) {
                            matches = this.failPattern.matcher(msg).find();
                        }
                        if (matches) break;
                    }
                }
                if (!matches) {
                    throw err;
                }
                Util.swallow((Throwable)err, null);
            }
        }
    }

    public static class FailedThread {
        public final String name;
        public final String location;
        public final Throwable failure;

        public FailedThread(String name, String location, Throwable failure) {
            this.name = name;
            this.location = location;
            this.failure = failure;
        }
    }
}

