/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.logging.Logger;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import net.hydromatic.optiq.config.Lex;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.test.SqlValidatorTestCase;
import org.eigenbase.util.Bug;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SqlValidatorTest
extends SqlValidatorTestCase {
    protected static final boolean TODO = false;
    public static final boolean TODO_TYPE_INFERENCE = false;
    private static final String ANY = "(?s).*";
    protected static final Logger LOGGER = Logger.getLogger(SqlValidatorTest.class.getName());
    private static final String ERR_IN_VALUES_INCOMPATIBLE = "Values in expression list must have compatible types";
    private static final String ERR_IN_OPERANDS_INCOMPATIBLE = "Values passed to IN operator must have compatible types";
    private static final String ERR_AGG_IN_GROUP_BY = "Aggregate expression is illegal in GROUP BY clause";
    private static final String ERR_AGG_IN_ORDER_BY = "Aggregate expression is illegal in ORDER BY clause of non-aggregating SELECT";
    private static final String ERR_NESTED_AGG = "Aggregate expressions cannot be nested";
    private static final String EMP_RECORD_TYPE = "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER NOT NULL MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER) NOT NULL";

    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testMultipleSameAsPass() {
        this.check("select 1 as again,2 as \"again\", 3 as AGAiN from (values (true))");
    }

    @Test
    public void testMultipleDifferentAs() {
        this.check("select 1 as c1,2 as c2 from (values(true))");
    }

    @Test
    public void testTypeOfAs() {
        this.checkColumnType("select 1 as c1 from (values (true))", "INTEGER NOT NULL");
        this.checkColumnType("select 'hej' as c1 from (values (true))", "CHAR(3) NOT NULL");
        this.checkColumnType("select x'deadbeef' as c1 from (values (true))", "BINARY(4) NOT NULL");
        this.checkColumnType("select cast(null as boolean) as c1 from (values (true))", "BOOLEAN");
    }

    @Test
    public void testTypesLiterals() {
        this.checkExpType("'abc'", "CHAR(3) NOT NULL");
        this.checkExpType("n'abc'", "CHAR(3) NOT NULL");
        this.checkExpType("_UTF16'abc'", "CHAR(3) NOT NULL");
        this.checkExpType("'ab '\n' cd'", "CHAR(6) NOT NULL");
        this.checkExpType("'ab'\n'cd'\n'ef'\n'gh'\n'ij'\n'kl'", "CHAR(12) NOT NULL");
        this.checkExpType("n'ab '\n' cd'", "CHAR(6) NOT NULL");
        this.checkExpType("_UTF16'ab '\n' cd'", "CHAR(6) NOT NULL");
        this.checkExpFails("^x'abc'^", "Binary literal string must contain an even number of hexits");
        this.checkExpType("x'abcd'", "BINARY(2) NOT NULL");
        this.checkExpType("x'abcd'\n'ff001122aabb'", "BINARY(8) NOT NULL");
        this.checkExpType("x'aaaa'\n'bbbb'\n'0000'\n'1111'", "BINARY(8) NOT NULL");
        this.checkExpType("1234567890", "INTEGER NOT NULL");
        this.checkExpType("123456.7890", "DECIMAL(10, 4) NOT NULL");
        this.checkExpType("123456.7890e3", "DOUBLE NOT NULL");
        this.checkExpType("true", "BOOLEAN NOT NULL");
        this.checkExpType("false", "BOOLEAN NOT NULL");
        this.checkExpType("unknown", "BOOLEAN");
    }

    @Test
    public void testBooleans() {
        this.check("select TRUE OR unknowN from (values(true))");
        this.check("select false AND unknown from (values(true))");
        this.check("select not UNKNOWn from (values(true))");
        this.check("select not true from (values(true))");
        this.check("select not false from (values(true))");
    }

    @Test
    public void testAndOrIllegalTypesFails() {
        this.checkWholeExpFails("'abc' AND FaLsE", "(?s).*'<CHAR.3.> AND <BOOLEAN>'.*");
        this.checkWholeExpFails("TRUE OR 1", ANY);
        this.checkWholeExpFails("unknown OR 1.0", ANY);
        this.checkWholeExpFails("true OR 1.0e4", ANY);
    }

    @Test
    public void testNotIllegalTypeFails() {
        this.assertExceptionIsThrown("select ^NOT 3.141^ from (values(true))", "(?s).*Cannot apply 'NOT' to arguments of type 'NOT<DECIMAL.4, 3.>'.*");
        this.assertExceptionIsThrown("select ^NOT 'abc'^ from (values(true))", ANY);
        this.assertExceptionIsThrown("select ^NOT 1^ from (values(true))", ANY);
    }

    @Test
    public void testIs() {
        this.check("select TRUE IS FALSE FROM (values(true))");
        this.check("select false IS NULL FROM (values(true))");
        this.check("select UNKNOWN IS NULL FROM (values(true))");
        this.check("select FALSE IS UNKNOWN FROM (values(true))");
        this.check("select TRUE IS NOT FALSE FROM (values(true))");
        this.check("select TRUE IS NOT NULL FROM (values(true))");
        this.check("select false IS NOT NULL FROM (values(true))");
        this.check("select UNKNOWN IS NOT NULL FROM (values(true))");
        this.check("select FALSE IS NOT UNKNOWN FROM (values(true))");
        this.check("select 1 IS NULL FROM (values(true))");
        this.check("select 1.2 IS NULL FROM (values(true))");
        this.checkExpFails("^'abc' IS NOT UNKNOWN^", "(?s).*Cannot apply.*");
    }

    @Test
    public void testIsFails() {
        this.assertExceptionIsThrown("select ^1 IS TRUE^ FROM (values(true))", "(?s).*'<INTEGER> IS TRUE'.*");
        this.assertExceptionIsThrown("select ^1.1 IS NOT FALSE^ FROM (values(true))", ANY);
        this.assertExceptionIsThrown("select ^1.1e1 IS NOT FALSE^ FROM (values(true))", "(?s).*Cannot apply 'IS NOT FALSE' to arguments of type '<DOUBLE> IS NOT FALSE'.*");
        this.assertExceptionIsThrown("select ^'abc' IS NOT TRUE^ FROM (values(true))", ANY);
    }

    @Test
    public void testScalars() {
        this.check("select 1  + 1 from (values(true))");
        this.check("select 1  + 2.3 from (values(true))");
        this.check("select 1.2+3 from (values(true))");
        this.check("select 1.2+3.4 from (values(true))");
        this.check("select 1  - 1 from (values(true))");
        this.check("select 1  - 2.3 from (values(true))");
        this.check("select 1.2-3 from (values(true))");
        this.check("select 1.2-3.4 from (values(true))");
        this.check("select 1  * 2 from (values(true))");
        this.check("select 1.2* 3 from (values(true))");
        this.check("select 1  * 2.3 from (values(true))");
        this.check("select 1.2* 3.4 from (values(true))");
        this.check("select 1  / 2 from (values(true))");
        this.check("select 1  / 2.3 from (values(true))");
        this.check("select 1.2/ 3 from (values(true))");
        this.check("select 1.2/3.4 from (values(true))");
    }

    @Test
    public void testScalarsFails() {
        this.assertExceptionIsThrown("select ^1+TRUE^ from (values(true))", "(?s).*Cannot apply '\\+' to arguments of type '<INTEGER> \\+ <BOOLEAN>'\\. Supported form\\(s\\):.*");
    }

    @Test
    public void testNumbers() {
        this.check("select 1+-2.*-3.e-1/-4>+5 AND true from (values(true))");
    }

    @Test
    public void testPrefix() {
        this.checkExpType("+interval '1' second", "INTERVAL SECOND NOT NULL");
        this.checkExpType("-interval '1' month", "INTERVAL MONTH NOT NULL");
        this.checkFails("SELECT ^-'abc'^ from (values(true))", "(?s).*Cannot apply '-' to arguments of type '-<CHAR.3.>'.*");
        this.checkFails("SELECT ^+'abc'^ from (values(true))", "(?s).*Cannot apply '\\+' to arguments of type '\\+<CHAR.3.>'.*");
    }

    @Test
    public void testEqualNotEqual() {
        this.checkExp("''=''");
        this.checkExp("'abc'=n''");
        this.checkExp("''=_latin1''");
        this.checkExp("n''=''");
        this.checkExp("n'abc'=n''");
        this.checkExp("n''=_latin1''");
        this.checkExp("_latin1''=''");
        this.checkExp("_latin1''=n''");
        this.checkExp("_latin1''=_latin1''");
        this.checkExp("''<>''");
        this.checkExp("'abc'<>n''");
        this.checkExp("''<>_latin1''");
        this.checkExp("n''<>''");
        this.checkExp("n'abc'<>n''");
        this.checkExp("n''<>_latin1''");
        this.checkExp("_latin1''<>''");
        this.checkExp("_latin1'abc'<>n''");
        this.checkExp("_latin1''<>_latin1''");
        this.checkExp("true=false");
        this.checkExp("unknown<>true");
        this.checkExp("1=1");
        this.checkExp("1=.1");
        this.checkExp("1=1e-1");
        this.checkExp("0.1=1");
        this.checkExp("0.1=0.1");
        this.checkExp("0.1=1e1");
        this.checkExp("1.1e1=1");
        this.checkExp("1.1e1=1.1");
        this.checkExp("1.1e-1=1e1");
        this.checkExp("''<>''");
        this.checkExp("1<>1");
        this.checkExp("1<>.1");
        this.checkExp("1<>1e-1");
        this.checkExp("0.1<>1");
        this.checkExp("0.1<>0.1");
        this.checkExp("0.1<>1e1");
        this.checkExp("1.1e1<>1");
        this.checkExp("1.1e1<>1.1");
        this.checkExp("1.1e-1<>1e1");
    }

    @Test
    public void testEqualNotEqualFails() {
        this.checkExpFails("^''<>1^", "(?s).*Cannot apply '<>' to arguments of type '<CHAR.0.> <> <INTEGER>'.*");
        this.checkExpFails("^'1'>=1^", "(?s).*Cannot apply '>=' to arguments of type '<CHAR.1.> >= <INTEGER>'.*");
        this.checkExpFails("^1<>n'abc'^", "(?s).*Cannot apply '<>' to arguments of type '<INTEGER> <> <CHAR.3.>'.*");
        this.checkExpFails("^''=.1^", "(?s).*Cannot apply '=' to arguments of type '<CHAR.0.> = <DECIMAL.1..1.>'.*");
        this.checkExpFails("^true<>1e-1^", "(?s).*Cannot apply '<>' to arguments of type '<BOOLEAN> <> <DOUBLE>'.*");
        this.checkExpFails("^false=''^", "(?s).*Cannot apply '=' to arguments of type '<BOOLEAN> = <CHAR.0.>'.*");
        this.checkExpFails("^x'a4'=0.01^", "(?s).*Cannot apply '=' to arguments of type '<BINARY.1.> = <DECIMAL.3, 2.>'.*");
        this.checkExpFails("^x'a4'=1^", "(?s).*Cannot apply '=' to arguments of type '<BINARY.1.> = <INTEGER>'.*");
        this.checkExpFails("^x'13'<>0.01^", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.1.> <> <DECIMAL.3, 2.>'.*");
        this.checkExpFails("^x'abcd'<>1^", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.2.> <> <INTEGER>'.*");
    }

    @Test
    public void testBinaryString() {
        this.check("select x'face'=X'' from (values(true))");
        this.check("select x'ff'=X'' from (values(true))");
    }

    @Test
    public void testBinaryStringFails() {
        this.assertExceptionIsThrown("select ^x'ffee'='abc'^ from (values(true))", "(?s).*Cannot apply '=' to arguments of type '<BINARY.2.> = <CHAR.3.>'.*");
        this.assertExceptionIsThrown("select ^x'ff'=88^ from (values(true))", "(?s).*Cannot apply '=' to arguments of type '<BINARY.1.> = <INTEGER>'.*");
        this.assertExceptionIsThrown("select ^x''<>1.1e-1^ from (values(true))", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.0.> <> <DOUBLE>'.*");
        this.assertExceptionIsThrown("select ^x''<>1.1^ from (values(true))", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.0.> <> <DECIMAL.2, 1.>'.*");
    }

    @Test
    public void testStringLiteral() {
        this.check("select n''=_iso-8859-1'abc' from (values(true))");
        this.check("select N'f'<>'''' from (values(true))");
    }

    @Test
    public void testStringLiteralBroken() {
        this.check("select 'foo'\n'bar' from (values(true))");
        this.check("select 'foo'\r'bar' from (values(true))");
        this.check("select 'foo'\n\r'bar' from (values(true))");
        this.check("select 'foo'\r\n'bar' from (values(true))");
        this.check("select 'foo'\n'bar' from (values(true))");
        this.checkFails("select 'foo' /* comment */ ^'bar'^ from (values(true))", "String literal continued on same line");
        this.check("select 'foo' -- comment\r from (values(true))");
        this.checkFails("select 'foo' ^'bar'^ from (values(true))", "String literal continued on same line");
    }

    @Test
    public void testArithmeticOperators() {
        this.checkExp("power(2,3)");
        this.checkExp("aBs(-2.3e-2)");
        this.checkExp("MOD(5             ,\t\f\r\n2)");
        this.checkExp("ln(5.43  )");
        this.checkExp("log10(- -.2  )");
        this.checkExp("mod(5.1, 3)");
        this.checkExp("mod(2,5.1)");
        this.checkExp("exp(3.67)");
    }

    @Test
    public void testArithmeticOperatorsFails() {
        this.checkExpFails("^power(2,'abc')^", "(?s).*Cannot apply 'POWER' to arguments of type 'POWER.<INTEGER>, <CHAR.3.>.*");
        this.checkExpFails("^power(true,1)^", "(?s).*Cannot apply 'POWER' to arguments of type 'POWER.<BOOLEAN>, <INTEGER>.*");
        this.checkExpFails("^mod(x'1100',1)^", "(?s).*Cannot apply 'MOD' to arguments of type 'MOD.<BINARY.2.>, <INTEGER>.*");
        this.checkExpFails("^mod(1, x'1100')^", "(?s).*Cannot apply 'MOD' to arguments of type 'MOD.<INTEGER>, <BINARY.2.>.*");
        this.checkExpFails("^abs(x'')^", "(?s).*Cannot apply 'ABS' to arguments of type 'ABS.<BINARY.0.>.*");
        this.checkExpFails("^ln(x'face12')^", "(?s).*Cannot apply 'LN' to arguments of type 'LN.<BINARY.3.>.*");
        this.checkExpFails("^log10(x'fa')^", "(?s).*Cannot apply 'LOG10' to arguments of type 'LOG10.<BINARY.1.>.*");
        this.checkExpFails("^exp('abc')^", "(?s).*Cannot apply 'EXP' to arguments of type 'EXP.<CHAR.3.>.*");
    }

    @Test
    public void testCaseExpression() {
        this.checkExp("case 1 when 1 then 'one' end");
        this.checkExp("case 1 when 1 then 'one' else null end");
        this.checkExp("case 1 when 1 then 'one' else 'more' end");
        this.checkExp("case 1 when 1 then 'one' when 2 then null else 'more' end");
        this.checkExp("case when TRUE then 'true' else 'false' end");
        this.check("values case when TRUE then 'true' else 'false' end");
        this.checkExp("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN null END");
        this.checkExp("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(null as integer) END");
        this.checkExp("CASE 1 WHEN 1 THEN null WHEN 2 THEN cast(null as integer) END");
        this.checkExp("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(cast(null as tinyint) as integer) END");
    }

    @Test
    public void testCaseExpressionTypes() {
        this.checkExpType("case 1 when 1 then 'one' else 'not one' end", "CHAR(7) NOT NULL");
        this.checkExpType("case when 2<1 then 'impossible' end", "CHAR(10)");
        this.checkExpType("case 'one' when 'two' then 2.00 when 'one' then 1.3 else 3.2 end", "DECIMAL(3, 2) NOT NULL");
        this.checkExpType("case 'one' when 'two' then 2 when 'one' then 1.00 else 3 end", "DECIMAL(12, 2) NOT NULL");
        this.checkExpType("case 1 when 1 then 'one' when 2 then null else 'more' end", "CHAR(4)");
        this.checkExpType("case when TRUE then 'true' else 'false' end", "CHAR(5) NOT NULL");
        this.checkExpType("CASE 1 WHEN 1 THEN cast(null as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN NULL WHEN 2 THEN cast(cast(null as tinyint) as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(null as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(cast(null as tinyint) as integer) END", "INTEGER");
    }

    @Test
    public void testCaseExpressionFails() {
        this.checkWholeExpFails("case 'string' when x'01' then 'zero one' else 'something' end", "(?s).*Cannot apply '=' to arguments of type '<CHAR.6.> = <BINARY.1.>'.*");
        this.checkWholeExpFails("case 1 when 1 then null else null end", "(?s).*ELSE clause or at least one THEN clause must be non-NULL.*");
        this.checkWholeExpFails("case 1 when 1 then null end", "(?s).*ELSE clause or at least one THEN clause must be non-NULL.*");
        this.checkWholeExpFails("case when true and true then 1 when false then 2 when false then true else case when true then 3 end end", "Illegal mixing of types in CASE or COALESCE statement");
    }

    @Test
    public void testNullIf() {
        this.checkExp("nullif(1,2)");
        this.checkExpType("nullif(1,2)", "INTEGER");
        this.checkExpType("nullif('a','b')", "CHAR(1)");
        this.checkExpType("nullif(345.21, 2)", "DECIMAL(5, 2)");
        this.checkExpType("nullif(345.21, 2e0)", "DECIMAL(5, 2)");
        this.checkWholeExpFails("nullif(1,2,3)", "Invalid number of arguments to function 'NULLIF'. Was expecting 2 arguments");
    }

    @Test
    public void testCoalesce() {
        this.checkExp("coalesce('a','b')");
        this.checkExpType("coalesce('a','b','c')", "CHAR(1) NOT NULL");
    }

    @Test
    public void testCoalesceFails() {
        this.checkWholeExpFails("coalesce('a',1)", "Illegal mixing of types in CASE or COALESCE statement");
        this.checkWholeExpFails("coalesce('a','b',1)", "Illegal mixing of types in CASE or COALESCE statement");
    }

    @Test
    public void testStringCompare() {
        this.checkExp("'a' = 'b'");
        this.checkExp("'a' <> 'b'");
        this.checkExp("'a' > 'b'");
        this.checkExp("'a' < 'b'");
        this.checkExp("'a' >= 'b'");
        this.checkExp("'a' <= 'b'");
        this.checkExp("cast('' as varchar(1))>cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))<cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))>=cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))<=cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))=cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))<>cast('' as char(1))");
    }

    @Test
    public void testStringCompareType() {
        this.checkExpType("'a' = 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' <> 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' > 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' < 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' >= 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' <= 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("CAST(NULL AS VARCHAR(33)) > 'foo'", "BOOLEAN");
    }

    @Test
    public void testConcat() {
        this.checkExp("'a'||'b'");
        this.checkExp("x'12'||x'34'");
        this.checkExpType("'a'||'b'", "CHAR(2) NOT NULL");
        this.checkExpType("cast('a' as char(1))||cast('b' as char(2))", "CHAR(3) NOT NULL");
        this.checkExpType("cast(null as char(1))||cast('b' as char(2))", "CHAR(3)");
        this.checkExpType("'a'||'b'||'c'", "CHAR(3) NOT NULL");
        this.checkExpType("'a'||'b'||'cde'||'f'", "CHAR(6) NOT NULL");
        this.checkExpType("'a'||'b'||cast('cde' as VARCHAR(3))|| 'f'", "VARCHAR(6) NOT NULL");
        this.checkExp("_UTF16'a'||_UTF16'b'||_UTF16'c'");
    }

    @Test
    public void testConcatWithCharset() {
        this.checkCharset("_UTF16'a'||_UTF16'b'||_UTF16'c'", Charset.forName("UTF-16LE"));
    }

    @Test
    public void testConcatFails() {
        this.checkWholeExpFails("'a'||x'ff'", "(?s).*Cannot apply '\\|\\|' to arguments of type '<CHAR.1.> \\|\\| <BINARY.1.>'.*Supported form.s.: '<STRING> \\|\\| <STRING>.*'");
    }

    @Test
    public void testBetween() {
        this.checkExp("1 between 2 and 3");
        this.checkExp("'a' between 'b' and 'c'");
        this.checkWholeExpFails("'' between 2 and 3", "(?s).*Cannot apply 'BETWEEN' to arguments of type.*");
    }

    @Test
    public void testCharsetMismatch() {
        this.checkWholeExpFails("''=_UTF16''", "Cannot apply .* to the two different charsets ISO-8859-1 and UTF-16LE");
        this.checkWholeExpFails("''<>_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''>_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''<_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''<=_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''>=_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''||_UTF16''", ANY);
        this.checkWholeExpFails("'a'||'b'||_UTF16'c'", ANY);
    }

    public void _testSimpleCollate() {
        this.checkExp("'s' collate latin1$en$1");
        this.checkExpType("'s' collate latin1$en$1", "CHAR(1)");
        this.checkCollation("'s'", "ISO-8859-1$en_US$primary", SqlCollation.Coercibility.COERCIBLE);
        this.checkCollation("'s' collate latin1$sv$3", "ISO-8859-1$sv$3", SqlCollation.Coercibility.EXPLICIT);
    }

    public void _testCharsetAndCollateMismatch() {
        this.checkExpFails("_UTF16's' collate latin1$en$1", "?");
    }

    public void _testDyadicCollateCompare() {
        this.checkExp("'s' collate latin1$en$1 < 't'");
        this.checkExp("'t' > 's' collate latin1$en$1");
        this.checkExp("'s' collate latin1$en$1 <> 't' collate latin1$en$1");
    }

    public void _testDyadicCompareCollateFails() {
        this.checkExpFails("'s' collate latin1$en$1 <= 't' collate latin1$en$2", "(?s).*Two explicit different collations.*are illegal.*");
        this.checkExpFails("'s' collate latin1$sv$1 >= 't' collate latin1$en$1", "(?s).*Two explicit different collations.*are illegal.*");
    }

    public void _testDyadicCollateOperator() {
        this.checkCollation("'a' || 'b'", "ISO-8859-1$en_US$primary", SqlCollation.Coercibility.COERCIBLE);
        this.checkCollation("'a' collate latin1$sv$3 || 'b'", "ISO-8859-1$sv$3", SqlCollation.Coercibility.EXPLICIT);
        this.checkCollation("'a' collate latin1$sv$3 || 'b' collate latin1$sv$3", "ISO-8859-1$sv$3", SqlCollation.Coercibility.EXPLICIT);
    }

    @Test
    public void testCharLength() {
        this.checkExp("char_length('string')");
        this.checkExp("char_length(_UTF16'string')");
        this.checkExp("character_length('string')");
        this.checkExpType("char_length('string')", "INTEGER NOT NULL");
        this.checkExpType("character_length('string')", "INTEGER NOT NULL");
    }

    @Test
    public void testUpperLower() {
        this.checkExp("upper(_UTF16'sadf')");
        this.checkExp("lower(n'sadf')");
        this.checkExpType("lower('sadf')", "CHAR(4) NOT NULL");
        this.checkWholeExpFails("upper(123)", "(?s).*Cannot apply 'UPPER' to arguments of type 'UPPER.<INTEGER>.'.*");
    }

    @Test
    public void testPosition() {
        this.checkExp("position('mouse' in 'house')");
        this.checkExp("position(x'11' in x'100110')");
        this.checkExp("position(x'abcd' in x'')");
        this.checkExpType("position('mouse' in 'house')", "INTEGER NOT NULL");
        this.checkWholeExpFails("position(x'1234' in '110')", "Parameters must be of the same type");
    }

    @Test
    public void testTrim() {
        this.checkExp("trim('mustache' FROM 'beard')");
        this.checkExp("trim(both 'mustache' FROM 'beard')");
        this.checkExp("trim(leading 'mustache' FROM 'beard')");
        this.checkExp("trim(trailing 'mustache' FROM 'beard')");
        this.checkExpType("trim('mustache' FROM 'beard')", "VARCHAR(5) NOT NULL");
        this.checkExpType("trim('beard  ')", "VARCHAR(7) NOT NULL");
        this.checkExpType("trim('mustache' FROM cast(null as varchar(4)))", "VARCHAR(4)");
    }

    @Test
    public void testTrimFails() {
        this.checkWholeExpFails("trim(123 FROM 'beard')", "(?s).*Cannot apply 'TRIM' to arguments of type.*");
        this.checkWholeExpFails("trim('a' FROM 123)", "(?s).*Cannot apply 'TRIM' to arguments of type.*");
        this.checkWholeExpFails("trim('a' FROM _UTF16'b')", "(?s).*not comparable to each other.*");
    }

    public void _testConvertAndTranslate() {
        this.checkExp("convert('abc' using conversion)");
        this.checkExp("translate('abc' using translation)");
    }

    @Test
    public void testOverlay() {
        this.checkExp("overlay('ABCdef' placing 'abc' from 1)");
        this.checkExp("overlay('ABCdef' placing 'abc' from 1 for 3)");
        this.checkWholeExpFails("overlay('ABCdef' placing 'abc' from '1' for 3)", "(?s).*OVERLAY\\(<STRING> PLACING <STRING> FROM <INTEGER>\\).*");
        this.checkExpType("overlay('ABCdef' placing 'abc' from 1 for 3)", "VARCHAR(9) NOT NULL");
        this.checkExpType("overlay('ABCdef' placing 'abc' from 6 for 3)", "VARCHAR(9) NOT NULL");
        this.checkExpType("overlay('ABCdef' placing cast(null as char(5)) from 1)", "VARCHAR(11)");
    }

    @Test
    public void testSubstring() {
        this.checkExp("substring('a' FROM 1)");
        this.checkExp("substring('a' FROM 1 FOR 3)");
        this.checkExp("substring('a' FROM 'reg' FOR '\\')");
        this.checkExp("substring(x'ff' FROM 1  FOR 2)");
        this.checkExpType("substring('10' FROM 1  FOR 2)", "VARCHAR(2) NOT NULL");
        this.checkExpType("substring('1000' FROM 2)", "VARCHAR(4) NOT NULL");
        this.checkExpType("substring('1000' FROM '1'  FOR 'w')", "VARCHAR(4) NOT NULL");
        this.checkExpType("substring(cast(' 100 ' as CHAR(99)) FROM '1'  FOR 'w')", "VARCHAR(99) NOT NULL");
        this.checkExpType("substring(x'10456b' FROM 1  FOR 2)", "VARBINARY(3) NOT NULL");
        this.checkCharset("substring('10' FROM 1  FOR 2)", Charset.forName("latin1"));
        this.checkCharset("substring(_UTF16'10' FROM 1  FOR 2)", Charset.forName("UTF-16LE"));
    }

    @Test
    public void testSubstringFails() {
        this.checkWholeExpFails("substring('a' from 1 for 'b')", "(?s).*Cannot apply 'SUBSTRING' to arguments of type.*");
        this.checkWholeExpFails("substring(_UTF16'10' FROM '0' FOR '\\')", "(?s).* not comparable to each other.*");
        this.checkWholeExpFails("substring('10' FROM _UTF16'0' FOR '\\')", "(?s).* not comparable to each other.*");
        this.checkWholeExpFails("substring('10' FROM '0' FOR _UTF16'\\')", "(?s).* not comparable to each other.*");
    }

    @Test
    public void testLikeAndSimilar() {
        this.checkExp("'a' like 'b'");
        this.checkExp("'a' like 'b'");
        this.checkExp("'a' similar to 'b'");
        this.checkExp("'a' similar to 'b' escape 'c'");
    }

    public void _testLikeAndSimilarFails() {
        this.checkExpFails("'a' like _UTF16'b'  escape 'c'", "(?s).*Operands _ISO-8859-1.a. COLLATE ISO-8859-1.en_US.primary, _SHIFT_JIS.b..*");
        this.checkExpFails("'a' similar to _UTF16'b'  escape 'c'", "(?s).*Operands _ISO-8859-1.a. COLLATE ISO-8859-1.en_US.primary, _SHIFT_JIS.b..*");
        this.checkExpFails("'a' similar to 'b' collate UTF16$jp  escape 'c'", "(?s).*Operands _ISO-8859-1.a. COLLATE ISO-8859-1.en_US.primary, _ISO-8859-1.b. COLLATE SHIFT_JIS.jp.primary.*");
    }

    @Test
    public void testNull() {
        this.checkFails("values 1.0 + ^NULL^", "(?s).*Illegal use of .NULL.*");
        this.checkExpFails("1.0 + ^NULL^", "(?s).*Illegal use of .NULL.*");
        this.checkExp("1 in (1, null, 2)");
        this.checkExp("1 in (null, 1, null, 2)");
        this.checkExp("1 in (cast(null as integer), null)");
        this.checkWholeExpFails("1 in (null, null)", ERR_IN_OPERANDS_INCOMPATIBLE);
    }

    @Test
    public void testNullCast() {
        this.checkExpType("cast(null as tinyint)", "TINYINT");
        this.checkExpType("cast(null as smallint)", "SMALLINT");
        this.checkExpType("cast(null as integer)", "INTEGER");
        this.checkExpType("cast(null as bigint)", "BIGINT");
        this.checkExpType("cast(null as float)", "FLOAT");
        this.checkExpType("cast(null as real)", "REAL");
        this.checkExpType("cast(null as double)", "DOUBLE");
        this.checkExpType("cast(null as boolean)", "BOOLEAN");
        this.checkExpType("cast(null as varchar(1))", "VARCHAR(1)");
        this.checkExpType("cast(null as char(1))", "CHAR(1)");
        this.checkExpType("cast(null as binary(1))", "BINARY(1)");
        this.checkExpType("cast(null as date)", "DATE");
        this.checkExpType("cast(null as time)", "TIME(0)");
        this.checkExpType("cast(null as timestamp)", "TIMESTAMP(0)");
        this.checkExpType("cast(null as decimal)", "DECIMAL(19, 0)");
        this.checkExpType("cast(null as varbinary(1))", "VARBINARY(1)");
        this.checkExp("cast(null as integer), cast(null as char(1))");
    }

    @Test
    public void testCastTypeToType() {
        this.checkExpType("cast(123 as char)", "CHAR(1) NOT NULL");
        this.checkExpType("cast(123 as varchar)", "VARCHAR(1) NOT NULL");
        this.checkExpType("cast(x'1234' as binary)", "BINARY(1) NOT NULL");
        this.checkExpType("cast(x'1234' as varbinary)", "VARBINARY(1) NOT NULL");
        this.checkExpType("cast(123 as varchar(3))", "VARCHAR(3) NOT NULL");
        this.checkExpType("cast(123 as char(3))", "CHAR(3) NOT NULL");
        this.checkExpType("cast('123' as integer)", "INTEGER NOT NULL");
        this.checkExpType("cast('123' as double)", "DOUBLE NOT NULL");
        this.checkExpType("cast('1.0' as real)", "REAL NOT NULL");
        this.checkExpType("cast(1.0 as tinyint)", "TINYINT NOT NULL");
        this.checkExpType("cast(1 as tinyint)", "TINYINT NOT NULL");
        this.checkExpType("cast(1.0 as smallint)", "SMALLINT NOT NULL");
        this.checkExpType("cast(1 as integer)", "INTEGER NOT NULL");
        this.checkExpType("cast(1.0 as integer)", "INTEGER NOT NULL");
        this.checkExpType("cast(1.0 as bigint)", "BIGINT NOT NULL");
        this.checkExpType("cast(1 as bigint)", "BIGINT NOT NULL");
        this.checkExpType("cast(1.0 as float)", "FLOAT NOT NULL");
        this.checkExpType("cast(1 as float)", "FLOAT NOT NULL");
        this.checkExpType("cast(1.0 as real)", "REAL NOT NULL");
        this.checkExpType("cast(1 as real)", "REAL NOT NULL");
        this.checkExpType("cast(1.0 as double)", "DOUBLE NOT NULL");
        this.checkExpType("cast(1 as double)", "DOUBLE NOT NULL");
        this.checkExpType("cast(123 as decimal(6,4))", "DECIMAL(6, 4) NOT NULL");
        this.checkExpType("cast(123 as decimal(6))", "DECIMAL(6, 0) NOT NULL");
        this.checkExpType("cast(123 as decimal)", "DECIMAL(19, 0) NOT NULL");
        this.checkExpType("cast(1.234 as decimal(2,5))", "DECIMAL(2, 5) NOT NULL");
        this.checkExpType("cast('4.5' as decimal(3,1))", "DECIMAL(3, 1) NOT NULL");
        this.checkExpType("cast(null as boolean)", "BOOLEAN");
        this.checkExpType("cast('abc' as varchar(1))", "VARCHAR(1) NOT NULL");
        this.checkExpType("cast('abc' as char(1))", "CHAR(1) NOT NULL");
        this.checkExpType("cast(x'ff' as binary(1))", "BINARY(1) NOT NULL");
        this.checkExpType("cast(multiset[1] as double multiset)", "DOUBLE NOT NULL MULTISET NOT NULL");
        this.checkExpType("cast(multiset['abc'] as integer multiset)", "INTEGER NOT NULL MULTISET NOT NULL");
    }

    @Test
    public void testCastFails() {
        this.checkExpFails("cast('foo' as ^bar^)", "(?s).*Unknown datatype name 'BAR'");
        this.checkWholeExpFails("cast(multiset[1] as integer)", "(?s).*Cast function cannot convert value of type INTEGER MULTISET to type INTEGER");
        this.checkWholeExpFails("cast(x'ff' as decimal(5,2))", "(?s).*Cast function cannot convert value of type BINARY\\(1\\) to type DECIMAL\\(5, 2\\)");
        this.checkWholeExpFails("cast(1 as boolean)", "(?s).*Cast function cannot convert value of type INTEGER to type BOOLEAN.*");
        this.checkWholeExpFails("cast(1.0e1 as boolean)", "(?s).*Cast function cannot convert value of type DOUBLE to type BOOLEAN.*");
        this.checkWholeExpFails("cast(true as numeric)", "(?s).*Cast function cannot convert value of type BOOLEAN to type DECIMAL.*");
        this.checkWholeExpFails("cast(DATE '1243-12-01' as TIME)", "(?s).*Cast function cannot convert value of type DATE to type TIME.*");
        this.checkWholeExpFails("cast(TIME '12:34:01' as DATE)", "(?s).*Cast function cannot convert value of type TIME\\(0\\) to type DATE.*");
        this.checkExp("cast(true as char(3))");
    }

    @Test
    public void testCastBinaryLiteral() {
        this.checkExpFails("cast(^x'0dd'^ as binary(5))", "Binary literal string must contain an even number of hexits");
    }

    @Test
    public void testDateTime() {
        this.checkExp("LOCALTIME(3)");
        this.checkExp("LOCALTIME");
        this.checkWholeExpFails("LOCALTIME(1+2)", "Argument to function 'LOCALTIME' must be a literal");
        this.checkWholeExpFails("LOCALTIME(NULL)", "Argument to function 'LOCALTIME' must not be NULL");
        this.checkWholeExpFails("LOCALTIME(CAST(NULL AS INTEGER))", "Argument to function 'LOCALTIME' must not be NULL");
        this.checkWholeExpFails("LOCALTIME()", "No match found for function signature LOCALTIME..");
        this.checkExpType("LOCALTIME", "TIME(0) NOT NULL");
        this.checkWholeExpFails("LOCALTIME(-1)", "Argument to function 'LOCALTIME' must be a positive integer literal");
        this.checkExpFails("LOCALTIME(^100000000000000^)", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("LOCALTIME(4)", "Argument to function 'LOCALTIME' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("LOCALTIME('foo')", "(?s).*Cannot apply.*");
        this.checkExp("LOCALTIMESTAMP(3)");
        this.checkExp("LOCALTIMESTAMP");
        this.checkWholeExpFails("LOCALTIMESTAMP(1+2)", "Argument to function 'LOCALTIMESTAMP' must be a literal");
        this.checkWholeExpFails("LOCALTIMESTAMP()", "No match found for function signature LOCALTIMESTAMP..");
        this.checkExpType("LOCALTIMESTAMP", "TIMESTAMP(0) NOT NULL");
        this.checkWholeExpFails("LOCALTIMESTAMP(-1)", "Argument to function 'LOCALTIMESTAMP' must be a positive integer literal");
        this.checkExpFails("LOCALTIMESTAMP(^100000000000000^)", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("LOCALTIMESTAMP(4)", "Argument to function 'LOCALTIMESTAMP' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("LOCALTIMESTAMP('foo')", "(?s).*Cannot apply.*");
        this.checkWholeExpFails("CURRENT_DATE(3)", "No match found for function signature CURRENT_DATE..NUMERIC..");
        this.checkExp("CURRENT_DATE");
        this.checkWholeExpFails("CURRENT_DATE(1+2)", "No match found for function signature CURRENT_DATE..NUMERIC..");
        this.checkWholeExpFails("CURRENT_DATE()", "No match found for function signature CURRENT_DATE..");
        this.checkExpType("CURRENT_DATE", "DATE NOT NULL");
        this.checkWholeExpFails("CURRENT_DATE(-1)", "No match found for function signature CURRENT_DATE..NUMERIC..");
        this.checkWholeExpFails("CURRENT_DATE('foo')", ANY);
        this.checkExp("current_time(3)");
        this.checkExp("current_time");
        this.checkWholeExpFails("current_time(1+2)", "Argument to function 'CURRENT_TIME' must be a literal");
        this.checkWholeExpFails("current_time()", "No match found for function signature CURRENT_TIME..");
        this.checkExpType("current_time", "TIME(0) NOT NULL");
        this.checkWholeExpFails("current_time(-1)", "Argument to function 'CURRENT_TIME' must be a positive integer literal");
        this.checkExpFails("CURRENT_TIME(^100000000000000^)", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("CURRENT_TIME(4)", "Argument to function 'CURRENT_TIME' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("current_time('foo')", "(?s).*Cannot apply.*");
        this.checkExp("CURRENT_TIMESTAMP(3)");
        this.checkExp("CURRENT_TIMESTAMP");
        this.check("SELECT CURRENT_TIMESTAMP AS X FROM (VALUES (1))");
        this.checkWholeExpFails("CURRENT_TIMESTAMP(1+2)", "Argument to function 'CURRENT_TIMESTAMP' must be a literal");
        this.checkWholeExpFails("CURRENT_TIMESTAMP()", "No match found for function signature CURRENT_TIMESTAMP..");
        this.checkExpType("CURRENT_TIMESTAMP", "TIMESTAMP(0) NOT NULL");
        this.checkExpType("CURRENT_TIMESTAMP(2)", "TIMESTAMP(2) NOT NULL");
        this.checkWholeExpFails("CURRENT_TIMESTAMP(-1)", "Argument to function 'CURRENT_TIMESTAMP' must be a positive integer literal");
        this.checkExpFails("CURRENT_TIMESTAMP(^100000000000000^)", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("CURRENT_TIMESTAMP(4)", "Argument to function 'CURRENT_TIMESTAMP' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("CURRENT_TIMESTAMP('foo')", "(?s).*Cannot apply.*");
        this.checkExp("DATE '2004-12-01'");
        this.checkExp("TIME '12:01:01'");
        this.checkExp("TIME '11:59:59.99'");
        this.checkExp("TIME '12:01:01.001'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01.001'");
    }

    @Test
    public void testDateTimeCast() {
        this.checkWholeExpFails("CAST(1 as DATE)", "Cast function cannot convert value of type INTEGER to type DATE");
        this.checkExp("CAST(DATE '2001-12-21' AS VARCHAR(10))");
        this.checkExp("CAST( '2001-12-21' AS DATE)");
        this.checkExp("CAST( TIMESTAMP '2001-12-21 10:12:21' AS VARCHAR(20))");
        this.checkExp("CAST( TIME '10:12:21' AS VARCHAR(20))");
        this.checkExp("CAST( '10:12:21' AS TIME)");
        this.checkExp("CAST( '2004-12-21 10:12:21' AS TIMESTAMP)");
    }

    @Test
    public void testInvalidFunction() {
        this.checkWholeExpFails("foo()", "No match found for function signature FOO..");
        this.checkWholeExpFails("mod(123)", "Invalid number of arguments to function 'MOD'. Was expecting 2 arguments");
    }

    @Test
    public void testJdbcFunctionCall() {
        this.checkExp("{fn log10(1)}");
        this.checkExp("{fn locate('','')}");
        this.checkExp("{fn insert('',1,2,'')}");
        this.checkWholeExpFails("{fn lower('Foo' || 'Bar')}", "Function '\\{fn LOWER\\}' is not defined");
        this.checkExp("{fn lcase('Foo' || 'Bar')}");
        this.checkExp("{fn power(2, 3)}");
        this.checkWholeExpFails("{fn insert('','',1,2)}", "(?s).*.*");
        this.checkWholeExpFails("{fn insert('','',1)}", "(?s).*4.*");
        this.checkWholeExpFails("{fn locate('','',1)}", ANY);
        this.checkWholeExpFails("{fn log10('1')}", "(?s).*Cannot apply.*fn LOG10..<CHAR.1.>.*");
        this.checkWholeExpFails("{fn log10(1,1)}", "(?s).*Encountered .fn LOG10. with 2 parameter.s.; was expecting 1 parameter.s.*");
        this.checkWholeExpFails("{fn fn(1)}", "(?s).*Function '.fn FN.' is not defined.*");
        this.checkWholeExpFails("{fn hahaha(1)}", "(?s).*Function '.fn HAHAHA.' is not defined.*");
    }

    @Test
    public void testQuotedFunction() {
        this.checkExpFails("^\"TRIM\"('b' FROM 'a')^", "(?s).*Encountered \"FROM\" at .*");
        this.checkExpType("\"TRIM\"('b')", "VARCHAR(1) NOT NULL");
        this.checkExpType("TRIM('b')", "VARCHAR(1) NOT NULL");
    }

    @Test
    public void testRowtype() {
        this.check("values (1),(2),(1)");
        this.checkResultType("values (1),(2),(1)", "RecordType(INTEGER NOT NULL EXPR$0) NOT NULL");
        this.check("values (1,'1'),(2,'2')");
        this.checkResultType("values (1,'1'),(2,'2')", "RecordType(INTEGER NOT NULL EXPR$0, CHAR(1) NOT NULL EXPR$1) NOT NULL");
        this.checkResultType("values true", "RecordType(BOOLEAN NOT NULL EXPR$0) NOT NULL");
        this.checkFails("^values ('1'),(2)^", "Values passed to VALUES operator must have compatible types");
    }

    @Test
    public void testRow() {
        this.checkColumnType("select t.r.\"EXPR$1\".\"EXPR$2\"\nfrom (select ((1,2),(3,4,5)) r from dept) t", "INTEGER NOT NULL");
    }

    @Test
    public void testMultiset() {
        this.checkExpType("multiset[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[1, CAST(null AS DOUBLE)]", "DOUBLE MULTISET NOT NULL");
        this.checkExpType("multiset[1.3,2.3]", "DECIMAL(2, 1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[1,2.3, cast(4 as bigint)]", "DECIMAL(19, 0) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset['1','22', '333','22']", "CHAR(3) NOT NULL MULTISET NOT NULL");
        this.checkExpFails("^multiset[1, '2']^", "Parameters must be of the same type");
        this.checkExpType("multiset[ROW(1,2)]", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[ROW(1,2),ROW(2,5)]", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[ROW(1,2),ROW(3.4,5.4)]", "RecordType(DECIMAL(11, 1) NOT NULL EXPR$0, DECIMAL(11, 1) NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset(select*from emp)", "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER NOT NULL MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER) NOT NULL MULTISET NOT NULL");
    }

    @Test
    public void testMultisetSetOperators() {
        this.checkExp("multiset[1] multiset union multiset[1,2.3]");
        this.checkExpType("multiset[324.2] multiset union multiset[23.2,2.32]", "DECIMAL(5, 2) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[1] multiset union multiset[1,2.3]", "DECIMAL(11, 1) NOT NULL MULTISET NOT NULL");
        this.checkExp("multiset[1] multiset union all multiset[1,2.3]");
        this.checkExp("multiset[1] multiset except multiset[1,2.3]");
        this.checkExp("multiset[1] multiset except all multiset[1,2.3]");
        this.checkExp("multiset[1] multiset intersect multiset[1,2.3]");
        this.checkExp("multiset[1] multiset intersect all multiset[1,2.3]");
        this.checkExpFails("^multiset[1, '2']^ multiset union multiset[1]", "Parameters must be of the same type");
        this.checkExp("multiset[ROW(1,2)] multiset intersect multiset[row(3,4)]");
    }

    @Test
    public void testSubMultisetOf() {
        this.checkExpType("multiset[1] submultiset of multiset[1,2.3]", "BOOLEAN NOT NULL");
        this.checkExpType("multiset[1] submultiset of multiset[1]", "BOOLEAN NOT NULL");
        this.checkExpFails("^multiset[1, '2']^ submultiset of multiset[1]", "Parameters must be of the same type");
        this.checkExp("multiset[ROW(1,2)] submultiset of multiset[row(3,4)]");
    }

    @Test
    public void testElement() {
        this.checkExpType("element(multiset[1])", "INTEGER NOT NULL");
        this.checkExpType("1.0+element(multiset[1])", "DECIMAL(12, 1) NOT NULL");
        this.checkExpType("element(multiset['1'])", "CHAR(1) NOT NULL");
        this.checkExpType("element(multiset[1e-2])", "DOUBLE NOT NULL");
        this.checkExpType("element(multiset[multiset[cast(null as tinyint)]])", "TINYINT MULTISET NOT NULL");
    }

    @Test
    public void testMemberOf() {
        this.checkExpType("1 member of multiset[1]", "BOOLEAN NOT NULL");
        this.checkWholeExpFails("1 member of multiset['1']", "Cannot compare values of types 'INTEGER', 'CHAR\\(1\\)'");
    }

    @Test
    public void testIsASet() {
        this.checkExp("multiset[1] is a set");
        this.checkExp("multiset['1'] is a set");
        this.checkWholeExpFails("'a' is a set", ".*Cannot apply 'IS A SET' to.*");
    }

    @Test
    public void testCardinality() {
        this.checkExpType("cardinality(multiset[1])", "INTEGER NOT NULL");
        this.checkExpType("cardinality(multiset['1'])", "INTEGER NOT NULL");
        this.checkWholeExpFails("cardinality('a')", "Cannot apply 'CARDINALITY' to arguments of type 'CARDINALITY\\(<CHAR\\(1\\)>\\)'\\. Supported form\\(s\\): 'CARDINALITY\\(<MULTISET>\\)'\n'CARDINALITY\\(<ARRAY>\\)'\n'CARDINALITY\\(<MAP>\\)'");
    }

    @Test
    public void testIntervalTimeUnitEnumeration() {
        Assert.assertEquals((long)0L, (long)SqlIntervalQualifier.TimeUnit.YEAR.ordinal());
        Assert.assertEquals((long)1L, (long)SqlIntervalQualifier.TimeUnit.MONTH.ordinal());
        Assert.assertEquals((long)2L, (long)SqlIntervalQualifier.TimeUnit.DAY.ordinal());
        Assert.assertEquals((long)3L, (long)SqlIntervalQualifier.TimeUnit.HOUR.ordinal());
        Assert.assertEquals((long)4L, (long)SqlIntervalQualifier.TimeUnit.MINUTE.ordinal());
        Assert.assertEquals((long)5L, (long)SqlIntervalQualifier.TimeUnit.SECOND.ordinal());
        boolean b = SqlIntervalQualifier.TimeUnit.YEAR.ordinal() < SqlIntervalQualifier.TimeUnit.MONTH.ordinal() && SqlIntervalQualifier.TimeUnit.MONTH.ordinal() < SqlIntervalQualifier.TimeUnit.DAY.ordinal() && SqlIntervalQualifier.TimeUnit.DAY.ordinal() < SqlIntervalQualifier.TimeUnit.HOUR.ordinal() && SqlIntervalQualifier.TimeUnit.HOUR.ordinal() < SqlIntervalQualifier.TimeUnit.MINUTE.ordinal() && SqlIntervalQualifier.TimeUnit.MINUTE.ordinal() < SqlIntervalQualifier.TimeUnit.SECOND.ordinal();
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void testIntervalMonthsConversion() {
        this.checkIntervalConv("INTERVAL '1' YEAR", "12");
        this.checkIntervalConv("INTERVAL '5' MONTH", "5");
        this.checkIntervalConv("INTERVAL '3-2' YEAR TO MONTH", "38");
        this.checkIntervalConv("INTERVAL '-5-4' YEAR TO MONTH", "-64");
    }

    @Test
    public void testIntervalMillisConversion() {
        this.checkIntervalConv("INTERVAL '1' DAY", "86400000");
        this.checkIntervalConv("INTERVAL '1' HOUR", "3600000");
        this.checkIntervalConv("INTERVAL '1' MINUTE", "60000");
        this.checkIntervalConv("INTERVAL '1' SECOND", "1000");
        this.checkIntervalConv("INTERVAL '1:05' HOUR TO MINUTE", "3900000");
        this.checkIntervalConv("INTERVAL '1:05' MINUTE TO SECOND", "65000");
        this.checkIntervalConv("INTERVAL '1 1' DAY TO HOUR", "90000000");
        this.checkIntervalConv("INTERVAL '1 1:05' DAY TO MINUTE", "90300000");
        this.checkIntervalConv("INTERVAL '1 1:05:03' DAY TO SECOND", "90303000");
        this.checkIntervalConv("INTERVAL '1 1:05:03.12345' DAY TO SECOND", "90303123");
        this.checkIntervalConv("INTERVAL '1.12345' SECOND", "1123");
        this.checkIntervalConv("INTERVAL '1:05.12345' MINUTE TO SECOND", "65123");
        this.checkIntervalConv("INTERVAL '1:05:03' HOUR TO SECOND", "3903000");
        this.checkIntervalConv("INTERVAL '1:05:03.12345' HOUR TO SECOND", "3903123");
    }

    public void subTestIntervalYearPositive() {
        this.checkExpType("INTERVAL '1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL '99' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL '1' YEAR(2)", "INTERVAL YEAR(2) NOT NULL");
        this.checkExpType("INTERVAL '99' YEAR(2)", "INTERVAL YEAR(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' YEAR(10)", "INTERVAL YEAR(10) NOT NULL");
        this.checkExpType("INTERVAL '0' YEAR(1)", "INTERVAL YEAR(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' YEAR(4)", "INTERVAL YEAR(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL '-1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL +'1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL +'+1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL +'-1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL -'1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL -'+1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL -'-1' YEAR", "INTERVAL YEAR NOT NULL");
    }

    public void subTestIntervalYearToMonthPositive() {
        this.checkExpType("INTERVAL '1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-11' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-0' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '1-2' YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-11' YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-0' YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '2147483647-11' YEAR(10) TO MONTH", "INTERVAL YEAR(10) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '0-0' YEAR(1) TO MONTH", "INTERVAL YEAR(1) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '2006-2' YEAR(4) TO MONTH", "INTERVAL YEAR(4) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '-1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '+1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL +'1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL +'-1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL +'+1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL -'1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL -'-1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL -'+1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
    }

    public void subTestIntervalMonthPositive() {
        this.checkExpType("INTERVAL '1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL '99' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL '1' MONTH(2)", "INTERVAL MONTH(2) NOT NULL");
        this.checkExpType("INTERVAL '99' MONTH(2)", "INTERVAL MONTH(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' MONTH(10)", "INTERVAL MONTH(10) NOT NULL");
        this.checkExpType("INTERVAL '0' MONTH(1)", "INTERVAL MONTH(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' MONTH(4)", "INTERVAL MONTH(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL '-1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL +'1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL +'+1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL +'-1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL -'1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL -'+1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL -'-1' MONTH", "INTERVAL MONTH NOT NULL");
    }

    public void subTestIntervalDayPositive() {
        this.checkExpType("INTERVAL '1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL '99' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL '1' DAY(2)", "INTERVAL DAY(2) NOT NULL");
        this.checkExpType("INTERVAL '99' DAY(2)", "INTERVAL DAY(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' DAY(10)", "INTERVAL DAY(10) NOT NULL");
        this.checkExpType("INTERVAL '0' DAY(1)", "INTERVAL DAY(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' DAY(4)", "INTERVAL DAY(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL '-1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL +'1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL +'+1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL +'-1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL -'1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL -'+1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL -'-1' DAY", "INTERVAL DAY NOT NULL");
    }

    public void subTestIntervalDayToHourPositive() {
        this.checkExpType("INTERVAL '1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 23' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 0' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '1 2' DAY(2) TO HOUR", "INTERVAL DAY(2) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 23' DAY(2) TO HOUR", "INTERVAL DAY(2) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 0' DAY(2) TO HOUR", "INTERVAL DAY(2) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23' DAY(10) TO HOUR", "INTERVAL DAY(10) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '0 0' DAY(1) TO HOUR", "INTERVAL DAY(1) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '2345 2' DAY(4) TO HOUR", "INTERVAL DAY(4) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '-1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '+1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL +'1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL +'-1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL +'+1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL -'1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL -'-1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL -'+1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
    }

    public void subTestIntervalDayToMinutePositive() {
        this.checkExpType("INTERVAL '1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 23:59' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 0:0' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '1 2:3' DAY(2) TO MINUTE", "INTERVAL DAY(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 23:59' DAY(2) TO MINUTE", "INTERVAL DAY(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 0:0' DAY(2) TO MINUTE", "INTERVAL DAY(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23:59' DAY(10) TO MINUTE", "INTERVAL DAY(10) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '0 0:0' DAY(1) TO MINUTE", "INTERVAL DAY(1) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2345 6:7' DAY(4) TO MINUTE", "INTERVAL DAY(4) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '-1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '+1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'-1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'+1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'-1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'+1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
    }

    public void subTestIntervalDayToSecondPositive() {
        this.checkExpType("INTERVAL '1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59.999999' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0.0' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '1 2:3:4' DAY(2) TO SECOND", "INTERVAL DAY(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59' DAY(2) TO SECOND", "INTERVAL DAY(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0' DAY(2) TO SECOND", "INTERVAL DAY(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59.999999' DAY TO SECOND(6)", "INTERVAL DAY TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0.0' DAY TO SECOND(6)", "INTERVAL DAY TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23:59:59' DAY(10) TO SECOND", "INTERVAL DAY(10) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23:59:59.999999999' DAY(10) TO SECOND(9)", "INTERVAL DAY(10) TO SECOND(9) NOT NULL");
        this.checkExpType("INTERVAL '0 0:0:0' DAY(1) TO SECOND", "INTERVAL DAY(1) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '0 0:0:0.0' DAY(1) TO SECOND(1)", "INTERVAL DAY(1) TO SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '2345 6:7:8' DAY(4) TO SECOND", "INTERVAL DAY(4) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2345 6:7:8.9012' DAY(4) TO SECOND(4)", "INTERVAL DAY(4) TO SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '-1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '+1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
    }

    public void subTestIntervalHourPositive() {
        this.checkExpType("INTERVAL '1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL '99' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL '1' HOUR(2)", "INTERVAL HOUR(2) NOT NULL");
        this.checkExpType("INTERVAL '99' HOUR(2)", "INTERVAL HOUR(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' HOUR(10)", "INTERVAL HOUR(10) NOT NULL");
        this.checkExpType("INTERVAL '0' HOUR(1)", "INTERVAL HOUR(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' HOUR(4)", "INTERVAL HOUR(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL '-1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL +'1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL +'+1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL +'-1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL -'1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL -'+1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL -'-1' HOUR", "INTERVAL HOUR NOT NULL");
    }

    public void subTestIntervalHourToMinutePositive() {
        this.checkExpType("INTERVAL '2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '23:59' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99:0' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2:3' HOUR(2) TO MINUTE", "INTERVAL HOUR(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '23:59' HOUR(2) TO MINUTE", "INTERVAL HOUR(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99:0' HOUR(2) TO MINUTE", "INTERVAL HOUR(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59' HOUR(10) TO MINUTE", "INTERVAL HOUR(10) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '0:0' HOUR(1) TO MINUTE", "INTERVAL HOUR(1) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2345:7' HOUR(4) TO MINUTE", "INTERVAL HOUR(4) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '-1:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '+1:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'-2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'+2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'-2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'+2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
    }

    public void subTestIntervalHourToSecondPositive() {
        this.checkExpType("INTERVAL '2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '23:59:59' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0:0' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '23:59:59.999999' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0:0.0' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2:3:4' HOUR(2) TO SECOND", "INTERVAL HOUR(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59:59' HOUR(2) TO SECOND", "INTERVAL HOUR(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0:0' HOUR(2) TO SECOND", "INTERVAL HOUR(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59:59.999999' HOUR TO SECOND(6)", "INTERVAL HOUR TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '99:0:0.0' HOUR TO SECOND(6)", "INTERVAL HOUR TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59:59' HOUR(10) TO SECOND", "INTERVAL HOUR(10) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59:59.999999999' HOUR(10) TO SECOND(9)", "INTERVAL HOUR(10) TO SECOND(9) NOT NULL");
        this.checkExpType("INTERVAL '0:0:0' HOUR(1) TO SECOND", "INTERVAL HOUR(1) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '0:0:0.0' HOUR(1) TO SECOND(1)", "INTERVAL HOUR(1) TO SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '2345:7:8' HOUR(4) TO SECOND", "INTERVAL HOUR(4) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2345:7:8.9012' HOUR(4) TO SECOND(4)", "INTERVAL HOUR(4) TO SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '-2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '+2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
    }

    public void subTestIntervalMinutePositive() {
        this.checkExpType("INTERVAL '1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL '1' MINUTE(2)", "INTERVAL MINUTE(2) NOT NULL");
        this.checkExpType("INTERVAL '99' MINUTE(2)", "INTERVAL MINUTE(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' MINUTE(10)", "INTERVAL MINUTE(10) NOT NULL");
        this.checkExpType("INTERVAL '0' MINUTE(1)", "INTERVAL MINUTE(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' MINUTE(4)", "INTERVAL MINUTE(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL '-1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'+1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'-1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'+1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'-1' MINUTE", "INTERVAL MINUTE NOT NULL");
    }

    public void subTestIntervalMinuteToSecondPositive() {
        this.checkExpType("INTERVAL '2:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '59:59' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '59:59.999999' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0.0' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2:4' MINUTE(2) TO SECOND", "INTERVAL MINUTE(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59' MINUTE(2) TO SECOND", "INTERVAL MINUTE(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0' MINUTE(2) TO SECOND", "INTERVAL MINUTE(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59.999999' MINUTE TO SECOND(6)", "INTERVAL MINUTE TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '99:0.0' MINUTE TO SECOND(6)", "INTERVAL MINUTE TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59' MINUTE(10) TO SECOND", "INTERVAL MINUTE(10) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59.999999999' MINUTE(10) TO SECOND(9)", "INTERVAL MINUTE(10) TO SECOND(9) NOT NULL");
        this.checkExpType("INTERVAL '0:0' MINUTE(1) TO SECOND", "INTERVAL MINUTE(1) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '0:0.0' MINUTE(1) TO SECOND(1)", "INTERVAL MINUTE(1) TO SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '2345:8' MINUTE(4) TO SECOND", "INTERVAL MINUTE(4) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2345:7.8901' MINUTE(4) TO SECOND(4)", "INTERVAL MINUTE(4) TO SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '-3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '+3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
    }

    public void subTestIntervalSecondPositive() {
        this.checkExpType("INTERVAL '1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '99' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '1' SECOND(2)", "INTERVAL SECOND(2) NOT NULL");
        this.checkExpType("INTERVAL '99' SECOND(2)", "INTERVAL SECOND(2) NOT NULL");
        this.checkExpType("INTERVAL '1' SECOND(2, 6)", "INTERVAL SECOND(2, 6) NOT NULL");
        this.checkExpType("INTERVAL '99' SECOND(2, 6)", "INTERVAL SECOND(2, 6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' SECOND(10)", "INTERVAL SECOND(10) NOT NULL");
        this.checkExpType("INTERVAL '2147483647.999999999' SECOND(10, 9)", "INTERVAL SECOND(10, 9) NOT NULL");
        this.checkExpType("INTERVAL '0' SECOND(1)", "INTERVAL SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '0.0' SECOND(1, 1)", "INTERVAL SECOND(1, 1) NOT NULL");
        this.checkExpType("INTERVAL '1234' SECOND(4)", "INTERVAL SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '1234.56789' SECOND(4, 5)", "INTERVAL SECOND(4, 5) NOT NULL");
        this.checkExpType("INTERVAL '+1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '-1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL +'1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL -'1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-1' SECOND", "INTERVAL SECOND NOT NULL");
    }

    public void subTestIntervalYearNegative() {
        this.checkWholeExpFails("INTERVAL '-' YEAR", "Illegal interval literal format '-' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1-2' YEAR", "Illegal interval literal format '1-2' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1.2' YEAR", "Illegal interval literal format '1.2' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1 2' YEAR", "Illegal interval literal format '1 2' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1-2' YEAR(2)", "Illegal interval literal format '1-2' for INTERVAL YEAR\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' YEAR", "Illegal interval literal format 'bogus text' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '--1' YEAR", "Illegal interval literal format '--1' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '100' YEAR", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' YEAR(2)", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' YEAR(3)", "Interval field value 1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' YEAR(3)", "Interval field value -1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' YEAR(10)", "Interval field value 2,147,483,648 exceeds precision of YEAR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' YEAR(10)", "Interval field value -2,147,483,648 exceeds precision of YEAR\\(10\\) field");
        this.checkExpFails("INTERVAL '1' YEAR(11^)^", "Interval leading field precision '11' out of range for INTERVAL YEAR\\(11\\)");
        this.checkExpFails("INTERVAL '0' YEAR(0^)^", "Interval leading field precision '0' out of range for INTERVAL YEAR\\(0\\)");
    }

    public void subTestIntervalYearToMonthNegative() {
        this.checkWholeExpFails("INTERVAL '-' YEAR TO MONTH", "Illegal interval literal format '-' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1' YEAR TO MONTH", "Illegal interval literal format '1' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1:2' YEAR TO MONTH", "Illegal interval literal format '1:2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1.2' YEAR TO MONTH", "Illegal interval literal format '1.2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1 2' YEAR TO MONTH", "Illegal interval literal format '1 2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1:2' YEAR(2) TO MONTH", "Illegal interval literal format '1:2' for INTERVAL YEAR\\(2\\) TO MONTH");
        this.checkWholeExpFails("INTERVAL 'bogus text' YEAR TO MONTH", "Illegal interval literal format 'bogus text' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '--1-2' YEAR TO MONTH", "Illegal interval literal format '--1-2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1--2' YEAR TO MONTH", "Illegal interval literal format '1--2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '100-0' YEAR TO MONTH", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100-0' YEAR(2) TO MONTH", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000-0' YEAR(3) TO MONTH", "Interval field value 1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000-0' YEAR(3) TO MONTH", "Interval field value -1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648-0' YEAR(10) TO MONTH", "Interval field value 2,147,483,648 exceeds precision of YEAR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648-0' YEAR(10) TO MONTH", "Interval field value -2,147,483,648 exceeds precision of YEAR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1-12' YEAR TO MONTH", "Illegal interval literal format '1-12' for INTERVAL YEAR TO MONTH.*");
        this.checkExpFails("INTERVAL '1-1' YEAR(11) TO ^MONTH^", "Interval leading field precision '11' out of range for INTERVAL YEAR\\(11\\) TO MONTH");
        this.checkExpFails("INTERVAL '0-0' YEAR(0) TO ^MONTH^", "Interval leading field precision '0' out of range for INTERVAL YEAR\\(0\\) TO MONTH");
    }

    public void subTestIntervalMonthNegative() {
        this.checkWholeExpFails("INTERVAL '-' MONTH", "Illegal interval literal format '-' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1-2' MONTH", "Illegal interval literal format '1-2' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1.2' MONTH", "Illegal interval literal format '1.2' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1 2' MONTH", "Illegal interval literal format '1 2' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1-2' MONTH(2)", "Illegal interval literal format '1-2' for INTERVAL MONTH\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' MONTH", "Illegal interval literal format 'bogus text' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '--1' MONTH", "Illegal interval literal format '--1' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '100' MONTH", "Interval field value 100 exceeds precision of MONTH\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' MONTH(2)", "Interval field value 100 exceeds precision of MONTH\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' MONTH(3)", "Interval field value 1,000 exceeds precision of MONTH\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' MONTH(3)", "Interval field value -1,000 exceeds precision of MONTH\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' MONTH(10)", "Interval field value 2,147,483,648 exceeds precision of MONTH\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' MONTH(10)", "Interval field value -2,147,483,648 exceeds precision of MONTH\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' MONTH(11^)^", "Interval leading field precision '11' out of range for INTERVAL MONTH\\(11\\)");
        this.checkExpFails("INTERVAL '0' MONTH(0^)^", "Interval leading field precision '0' out of range for INTERVAL MONTH\\(0\\)");
    }

    public void subTestIntervalDayNegative() {
        this.checkWholeExpFails("INTERVAL '-' DAY", "Illegal interval literal format '-' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1-2' DAY", "Illegal interval literal format '1-2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1.2' DAY", "Illegal interval literal format '1.2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1 2' DAY", "Illegal interval literal format '1 2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1:2' DAY", "Illegal interval literal format '1:2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1-2' DAY(2)", "Illegal interval literal format '1-2' for INTERVAL DAY\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY", "Illegal interval literal format 'bogus text' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '--1' DAY", "Illegal interval literal format '--1' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '100' DAY", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' DAY(2)", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' DAY(3)", "Interval field value 1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' DAY(3)", "Interval field value -1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' DAY(10)", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' DAY(10)", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' DAY(11^)^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\)");
        this.checkExpFails("INTERVAL '0' DAY(0^)^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\)");
    }

    public void subTestIntervalDayToHourNegative() {
        this.checkWholeExpFails("INTERVAL '-' DAY TO HOUR", "Illegal interval literal format '-' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1' DAY TO HOUR", "Illegal interval literal format '1' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1:2' DAY TO HOUR", "Illegal interval literal format '1:2' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1.2' DAY TO HOUR", "Illegal interval literal format '1.2' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1 x' DAY TO HOUR", "Illegal interval literal format '1 x' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL ' ' DAY TO HOUR", "Illegal interval literal format ' ' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1:2' DAY(2) TO HOUR", "Illegal interval literal format '1:2' for INTERVAL DAY\\(2\\) TO HOUR");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY TO HOUR", "Illegal interval literal format 'bogus text' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '--1 1' DAY TO HOUR", "Illegal interval literal format '--1 1' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1 -1' DAY TO HOUR", "Illegal interval literal format '1 -1' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '100 0' DAY TO HOUR", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100 0' DAY(2) TO HOUR", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000 0' DAY(3) TO HOUR", "Interval field value 1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000 0' DAY(3) TO HOUR", "Interval field value -1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648 0' DAY(10) TO HOUR", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 0' DAY(10) TO HOUR", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1 24' DAY TO HOUR", "Illegal interval literal format '1 24' for INTERVAL DAY TO HOUR.*");
        this.checkExpFails("INTERVAL '1 1' DAY(11) TO ^HOUR^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\) TO HOUR");
        this.checkExpFails("INTERVAL '0 0' DAY(0) TO ^HOUR^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\) TO HOUR");
    }

    public void subTestIntervalDayToMinuteNegative() {
        this.checkWholeExpFails("INTERVAL ' :' DAY TO MINUTE", "Illegal interval literal format ' :' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1' DAY TO MINUTE", "Illegal interval literal format '1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 2' DAY TO MINUTE", "Illegal interval literal format '1 2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:2' DAY TO MINUTE", "Illegal interval literal format '1:2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1.2' DAY TO MINUTE", "Illegal interval literal format '1.2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL 'x 1:1' DAY TO MINUTE", "Illegal interval literal format 'x 1:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 x:1' DAY TO MINUTE", "Illegal interval literal format '1 x:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:x' DAY TO MINUTE", "Illegal interval literal format '1 1:x' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:2:3' DAY TO MINUTE", "Illegal interval literal format '1 1:2:3' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.2' DAY TO MINUTE", "Illegal interval literal format '1 1:1:1.2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:2:3' DAY(2) TO MINUTE", "Illegal interval literal format '1 1:2:3' for INTERVAL DAY\\(2\\) TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1' DAY(2) TO MINUTE", "Illegal interval literal format '1 1' for INTERVAL DAY\\(2\\) TO MINUTE");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY TO MINUTE", "Illegal interval literal format 'bogus text' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '--1 1:1' DAY TO MINUTE", "Illegal interval literal format '--1 1:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 -1:1' DAY TO MINUTE", "Illegal interval literal format '1 -1:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:-1' DAY TO MINUTE", "Illegal interval literal format '1 1:-1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '100 0:0' DAY TO MINUTE", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100 0:0' DAY(2) TO MINUTE", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000 0:0' DAY(3) TO MINUTE", "Interval field value 1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000 0:0' DAY(3) TO MINUTE", "Interval field value -1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648 0:0' DAY(10) TO MINUTE", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 0:0' DAY(10) TO MINUTE", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1 24:1' DAY TO MINUTE", "Illegal interval literal format '1 24:1' for INTERVAL DAY TO MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1 1:60' DAY TO MINUTE", "Illegal interval literal format '1 1:60' for INTERVAL DAY TO MINUTE.*");
        this.checkExpFails("INTERVAL '1 1:1' DAY(11) TO ^MINUTE^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\) TO MINUTE");
        this.checkExpFails("INTERVAL '0 0' DAY(0) TO ^MINUTE^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\) TO MINUTE");
    }

    public void subTestIntervalDayToSecondNegative() {
        this.checkWholeExpFails("INTERVAL ' ::' DAY TO SECOND", "Illegal interval literal format ' ::' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL ' ::.' DAY TO SECOND", "Illegal interval literal format ' ::\\.' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1' DAY TO SECOND", "Illegal interval literal format '1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 2' DAY TO SECOND", "Illegal interval literal format '1 2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2' DAY TO SECOND", "Illegal interval literal format '1:2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1.2' DAY TO SECOND", "Illegal interval literal format '1\\.2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' DAY TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2:x' DAY TO SECOND", "Illegal interval literal format '1 1:2:x' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2:3' DAY TO SECOND", "Illegal interval literal format '1:2:3' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:1.2' DAY TO SECOND", "Illegal interval literal format '1:1:1\\.2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' DAY(2) TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL DAY\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1' DAY(2) TO SECOND", "Illegal interval literal format '1 1' for INTERVAL DAY\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY TO SECOND", "Illegal interval literal format 'bogus text' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '2345 6:7:8901' DAY TO SECOND(4)", "Illegal interval literal format '2345 6:7:8901' for INTERVAL DAY TO SECOND\\(4\\)");
        this.checkWholeExpFails("INTERVAL '--1 1:1:1' DAY TO SECOND", "Illegal interval literal format '--1 1:1:1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 -1:1:1' DAY TO SECOND", "Illegal interval literal format '1 -1:1:1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:-1:1' DAY TO SECOND", "Illegal interval literal format '1 1:-1:1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:1:-1' DAY TO SECOND", "Illegal interval literal format '1 1:1:-1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.-1' DAY TO SECOND", "Illegal interval literal format '1 1:1:1.-1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '100 0' DAY TO SECOND", "Illegal interval literal format '100 0' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '100 0' DAY(2) TO SECOND", "Illegal interval literal format '100 0' for INTERVAL DAY\\(2\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1000 0' DAY(3) TO SECOND", "Illegal interval literal format '1000 0' for INTERVAL DAY\\(3\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '-1000 0' DAY(3) TO SECOND", "Illegal interval literal format '-1000 0' for INTERVAL DAY\\(3\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '2147483648 1:1:0' DAY(10) TO SECOND", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 1:1:0' DAY(10) TO SECOND", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648 0' DAY(10) TO SECOND", "Illegal interval literal format '2147483648 0' for INTERVAL DAY\\(10\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 0' DAY(10) TO SECOND", "Illegal interval literal format '-2147483648 0' for INTERVAL DAY\\(10\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 24:1:1' DAY TO SECOND", "Illegal interval literal format '1 24:1:1' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:60:1' DAY TO SECOND", "Illegal interval literal format '1 1:60:1' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:1:60' DAY TO SECOND", "Illegal interval literal format '1 1:1:60' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.0000001' DAY TO SECOND", "Illegal interval literal format '1 1:1:1\\.0000001' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.0001' DAY TO SECOND(3)", "Illegal interval literal format '1 1:1:1\\.0001' for INTERVAL DAY TO SECOND\\(3\\).*");
        this.checkExpFails("INTERVAL '1 1' DAY(11) TO ^SECOND^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\) TO SECOND");
        this.checkExpFails("INTERVAL '1 1' DAY TO SECOND(10^)^", "Interval fractional second precision '10' out of range for INTERVAL DAY TO SECOND\\(10\\)");
        this.checkExpFails("INTERVAL '0 0:0:0' DAY(0) TO ^SECOND^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\) TO SECOND");
        this.checkExpFails("INTERVAL '0 0:0:0' DAY TO SECOND(0^)^", "Interval fractional second precision '0' out of range for INTERVAL DAY TO SECOND\\(0\\)");
    }

    public void subTestIntervalHourNegative() {
        this.checkWholeExpFails("INTERVAL '-' HOUR", "Illegal interval literal format '-' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1-2' HOUR", "Illegal interval literal format '1-2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1.2' HOUR", "Illegal interval literal format '1.2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR", "Illegal interval literal format '1 2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1:2' HOUR", "Illegal interval literal format '1:2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1-2' HOUR(2)", "Illegal interval literal format '1-2' for INTERVAL HOUR\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' HOUR", "Illegal interval literal format 'bogus text' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '--1' HOUR", "Illegal interval literal format '--1' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '100' HOUR", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' HOUR(2)", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' HOUR(3)", "Interval field value 1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' HOUR(3)", "Interval field value -1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' HOUR(10)", "Interval field value 2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' HOUR(10)", "Interval field value -2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' HOUR(11^)^", "Interval leading field precision '11' out of range for INTERVAL HOUR\\(11\\)");
        this.checkExpFails("INTERVAL '0' HOUR(0^)^", "Interval leading field precision '0' out of range for INTERVAL HOUR\\(0\\)");
    }

    public void subTestIntervalHourToMinuteNegative() {
        this.checkWholeExpFails("INTERVAL ':' HOUR TO MINUTE", "Illegal interval literal format ':' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1' HOUR TO MINUTE", "Illegal interval literal format '1' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:x' HOUR TO MINUTE", "Illegal interval literal format '1:x' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1.2' HOUR TO MINUTE", "Illegal interval literal format '1.2' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR TO MINUTE", "Illegal interval literal format '1 2' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:2:3' HOUR TO MINUTE", "Illegal interval literal format '1:2:3' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR(2) TO MINUTE", "Illegal interval literal format '1 2' for INTERVAL HOUR\\(2\\) TO MINUTE");
        this.checkWholeExpFails("INTERVAL 'bogus text' HOUR TO MINUTE", "Illegal interval literal format 'bogus text' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '--1:1' HOUR TO MINUTE", "Illegal interval literal format '--1:1' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:-1' HOUR TO MINUTE", "Illegal interval literal format '1:-1' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '100:0' HOUR TO MINUTE", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100:0' HOUR(2) TO MINUTE", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000:0' HOUR(3) TO MINUTE", "Interval field value 1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000:0' HOUR(3) TO MINUTE", "Interval field value -1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648:0' HOUR(10) TO MINUTE", "Interval field value 2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648:0' HOUR(10) TO MINUTE", "Interval field value -2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1:60' HOUR TO MINUTE", "Illegal interval literal format '1:60' for INTERVAL HOUR TO MINUTE.*");
        this.checkExpFails("INTERVAL '1:1' HOUR(11) TO ^MINUTE^", "Interval leading field precision '11' out of range for INTERVAL HOUR\\(11\\) TO MINUTE");
        this.checkExpFails("INTERVAL '0:0' HOUR(0) TO ^MINUTE^", "Interval leading field precision '0' out of range for INTERVAL HOUR\\(0\\) TO MINUTE");
    }

    public void subTestIntervalHourToSecondNegative() {
        this.checkWholeExpFails("INTERVAL '::' HOUR TO SECOND", "Illegal interval literal format '::' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '::.' HOUR TO SECOND", "Illegal interval literal format '::\\.' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1' HOUR TO SECOND", "Illegal interval literal format '1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR TO SECOND", "Illegal interval literal format '1 2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2' HOUR TO SECOND", "Illegal interval literal format '1:2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1.2' HOUR TO SECOND", "Illegal interval literal format '1\\.2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' HOUR TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2:x' HOUR TO SECOND", "Illegal interval literal format '1:2:x' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:x:3' HOUR TO SECOND", "Illegal interval literal format '1:x:3' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:1.x' HOUR TO SECOND", "Illegal interval literal format '1:1:1\\.x' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' HOUR(2) TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL HOUR\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1' HOUR(2) TO SECOND", "Illegal interval literal format '1 1' for INTERVAL HOUR\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL 'bogus text' HOUR TO SECOND", "Illegal interval literal format 'bogus text' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '6:7:8901' HOUR TO SECOND(4)", "Illegal interval literal format '6:7:8901' for INTERVAL HOUR TO SECOND\\(4\\)");
        this.checkWholeExpFails("INTERVAL '--1:1:1' HOUR TO SECOND", "Illegal interval literal format '--1:1:1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:-1:1' HOUR TO SECOND", "Illegal interval literal format '1:-1:1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:-1' HOUR TO SECOND", "Illegal interval literal format '1:1:-1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:1.-1' HOUR TO SECOND", "Illegal interval literal format '1:1:1\\.-1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '100:0:0' HOUR TO SECOND", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100:0:0' HOUR(2) TO SECOND", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000:0:0' HOUR(3) TO SECOND", "Interval field value 1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000:0:0' HOUR(3) TO SECOND", "Interval field value -1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648:0:0' HOUR(10) TO SECOND", "Interval field value 2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648:0:0' HOUR(10) TO SECOND", "Interval field value -2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1:60:1' HOUR TO SECOND", "Illegal interval literal format '1:60:1' for INTERVAL HOUR TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:60' HOUR TO SECOND", "Illegal interval literal format '1:1:60' for INTERVAL HOUR TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:1.0000001' HOUR TO SECOND", "Illegal interval literal format '1:1:1\\.0000001' for INTERVAL HOUR TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:1.0001' HOUR TO SECOND(3)", "Illegal interval literal format '1:1:1\\.0001' for INTERVAL HOUR TO SECOND\\(3\\).*");
        this.checkExpFails("INTERVAL '1:1:1' HOUR(11) TO ^SECOND^", "Interval leading field precision '11' out of range for INTERVAL HOUR\\(11\\) TO SECOND");
        this.checkExpFails("INTERVAL '1:1:1' HOUR TO SECOND(10^)^", "Interval fractional second precision '10' out of range for INTERVAL HOUR TO SECOND\\(10\\)");
        this.checkExpFails("INTERVAL '0:0:0' HOUR(0) TO ^SECOND^", "Interval leading field precision '0' out of range for INTERVAL HOUR\\(0\\) TO SECOND");
        this.checkExpFails("INTERVAL '0:0:0' HOUR TO SECOND(0^)^", "Interval fractional second precision '0' out of range for INTERVAL HOUR TO SECOND\\(0\\)");
    }

    public void subTestIntervalMinuteNegative() {
        this.checkWholeExpFails("INTERVAL '-' MINUTE", "Illegal interval literal format '-' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1-2' MINUTE", "Illegal interval literal format '1-2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1.2' MINUTE", "Illegal interval literal format '1.2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1 2' MINUTE", "Illegal interval literal format '1 2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1:2' MINUTE", "Illegal interval literal format '1:2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1-2' MINUTE(2)", "Illegal interval literal format '1-2' for INTERVAL MINUTE\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' MINUTE", "Illegal interval literal format 'bogus text' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '--1' MINUTE", "Illegal interval literal format '--1' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '100' MINUTE", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' MINUTE(2)", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' MINUTE(3)", "Interval field value 1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' MINUTE(3)", "Interval field value -1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' MINUTE(10)", "Interval field value 2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' MINUTE(10)", "Interval field value -2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' MINUTE(11^)^", "Interval leading field precision '11' out of range for INTERVAL MINUTE\\(11\\)");
        this.checkExpFails("INTERVAL '0' MINUTE(0^)^", "Interval leading field precision '0' out of range for INTERVAL MINUTE\\(0\\)");
    }

    public void subTestIntervalMinuteToSecondNegative() {
        this.checkWholeExpFails("INTERVAL ':' MINUTE TO SECOND", "Illegal interval literal format ':' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL ':.' MINUTE TO SECOND", "Illegal interval literal format ':\\.' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1' MINUTE TO SECOND", "Illegal interval literal format '1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 2' MINUTE TO SECOND", "Illegal interval literal format '1 2' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1.2' MINUTE TO SECOND", "Illegal interval literal format '1\\.2' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' MINUTE TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:x' MINUTE TO SECOND", "Illegal interval literal format '1:x' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL 'x:3' MINUTE TO SECOND", "Illegal interval literal format 'x:3' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1.x' MINUTE TO SECOND", "Illegal interval literal format '1:1\\.x' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' MINUTE(2) TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL MINUTE\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1' MINUTE(2) TO SECOND", "Illegal interval literal format '1 1' for INTERVAL MINUTE\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL 'bogus text' MINUTE TO SECOND", "Illegal interval literal format 'bogus text' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '7:8901' MINUTE TO SECOND(4)", "Illegal interval literal format '7:8901' for INTERVAL MINUTE TO SECOND\\(4\\)");
        this.checkWholeExpFails("INTERVAL '--1:1' MINUTE TO SECOND", "Illegal interval literal format '--1:1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:-1' MINUTE TO SECOND", "Illegal interval literal format '1:-1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1.-1' MINUTE TO SECOND", "Illegal interval literal format '1:1.-1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '100:0' MINUTE TO SECOND", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100:0' MINUTE(2) TO SECOND", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000:0' MINUTE(3) TO SECOND", "Interval field value 1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000:0' MINUTE(3) TO SECOND", "Interval field value -1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648:0' MINUTE(10) TO SECOND", "Interval field value 2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648:0' MINUTE(10) TO SECOND", "Interval field value -2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1:60' MINUTE TO SECOND", "Illegal interval literal format '1:60' for INTERVAL MINUTE TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1.0000001' MINUTE TO SECOND", "Illegal interval literal format '1:1\\.0000001' for INTERVAL MINUTE TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:1.0001' MINUTE TO SECOND(3)", "Illegal interval literal format '1:1:1\\.0001' for INTERVAL MINUTE TO SECOND\\(3\\).*");
        this.checkExpFails("INTERVAL '1:1' MINUTE(11) TO ^SECOND^", "Interval leading field precision '11' out of range for INTERVAL MINUTE\\(11\\) TO SECOND");
        this.checkExpFails("INTERVAL '1:1' MINUTE TO SECOND(10^)^", "Interval fractional second precision '10' out of range for INTERVAL MINUTE TO SECOND\\(10\\)");
        this.checkExpFails("INTERVAL '0:0' MINUTE(0) TO ^SECOND^", "Interval leading field precision '0' out of range for INTERVAL MINUTE\\(0\\) TO SECOND");
        this.checkExpFails("INTERVAL '0:0' MINUTE TO SECOND(0^)^", "Interval fractional second precision '0' out of range for INTERVAL MINUTE TO SECOND\\(0\\)");
    }

    public void subTestIntervalSecondNegative() {
        this.checkWholeExpFails("INTERVAL ':' SECOND", "Illegal interval literal format ':' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '.' SECOND", "Illegal interval literal format '\\.' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1-2' SECOND", "Illegal interval literal format '1-2' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1.x' SECOND", "Illegal interval literal format '1\\.x' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL 'x.1' SECOND", "Illegal interval literal format 'x\\.1' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 2' SECOND", "Illegal interval literal format '1 2' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:2' SECOND", "Illegal interval literal format '1:2' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1-2' SECOND(2)", "Illegal interval literal format '1-2' for INTERVAL SECOND\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' SECOND", "Illegal interval literal format 'bogus text' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '--1' SECOND", "Illegal interval literal format '--1' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1.-1' SECOND", "Illegal interval literal format '1.-1' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '100' SECOND", "Interval field value 100 exceeds precision of SECOND\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' SECOND(2)", "Interval field value 100 exceeds precision of SECOND\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' SECOND(3)", "Interval field value 1,000 exceeds precision of SECOND\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' SECOND(3)", "Interval field value -1,000 exceeds precision of SECOND\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' SECOND(10)", "Interval field value 2,147,483,648 exceeds precision of SECOND\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' SECOND(10)", "Interval field value -2,147,483,648 exceeds precision of SECOND\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1.0000001' SECOND", "Illegal interval literal format '1\\.0000001' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1.0000001' SECOND(2)", "Illegal interval literal format '1\\.0000001' for INTERVAL SECOND\\(2\\).*");
        this.checkWholeExpFails("INTERVAL '1.0001' SECOND(2, 3)", "Illegal interval literal format '1\\.0001' for INTERVAL SECOND\\(2, 3\\).*");
        this.checkWholeExpFails("INTERVAL '1.0000000001' SECOND(2, 9)", "Illegal interval literal format '1\\.0000000001' for INTERVAL SECOND\\(2, 9\\).*");
        this.checkExpFails("INTERVAL '1' SECOND(11^)^", "Interval leading field precision '11' out of range for INTERVAL SECOND\\(11\\)");
        this.checkExpFails("INTERVAL '1.1' SECOND(1, 10^)^", "Interval fractional second precision '10' out of range for INTERVAL SECOND\\(1, 10\\)");
        this.checkExpFails("INTERVAL '0' SECOND(0^)^", "Interval leading field precision '0' out of range for INTERVAL SECOND\\(0\\)");
        this.checkExpFails("INTERVAL '0' SECOND(1, 0^)^", "Interval fractional second precision '0' out of range for INTERVAL SECOND\\(1, 0\\)");
    }

    @Test
    public void testIntervalLiterals() {
        Assert.assertTrue((SqlTypeName.INTERVAL_YEAR_MONTH.getMinPrecision() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_DAY_TIME.getMinPrecision() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_YEAR_MONTH.getMaxPrecision() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_DAY_TIME.getMaxPrecision() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_YEAR_MONTH.getDefaultPrecision() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_DAY_TIME.getDefaultPrecision() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_YEAR_MONTH.getMinScale() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_DAY_TIME.getMinScale() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_YEAR_MONTH.getMaxScale() == 9 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_DAY_TIME.getMaxScale() == 9 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_YEAR_MONTH.getDefaultScale() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((SqlTypeName.INTERVAL_DAY_TIME.getDefaultScale() == 6 ? 1 : 0) != 0);
        this.subTestIntervalYearPositive();
        this.subTestIntervalYearToMonthPositive();
        this.subTestIntervalMonthPositive();
        this.subTestIntervalDayPositive();
        this.subTestIntervalDayToHourPositive();
        this.subTestIntervalDayToMinutePositive();
        this.subTestIntervalDayToSecondPositive();
        this.subTestIntervalHourPositive();
        this.subTestIntervalHourToMinutePositive();
        this.subTestIntervalHourToSecondPositive();
        this.subTestIntervalMinutePositive();
        this.subTestIntervalMinuteToSecondPositive();
        this.subTestIntervalSecondPositive();
        this.subTestIntervalYearNegative();
        this.subTestIntervalYearToMonthNegative();
        this.subTestIntervalMonthNegative();
        this.subTestIntervalDayNegative();
        this.subTestIntervalDayToHourNegative();
        this.subTestIntervalDayToMinuteNegative();
        this.subTestIntervalDayToSecondNegative();
        this.subTestIntervalHourNegative();
        this.subTestIntervalHourToMinuteNegative();
        this.subTestIntervalHourToSecondNegative();
        this.subTestIntervalMinuteNegative();
        this.subTestIntervalMinuteToSecondNegative();
        this.subTestIntervalSecondNegative();
        this.checkWholeExpFails("INTERVAL '1.0' HOUR", "Illegal interval literal format '1.0' for INTERVAL HOUR");
        this.checkExpType("INTERVAL '1.0' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '0999' MONTH(3)", "INTERVAL MONTH(3) NOT NULL");
    }

    @Test
    public void testIntervalOperators() {
        this.checkExpType("interval '1' hour + TIME '8:8:8'", "TIME(0) NOT NULL");
        this.checkExpType("TIME '8:8:8' - interval '1' hour", "TIME(0) NOT NULL");
        this.checkExpType("TIME '8:8:8' + interval '1' hour", "TIME(0) NOT NULL");
        this.checkExpType("interval '1' day + interval '1' DAY(4)", "INTERVAL DAY(4) NOT NULL");
        this.checkExpType("interval '1' day(5) + interval '1' DAY", "INTERVAL DAY(5) NOT NULL");
        this.checkExpType("interval '1' day + interval '1' HOUR(10)", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("interval '1' day + interval '1' MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("interval '1' day + interval '1' second", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1:2' hour to minute + interval '1' second", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("interval '1:3' hour to minute + interval '1 1:2:3.4' day to second", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1:2' hour to minute + interval '1 1' day to hour", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("interval '1:2' hour to minute + interval '1 1' day to hour", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("interval '1 2' day to hour + interval '1:1' minute to second", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1' year + interval '1' month", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("interval '1' day - interval '1' hour", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("interval '1' year - interval '1' month", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("interval '1' month - interval '1' year", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkWholeExpFails("interval '1' year + interval '1' day", "(?s).*Cannot apply '\\+' to arguments of type '<INTERVAL YEAR> \\+ <INTERVAL DAY>'.*");
        this.checkWholeExpFails("interval '1' month + interval '1' second", "(?s).*Cannot apply '\\+' to arguments of type '<INTERVAL MONTH> \\+ <INTERVAL SECOND>'.*");
        this.checkWholeExpFails("interval '1' year - interval '1' day", "(?s).*Cannot apply '-' to arguments of type '<INTERVAL YEAR> - <INTERVAL DAY>'.*");
        this.checkWholeExpFails("interval '1' month - interval '1' second", "(?s).*Cannot apply '-' to arguments of type '<INTERVAL MONTH> - <INTERVAL SECOND>'.*");
        this.checkExpType("interval '1' year * 2", "INTERVAL YEAR NOT NULL");
        this.checkExpType("1.234*interval '1 1:2:3' day to second ", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1' month / 0.1", "INTERVAL MONTH NOT NULL");
        this.checkExpType("interval '1-2' year TO month / 0.1e-9", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkWholeExpFails("1.234/interval '1 1:2:3' day to second", "(?s).*Cannot apply '/' to arguments of type '<DECIMAL.4, 3.> / <INTERVAL DAY TO SECOND>'.*");
    }

    @Test
    public void testNumericOperators() {
        this.checkExpType("- cast(1 as TINYINT)", "TINYINT NOT NULL");
        this.checkExpType("+ cast(1 as INT)", "INTEGER NOT NULL");
        this.checkExpType("- cast(1 as FLOAT)", "FLOAT NOT NULL");
        this.checkExpType("+ cast(1 as DOUBLE)", "DOUBLE NOT NULL");
        this.checkExpType("-1.643", "DECIMAL(4, 3) NOT NULL");
        this.checkExpType("+1.643", "DECIMAL(4, 3) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) + cast(5 as INTEGER)", "INTEGER NOT NULL");
        this.checkExpType("cast(null as SMALLINT) + cast(5 as BIGINT)", "BIGINT");
        this.checkExpType("cast(1 as REAL) + cast(5 as INTEGER)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) + cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as REAL) + cast(5 as REAL)", "REAL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as REAL)", "DOUBLE NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as DOUBLE)", "DOUBLE NOT NULL");
        this.checkExpType("cast(null as DECIMAL(5, 2)) + cast(1 as DOUBLE)", "DOUBLE");
        this.checkExpType("1.543 + 2.34", "DECIMAL(5, 3) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as BIGINT)", "DECIMAL(19, 2) NOT NULL");
        this.checkExpType("cast(1 as NUMERIC(5, 2)) + cast(1 as INTEGER)", "DECIMAL(13, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(null as SMALLINT)", "DECIMAL(8, 2)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as TINYINT)", "DECIMAL(6, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as DECIMAL(5, 2))", "DECIMAL(6, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as DECIMAL(6, 2))", "DECIMAL(7, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) + cast(1 as DECIMAL(6, 4))", "DECIMAL(7, 4) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(4, 2)) + cast(1 as DECIMAL(6, 4))", "DECIMAL(7, 4)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) + cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 2) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) - cast(5 as BIGINT)", "BIGINT NOT NULL");
        this.checkExpType("cast(null as INTEGER) - cast(5 as SMALLINT)", "INTEGER");
        this.checkExpType("cast(1 as INTEGER) - cast(5 as REAL)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) - cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as REAL) - cast(5 as REAL)", "REAL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as DOUBLE)", "DOUBLE NOT NULL");
        this.checkExpType("cast(null as DOUBLE) - cast(1 as DECIMAL)", "DOUBLE");
        this.checkExpType("1.543 - 24", "DECIMAL(14, 3) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5)) - cast(1 as BIGINT)", "DECIMAL(19, 0) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as INTEGER)", "DECIMAL(13, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(null as SMALLINT)", "DECIMAL(8, 2)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as TINYINT)", "DECIMAL(6, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as DECIMAL(7))", "DECIMAL(10, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as DECIMAL(6, 2))", "DECIMAL(7, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) - cast(1 as DECIMAL(6, 4))", "DECIMAL(7, 4) NOT NULL");
        this.checkExpType("cast(null as DECIMAL) - cast(1 as DECIMAL(6, 4))", "DECIMAL(19, 4)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) - cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 2) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) * cast(5 as INTEGER)", "INTEGER NOT NULL");
        this.checkExpType("cast(null as SMALLINT) * cast(5 as BIGINT)", "BIGINT");
        this.checkExpType("cast(1 as REAL) * cast(5 as INTEGER)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) * cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(1 as DECIMAL(7, 3)) * 1.654", "DECIMAL(11, 6) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(7, 3)) * cast (1.654 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as DECIMAL(5, 2)) * cast(1 as BIGINT)", "DECIMAL(19, 2)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as INTEGER)", "DECIMAL(15, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as SMALLINT)", "DECIMAL(10, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as TINYINT)", "DECIMAL(8, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as DECIMAL(5, 2))", "DECIMAL(10, 4) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as DECIMAL(6, 2))", "DECIMAL(11, 4) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) * cast(1 as DECIMAL(6, 4))", "DECIMAL(10, 6) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(4, 2)) * cast(1 as DECIMAL(6, 4))", "DECIMAL(10, 6)");
        this.checkExpType("cast(1 as DECIMAL(4, 10)) * cast(null as DECIMAL(6, 10))", "DECIMAL(10, 19)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) * cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 4) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) / cast(5 as INTEGER)", "INTEGER NOT NULL");
        this.checkExpType("cast(null as SMALLINT) / cast(5 as BIGINT)", "BIGINT");
        this.checkExpType("cast(1 as REAL) / cast(5 as INTEGER)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) / cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(1 as DECIMAL(7, 3)) / 1.654", "DECIMAL(15, 8) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(7, 3)) / cast (1.654 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as DECIMAL(5, 2)) / cast(1 as BIGINT)", "DECIMAL(19, 16)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as INTEGER)", "DECIMAL(16, 13) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as SMALLINT)", "DECIMAL(11, 8) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as TINYINT)", "DECIMAL(9, 6) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as DECIMAL(5, 2))", "DECIMAL(13, 8) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as DECIMAL(6, 2))", "DECIMAL(14, 9) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) / cast(1 as DECIMAL(6, 4))", "DECIMAL(15, 9) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(4, 2)) / cast(1 as DECIMAL(6, 4))", "DECIMAL(15, 9)");
        this.checkExpType("cast(1 as DECIMAL(4, 10)) / cast(null as DECIMAL(6, 19))", "DECIMAL(19, 6)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) / cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 0) NOT NULL");
    }

    @Test
    public void testFloorCeil() {
        this.checkExpType("floor(cast(null as tinyint))", "TINYINT");
        this.checkExpType("floor(1.2)", "DECIMAL(2, 0) NOT NULL");
        this.checkExpType("floor(1)", "INTEGER NOT NULL");
        this.checkExpType("floor(1.2e-2)", "DOUBLE NOT NULL");
        this.checkExpType("floor(interval '2' day)", "INTERVAL DAY NOT NULL");
        this.checkExpType("ceil(cast(null as bigint))", "BIGINT");
        this.checkExpType("ceil(1.2)", "DECIMAL(2, 0) NOT NULL");
        this.checkExpType("ceil(1)", "INTEGER NOT NULL");
        this.checkExpType("ceil(1.2e-2)", "DOUBLE NOT NULL");
        this.checkExpType("ceil(interval '2' second)", "INTERVAL SECOND NOT NULL");
    }

    protected void checkWin(String sql, String expectedMsgPattern) {
        LOGGER.info(sql);
        this.checkFails(sql, expectedMsgPattern);
    }

    public void checkWinClauseExp(String sql, String expectedMsgPattern) {
        sql = "select * from emp " + sql;
        this.checkWin(sql, expectedMsgPattern);
    }

    public void checkWinFuncExpWithWinClause(String sql, String expectedMsgPattern) {
        sql = "select " + sql + " from emp window w as (order by deptno)";
        this.checkWin(sql, expectedMsgPattern);
    }

    public void checkWinFuncExp(String sql, String expectedMsgPattern) {
        sql = "select " + sql + " from emp";
        this.checkWin(sql, expectedMsgPattern);
    }

    public void _testWinPartClause() {
        this.checkWinClauseExp("window w as (w2 order by deptno), w2 as (^rang^e 100 preceding)", "Referenced window cannot have framing declarations");
    }

    @Test
    public void testWindowFunctions() {
        this.checkWin("select *\n from emp\n where ^sum(sal) over (partition by deptno\n    order by empno\n    rows 3 preceding)^ > 10", "Windowed aggregate expression is illegal in WHERE clause");
        this.checkWin("select *\n from emp\n group by ename, ^sum(sal) over (partition by deptno\n    order by empno\n    rows 3 preceding)^ + 10\norder by deptno", "Windowed aggregate expression is illegal in GROUP BY clause");
        this.checkWin("select *\n from emp\n join dept on emp.deptno = dept.deptno\n and ^sum(sal) over (partition by deptno\n    order by empno\n    rows 3 preceding)^ = dept.deptno + 40\norder by deptno", "Windowed aggregate expression is illegal in ON clause");
        this.checkWin("select sal from emp order by sum(sal) over (partition by deptno order by deptno)", null);
        this.checkWinFuncExpWithWinClause("sum(sal)", null);
    }

    @Ignore
    @Test
    public void testWindowFunctions2() {
        this.checkWinFuncExpWithWinClause("^dense_rank()^", "Function 'DENSE_RANK\\(\\)' is not defined");
        this.checkWinFuncExpWithWinClause("^percent_rank()^", "Function 'PERCENT_RANK\\(\\)' is not defined");
        this.checkWinFuncExpWithWinClause("^rank()^", "Function 'RANK\\(\\)' is not defined");
        this.checkWinFuncExpWithWinClause("^cume_dist()^", "Function 'CUME_DIST\\(\\)' is not defined");
        this.checkWinFuncExpWithWinClause("^row_number()^", "Function 'ROW_NUMBER\\(\\)' is not defined");
        this.checkWinFuncExpWithWinClause("sum(^invalidColumn^)", "Column 'INVALIDCOLUMN' not found in any table");
        this.checkWinFuncExpWithWinClause("^invalidFun(sal)^", "No match found for function signature INVALIDFUN\\(<NUMERIC>\\)");
        this.checkWin("select sum(sal) over (w partition by ^deptno^)\n from emp window w as (order by empno rows 2 preceding )", "PARTITION BY not allowed with existing window reference");
        this.checkWin("select sum(sal) over (w order by ^empno^)\n from emp window w as (order by empno rows 2 preceding )", "ORDER BY not allowed in both base and referenced windows");
        this.checkWin("select sum(sal) over (w)\n from emp window w as (order by empno ^rows^ 2 preceding )", "Referenced window cannot have framing declarations");
    }

    @Test
    public void testInlineWinDef() {
        this.check("select sum(sal) over (partition by deptno order by empno) from emp order by empno");
        this.checkWinFuncExp("sum(sal) OVER (partition by deptno order by empno rows 2 preceding )", null);
        this.checkWinFuncExp("sum(sal) OVER (order by 1 rows 2 preceding )", null);
        this.checkWinFuncExp("sum(sal) OVER (order by 'b' rows 2 preceding )", null);
        this.checkWinFuncExp("sum(sal) over (partition by deptno order by 1+1 rows 26 preceding)", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno rows unbounded preceding)", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno rows current row)", null);
        this.checkWinFuncExp("sum(sal) over ^(order by deptno rows between unbounded preceding and unbounded following)^", "UNBOUNDED FOLLOWING window not supported");
        this.checkWinFuncExp("sum(sal) over ^(order by deptno rows between CURRENT ROW and unbounded following)^", "UNBOUNDED FOLLOWING window not supported");
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between unbounded preceding and CURRENT ROW)", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between CURRENT ROW and CURRENT ROW)", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno range between CURRENT ROW and CURRENT ROW)", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between 2 preceding and CURRENT ROW)", null);
        this.checkWinFuncExpWithWinClause("sum(sal) OVER (w rows 2 preceding )", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno range 2.0 preceding)", null);
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between ^UNBOUNDED FOLLOWING^ and unbounded preceding)", "UNBOUNDED FOLLOWING cannot be specified for the lower frame boundary");
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between 2 preceding and ^UNBOUNDED PRECEDING^)", "UNBOUNDED PRECEDING cannot be specified for the upper frame boundary");
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between CURRENT ROW and ^2 preceding^)", "Upper frame boundary cannot be PRECEDING when lower boundary is CURRENT ROW");
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between 2 following and ^CURRENT ROW^)", "Upper frame boundary cannot be CURRENT ROW when lower boundary is FOLLOWING");
        this.checkWinFuncExp("sum(sal) over (order by deptno rows between 2 following and ^2 preceding^)", "Upper frame boundary cannot be PRECEDING when lower boundary is FOLLOWING");
        this.checkWinFuncExp("sum(sal) over (order by deptno RANGE BETWEEN ^INTERVAL '1' SECOND^ PRECEDING AND INTERVAL '1' SECOND FOLLOWING)", "Data Type mismatch between ORDER BY and RANGE clause");
        this.checkWinFuncExp("sum(sal) over (order by empno RANGE BETWEEN ^INTERVAL '1' SECOND^ PRECEDING AND INTERVAL '1' SECOND FOLLOWING)", "Data Type mismatch between ORDER BY and RANGE clause");
        this.checkWinFuncExp("sum(sal) over (order by deptno, empno ^range^ 2 preceding)", "RANGE clause cannot be used with compound ORDER BY clause");
        this.checkWinFuncExp("sum(sal) over ^(partition by deptno range 5 preceding)^", "Window specification must contain an ORDER BY clause");
        this.checkWinFuncExp("sum(sal) over ^w1^", "Window 'W1' not found");
        this.checkWinFuncExp("sum(sal) OVER (^w1^ partition by deptno order by empno rows 2 preceding )", "Window 'W1' not found");
    }

    @Test
    public void testPartitionByExpr() {
        this.checkWinFuncExp("sum(sal) over (partition by empno + deptno order by empno range 5 preceding)", null);
        this.checkWinFuncExp("sum(sal) over (partition by ^empno + ename^ order by empno range 5 preceding)", "(?s)Cannot apply '\\+' to arguments of type '<INTEGER> \\+ <VARCHAR\\(20\\)>'.*");
    }

    @Test
    public void testWindowClause() {
        this.checkWinFuncExpWithWinClause("sum(sal) as sumsal", null);
        this.checkWinClauseExp("window w as (partition by sal order by deptno rows 2 preceding)", null);
        this.checkWinClauseExp("window w as (order by sal), w1 as (w)", null);
        this.checkWinClauseExp("window w as ^(range 100 preceding)^", "Window specification must contain an ORDER BY clause");
        this.checkWinClauseExp("window w as (order by sal range 100 preceding)", null);
        this.checkWinClauseExp("window w as (order by hiredate range ^100^ preceding)", "Data Type mismatch between ORDER BY and RANGE clause");
        this.checkWinClauseExp("window w as (order by ename range ^100^ preceding)", "Data type of ORDER BY prohibits use of RANGE clause");
        this.checkWinClauseExp("window w as (rows 2 preceding)", null);
        this.checkWinClauseExp("window w as (rows ^-2.5^ preceding)", "ROWS value must be a non-negative integral constant");
        this.checkWinClauseExp("window w as (rows ^-2^ preceding)", "ROWS value must be a non-negative integral constant");
        this.checkWinClauseExp("window w as (rows ^2.5^ preceding)", "ROWS value must be a non-negative integral constant");
        this.checkWinClauseExp("window w as (partition by ^xyz^)", "Column 'XYZ' not found in any table");
        this.checkWinClauseExp("window w as ^( /* boo! */  )^", "Window specification must contain an ORDER BY clause");
        this.checkWinClauseExp("window w as (order by empno), ^w^ as (order by empno)", "Duplicate window names not allowed");
        this.checkWinClauseExp("window win1 as (order by empno), ^win1^ as (order by empno)", "Duplicate window names not allowed");
        this.checkFails("select min(sal) over (order by deptno) from emp group by deptno,sal", null);
        this.checkFails("select min(sal) over (order by ^deptno^) from emp group by sal", "Expression 'DEPTNO' is not being grouped");
        this.checkFails("select min(sal) over\n(partition by comm order by deptno) from emp group by deptno,sal,comm", null);
        this.checkFails("select min(sal) over\n(partition by ^comm^ order by deptno) from emp group by deptno,sal", "Expression 'COMM' is not being grouped");
        this.checkWinClauseExp("window w as (order by rank() over (order by sal))", null);
        this.checkWinClauseExp("window w as (rows between ^unbounded following^ and 5 following)", "UNBOUNDED FOLLOWING cannot be specified for the lower frame boundary");
        this.checkWinClauseExp("window w as (order by deptno rows between 2 preceding and ^UNBOUNDED PRECEDING^)", "UNBOUNDED PRECEDING cannot be specified for the upper frame boundary");
        this.checkWinClauseExp("window w as (order by deptno rows between 2 following and ^2 preceding^)", "Upper frame boundary cannot be PRECEDING when lower boundary is FOLLOWING");
        this.checkWinClauseExp("window w as (order by deptno rows between CURRENT ROW and ^2 preceding^)", "Upper frame boundary cannot be PRECEDING when lower boundary is CURRENT ROW");
        this.checkWinClauseExp("window w as (order by deptno rows between 2 following and ^CURRENT ROW^)", "Upper frame boundary cannot be CURRENT ROW when lower boundary is FOLLOWING");
        this.checkWinClauseExp("window w as (w2 range 2 preceding ), w2 as (order by sal)", null);
        this.checkWinClauseExp("window w as ^(partition by sal)^, w2 as (w order by deptno)", "Window specification must contain an ORDER BY clause");
        this.checkWinClauseExp("window w as (w2 partition by ^sal^), w2 as (order by deptno)", "PARTITION BY not allowed with existing window reference");
        this.checkWinClauseExp("window w as (partition by sal order by deptno), w2 as (w order by ^deptno^)", "ORDER BY not allowed in both base and referenced windows");
        this.checkWinClauseExp("window w as (w2 order by deptno), w2 as (^range^ 100 preceding)", "Referenced window cannot have framing declarations");
        this.checkWinClauseExp("window w as (order by sal)", null);
        this.checkWinClauseExp("window w as (order by ^non_exist_col^)", "Column 'NON_EXIST_COL' not found in any table");
        this.checkWinClauseExp("window w as (partition by ^non_exist_col^ order by sal)", "Column 'NON_EXIST_COL' not found in any table");
    }

    @Test
    public void testWindowClause2() {
        this.checkWinClauseExp("window\nw  as (partition by deptno order by empno rows 2 preceding),\nw2 as ^(partition by deptno order by empno rows 2 preceding)^\n", "Duplicate window specification not allowed in the same window clause");
    }

    @Test
    public void testWindowClauseWithSubquery() {
        this.check("select * from\n( select sum(empno) over w, sum(deptno) over w from emp\nwindow w as (order by hiredate range interval '1' minute preceding))");
        this.check("select * from\n( select sum(empno) over w, sum(deptno) over w, hiredate from emp)\nwindow w as (order by hiredate range interval '1' minute preceding)");
        this.checkFails("select * from\n( select sum(empno) over w, sum(deptno) over w from emp)\nwindow w as (order by ^hiredate^ range interval '1' minute preceding)", "Column 'HIREDATE' not found in any table");
    }

    @Test
    public void testWindowNegative() {
        String negSize = "Window has negative size";
        this.checkNegWindow("rows between 2 preceding and 4 preceding", "Window has negative size");
        this.checkNegWindow("rows between 2 preceding and 3 preceding", "Window has negative size");
        this.checkNegWindow("rows between 2 preceding and 2 preceding", null);
        this.checkNegWindow("rows between unbounded preceding and current row", null);
        String unboundedFollowing = "UNBOUNDED FOLLOWING window not supported";
        this.checkNegWindow("rows between unbounded preceding and unbounded following", "UNBOUNDED FOLLOWING window not supported");
        this.checkNegWindow("rows between current row and unbounded following", "UNBOUNDED FOLLOWING window not supported");
        this.checkNegWindow("rows between current row and 2 following", null);
        this.checkNegWindow("range between 2 preceding and 2 following", null);
        this.checkNegWindow("range between 2 preceding and -2 preceding", null);
        this.checkNegWindow("range between 4 following and 3 following", "Window has negative size");
        this.checkNegWindow("range between 4 following and 5 following", null);
        this.checkNegWindow("rows between 1 following and 0 following", "Window has negative size");
        this.checkNegWindow("rows between 0 following and 0 following", null);
    }

    private void checkNegWindow(String s, String msg) {
        String sql = "select sum(deptno) over ^(order by empno " + s + ")^ from emp";
        this.checkFails(sql, msg);
    }

    @Test
    public void testWindowPartial() {
        this.check("select sum(deptno) over (\norder by deptno, empno rows 2 preceding disallow partial)\nfrom emp");
        this.checkFails("select sum(deptno) over (\n  partition by deptno\n  order by empno\n  range between 2 preceding and 3 following\n  ^disallow partial^)\nfrom emp", "Cannot use DISALLOW PARTIAL with window based on RANGE");
    }

    @Test
    public void testOneWinFunc() {
        this.checkWinClauseExp("window w as (partition by sal order by deptno rows 2 preceding)", null);
    }

    @Test
    public void testNameResolutionInValuesClause() {
        String emps = "(select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1)))";
        String depts = "(select 10 as deptno, 'Sales' as name from (values (1)))";
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) join (select 10 as deptno, 'Sales' as name from (values (1)))\n on ^emps^.deptno = deptno", "Table 'EMPS' not found");
        this.check("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e\n join (select 10 as deptno, 'Sales' as name from (values (1))) as d\n on e.deptno = d.deptno");
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as emps,\n (select 10 as deptno, 'Sales' as name from (values (1)))\nwhere ^deptno^ > 5", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e\n join (select 10 as deptno, 'Sales' as name from (values (1))) as d\n on e.deptno = ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e\n join (select 10 as deptno, 'Sales' as name from (values (1))) as d\n on e.deptno = age");
        this.check("select * from (select 10 as deptno, 'Sales' as name from (values (1)))\n join (select mod(age, 30) as agemod from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))))\non deptno = agemod");
        this.checkFails("select name from (select 10 as deptno, 'Sales' as name from (values (1)))\njoin (select mod(age, 30) as agemod, deptno from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))))\non ^deptno^ = agemod", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e,\n (select 1, ^e^.deptno from (values(true))) as d", "Table 'E' not found");
    }

    @Test
    public void testNestedFrom() {
        this.checkColumnType("values (true)", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (values(true))", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (select * from (values(true)))", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (select * from (select * from (values(true))))", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (  select * from (    select * from (values(true))    union    select * from (values (false)))  except  select * from (values(true)))", "BOOLEAN NOT NULL");
    }

    @Test
    public void testAmbiguousColumn() {
        this.checkFails("select * from emp join dept\n on emp.deptno = ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select * from emp as e\n join dept as d\n on e.deptno = d.deptno");
        this.checkFails("select * from emp as emps, dept\nwhere ^deptno^ > 5", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from emp as emps, dept as d\nwhere ^dept^.deptno > 5", "Table 'DEPT' not found");
        this.checkFails("select * from emp as e\n join dept as d\n on e.deptno = ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select * from emp as e\n join dept as d\n on e.deptno = comm");
        this.check("select * from dept\n join (select mod(comm, 30) as commmod from emp)\non deptno = commmod");
        this.checkFails("select name from dept\njoin (select mod(comm, 30) as commmod, deptno from emp)\non ^deptno^ = commmod", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from emp as e,\n (select 1, ^e^.deptno from (values(true))) as d", "Table 'E' not found");
    }

    @Test
    public void testExpandStar() {
        this.checkFails("select ^r^.* from dept", "Unknown identifier 'R'");
        this.check("select e.* from emp as e");
        this.check("select emp.* from emp");
        this.checkFails("select ^empno^ .  * from emp", "Unknown identifier 'EMPNO'");
    }

    @Test
    public void testAsColumnList() {
        this.check("select d.a, b from dept as d(a, b)");
        this.checkFails("select d.^deptno^ from dept as d(a, b)", "(?s).*Column 'DEPTNO' not found in table 'D'.*");
        this.checkFails("select 1 from dept as d(^a^, b, c)", "(?s).*List of column aliases must have same degree as table; table has 2 columns \\('DEPTNO', 'NAME'\\), whereas alias list has 3 columns.*");
        this.checkResultType("select * from dept as d(a, b)", "RecordType(INTEGER NOT NULL A, VARCHAR(10) NOT NULL B) NOT NULL");
        this.checkResultType("select * from (values ('a', 1), ('bc', 2)) t (a, b)", "RecordType(CHAR(2) NOT NULL A, INTEGER NOT NULL B) NOT NULL");
    }

    public void _testAmbiguousColumnInIn() {
        this.check("select * from emp as e\nwhere e.deptno in (\n  select 1 from (values(true)) where e.empno > 10)");
        this.check("select * from emp as e\nwhere e.deptno in (\n  select e.deptno from (values(true)))");
    }

    @Test
    public void testInList() {
        this.check("select * from emp where empno in (10,20)");
        this.check("select * from emp where empno in (10 + deptno, cast(null as integer))");
        this.checkFails("select * from emp where empno in ^(10, '20')^", ERR_IN_VALUES_INCOMPATIBLE);
        this.checkExpType("1 in (2, 3, 4)", "BOOLEAN NOT NULL");
        this.checkExpType("cast(null as integer) in (2, 3, 4)", "BOOLEAN");
        this.checkExpType("1 in (2, cast(null as integer) , 4)", "BOOLEAN");
        this.checkExpType("1 in (2.5, 3.14)", "BOOLEAN NOT NULL");
        this.checkExpType("true in (false, unknown)", "BOOLEAN");
        this.checkExpType("true in (false, false or unknown)", "BOOLEAN");
        this.checkExpType("true in (false, true)", "BOOLEAN NOT NULL");
        this.checkExpType("(1,2) in ((1,2), (3,4))", "BOOLEAN NOT NULL");
        this.checkExpType("'medium' in (cast(null as varchar(10)), 'bc')", "BOOLEAN");
        this.checkColumnType("select empno in (1, 2) from emp", "BOOLEAN NOT NULL");
        this.checkColumnType("select nullif(empno,empno) in (1, 2) from emp", "BOOLEAN");
        this.checkColumnType("select empno in (1, nullif(empno,empno), 2) from emp", "BOOLEAN");
        this.checkExpFails("1 in ^(2, 'c')^", ERR_IN_VALUES_INCOMPATIBLE);
        this.checkExpFails("1 in ^((2), (3,4))^", ERR_IN_VALUES_INCOMPATIBLE);
        this.checkExpFails("false and ^1 in ('b', 'c')^", ERR_IN_OPERANDS_INCOMPATIBLE);
        this.checkExpFails("1 > 5 ^or (1, 2) in (3, 4)^", ERR_IN_OPERANDS_INCOMPATIBLE);
    }

    @Test
    public void testInSubquery() {
        this.check("select * from emp where deptno in (select deptno from dept)");
        this.check("select * from emp where (empno,deptno) in (select deptno,deptno from dept)");
        this.checkFails("select * from emp where ^deptno in (select deptno,deptno from dept^)", ERR_IN_OPERANDS_INCOMPATIBLE);
    }

    @Test
    public void testDoubleNoAlias() {
        this.check("select * from emp join dept on true");
        this.check("select * from emp, dept");
        this.check("select * from emp cross join dept");
    }

    @Test
    public void testDuplicateColumnAliasIsOK() {
        this.check("select 1 as a, 2 as b, 3 as a from emp");
    }

    @Test
    public void testDuplicateTableAliasFails() {
        this.checkFails("select 1 from emp, ^emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp join ^emp^ on emp.empno = emp.mgrno", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp join ^dept as emp^ on emp.empno = emp.deptno", "Duplicate relation name 'EMP' in FROM clause");
        this.check("select 1 from emp as e join emp on emp.empno = e.deptno");
        this.check("select 1 from emp as e join dept as emp on e.empno = emp.deptno");
        this.checkFails("select 1 from emp, dept, emp as e, ^dept as emp^, emp", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, (^select 1 as x from (values (true))) as emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, (^values (true,false)) as emp (b, c)^, dept as emp", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, ^table(foo()) as emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, ^(table foo.bar.emp) as emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.check("select 1 from emp, dept where exists (\n  select 1 from emp where emp.empno = emp.deptno)");
    }

    @Test
    public void testInvalidGroupBy() {
        this.checkFails("select ^empno^, deptno from emp group by deptno", "Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testSumInvalidArgs() {
        this.checkFails("select ^sum(ename)^, deptno from emp group by deptno", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<VARCHAR\\(20\\)>\\)'\\. .*");
    }

    @Test
    public void testSumTooManyArgs() {
        this.checkFails("select ^sum(empno, deptno)^, deptno from emp group by deptno", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments");
    }

    @Test
    public void testSumTooFewArgs() {
        this.checkFails("select ^sum()^, deptno from emp group by deptno", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments");
    }

    @Test
    public void testSingleNoAlias() {
        this.check("select * from emp");
    }

    @Test
    public void testObscuredAliasFails() {
        this.checkFails("select * from emp as e where exists (\n  select 1 from dept where dept.deptno = ^emp^.deptno)", "Table 'EMP' not found");
    }

    @Test
    public void testFromReferenceFails() {
        this.checkFails("select * from emp as e1 where exists (\n  select * from emp as e2,\n    (select * from dept where dept.deptno = ^e2^.deptno))", "Table 'E2' not found");
    }

    @Test
    public void testWhereReference() {
        this.check("select * from emp as e1 where exists (\n  select * from emp as e2,\n    (select * from dept where dept.deptno = e1.deptno))");
    }

    @Test
    public void testUnionNameResolution() {
        this.checkFails("select * from emp as e1 where exists (\n  select * from emp as e2,\n  (select deptno from dept as d\n   union\n   select deptno from emp as e3 where deptno = ^e2^.deptno))", "Table 'E2' not found");
        this.checkFails("select * from emp\nunion\nselect * from dept where ^empno^ < 10", "Column 'EMPNO' not found in any table");
    }

    @Test
    public void testUnionCountMismatchFails() {
        this.checkFails("select 1,2 from emp\nunion\nselect ^3^ from dept", "Column count mismatch in UNION");
    }

    @Test
    public void testUnionCountMismatcWithValuesFails() {
        this.checkFails("select * from ( values (1))\nunion\nselect ^*^ from ( values (1,2))", "Column count mismatch in UNION");
        this.checkFails("select * from ( values (1))\nunion\nselect ^*^ from emp", "Column count mismatch in UNION");
        this.checkFails("select * from emp\nunion\nselect ^*^ from ( values (1))", "Column count mismatch in UNION");
    }

    @Test
    public void testUnionTypeMismatchFails() {
        this.checkFails("select 1, ^2^ from emp union select deptno, name from dept", "Type mismatch in column 2 of UNION");
        this.checkFails("select ^slacker^ from emp union select name from dept", "Type mismatch in column 1 of UNION");
    }

    @Test
    public void testUnionTypeMismatchWithStarFails() {
        this.checkFails("select ^*^ from dept union select 1, 2 from emp", "Type mismatch in column 2 of UNION");
        this.checkFails("select ^dept.*^ from dept union select 1, 2 from emp", "Type mismatch in column 2 of UNION");
    }

    @Test
    public void testUnionTypeMismatchWithValuesFails() {
        this.checkFails("values (1, ^2^, 3), (3, 4, 5), (6, 7, 8) union\nselect deptno, name, deptno from dept", "Type mismatch in column 2 of UNION");
        this.checkFails("select 1 from (values (^'x'^)) union\nselect 'a' from (values ('y'))", "Type mismatch in column 1 of UNION");
        this.checkFails("select 1 from (values (^'x'^)) union\n(values ('a'))", "Type mismatch in column 1 of UNION");
    }

    @Test
    public void testValuesTypeMismatchFails() {
        this.checkFails("^values (1), ('a')^", "Values passed to VALUES operator must have compatible types");
    }

    @Test
    public void testNaturalCrossJoinFails() {
        this.checkFails("select * from emp natural cross ^join^ dept", "Cannot specify condition \\(NATURAL keyword, or ON or USING clause\\) following CROSS JOIN");
    }

    @Test
    public void testCrossJoinUsingFails() {
        this.checkFails("select * from emp cross join dept ^using (deptno)^", "Cannot specify condition \\(NATURAL keyword, or ON or USING clause\\) following CROSS JOIN");
    }

    @Test
    public void testJoinUsing() {
        this.check("select * from emp join dept using (deptno)");
        this.checkFails("select * from emp join dept using (deptno, ^comm^)", "Column 'COMM' not found in any table");
        this.check("select * from emp join dept using (deptno, deptno)");
        this.checkFails("select * from dept where exists (\nselect 1 from emp join bonus using (^dname^))", "Column 'DNAME' not found in any table");
        this.checkFails("select * from dept where exists (\nselect 1 from emp join bonus using (^deptno^))", "Column 'DEPTNO' not found in any table");
    }

    @Test
    public void testCrossJoinOnFails() {
        this.checkFails("select * from emp cross join dept\n ^on emp.deptno = dept.deptno^", "Cannot specify condition \\(NATURAL keyword, or ON or USING clause\\) following CROSS JOIN");
    }

    @Test
    public void testInnerJoinWithoutUsingOrOnFails() {
        this.checkFails("select * from emp inner ^join^ dept\nwhere emp.deptno = dept.deptno", "INNER, LEFT, RIGHT or FULL join requires a condition \\(NATURAL keyword or ON or USING clause\\)");
    }

    @Test
    public void testNaturalJoinWithOnFails() {
        this.checkFails("select * from emp natural join dept on ^emp.deptno = dept.deptno^", "Cannot specify NATURAL keyword with ON or USING clause");
    }

    @Test
    public void testNaturalJoinWithUsing() {
        this.checkFails("select * from emp natural join dept ^using (deptno)^", "Cannot specify NATURAL keyword with ON or USING clause");
    }

    @Test
    public void testNaturalJoinIncompatibleDatatype() {
        this.checkFails("select * from emp natural ^join^\n(select deptno, name as sal from dept)", "Column 'SAL' matched using NATURAL keyword or USING clause has incompatible types: cannot compare 'INTEGER' to 'VARCHAR\\(10\\)'");
        this.check("select * from emp natural join\n (select deptno, name as sal, 'foo' as sal from dept)");
    }

    @Test
    public void testJoinUsingIncompatibleDatatype() {
        this.checkFails("select * from emp join (select deptno, name as sal from dept) using (deptno, ^sal^)", "Column 'SAL' matched using NATURAL keyword or USING clause has incompatible types: cannot compare 'INTEGER' to 'VARCHAR\\(10\\)'");
    }

    @Test
    public void testJoinUsingInvalidColsFails() {
        this.checkFails("select * from emp left join dept using (^gender^)", "Column 'GENDER' not found in any table");
    }

    @Test
    public void testJoinUsingDupColsFails() {
        this.checkFails("select * from emp left join (select deptno, name as deptno from dept) using (^deptno^)", "Column name 'DEPTNO' in USING clause is not unique on one side of join");
    }

    @Test
    public void testJoinRowType() {
        this.checkResultType("select * from emp left join dept on emp.deptno = dept.deptno", "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER NOT NULL MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER, INTEGER DEPTNO0, VARCHAR(10) NAME) NOT NULL");
        this.checkResultType("select * from emp right join dept on emp.deptno = dept.deptno", "RecordType(INTEGER EMPNO, VARCHAR(20) ENAME, VARCHAR(10) JOB, INTEGER MGR, TIMESTAMP(0) HIREDATE, INTEGER SAL, INTEGER COMM, INTEGER DEPTNO, BOOLEAN SLACKER, INTEGER NOT NULL DEPTNO0, VARCHAR(10) NOT NULL NAME) NOT NULL");
        this.checkResultType("select * from emp full join dept on emp.deptno = dept.deptno", "RecordType(INTEGER EMPNO, VARCHAR(20) ENAME, VARCHAR(10) JOB, INTEGER MGR, TIMESTAMP(0) HIREDATE, INTEGER SAL, INTEGER COMM, INTEGER DEPTNO, BOOLEAN SLACKER, INTEGER DEPTNO0, VARCHAR(10) NAME) NOT NULL");
    }

    public void _testJoinUsing() {
        this.check("select * from (emp join bonus using (job))\njoin dept using (deptno)");
        this.checkFails("select * from (emp join bonus using (job)) as x\njoin dept using (deptno)", "as wrong here");
        this.checkFails("select * from (emp join bonus using (job))\njoin dept using (^dname^)", "dname not found in lhs");
        this.checkFails("select * from (emp join bonus using (job))\njoin (select 1 as job from (true)) using (job)", "ambig");
    }

    @Ignore(value="bug: should fail if subquery does not have alias")
    @Test
    public void testJoinSubquery() {
        this.checkFails("select * from (select 1 as one from emp)\njoin (values (1), (2)) on true", "require alias");
    }

    @Test
    public void testJoinUsingThreeWay() {
        this.check("select *\nfrom emp as e\njoin dept as d using (deptno)\njoin emp as e2 using (empno)");
        this.checkFails("select *\nfrom emp as e\njoin dept as d using (deptno)\njoin dept as d2 using (^deptno^)", "Column name 'DEPTNO' in USING clause is not unique on one side of join");
    }

    @Test
    public void testWhere() {
        this.checkFails("select * from emp where ^sal^", "WHERE clause must be a condition");
    }

    @Test
    public void testOn() {
        this.checkFails("select * from emp e1 left outer join emp e2 on ^e1.sal^", "ON clause must be a condition");
    }

    @Test
    public void testHaving() {
        this.checkFails("select * from emp having ^sum(sal)^", "HAVING clause must be a condition");
        this.checkFails("select ^*^ from emp having sum(sal) > 10", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.check("select sum(sal + sal) from emp having sum(sal) > 10");
        this.checkFails("SELECT deptno FROM emp GROUP BY deptno HAVING ^sal^ > 10", "Expression 'SAL' is not being grouped");
    }

    @Test
    public void testHavingBetween() {
        this.check("select deptno from emp group by deptno having deptno between 10 and 12");
        this.check("select deptno from emp group by deptno having deptno + 5 > 10");
    }

    @Test
    public void testWith() {
        this.checkResultType("with emp2 as (select * from emp)\nselect * from emp2", EMP_RECORD_TYPE);
        this.checkFails("with emp2 ^(x, y)^ as (select * from emp)\nselect * from emp2", "Number of columns must match number of query columns");
        this.checkFails("with emp2 (x, y, ^y^, x) as (select sal, deptno, ename, empno from emp)\nselect * from emp2", "Duplicate name 'Y' in column list");
        this.checkFails("with emp2 as (^select empno as e, sal, deptno as e from emp^)\nselect * from emp2", "Column has duplicate column name 'E' and no column list specified");
        this.checkFails("with emp3 as (select * from ^emp2^),\n emp2 as (select * from emp)\nselect * from emp3", "Table 'EMP2' not found");
        this.checkFails("with emp3 as (select * from ^emp2^),\n emp2 as (select * from emp)\nselect * from emp2", "Table 'EMP2' not found");
        this.checkResultType("with emp2 as (select * from emp),\n emp3 as (select * from emp2)\nselect * from emp2", EMP_RECORD_TYPE);
        this.checkFails("with emp2 as (select * from emp),\n emp3 as (select * from ^emp3^)\nvalues (1)", "Table 'EMP3' not found");
        this.checkFails("with emp2 as (select * from ^emp2^)\nselect * from emp2 where false", "Table 'EMP2' not found");
        this.checkResultType("with emp2 as (select * from emp),\n dept2 as (select * from dept),\n empDept as (select emp2.empno, dept2.deptno from dept2 join emp2 using (deptno))\nselect 1 as one from empDept", "RecordType(INTEGER NOT NULL ONE) NOT NULL");
    }

    @Test
    public void testWithUnion() {
        this.checkResultType("with emp2 as (select * from emp)\nselect * from emp2 union all select * from emp", EMP_RECORD_TYPE);
    }

    @Test
    public void testWithSubquery() {
        this.checkResultType("with emp2 as (select * from emp)\n(\n  with dept2 as (select * from dept)\n  (\n    with empDept as (select emp2.empno, dept2.deptno from dept2 join emp2 using (deptno))\n    select 1 as one from empDept))", "RecordType(INTEGER NOT NULL ONE) NOT NULL");
        this.checkResultType("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)", EMP_RECORD_TYPE);
        this.checkFails("select * from emp\njoin (\n  with dept2 as (select * from dept where dept.deptno >= ^emp^.deptno)\n  select * from dept2) as d on true", "Table 'EMP' not found");
        this.checkFails("select * from emp\njoin (\n  with dept2 as (select * from dept where dept.deptno >= ^emp^.deptno)\n  select * from dept2) as d using (deptno)", "Table 'EMP' not found");
        this.checkResultType("select e.empno, d.* from emp as e\njoin (\n  with dept2 as (select * from dept where dept.deptno > 10)\n  select deptno, 1 as one from dept2) as d using (deptno)", "RecordType(INTEGER NOT NULL EMPNO, INTEGER NOT NULL DEPTNO, INTEGER NOT NULL ONE) NOT NULL");
        this.checkFails("select ^e^.empno, d.* from emp\njoin (\n  with dept2 as (select * from dept where dept.deptno > 10)\n  select deptno, 1 as one from dept2) as d using (deptno)", "Table 'E' not found");
    }

    @Test
    public void testLarge() {
        int x = 700;
        if (System.getProperty("os.name").startsWith("Windows")) {
            x /= 3;
        }
        String large = this.list(" + ", "deptno * ", x);
        this.check("select " + large + "from emp");
        this.check("select distinct " + large + "from emp");
        this.check("select " + large + " from emp " + "group by deptno");
        this.check("select * from emp where " + large + " > 5");
        this.check("select * from emp order by " + large + " desc");
        this.check("select " + large + " from emp order by 1");
        this.check("select distinct " + large + " from emp order by " + large);
        this.check("select * from emp where deptno in (" + this.list(", ", "", x) + ")");
        this.check("select * from emp where " + this.list(" or ", "deptno = ", x));
        this.check("select " + this.list(", ", "x", x) + " from (select " + this.list(", ", "'a' as x", x) + " from emp " + "union all select " + this.list(", ", "'bb' as x", x) + " from dept)");
    }

    private String list(String sep, String before, int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            buf.append(before).append(i);
        }
        return buf.toString();
    }

    @Test
    public void testOrder() {
        SqlConformance conformance = this.tester.getConformance();
        this.check("select empno as x from emp order by empno");
        this.checkFails("select empno, sal from emp order by ^asc^", "Column 'ASC' not found in any table");
        this.checkFails("select empno as x from emp order by empno", conformance.isSortByAliasObscures() ? "unknown column empno" : null);
        this.checkFails("select empno as x from emp order by ^x^", conformance.isSortByAlias() ? null : "Column 'X' not found in any table");
        this.checkFails("select empno as x from emp order by ^10^", conformance.isSortByOrdinal() ? "Ordinal out of range" : null);
        this.check("select empno + 1 as empno from emp order by empno");
        this.checkFails("select empno as x from emp, dept order by ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select empno + 1 from emp order by deptno asc, empno + 1 desc");
        this.checkFails("select empno as deptno from emp, dept order by deptno", conformance.isSortByAlias() ? null : "col ambig");
        this.check("select deptno from dept\nunion\nselect empno from emp\norder by deptno");
        this.checkFails("select deptno from dept\nunion\nselect empno from emp\norder by ^empno^", "Column 'EMPNO' not found in any table");
        this.checkFails("select deptno from dept\nunion\nselect empno from emp\norder by ^10^", conformance.isSortByOrdinal() ? "Ordinal out of range" : null);
        this.check("select * from emp\norder by (select name from dept where deptno = emp.deptno)");
        this.checkFails("select * from emp\norder by (select name from dept where deptno = emp.^foo^)", "Column 'FOO' not found in table 'EMP'");
        this.check("select * from emp order by empno");
        this.checkFails("select * from emp order by ^nonExistent^, deptno", "Column 'NONEXISTENT' not found in any table");
        this.checkFails("select 'foo' as empno from emp order by ^empno + 5^", "(?s)Cannot apply '\\+' to arguments of type '<CHAR\\(3\\)> \\+ <INTEGER>'\\..*");
    }

    @Test
    public void testOrderUnion() {
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by empno");
        this.checkFails("select empno, sal from emp union all select deptno, deptno from dept order by ^asc^", "Column 'ASC' not found in any table");
        this.checkFails("select empno, sal from emp union all select deptno, deptno from dept order by ^ename^ desc", "Column 'ENAME' not found in any table");
        this.checkFails("select deptno, deptno from dept union all select empno, sal from emp order by deptno asc, ^empno^", "Column 'EMPNO' not found in any table");
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by 2");
        if (this.tester.getConformance().isSortByOrdinal()) {
            this.checkFails("select empno, sal from emp union all select deptno, deptno from dept order by ^3^", "Ordinal out of range");
        }
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by empno * sal + 2");
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by 'foobar'");
    }

    @Test
    public void testOrderGroup() {
        this.checkFails("select 1 from emp group by deptno order by ^empno^", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.check("select empno from emp group by empno, deptno order by deptno * sum(sal + 2)");
        this.checkFails("select sum(sal) from emp having count(*) > 3 order by ^empno^", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.check("select sum(sal) from emp having count(*) > 3 order by sum(deptno)");
        this.checkFails("select distinct deptno from emp group by deptno order by ^empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct deptno from emp group by deptno order by deptno, ^empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.check("select distinct deptno from emp group by deptno order by deptno");
        this.check("select distinct deptno from dept union all select empno from emp group by deptno, empno order by deptno");
        this.check("select empno as x from emp group by empno, deptno order by x * sum(sal + 2)");
        this.checkFails("select empno as x from emp group by empno, deptno order by empno * sum(sal + 2)", this.tester.getConformance().isSortByAliasObscures() ? "xxxx" : null);
        this.checkFails("select distinct cast(empno as bigint) from emp order by ^empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) from emp order by ^emp.empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) as empno from emp order by ^emp.empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) as empno from emp as e order by ^e.empno^", "Expression 'E\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) as empno from emp order by ^empno^", this.tester.getConformance().isSortByAlias() ? null : "Expression 'EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) as eno from emp order by ^eno^", this.tester.getConformance().isSortByAlias() ? null : "Column 'ENO' not found in any table");
        this.checkFails("select distinct cast(empno as bigint) as empno from emp e order by ^empno^", this.tester.getConformance().isSortByAlias() ? null : "Expression 'EMPNO' is not in the select clause");
        if (this.tester.getConformance().isSortByOrdinal()) {
            this.check("select distinct cast(empno as bigint) from emp order by 1");
            this.check("select distinct cast(empno as bigint) as empno from emp order by 1");
            this.check("select distinct cast(empno as bigint) as empno from emp as e order by 1");
        }
        this.check("select distinct cast(empno as varchar(10)) from emp order by cast(empno as varchar(10))");
        this.checkFails("select distinct cast(empno as varchar(10)) as eno from emp  order by upper(^eno^)", this.tester.getConformance().isSortByAlias() ? null : "Column 'ENO' not found in any table");
    }

    @Test
    public void testGroup() {
        this.checkFails("select empno from emp where ^sum(sal)^ > 50", "Aggregate expression is illegal in WHERE clause");
        this.checkFails("select ^empno^ from emp group by deptno", "Expression 'EMPNO' is not being grouped");
        this.checkFails("select ^*^ from emp group by deptno", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.check("select * from (select empno,deptno from emp) group by deptno,empno");
        this.check("select deptno\nfrom emp\ngroup by deptno\nhaving exists (select sum(emp.sal) > 10 from (values(true)))");
        this.check("select deptno from emp group by deptno having exists (select 1 from (values(true)) where emp.deptno = 10)");
        this.check("select cast(1 as integer) + 2 from emp group by deptno");
        this.check("select localtime, deptno + 3 from emp group by deptno");
    }

    @Test
    public void testGroupByCorrelatedColumnFails() {
        this.checkFails("select count(*)\nfrom emp\nwhere exists (select count(*) from dept group by ^emp^.empno)", "Table 'EMP' not found");
    }

    @Test
    public void testGroupExpressionEquivalence() {
        this.check("select empno + 1 from emp group by empno + 1");
        this.checkFails("select 1 + ^empno^ from emp group by empno + 1", "Expression 'EMPNO' is not being grouped");
        this.check("select cast(empno as VARCHAR(10)) from emp group by cast(empno as VARCHAR(10))");
        this.checkFails("select cast(^empno^ as VARCHAR(11)) from emp group by cast(empno as VARCHAR(10))", "Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testGroupExpressionEquivalenceId() {
        this.check("select case empno when 10 then deptno else null end from emp group by case empno when 10 then deptno else null end");
        this.check("select case empno when 10 then deptno else null end from emp group by case empno when 10 then emp.deptno else null end");
        this.check("select case empno when 10 then deptno else null end from emp group by case emp.empno when 10 then emp.deptno else null end");
        this.check("select case emp.empno when 10 then deptno else null end from emp group by case empno when 10 then emp.deptno else null end");
        this.checkFails("select case ^emp.empno^ when 10 then emp.deptno else null end from emp join dept on emp.deptno = dept.deptno group by case emp.empno when 10 then dept.deptno else null end", "Expression 'EMP\\.EMPNO' is not being grouped");
    }

    public void _testGroupExpressionEquivalenceCorrelated() {
        this.check("select * from dept where exists (select dname from emp group by empno)");
        this.check("select * from dept where exists (select dname + empno + 1 from emp group by empno, dept.deptno)");
    }

    public void _testGroupExpressionEquivalenceParams() {
        this.check("select cast(? as integer) from emp group by cast(? as integer)");
    }

    @Test
    public void testGroupExpressionEquivalenceLiteral() {
        this.check("select case empno when 10 then date '1969-04-29' else null end from emp group by case empno when 10 then date '1969-04-29' else null end");
        this.checkFails("select case ^empno^ when 10 then 1 else null end from emp group by case empno when 10 then 1.0 else null end", "Expression 'EMPNO' is not being grouped");
        this.checkFails("select case ^empno^ when 10 then 3.1415 else null end from emp group by case empno when 10 then 3.14150 else null end", "Expression 'EMPNO' is not being grouped");
        this.check("select case empno when 10 then 03 else null end from emp group by case empno when 10 then 3 else null end");
        this.checkFails("select case ^empno^ when 10 then 1 else null end from emp group by case empno when 10 then 2 else null end", "Expression 'EMPNO' is not being grouped");
        this.check("select case empno when 10 then timestamp '1969-04-29 12:34:56.0' else null end from emp group by case empno when 10 then timestamp '1969-04-29 12:34:56' else null end");
    }

    @Test
    public void testGroupExpressionEquivalenceStringLiteral() {
        this.check("select case empno when 10 then 'foo bar' else null end from emp group by case empno when 10 then 'foo bar' else null end");
        this.checkFails("select case ^empno^ when 10 then _iso-8859-1'foo bar' else null end from emp group by case empno when 10 then _UTF16'foo bar' else null end", "Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testGroupAgg() {
        this.check("select deptno as d, count(*) as c from emp group by deptno");
    }

    @Test
    public void testNestedAggFails() {
        this.checkFails("select ^sum(max(empno))^ from emp", ERR_NESTED_AGG);
        this.checkFails("select ^sum(2*max(empno))^ from emp", ERR_NESTED_AGG);
        this.checkFails("select ^sum(max(empno))^ from emp group by deptno", ERR_NESTED_AGG);
        this.checkFails("select count(*) from emp group by deptno having ^sum(max(empno))^=3", ERR_NESTED_AGG);
        this.checkFails("select sum(^max(min(empno))^) from emp", ERR_NESTED_AGG);
        this.checkFails("select ^sum(max(empno)) OVER^ (order by deptno ROWS 2 PRECEDING) from emp", ERR_NESTED_AGG);
        this.checkFails("select ^sum(max(empno) OVER (order by deptno ROWS 2 PRECEDING))^ from emp", ERR_NESTED_AGG);
    }

    @Test
    public void testAggregateInGroupByFails() {
        this.checkFails("select count(*) from emp group by ^sum(empno)^", ERR_AGG_IN_GROUP_BY);
    }

    @Test
    public void testAggregateInNonGroupBy() {
        this.checkFails("select count(1), ^empno^ from emp", "Expression 'EMPNO' is not being grouped");
        this.checkColumnType("select count(*) from emp", "BIGINT NOT NULL");
        this.checkColumnType("select count(deptno) from emp", "BIGINT NOT NULL");
        this.checkColumnType("select sum(deptno) from emp", "INTEGER");
        this.checkColumnType("select sum(deptno) from emp group by ()", "INTEGER");
        this.checkColumnType("select sum(deptno) from emp group by empno", "INTEGER NOT NULL");
    }

    @Test
    public void testAggregateInOrderByFails() {
        this.checkFails("select empno from emp order by ^sum(empno)^", ERR_AGG_IN_ORDER_BY);
        this.check("select sum(empno) from emp group by deptno order by sum(empno)");
        this.check("select sum(empno) from emp order by sum(empno)");
    }

    @Test
    public void testCorrelatingVariables() {
        this.check("select * from emp where exists (\nselect * from dept where deptno = sal)");
        this.check("select * from emp where exists (\nselect * from dept where deptno = emp.sal)");
    }

    @Test
    public void testIntervalCompare() {
        this.checkExpType("interval '1' hour = interval '1' day", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' hour <> interval '1' hour", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' hour < interval '1' second", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' hour <= interval '1' minute", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' minute > interval '1' second", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' second >= interval '1' day", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' year >= interval '1' year", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' month = interval '1' year", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' month <> interval '1' month", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' year >= interval '1' month", "BOOLEAN NOT NULL");
        this.checkWholeExpFails("interval '1' second >= interval '1' year", "(?s).*Cannot apply '>=' to arguments of type '<INTERVAL SECOND> >= <INTERVAL YEAR>'.*");
        this.checkWholeExpFails("interval '1' month = interval '1' day", "(?s).*Cannot apply '=' to arguments of type '<INTERVAL MONTH> = <INTERVAL DAY>'.*");
    }

    @Test
    public void testOverlaps() {
        this.checkExpType("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
        this.checkExp("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', interval '1' year)");
        this.checkExp("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', time '1:2:3')");
        this.checkExp("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)");
        this.checkWholeExpFails("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (time '4:5:6', interval '1 2:3:4.5' day to second)", "(?s).*Cannot apply 'OVERLAPS' to arguments of type '.<TIMESTAMP.0.>, <TIMESTAMP.0.>. OVERLAPS .<TIME.0.>, <INTERVAL DAY TO SECOND>.*");
        this.checkWholeExpFails("(time '4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (time '4:5:6', interval '1 2:3:4.5' day to second)", "(?s).*Cannot apply 'OVERLAPS' to arguments of type '.<TIME.0.>, <TIMESTAMP.0.>. OVERLAPS .<TIME.0.>, <INTERVAL DAY TO SECOND>.'.*");
        this.checkWholeExpFails("(time '4:5:6', time '4:5:6' ) overlaps (time '4:5:6', date '1-2-3')", "(?s).*Cannot apply 'OVERLAPS' to arguments of type '.<TIME.0.>, <TIME.0.>. OVERLAPS .<TIME.0.>, <DATE>.'.*");
    }

    @Test
    public void testExtract() {
        this.checkExpType("extract(year from interval '1-2' year to month)", "BIGINT NOT NULL");
        this.checkExp("extract(minute from interval '1.1' second)");
        this.checkExp("extract(year from DATE '2008-2-2')");
        this.checkWholeExpFails("extract(minute from interval '11' month)", "(?s).*Cannot apply.*");
        this.checkWholeExpFails("extract(year from interval '11' second)", "(?s).*Cannot apply.*");
    }

    @Test
    public void testCastToInterval() {
        this.checkExpType("cast(interval '1' hour as varchar(20))", "VARCHAR(20) NOT NULL");
        this.checkExpType("cast(interval '1' hour as bigint)", "BIGINT NOT NULL");
        this.checkExpType("cast(1000 as interval hour)", "INTERVAL HOUR NOT NULL");
        this.checkExpType("cast(interval '1' month as interval year)", "INTERVAL YEAR NOT NULL");
        this.checkExpType("cast(interval '1-1' year to month as interval month)", "INTERVAL MONTH NOT NULL");
        this.checkExpType("cast(interval '1:1' hour to minute as interval day)", "INTERVAL DAY NOT NULL");
        this.checkExpType("cast(interval '1:1' hour to minute as interval minute to second)", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkWholeExpFails("cast(interval '1:1' hour to minute as interval month)", "Cast function cannot convert value of type INTERVAL HOUR TO MINUTE to type INTERVAL MONTH");
        this.checkWholeExpFails("cast(interval '1-1' year to month as interval second)", "Cast function cannot convert value of type INTERVAL YEAR TO MONTH to type INTERVAL SECOND");
    }

    @Test
    public void testMinusDateOperator() {
        this.checkExpType("(CURRENT_DATE - CURRENT_DATE) HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("(CURRENT_DATE - CURRENT_DATE) YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkWholeExpFails("(CURRENT_DATE - LOCALTIME) YEAR TO MONTH", "(?s).*Parameters must be of the same type.*");
    }

    @Test
    public void testBind() {
        this.check("select * from emp where deptno = ?");
        this.check("select * from emp where deptno = ? and sal < 100000");
        this.check("select 1 from emp having sum(sal) < ?");
    }

    @Test
    public void testUnnest() {
        this.checkColumnType("select*from unnest(multiset[1])", "INTEGER NOT NULL");
        this.checkColumnType("select*from unnest(multiset[1, 2])", "INTEGER NOT NULL");
        this.checkColumnType("select*from unnest(multiset[321.3, 2.33])", "DECIMAL(5, 2) NOT NULL");
        this.checkColumnType("select*from unnest(multiset[321.3, 4.23e0])", "DOUBLE NOT NULL");
        this.checkColumnType("select*from unnest(multiset[43.2e1, cast(null as decimal(4,2))])", "DOUBLE");
        this.checkColumnType("select*from unnest(multiset[1, 2.3, 1])", "DECIMAL(11, 1) NOT NULL");
        this.checkColumnType("select*from unnest(multiset['1','22','333'])", "CHAR(3) NOT NULL");
        this.checkColumnType("select*from unnest(multiset['1','22','333','22'])", "CHAR(3) NOT NULL");
        this.checkFails("select*from ^unnest(1)^", "(?s).*Cannot apply 'UNNEST' to arguments of type 'UNNEST.<INTEGER>.'.*");
        this.check("select*from unnest(multiset(select*from dept))");
    }

    @Test
    public void testCorrelationJoin() {
        this.check("select *,         multiset(select * from emp where deptno=dept.deptno)                as empset      from dept");
        this.check("select*from unnest(select multiset[8] from dept)");
        this.check("select*from unnest(select multiset[deptno] from dept)");
    }

    @Test
    public void testStructuredTypes() {
        this.checkColumnType("values new address()", "ObjectSqlType(ADDRESS) NOT NULL");
        this.checkColumnType("select home_address from emp_address", "ObjectSqlType(ADDRESS) NOT NULL");
        this.checkColumnType("select ea.home_address.zip from emp_address ea", "INTEGER NOT NULL");
        this.checkColumnType("select ea.mailing_address.city from emp_address ea", "VARCHAR(20) NOT NULL");
    }

    @Test
    public void testLateral() {
        this.checkFails("select * from emp, (select * from dept where ^emp^.deptno=dept.deptno)", "Table 'EMP' not found");
        this.check("select * from emp, LATERAL (select * from dept where emp.deptno=dept.deptno)");
        this.check("select * from emp, LATERAL (select * from dept where emp.deptno=dept.deptno) as ldt");
        this.check("select * from emp, LATERAL (select * from dept where emp.deptno=dept.deptno) ldt");
    }

    @Test
    public void testCollect() {
        this.check("select collect(deptno) from emp");
        this.check("select collect(multiset[3]) from emp");
    }

    @Test
    public void testFusion() {
        this.checkFails("select ^fusion(deptno)^ from emp", "(?s).*Cannot apply 'FUSION' to arguments of type 'FUSION.<INTEGER>.'.*");
        this.check("select fusion(multiset[3]) from emp");
    }

    @Test
    public void testCountFunction() {
        this.check("select count(*) from emp");
        this.check("select count(ename) from emp");
        this.check("select count(sal) from emp");
        this.check("select count(1) from emp");
        this.checkFails("select ^count(sal,ename)^ from emp", "Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments");
    }

    @Test
    public void testLastFunction() {
        this.check("select LAST_VALUE(sal) over (order by empno) from emp");
        this.check("select LAST_VALUE(ename) over (order by empno) from emp");
        this.check("select FIRST_VALUE(sal) over (order by empno) from emp");
        this.check("select FIRST_VALUE(ename) over (order by empno) from emp");
    }

    @Test
    public void testMinMaxFunctions() {
        this.check("SELECT MIN(true) from emp");
        this.check("SELECT MAX(false) from emp");
        this.check("SELECT MIN(sal+deptno) FROM emp");
        this.check("SELECT MAX(ename) FROM emp");
        this.check("SELECT MIN(5.5) FROM emp");
        this.check("SELECT MAX(5) FROM emp");
    }

    @Test
    public void testFunctionalDistinct() {
        this.check("select count(distinct sal) from emp");
        this.checkFails("select COALESCE(^distinct^ sal) from emp", "DISTINCT/ALL not allowed with COALESCE function");
    }

    @Test
    public void testSelectDistinct() {
        this.check("SELECT DISTINCT deptno FROM emp");
        this.check("SELECT DISTINCT deptno, sal FROM emp");
        this.check("SELECT DISTINCT deptno FROM emp GROUP BY deptno");
        this.checkFails("SELECT DISTINCT ^deptno^ FROM emp GROUP BY sal", "Expression 'DEPTNO' is not being grouped");
        this.check("SELECT DISTINCT avg(sal) from emp");
        this.checkFails("SELECT DISTINCT ^deptno^, avg(sal) from emp", "Expression 'DEPTNO' is not being grouped");
        this.check("SELECT DISTINCT deptno, sal from emp GROUP BY sal, deptno");
        this.check("SELECT deptno FROM emp GROUP BY deptno HAVING deptno > 55");
        this.check("SELECT DISTINCT deptno, 33 FROM emp GROUP BY deptno HAVING deptno > 55");
        this.checkFails("SELECT DISTINCT deptno, 33 FROM emp HAVING ^deptno^ > 55", "Expression 'DEPTNO' is not being grouped");
        this.check("SELECT DISTINCT * from emp");
        this.checkFails("SELECT DISTINCT ^*^ from emp GROUP BY deptno", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.checkFails("SELECT deptno FROM emp GROUP BY deptno ORDER BY deptno, ^empno^", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.checkFails("SELECT DISTINCT deptno from emp ORDER BY deptno, ^empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.check("SELECT DISTINCT deptno from emp ORDER BY deptno + 2");
        this.checkFails("SELECT DISTINCT deptno FROM emp GROUP BY deptno, empno ORDER BY deptno, ^empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.check("select distinct * from (select distinct deptno from emp) order by 1");
        this.check("SELECT DISTINCT 5, 10+5, 'string' from emp");
    }

    @Test
    public void testExplicitTable() {
        String empRecordType = EMP_RECORD_TYPE;
        this.checkResultType("select * from (table emp)", EMP_RECORD_TYPE);
        this.checkResultType("table emp", EMP_RECORD_TYPE);
        this.checkFails("table ^nonexistent^", "Table 'NONEXISTENT' not found");
    }

    @Test
    public void testCollectionTable() {
        this.checkResultType("select * from table(ramp(3))", "RecordType(INTEGER NOT NULL I) NOT NULL");
        this.checkFails("select * from table(^ramp('3')^)", "Cannot apply 'RAMP' to arguments of type 'RAMP\\(<CHAR\\(1\\)>\\)'\\. Supported form\\(s\\): 'RAMP\\(<NUMERIC>\\)'");
        this.checkFails("select * from table(^nonExistentRamp('3')^)", "No match found for function signature NONEXISTENTRAMP\\(<CHARACTER>\\)");
    }

    @Test
    public void testCollectionTableWithCursorParam() {
        this.checkResultType("select * from table(dedup(cursor(select * from emp),'ename'))", "RecordType(VARCHAR(1024) NOT NULL NAME) NOT NULL");
        this.checkFails("select * from table(dedup(cursor(select * from ^bloop^),'ename'))", "Table 'BLOOP' not found");
    }

    @Test
    public void testScalarSubQuery() {
        this.check("SELECT  ename,(select name from dept where deptno=1) FROM emp");
        this.checkFails("SELECT ename,(^select losal, hisal from salgrade where grade=1^) FROM emp", "Cannot apply '\\$SCALAR_QUERY' to arguments of type '\\$SCALAR_QUERY\\(<RECORDTYPE\\(INTEGER LOSAL, INTEGER HISAL\\)>\\)'\\. Supported form\\(s\\): '\\$SCALAR_QUERY\\(<RECORDTYPE\\(SINGLE FIELD\\)>\\)'");
        this.checkResultType("SELECT  ename,(select name from dept where deptno=1) FROM emp", "RecordType(VARCHAR(20) NOT NULL ENAME, VARCHAR(10) EXPR$1) NOT NULL");
        this.checkResultType("SELECT  ename,(select name from dept where deptno=1) as X FROM emp", "RecordType(VARCHAR(20) NOT NULL ENAME, VARCHAR(10) X) NOT NULL");
        this.checkResultType("SELECT  ename, 1 + (select deptno from dept where deptno=1) as X FROM emp", "RecordType(VARCHAR(20) NOT NULL ENAME, INTEGER X) NOT NULL");
        this.check("select * from emp where (select true from dept)");
    }

    public void _testSubqueryInOnClause() {
        this.check("select * from emp as emps left outer join dept as depts\non emps.deptno = depts.deptno and emps.deptno = (\nselect min(deptno) from dept as depts2)");
    }

    @Test
    public void testRecordType() {
        this.checkFails("SELECT ^coord^.x, coord.y FROM customer.contact", "Table 'COORD' not found");
        this.checkResultType("SELECT contact.coord.x, contact.coord.y FROM customer.contact", "RecordType(INTEGER NOT NULL X, INTEGER NOT NULL Y) NOT NULL");
    }

    @Test
    public void testSample() {
        this.check("SELECT * FROM emp TABLESAMPLE SUBSTITUTE('foo')");
        this.check("SELECT * FROM emp TABLESAMPLE BERNOULLI(50)");
        this.check("SELECT * FROM emp TABLESAMPLE SYSTEM(50)");
        this.check("SELECT * FROM (SELECT deptno FROM emp UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SUBSTITUTE('foo') WHERE x.deptno < 100");
        this.checkFails("SELECT x.^empno^ FROM (SELECT deptno FROM emp TABLESAMPLE SUBSTITUTE('bar') UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SUBSTITUTE('foo') ORDER BY 1", "Column 'EMPNO' not found in table 'X'");
        this.check("select * from (\n    select * from emp\n    join dept on emp.deptno = dept.deptno\n) tablesample substitute('SMALL')");
        this.check("SELECT * FROM (SELECT deptno FROM emp UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE BERNOULLI(50) WHERE x.deptno < 100");
        this.checkFails("SELECT x.^empno^ FROM (SELECT deptno FROM emp TABLESAMPLE BERNOULLI(50) UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE BERNOULLI(10) ORDER BY 1", "Column 'EMPNO' not found in table 'X'");
        this.check("select * from (\n    select * from emp\n    join dept on emp.deptno = dept.deptno\n) tablesample bernoulli(10)");
        this.check("SELECT * FROM (SELECT deptno FROM emp UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SYSTEM(50) WHERE x.deptno < 100");
        this.checkFails("SELECT x.^empno^ FROM (SELECT deptno FROM emp TABLESAMPLE SYSTEM(50) UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SYSTEM(10) ORDER BY 1", "Column 'EMPNO' not found in table 'X'");
        this.check("select * from (\n    select * from emp\n    join dept on emp.deptno = dept.deptno\n) tablesample system(10)");
    }

    @Test
    public void testRewriteWithoutIdentifierExpansion() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(false);
        this.tester.checkRewrite(validator, "select * from dept", "SELECT *\nFROM `DEPT`");
    }

    @Test
    public void testRewriteWithIdentifierExpansion() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(true);
        this.tester.checkRewrite(validator, "select * from dept", "SELECT `DEPT`.`DEPTNO`, `DEPT`.`NAME`\nFROM `CATALOG`.`SALES`.`DEPT` AS `DEPT`");
    }

    @Test
    public void testRewriteWithColumnReferenceExpansion() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(true);
        validator.setColumnReferenceExpansion(true);
        this.tester.checkRewrite(validator, "select name from dept where name = 'Moonracer' group by name having sum(deptno) > 3 order by name", "SELECT `DEPT`.`NAME`\nFROM `CATALOG`.`SALES`.`DEPT` AS `DEPT`\nWHERE `DEPT`.`NAME` = 'Moonracer'\nGROUP BY `DEPT`.`NAME`\nHAVING SUM(`DEPT`.`DEPTNO`) > 3\nORDER BY `NAME`");
    }

    @Test
    public void testRewriteWithColumnReferenceExpansionAndFromAlias() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(true);
        validator.setColumnReferenceExpansion(true);
        this.tester.checkRewrite(validator, "select name from (select * from dept) where name = 'Moonracer' group by name having sum(deptno) > 3 order by name", "SELECT `EXPR$0`.`NAME`\nFROM (SELECT `DEPT`.`DEPTNO`, `DEPT`.`NAME`\nFROM `CATALOG`.`SALES`.`DEPT` AS `DEPT`) AS `EXPR$0`\nWHERE `EXPR$0`.`NAME` = 'Moonracer'\nGROUP BY `EXPR$0`.`NAME`\nHAVING SUM(`EXPR$0`.`DEPTNO`) > 3\nORDER BY `NAME`");
    }

    @Test
    public void testCoalesceWithoutRewrite() {
        SqlValidator validator = this.tester.getValidator();
        validator.setCallRewrite(false);
        if (validator.shouldExpandIdentifiers()) {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT COALESCE(`EMP`.`DEPTNO`, `EMP`.`EMPNO`)\nFROM `CATALOG`.`SALES`.`EMP` AS `EMP`");
        } else {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT COALESCE(`DEPTNO`, `EMPNO`)\nFROM `EMP`");
        }
    }

    @Test
    public void testCoalesceWithRewrite() {
        SqlValidator validator = this.tester.getValidator();
        validator.setCallRewrite(true);
        if (validator.shouldExpandIdentifiers()) {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT CASE WHEN `EMP`.`DEPTNO` IS NOT NULL THEN `EMP`.`DEPTNO` ELSE `EMP`.`EMPNO` END\nFROM `CATALOG`.`SALES`.`EMP` AS `EMP`");
        } else {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT CASE WHEN `DEPTNO` IS NOT NULL THEN `DEPTNO` ELSE `EMPNO` END\nFROM `EMP`");
        }
    }

    public void _testValuesWithAggFuncs() {
        this.checkFails("values(^count(1)^)", "Call to xxx is invalid\\. Direct calls to aggregate functions not allowed in ROW definitions\\.");
    }

    @Test
    public void testFieldOrigin() {
        this.tester.checkFieldOrigin("select * from emp join dept on true", "{CATALOG.SALES.EMP.EMPNO, CATALOG.SALES.EMP.ENAME, CATALOG.SALES.EMP.JOB, CATALOG.SALES.EMP.MGR, CATALOG.SALES.EMP.HIREDATE, CATALOG.SALES.EMP.SAL, CATALOG.SALES.EMP.COMM, CATALOG.SALES.EMP.DEPTNO, CATALOG.SALES.EMP.SLACKER, CATALOG.SALES.DEPT.DEPTNO, CATALOG.SALES.DEPT.NAME}");
        this.tester.checkFieldOrigin("select distinct emp.empno, hiredate, 1 as one,\n emp.empno * 2 as twiceEmpno\nfrom emp join dept on true", "{CATALOG.SALES.EMP.EMPNO, CATALOG.SALES.EMP.HIREDATE, null, null}");
    }

    @Test
    public void testBrackets() {
        SqlTester tester1 = this.tester.withQuoting(Quoting.BRACKET);
        tester1.checkResultType("select [e].EMPNO from [EMP] as [e]", "RecordType(INTEGER NOT NULL EMPNO) NOT NULL");
        tester1.checkQueryFails("select ^e^.EMPNO from [EMP] as [e]", "Table 'E' not found");
        tester1.checkQueryFails("select ^x^ from (\n  select [e].EMPNO as [x] from [EMP] as [e])", "Column 'X' not found in any table");
        tester1.checkQueryFails("select EMP.^\"x\"^ from EMP", "(?s).*Encountered \"\\. \\\\\"\" at line .*");
        tester1.checkResultType("select [x[y]] z ] from (\n  select [e].EMPNO as [x[y]] z ] from [EMP] as [e])", "RecordType(INTEGER NOT NULL x[y] z ) NOT NULL");
    }

    @Test
    public void testLexJava() {
        SqlTester tester1 = this.tester.withLex(Lex.JAVA);
        tester1.checkResultType("select e.EMPNO from EMP as e", "RecordType(INTEGER NOT NULL EMPNO) NOT NULL");
        tester1.checkQueryFails("select ^e^.EMPNO from EMP as E", "Table 'e' not found");
        tester1.checkQueryFails("select ^E^.EMPNO from EMP as e", "Table 'E' not found");
        tester1.checkQueryFails("select ^x^ from (\n  select e.EMPNO as X from EMP as e)", "Column 'x' not found in any table");
        tester1.checkQueryFails("select EMP.^\"x\"^ from EMP", "(?s).*Encountered \"\\. \\\\\"\" at line .*");
        tester1.checkResultType("select `x[y] z ` from (\n  select e.EMPNO as `x[y] z ` from EMP as e)", "RecordType(INTEGER NOT NULL x[y] z ) NOT NULL");
    }

    @Test
    public void testLexJavaKeyword() {
        SqlTester tester1 = this.tester.withLex(Lex.JAVA);
        tester1.checkResultType("select path, x from (select 1 as path, 2 as x from (values (true)))", "RecordType(INTEGER NOT NULL path, INTEGER NOT NULL x) NOT NULL");
        tester1.checkResultType("select path, x from (select 1 as `path`, 2 as x from (values (true)))", "RecordType(INTEGER NOT NULL path, INTEGER NOT NULL x) NOT NULL");
        tester1.checkResultType("select `path`, x from (select 1 as path, 2 as x from (values (true)))", "RecordType(INTEGER NOT NULL path, INTEGER NOT NULL x) NOT NULL");
        tester1.checkFails("select ^PATH^ from (select 1 as path from (values (true)))", "Column 'PATH' not found in any table", false);
        tester1.checkFails("select t.^PATH^ from (select 1 as path from (values (true))) as t", "Column 'PATH' not found in table 't'", false);
        tester1.checkQueryFails("select t.x, t.^PATH^ from (values (true, 1)) as t(path, x)", "Column 'PATH' not found in table 't'");
        tester1.checkQuery("values (current_timestamp, floor(2.5), ceil (3.5))");
        tester1.checkQuery("values (CURRENT_TIMESTAMP, FLOOR(2.5), CEIL (3.5))");
        tester1.checkResultType("values (CURRENT_TIMESTAMP, CEIL (3.5))", "RecordType(TIMESTAMP(0) NOT NULL CURRENT_TIMESTAMP, DECIMAL(2, 0) NOT NULL EXPR$1) NOT NULL");
    }

    @Test
    public void testLexAndQuoting() {
        SqlTester tester1 = this.tester.withLex(Lex.JAVA).withQuoting(Quoting.DOUBLE_QUOTE);
        tester1.checkResultType("select \"x[y] z \" from (\n  select e.EMPNO as \"x[y] z \" from EMP as e)", "RecordType(INTEGER NOT NULL x[y] z ) NOT NULL");
    }

    @Test
    public void testCaseInsensitive() {
        SqlTester tester1 = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        SqlTester tester2 = this.tester.withQuoting(Quoting.BRACKET);
        tester1.checkQuery("select EMPNO from EMP");
        tester1.checkQuery("select empno from emp");
        tester1.checkQuery("select [empno] from [emp]");
        tester1.checkQuery("select [E].[empno] from [emp] as e");
        tester1.checkQuery("select t.[x] from (\n  select [E].[empno] as x from [emp] as e) as [t]");
        tester1.checkQuery("select * from emp as [e] where exists (\nselect 1 from dept where dept.deptno = [E].deptno)");
        tester2.checkQueryFails("select * from emp as [e] where exists (\nselect 1 from dept where dept.deptno = ^[E]^.deptno)", "(?s).*Table 'E' not found");
        this.checkFails("select count(1), ^empno^ from emp", "Expression 'EMPNO' is not being grouped");
        tester2.checkQuery("select count(*) from dept as [D], dept as [d]");
        if (!Bug.upgrade((String)"fix case sensitivity bug")) {
            return;
        }
        tester1.checkQueryFails("select count(*) from dept as [D], dept as [d]", "xxx");
    }

    @Test
    public void testUnquotedBuiltInFunctionNames() {
        SqlTester mysql = this.tester.withUnquotedCasing(Casing.UNCHANGED).withQuoting(Quoting.BACK_TICK).withCaseSensitive(false);
        SqlTester oracle = this.tester.withUnquotedCasing(Casing.TO_UPPER).withCaseSensitive(true);
        oracle.checkQuery("select count(*), sum(deptno), floor(2.5) from dept");
        oracle.checkQuery("select COUNT(*), FLOOR(2.5) from dept");
        oracle.checkQuery("select cOuNt(*), FlOOr(2.5) from dept");
        oracle.checkQuery("select cOuNt (*), FlOOr (2.5) from dept");
        oracle.checkQuery("select current_time from dept");
        oracle.checkQuery("select Current_Time from dept");
        oracle.checkQuery("select CURRENT_TIME from dept");
        mysql.checkQuery("select sum(deptno), floor(2.5) from dept");
        mysql.checkQuery("select count(*), sum(deptno), floor(2.5) from dept");
        mysql.checkQuery("select COUNT(*), FLOOR(2.5) from dept");
        mysql.checkQuery("select cOuNt(*), FlOOr(2.5) from dept");
        mysql.checkQuery("select cOuNt (*), FlOOr (2.5) from dept");
        mysql.checkQuery("select current_time from dept");
        mysql.checkQuery("select Current_Time from dept");
        mysql.checkQuery("select CURRENT_TIME from dept");
        oracle.checkQuery("select \"count\"(*) from dept");
        mysql.checkQuery("select `count`(*) from dept");
    }

    @Test
    public void testStandardOperatorNamesAreUpperCase() {
        block3: for (SqlOperator op : SqlStdOperatorTable.instance().getOperatorList()) {
            String name = op.getName();
            switch (op.getSyntax()) {
                case SPECIAL: 
                case INTERNAL: {
                    continue block3;
                }
            }
            Assert.assertThat((Object)name.toUpperCase(), (Matcher)CoreMatchers.equalTo((Object)name));
        }
    }

    @Test
    public void testCaseInsensitiveInsert() {
        SqlTester tester1 = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        tester1.checkQueryFails("insert into EMP ([EMPNO], deptno, ^[empno]^)\n values (1, 1, 1)", "Target column 'EMPNO' is assigned more than once");
    }

    @Test
    public void testCaseInsensitiveSubQuery() {
        SqlTester insensitive = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        SqlTester sensitive = this.tester.withCaseSensitive(true).withQuoting(Quoting.BRACKET);
        String sql = "select [e] from (\nselect empno as [e], deptno as d, 1 as [e] from EMP)";
        sensitive.checkQuery(sql);
        insensitive.checkQuery(sql);
        String sql1 = "select e from (\nselect empno as [e], deptno as d, 1 as [E] from EMP)";
        insensitive.checkQuery(sql1);
        sensitive.checkQuery(sql1);
    }

    @Test
    public void testCaseInsensitiveTables() {
        SqlTester tester1 = this.tester.withLex(Lex.SQL_SERVER);
        tester1.checkQuery("select eMp.* from (select * from emp) as EmP");
        tester1.checkQueryFails("select ^eMp^.* from (select * from emp as EmP)", "Unknown identifier 'eMp'");
        tester1.checkQuery("select eMp.* from (select * from emP) as EmP");
        tester1.checkQuery("select eMp.empNo from (select * from emP) as EmP");
        tester1.checkQuery("select empNo from (select Empno from emP) as EmP");
        tester1.checkQuery("select empNo from (select Empno from emP)");
    }

    @Test
    public void testNew() {
    }
}

