/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.BasicSqlType;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.test.DiffRepository;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlLimitsTest {
    private static final List<BasicSqlType> TYPE_LIST = ImmutableList.of((Object)new BasicSqlType(SqlTypeName.BOOLEAN), (Object)new BasicSqlType(SqlTypeName.TINYINT), (Object)new BasicSqlType(SqlTypeName.SMALLINT), (Object)new BasicSqlType(SqlTypeName.INTEGER), (Object)new BasicSqlType(SqlTypeName.BIGINT), (Object)new BasicSqlType(SqlTypeName.DECIMAL), (Object)new BasicSqlType(SqlTypeName.DECIMAL, 5), (Object)new BasicSqlType(SqlTypeName.DECIMAL, 6, 2), (Object)new BasicSqlType(SqlTypeName.DECIMAL, SqlTypeName.DECIMAL.getMaxPrecision(), 0), (Object)new BasicSqlType(SqlTypeName.DECIMAL, SqlTypeName.DECIMAL.getMaxPrecision(), 5), (Object)new BasicSqlType(SqlTypeName.CHAR, 5), (Object)new BasicSqlType(SqlTypeName.VARCHAR, 1), (Object[])new BasicSqlType[]{new BasicSqlType(SqlTypeName.VARCHAR, 20), new BasicSqlType(SqlTypeName.BINARY, 3), new BasicSqlType(SqlTypeName.VARBINARY, 4), new BasicSqlType(SqlTypeName.DATE), new BasicSqlType(SqlTypeName.TIME, 0), new BasicSqlType(SqlTypeName.TIMESTAMP, 0)});

    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(SqlLimitsTest.class);
    }

    public static List<BasicSqlType> getTypes() {
        return TYPE_LIST;
    }

    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testPrintLimits() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (BasicSqlType type : TYPE_LIST) {
            pw.println(type.toString());
            this.printLimit(pw, "  min - epsilon:          ", type, false, SqlTypeName.Limit.OVERFLOW, true);
            this.printLimit(pw, "  min:                    ", type, false, SqlTypeName.Limit.OVERFLOW, false);
            this.printLimit(pw, "  zero - delta:           ", type, false, SqlTypeName.Limit.UNDERFLOW, false);
            this.printLimit(pw, "  zero - delta + epsilon: ", type, false, SqlTypeName.Limit.UNDERFLOW, true);
            this.printLimit(pw, "  zero:                   ", type, false, SqlTypeName.Limit.ZERO, false);
            this.printLimit(pw, "  zero + delta - epsilon: ", type, true, SqlTypeName.Limit.UNDERFLOW, true);
            this.printLimit(pw, "  zero + delta:           ", type, true, SqlTypeName.Limit.UNDERFLOW, false);
            this.printLimit(pw, "  max:                    ", type, true, SqlTypeName.Limit.OVERFLOW, false);
            this.printLimit(pw, "  max + epsilon:          ", type, true, SqlTypeName.Limit.OVERFLOW, true);
            pw.println();
        }
        pw.flush();
        this.getDiffRepos().assertEquals("output", "${output}", sw.toString());
    }

    private void printLimit(PrintWriter pw, String desc, BasicSqlType type, boolean sign, SqlTypeName.Limit limit, boolean beyond) {
        String s;
        Object o = type.getLimit(sign, limit, beyond);
        if (o == null) {
            return;
        }
        pw.print(desc);
        if (o instanceof byte[]) {
            int k = 0;
            StringBuilder buf = new StringBuilder("{");
            for (byte b : (byte[])o) {
                if (k++ > 0) {
                    buf.append(", ");
                }
                buf.append(Integer.toHexString(b & 0xFF));
            }
            buf.append("}");
            s = buf.toString();
        } else if (o instanceof Calendar) {
            DateFormat dateFormat;
            Calendar calendar = (Calendar)o;
            switch (type.getSqlTypeName()) {
                case DATE: {
                    dateFormat = DateFormat.getDateInstance();
                    break;
                }
                case TIME: {
                    dateFormat = DateFormat.getTimeInstance();
                    break;
                }
                default: {
                    dateFormat = DateFormat.getDateTimeInstance();
                }
            }
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            s = dateFormat.format(calendar.getTime());
        } else {
            s = o.toString();
        }
        pw.print(s);
        SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
        pw.print("; as SQL: ");
        pw.print(literal.toSqlString(SqlDialect.DUMMY));
        pw.println();
    }
}

