/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.test;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlJdbcFunctionCall;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.test.DefaultSqlTestFactory;
import org.eigenbase.sql.test.SqlOperatorTest;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.test.SqlTesterImpl;
import org.eigenbase.sql.test.SqlTests;
import org.eigenbase.sql.type.BasicSqlType;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.SqlString;
import org.eigenbase.test.SqlLimitsTest;
import org.eigenbase.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlOperatorBaseTest {
    public static final String INVALID_CHAR_MESSAGE = "(?s).*";
    public static final String OUT_OF_RANGE_MESSAGE = "(?s).*";
    public static final String DIVISION_BY_ZERO_MESSAGE = "(?s).*";
    public static final String STRING_TRUNC_MESSAGE = "(?s).*";
    public static final String BAD_DATETIME_MESSAGE = "(?s).*";
    public static final String LITERAL_OUT_OF_RANGE_MESSAGE = "(?s).*Numeric literal.*out of range.*";
    public static final boolean TODO = false;
    public static final Pattern TIME_PATTERN = Pattern.compile("[0-9][0-9]:[0-9][0-9]:[0-9][0-9]");
    public static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]");
    public static final Pattern DATE_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]");
    public static final String[] NUMERIC_TYPE_NAMES = new String[]{"TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DECIMAL(5, 2)", "REAL", "FLOAT", "DOUBLE"};
    public static final String[] MIN_NUMERIC_STRINGS = new String[]{Long.toString(-128L), Long.toString(-32768L), Long.toString(Integer.MIN_VALUE), Long.toString(Long.MIN_VALUE), "-999.99", "1E-37", "2E-307", "2E-307"};
    public static final String[] MIN_OVERFLOW_NUMERIC_STRINGS = new String[]{Long.toString(-129L), Long.toString(-32769L), Long.toString(-2147483649L), new BigDecimal(Long.MIN_VALUE).subtract(BigDecimal.ONE).toString(), "-1000.00", "1e-46", "1e-324", "1e-324"};
    public static final String[] MAX_NUMERIC_STRINGS = new String[]{Long.toString(127L), Long.toString(32767L), Long.toString(Integer.MAX_VALUE), Long.toString(Long.MAX_VALUE), "999.99", "3.4028234E38", "1.79769313486231E308", "1.79769313486231E308"};
    public static final String[] MAX_OVERFLOW_NUMERIC_STRINGS = new String[]{Long.toString(128L), Long.toString(32768L), Long.toString(0x80000000L), new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE).toString(), "1000.00", "1e39", "-1e309", "1e309"};
    private static final boolean[] FALSE_TRUE = new boolean[]{false, true};
    private static final SqlTester.VmName VM_FENNEL = SqlTester.VmName.FENNEL;
    private static final SqlTester.VmName VM_JAVA = SqlTester.VmName.JAVA;
    private static final SqlTester.VmName VM_EXPAND = SqlTester.VmName.EXPAND;
    protected static final TimeZone UTC_TZ = TimeZone.getTimeZone("GMT");
    protected static final TimeZone LOCAL_TZ;
    protected static final TimeZone CURRENT_TZ;
    private static final Pattern INVALID_ARG_FOR_POWER;
    private static final Pattern CODE_2201F;
    public static final boolean DECIMAL = false;
    public static final boolean INTERVAL = false;
    private final boolean enable;
    protected final SqlTester tester;

    protected SqlOperatorBaseTest(boolean enable, SqlTester tester) {
        this.enable = enable;
        this.tester = tester;
        assert (tester != null);
    }

    @Before
    public void setUp() throws Exception {
        this.tester.setFor(null, new SqlTester.VmName[0]);
    }

    @Test
    public void testDummy() {
    }

    @Test
    public void testBetween() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.BETWEEN, SqlTester.VmName.EXPAND);
        this.tester.checkBoolean("2 between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("2 between 3 and 2", Boolean.FALSE);
        this.tester.checkBoolean("2 between symmetric 3 and 2", Boolean.TRUE);
        this.tester.checkBoolean("3 between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("4 between 1 and 3", Boolean.FALSE);
        this.tester.checkBoolean("1 between 4 and -3", Boolean.FALSE);
        this.tester.checkBoolean("1 between -1 and -3", Boolean.FALSE);
        this.tester.checkBoolean("1 between -1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1 between 1 and 1", Boolean.TRUE);
        this.tester.checkBoolean("1.5 between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1.2 between 1.1 and 1.3", Boolean.TRUE);
        this.tester.checkBoolean("1.5 between 2 and 3", Boolean.FALSE);
        this.tester.checkBoolean("1.5 between 1.6 and 1.7", Boolean.FALSE);
        this.tester.checkBoolean("1.2e1 between 1.1 and 1.3", Boolean.FALSE);
        this.tester.checkBoolean("1.2e0 between 1.1 and 1.3", Boolean.TRUE);
        this.tester.checkBoolean("1.5e0 between 2 and 3", Boolean.FALSE);
        this.tester.checkBoolean("1.5e0 between 2e0 and 3e0", Boolean.FALSE);
        this.tester.checkBoolean("1.5e1 between 1.6e1 and 1.7e1", Boolean.FALSE);
        this.tester.checkBoolean("x'' between x'' and x''", Boolean.TRUE);
        this.tester.checkNull("cast(null as integer) between -1 and 2");
        this.tester.checkNull("1 between -1 and cast(null as integer)");
        this.tester.checkNull("1 between cast(null as integer) and cast(null as integer)");
        this.tester.checkNull("1 between cast(null as integer) and 1");
    }

    @Test
    public void testNotBetween() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_BETWEEN, VM_EXPAND);
        this.tester.checkBoolean("2 not between 1 and 3", Boolean.FALSE);
        this.tester.checkBoolean("3 not between 1 and 3", Boolean.FALSE);
        this.tester.checkBoolean("4 not between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1.2e0 not between 1.1 and 1.3", Boolean.FALSE);
        this.tester.checkBoolean("1.2e1 not between 1.1 and 1.3", Boolean.TRUE);
        this.tester.checkBoolean("1.5e0 not between 2 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1.5e0 not between 2e0 and 3e0", Boolean.TRUE);
    }

    private String getCastString(String value, String targetType, boolean errorLoc) {
        if (errorLoc) {
            value = "^" + value + "^";
        }
        return "cast(" + value + " as " + targetType + ")";
    }

    private void checkCastToApproxOkay(String value, String targetType, double expected, double delta) {
        this.tester.checkScalarApprox(this.getCastString(value, targetType, false), targetType + " NOT NULL", expected, delta);
    }

    private void checkCastToStringOkay(String value, String targetType, String expected) {
        this.tester.checkString(this.getCastString(value, targetType, false), expected, targetType + " NOT NULL");
    }

    private void checkCastToScalarOkay(String value, String targetType, String expected) {
        this.tester.checkScalarExact(this.getCastString(value, targetType, false), targetType + " NOT NULL", expected);
    }

    private void checkCastToScalarOkay(String value, String targetType) {
        this.checkCastToScalarOkay(value, targetType, value);
    }

    private void checkCastFails(String value, String targetType, String expectedError, boolean runtime) {
        this.tester.checkFails(this.getCastString(value, targetType, !runtime), expectedError, runtime);
    }

    private void checkCastToString(String value, String type, String expected) {
        String spaces = "     ";
        if (expected == null) {
            expected = value.trim();
        }
        int len = expected.length();
        if (type != null) {
            value = this.getCastString(value, type, false);
        }
        this.checkCastToStringOkay(value, "VARCHAR(" + len + ")", expected);
        this.checkCastToStringOkay(value, "VARCHAR(" + (len + 5) + ")", expected);
        this.checkCastToStringOkay(value, "CHAR(" + len + ")", expected);
        this.checkCastToStringOkay(value, "CHAR(" + (len + 5) + ")", expected + spaces);
    }

    @Test
    public void testCastToString() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToString("123", "CHAR(3)", "123");
        this.checkCastToString("0", "CHAR", "0");
        this.checkCastToString("-123", "CHAR(4)", "-123");
        this.checkCastToString("123.4", "CHAR(5)", "123.4");
        this.checkCastToString("-0.0", "CHAR(2)", ".0");
        this.checkCastToString("-123.4", "CHAR(6)", "-123.4");
        this.tester.checkString("cast(1.29 as varchar(10))", "1.29", "VARCHAR(10) NOT NULL");
        this.tester.checkString("cast(.48 as varchar(10))", ".48", "VARCHAR(10) NOT NULL");
        this.tester.checkFails("cast(2.523 as char(2))", STRING_TRUNC_MESSAGE, true);
        this.tester.checkString("cast(-0.29 as varchar(10))", "-.29", "VARCHAR(10) NOT NULL");
        this.tester.checkString("cast(-1.29 as varchar(10))", "-1.29", "VARCHAR(10) NOT NULL");
        this.checkCastToString("1.23E45", "CHAR(7)", "1.23E45");
        this.checkCastToString("CAST(0 AS DOUBLE)", "CHAR(3)", "0E0");
        this.checkCastToString("-1.20e-07", "CHAR(7)", "-1.2E-7");
        this.checkCastToString("cast(0e0 as varchar(5))", "CHAR(3)", "0E0");
        this.tester.checkFails("cast(1.3243232e0 as varchar(4))", STRING_TRUNC_MESSAGE, true);
        this.tester.checkFails("cast(1.9e5 as char(4))", STRING_TRUNC_MESSAGE, true);
        this.checkCastToString("'abc'", "CHAR(1)", "a");
        this.checkCastToString("'abc'", "CHAR(3)", "abc");
        this.checkCastToString("cast('abc' as varchar(6))", "CHAR(3)", "abc");
        this.checkCastToString("date '2008-01-01'", "CHAR(10)", "2008-01-01");
        this.checkCastToString("time '1:2:3'", "CHAR(8)", "01:02:03");
        this.checkCastToString("timestamp '2008-1-1 1:2:3'", "CHAR(19)", "2008-01-01 01:02:03");
        this.checkCastToString("timestamp '2008-1-1 1:2:3'", "VARCHAR(30)", "2008-01-01 01:02:03");
        this.checkCastToString("interval '3-2' year to month", "CHAR(5)", "+3-02");
        this.checkCastToString("interval '32' month", "CHAR(3)", "+32");
        this.checkCastToString("interval '1 2:3:4' day to second", "CHAR(11)", "+1 02:03:04");
        this.checkCastToString("interval '1234.56' second(4,2)", "CHAR(8)", "+1234.56");
        this.checkCastToString("True", "CHAR(4)", "TRUE");
        this.checkCastToString("False", "CHAR(5)", "FALSE");
        this.tester.checkFails("cast(true as char(3))", INVALID_CHAR_MESSAGE, true);
        this.tester.checkFails("cast(false as char(4))", INVALID_CHAR_MESSAGE, true);
        this.tester.checkFails("cast(true as varchar(3))", INVALID_CHAR_MESSAGE, true);
        this.tester.checkFails("cast(false as varchar(4))", INVALID_CHAR_MESSAGE, true);
    }

    @Test
    public void testCastExactNumericLimits() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        for (int i = 0; i < NUMERIC_TYPE_NAMES.length; ++i) {
            String type = NUMERIC_TYPE_NAMES[i];
            if (type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("FLOAT") || type.equalsIgnoreCase("REAL")) continue;
            this.checkCastToScalarOkay(MAX_NUMERIC_STRINGS[i], type);
            this.checkCastToScalarOkay(MIN_NUMERIC_STRINGS[i], type);
            if (type.equalsIgnoreCase("BIGINT")) {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, LITERAL_OUT_OF_RANGE_MESSAGE, false);
                this.checkCastFails(MIN_OVERFLOW_NUMERIC_STRINGS[i], type, LITERAL_OUT_OF_RANGE_MESSAGE, false);
            } else {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, OUT_OF_RANGE_MESSAGE, true);
                this.checkCastFails(MIN_OVERFLOW_NUMERIC_STRINGS[i], type, OUT_OF_RANGE_MESSAGE, true);
            }
            if (!this.enable) {
                return;
            }
            this.checkCastToScalarOkay("'" + MAX_NUMERIC_STRINGS[i] + "'", type, MAX_NUMERIC_STRINGS[i]);
            this.checkCastToScalarOkay("'" + MIN_NUMERIC_STRINGS[i] + "'", type, MIN_NUMERIC_STRINGS[i]);
            this.checkCastFails("'" + MAX_OVERFLOW_NUMERIC_STRINGS[i] + "'", type, OUT_OF_RANGE_MESSAGE, true);
            this.checkCastFails("'" + MIN_OVERFLOW_NUMERIC_STRINGS[i] + "'", type, OUT_OF_RANGE_MESSAGE, true);
            this.checkCastToString(MAX_NUMERIC_STRINGS[i], null, null);
            this.checkCastToString(MAX_NUMERIC_STRINGS[i], type, null);
            this.checkCastToString(MIN_NUMERIC_STRINGS[i], null, null);
            this.checkCastToString(MIN_NUMERIC_STRINGS[i], type, null);
            this.checkCastFails("'notnumeric'", type, INVALID_CHAR_MESSAGE, true);
        }
    }

    @Test
    public void testCastToExactNumeric() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToScalarOkay("1", "BIGINT");
        this.checkCastToScalarOkay("1", "INTEGER");
        this.checkCastToScalarOkay("1", "SMALLINT");
        this.checkCastToScalarOkay("1", "TINYINT");
        this.checkCastToScalarOkay("1", "DECIMAL(4, 0)");
        this.checkCastToScalarOkay("-1", "BIGINT");
        this.checkCastToScalarOkay("-1", "INTEGER");
        this.checkCastToScalarOkay("-1", "SMALLINT");
        this.checkCastToScalarOkay("-1", "TINYINT");
        this.checkCastToScalarOkay("-1", "DECIMAL(4, 0)");
        this.checkCastToScalarOkay("1.234E3", "INTEGER", "1234");
        this.checkCastToScalarOkay("-9.99E2", "INTEGER", "-999");
        this.checkCastToScalarOkay("'1'", "INTEGER", "1");
        this.checkCastToScalarOkay("' 01 '", "INTEGER", "1");
        this.checkCastToScalarOkay("'-1'", "INTEGER", "-1");
        this.checkCastToScalarOkay("' -00 '", "INTEGER", "0");
        this.tester.checkScalarExact("cast('6543' as integer)", "6543");
        this.tester.checkScalarExact("cast(' -123 ' as int)", "-123");
        this.tester.checkScalarExact("cast('654342432412312' as bigint)", "BIGINT NOT NULL", "654342432412312");
    }

    @Test
    public void testCastStringToDecimal() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
    }

    @Test
    public void testCastIntervalToNumeric() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
    }

    @Test
    public void testCastToInterval() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
    }

    @Test
    public void testCastIntervalToInterval() {
    }

    @Test
    public void testCastWithRoundingToScalar() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToScalarOkay("1.25", "INTEGER", "1");
        this.checkCastToScalarOkay("1.25E0", "INTEGER", "1");
        if (!this.enable) {
            return;
        }
        this.checkCastToScalarOkay("1.5", "INTEGER", "2");
        this.checkCastToScalarOkay("5E-1", "INTEGER", "1");
        this.checkCastToScalarOkay("1.75", "INTEGER", "2");
        this.checkCastToScalarOkay("1.75E0", "INTEGER", "2");
        this.checkCastToScalarOkay("-1.25", "INTEGER", "-1");
        this.checkCastToScalarOkay("-1.25E0", "INTEGER", "-1");
        this.checkCastToScalarOkay("-1.5", "INTEGER", "-2");
        this.checkCastToScalarOkay("-5E-1", "INTEGER", "-1");
        this.checkCastToScalarOkay("-1.75", "INTEGER", "-2");
        this.checkCastToScalarOkay("-1.75E0", "INTEGER", "-2");
        this.checkCastToScalarOkay("1.23454", "DECIMAL(8, 4)", "1.2345");
        this.checkCastToScalarOkay("1.23454E0", "DECIMAL(8, 4)", "1.2345");
        this.checkCastToScalarOkay("1.23455", "DECIMAL(8, 4)", "1.2346");
        this.checkCastToScalarOkay("5E-5", "DECIMAL(8, 4)", "0.0001");
        this.checkCastToScalarOkay("1.99995", "DECIMAL(8, 4)", "2.0000");
        this.checkCastToScalarOkay("1.99995E0", "DECIMAL(8, 4)", "2.0000");
        this.checkCastToScalarOkay("-1.23454", "DECIMAL(8, 4)", "-1.2345");
        this.checkCastToScalarOkay("-1.23454E0", "DECIMAL(8, 4)", "-1.2345");
        this.checkCastToScalarOkay("-1.23455", "DECIMAL(8, 4)", "-1.2346");
        this.checkCastToScalarOkay("-5E-5", "DECIMAL(8, 4)", "-0.0001");
        this.checkCastToScalarOkay("-1.99995", "DECIMAL(8, 4)", "-2.0000");
        this.checkCastToScalarOkay("-1.99995E0", "DECIMAL(8, 4)", "-2.0000");
        this.tester.checkFails("cast(9.99 as decimal(2,1))", OUT_OF_RANGE_MESSAGE, true);
    }

    @Test
    public void testCastDecimalToDoubleToInteger() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("cast( cast(1.25 as double) as integer)", "1");
        this.tester.checkScalarExact("cast( cast(-1.25 as double) as integer)", "-1");
        if (!this.enable) {
            return;
        }
        this.tester.checkScalarExact("cast( cast(1.75 as double) as integer)", "2");
        this.tester.checkScalarExact("cast( cast(-1.75 as double) as integer)", "-2");
        this.tester.checkScalarExact("cast( cast(1.5 as double) as integer)", "2");
        this.tester.checkScalarExact("cast( cast(-1.5 as double) as integer)", "-2");
    }

    @Test
    public void testCastApproxNumericLimits() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        for (int i = 0; i < NUMERIC_TYPE_NAMES.length; ++i) {
            boolean isFloat;
            String type = NUMERIC_TYPE_NAMES[i];
            if (type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("FLOAT")) {
                isFloat = false;
            } else {
                if (!type.equalsIgnoreCase("REAL")) continue;
                isFloat = true;
            }
            if (!this.enable) {
                return;
            }
            this.checkCastToApproxOkay(MAX_NUMERIC_STRINGS[i], type, Double.parseDouble(MAX_NUMERIC_STRINGS[i]), isFloat ? 1.0E32 : 0.0);
            this.checkCastToApproxOkay(MIN_NUMERIC_STRINGS[i], type, Double.parseDouble(MIN_NUMERIC_STRINGS[i]), 0.0);
            if (isFloat) {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, OUT_OF_RANGE_MESSAGE, true);
            } else {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, LITERAL_OUT_OF_RANGE_MESSAGE, false);
            }
            this.checkCastToApproxOkay(MIN_OVERFLOW_NUMERIC_STRINGS[i], type, 0.0, 0.0);
            this.checkCastToApproxOkay("'" + MAX_NUMERIC_STRINGS[i] + "'", type, Double.parseDouble(MAX_NUMERIC_STRINGS[i]), isFloat ? 1.0E32 : 0.0);
            this.checkCastToApproxOkay("'" + MIN_NUMERIC_STRINGS[i] + "'", type, Double.parseDouble(MIN_NUMERIC_STRINGS[i]), 0.0);
            this.checkCastFails("'" + MAX_OVERFLOW_NUMERIC_STRINGS[i] + "'", type, OUT_OF_RANGE_MESSAGE, true);
            this.checkCastToApproxOkay("'" + MIN_OVERFLOW_NUMERIC_STRINGS[i] + "'", type, 0.0, 0.0);
            this.checkCastToString(MAX_NUMERIC_STRINGS[i], null, isFloat ? null : "1.79769313486231E308");
            this.checkCastFails("'notnumeric'", type, INVALID_CHAR_MESSAGE, true);
        }
    }

    @Test
    public void testCastToApproxNumeric() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToApproxOkay("1", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("1.0", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("-2.3", "FLOAT", -2.3, 1.0E-6);
        this.checkCastToApproxOkay("'1'", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("'  -1e-37  '", "DOUBLE", -1.0E-37, 0.0);
        this.checkCastToApproxOkay("1e0", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("0e0", "REAL", 0.0, 0.0);
    }

    @Test
    public void testCastNull() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkNull("cast(null as integer)");
        this.tester.checkNull("cast(null as double)");
        this.tester.checkNull("cast(null as varchar(10))");
        this.tester.checkNull("cast(null as char(10))");
        this.tester.checkNull("cast(null as date)");
        this.tester.checkNull("cast(null as time)");
        this.tester.checkNull("cast(null as timestamp)");
        this.tester.checkNull("cast(null as interval year to month)");
        this.tester.checkNull("cast(null as interval day to second(3))");
        this.tester.checkNull("cast(null as boolean)");
    }

    @Test
    public void testCastDateTime() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(TIME '12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        if (this.enable) {
            this.tester.checkScalar("cast(TIME '12:42:25.9' as TIME)", "12:42:26", "TIME(0) NOT NULL");
        }
        this.tester.checkScalar("cast(DATE '1945-02-24' as DATE)", "1945-02-24", "DATE NOT NULL");
        if (this.enable) {
            this.tester.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        }
        this.checkCastToString("TIME '12:42:25'", null, "12:42:25");
        String today = new SimpleDateFormat("yyyy-MM-dd").format(SqlOperatorBaseTest.getCalendarNotTooNear(5).getTime());
        if (this.enable) {
            this.tester.checkScalar("cast(DATE '1945-02-24' as TIMESTAMP)", "1945-02-24 00:00:00", "TIMESTAMP(0) NOT NULL");
        }
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("cast(cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIME) as TIMESTAMP)", today + " 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(TIME '12:42:25.34' as TIMESTAMP)", today + " 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkScalar("cast(cast(TIMESTAMP '1945-02-24 12:42:25.34' as DATE) as TIMESTAMP)", "1945-02-24 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('12:42:25' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('1:42:25' as TIME)", "01:42:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('1:2:25' as TIME)", "01:02:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('  12:42:25  ' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.tester.checkFails("cast('nottime' as TIME)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('1241241' as TIME)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('12:54:78' as TIME)", BAD_DATETIME_MESSAGE, true);
        this.checkCastToString("TIMESTAMP '1945-02-24 12:42:25'", null, "1945-02-24 12:42:25");
        this.tester.checkScalar("cast('1945-02-24 12:42:25' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('1945-2-2 12:2:5' as TIMESTAMP)", "1945-02-02 12:02:05", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('  1945-02-24 12:42:25  ' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('1945-02-24 12:42:25.34' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkFails("cast('nottime' as TIMESTAMP)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('1241241' as TIMESTAMP)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('1945-20-24 12:42:25.34' as TIMESTAMP)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('1945-01-24 25:42:25.34' as TIMESTAMP)", BAD_DATETIME_MESSAGE, true);
        this.checkCastToString("DATE '1945-02-24'", null, "1945-02-24");
        this.checkCastToString("DATE '1945-2-24'", null, "1945-02-24");
        this.tester.checkScalar("cast('1945-02-24' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkScalar("cast('  1945-02-24  ' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkFails("cast('notdate' as DATE)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('52534253' as DATE)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkFails("cast('1945-30-24' as DATE)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkNull("cast(null as date)");
        this.tester.checkNull("cast(null as timestamp)");
        this.tester.checkNull("cast(null as time)");
        this.tester.checkNull("cast(cast(null as varchar(10)) as time)");
        this.tester.checkNull("cast(cast(null as varchar(10)) as date)");
        this.tester.checkNull("cast(cast(null as varchar(10)) as timestamp)");
        this.tester.checkNull("cast(cast(null as date) as timestamp)");
        this.tester.checkNull("cast(cast(null as time) as timestamp)");
        this.tester.checkNull("cast(cast(null as timestamp) as date)");
        this.tester.checkNull("cast(cast(null as timestamp) as time)");
    }

    /*
     * Exception decompiling
     */
    protected static Calendar getCalendarNotTooNear(int timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testCastToBoolean() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkBoolean("cast('true' as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast('false' as boolean)", Boolean.FALSE);
        this.tester.checkBoolean("cast('  trUe' as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast('  fALse' as boolean)", Boolean.FALSE);
        this.tester.checkFails("cast('unknown' as boolean)", INVALID_CHAR_MESSAGE, true);
        this.tester.checkBoolean("cast(cast('true' as varchar(10))  as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast(cast('false' as varchar(10)) as boolean)", Boolean.FALSE);
        this.tester.checkFails("cast(cast('blah' as varchar(10)) as boolean)", INVALID_CHAR_MESSAGE, true);
    }

    @Test
    public void testCase() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CASE, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("case when 'a'='a' then 1 end", "1");
        this.tester.checkString("case 2 when 1 then 'a' when 2 then 'bcd' end", "bcd", "CHAR(3)");
        this.tester.checkString("case 1 when 1 then 'a' when 2 then 'bcd' end", "a  ", "CHAR(3)");
        this.tester.checkString("case 1 when 1 then cast('a' as varchar(1)) when 2 then cast('bcd' as varchar(3)) end", "a", "VARCHAR(3)");
        this.tester.checkScalarExact("case 'a' when 'a' then 1 end", "1");
        this.tester.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then cast(4 as bigint) else 3 end", "DOUBLE NOT NULL", 11.2, 0.0);
        this.tester.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then 4 else null end", "DOUBLE", 11.2, 0.0);
        this.tester.checkScalarApprox("case 2 when 1 then 11.2e0 when 2 then 4 else null end", "DOUBLE", 4.0, 0.0);
        this.tester.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then 4.543 else null end", "DOUBLE", 11.2, 0.0);
        this.tester.checkScalarApprox("case 2 when 1 then 11.2e0 when 2 then 4.543 else null end", "DOUBLE", 4.543, 0.0);
        this.tester.checkNull("case 'a' when 'b' then 1 end");
        this.tester.checkString("case cast(null as int) when cast(null as int) then 'nulls match' else 'nulls do not match' end", "nulls do not match", "CHAR(18) NOT NULL");
        this.tester.checkScalarExact("case when 'a'=cast(null as varchar(1)) then 1 else 2 end", "2");
        this.tester.checkString("case when 'a' = cast(null as varchar(1)) then null else 'a' end", "a", "CHAR(1)");
        this.tester.checkString("case 1 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2           ", "CHAR(17) NOT NULL");
        this.tester.checkString("case 2 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2           ", "CHAR(17) NOT NULL");
        this.tester.checkString("case 3 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "3                ", "CHAR(17) NOT NULL");
        this.tester.checkString("case 4 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "none of the above", "CHAR(17) NOT NULL");
    }

    @Test
    public void testCaseType() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CASE, new SqlTester.VmName[0]);
        this.tester.checkType("case 1 when 1 then current_timestamp else null end", "TIMESTAMP(0)");
        this.tester.checkType("case 1 when 1 then current_timestamp else current_timestamp end", "TIMESTAMP(0) NOT NULL");
        this.tester.checkType("case when true then current_timestamp else null end", "TIMESTAMP(0)");
        this.tester.checkType("case when true then current_timestamp end", "TIMESTAMP(0)");
        this.tester.checkType("case 'x' when 'a' then 3 when 'b' then null else 4.5 end", "DECIMAL(11, 1)");
    }

    @Test
    public void testJdbcFn() {
        this.tester.setFor((SqlOperator)new SqlJdbcFunctionCall("dummy"), new SqlTester.VmName[0]);
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("{fn ABS(-3)}", 3, "INTEGER NOT NULL");
        this.tester.checkScalarApprox("{fn EXP(2)}", "DOUBLE NOT NULL", 7.389, 0.001);
        this.tester.checkScalarApprox("{fn LOG(10)}", "DOUBLE NOT NULL", 2.30258, 0.001);
        this.tester.checkScalarApprox("{fn LOG10(100)}", "DOUBLE NOT NULL", 2.0, 0.0);
        this.tester.checkScalar("{fn MOD(19, 4)}", 3, "INTEGER NOT NULL");
        this.tester.checkScalar("{fn POWER(2, 3)}", 8.0, "DOUBLE NOT NULL");
        this.tester.checkScalar("{fn CONCAT('foo', 'bar')}", "foobar", "CHAR(6) NOT NULL");
        this.tester.checkScalar("{fn INSERT('abc', 1, 2, 'ABCdef')}", "ABCdefc", "VARCHAR(9) NOT NULL");
        this.tester.checkScalar("{fn LCASE('foo' || 'bar')}", "foobar", "CHAR(6) NOT NULL");
        this.tester.checkScalar("{fn LOCATE('ha', 'alphabet')}", 4, "INTEGER NOT NULL");
        this.tester.checkScalar("{fn SUBSTRING('abcdef', 2, 3)}", "bcd", "VARCHAR(6) NOT NULL");
        this.tester.checkScalar("{fn UCASE('xxx')}", "XXX", "CHAR(3) NOT NULL");
        this.tester.checkType("{fn CURDATE()}", "DATE NOT NULL");
        this.tester.checkType("{fn CURTIME()}", "TIME(0) NOT NULL");
        this.tester.checkType("{fn NOW()}", "TIMESTAMP(0) NOT NULL");
    }

    @Test
    public void testSelect() {
        this.tester.check("select * from (values(1))", SqlTests.INTEGER_TYPE_CHECKER, "1", 0.0);
        if (this.getClass() != SqlOperatorTest.class) {
            // empty if block
        }
    }

    @Test
    public void testLiteralChain() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LITERAL_CHAIN, VM_EXPAND);
        this.tester.checkString("'buttered'\n' toast'", "buttered toast", "CHAR(14) NOT NULL");
        this.tester.checkString("'corned'\n' beef'\n' on'\n' rye'", "corned beef on rye", "CHAR(18) NOT NULL");
        this.tester.checkString("_latin1'Spaghetti'\n' all''Amatriciana'", "Spaghetti all'Amatriciana", "CHAR(25) NOT NULL");
        this.tester.checkBoolean("x'1234'\n'abcd' = x'1234abcd'", Boolean.TRUE);
        this.tester.checkBoolean("x'1234'\n'' = x'1234'", Boolean.TRUE);
        this.tester.checkBoolean("x''\n'ab' = x'ab'", Boolean.TRUE);
    }

    @Test
    public void testRow() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ROW, VM_FENNEL);
    }

    @Test
    public void testAndOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.AND, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true and false", Boolean.FALSE);
        this.tester.checkBoolean("true and true", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) and false", Boolean.FALSE);
        this.tester.checkBoolean("false and cast(null as boolean)", Boolean.FALSE);
        this.tester.checkNull("cast(null as boolean) and true");
        this.tester.checkBoolean("true and (not false)", Boolean.TRUE);
    }

    @Test
    public void testAndOperator2() {
        this.tester.checkBoolean("case when false then unknown else true end and true", Boolean.TRUE);
        this.tester.checkBoolean("case when false then cast(null as boolean) else true end and true", Boolean.TRUE);
        this.tester.checkBoolean("case when false then null else true end and true", Boolean.TRUE);
    }

    @Test
    public void testAndOperatorLazy() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.AND, new SqlTester.VmName[0]);
        this.tester.check("values 1 > 2 and sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, new ValueOrExceptionResultChecker(Boolean.FALSE, INVALID_ARG_FOR_POWER, CODE_2201F));
    }

    @Test
    public void testConcatOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CONCAT, new SqlTester.VmName[0]);
        this.tester.checkString(" 'a'||'b' ", "ab", "CHAR(2) NOT NULL");
        this.tester.checkNull(" 'a' || cast(null as char(2)) ");
        this.tester.checkNull(" cast(null as char(2)) || 'b' ");
        this.tester.checkNull(" cast(null as char(1)) || cast(null as char(2)) ");
        this.tester.checkString(" x'fe'||x'df' ", "fedf", "BINARY(2) NOT NULL");
        this.tester.checkNull("x'ff' || cast(null as varbinary)");
    }

    @Test
    public void testDivideOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DIVIDE, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("10 / 5", "2");
        this.tester.checkScalarExact("-10 / 5", "-2");
        this.tester.checkScalarExact("1 / 3", "0");
        this.tester.checkScalarApprox(" cast(10.0 as double) / 5", "DOUBLE NOT NULL", 2.0, 0.0);
        this.tester.checkScalarApprox(" cast(10.0 as real) / 5", "REAL NOT NULL", 2.0, 0.0);
        this.tester.checkScalarApprox(" 6.0 / cast(10.0 as real) ", "DOUBLE NOT NULL", 0.6, 0.0);
        this.tester.checkScalarExact("10.0 / 5.0", "DECIMAL(9, 6) NOT NULL", "2");
        this.tester.checkNull("1e1 / cast(null as float)");
        this.tester.checkFails("100.1 / 0.00000000000000001", OUT_OF_RANGE_MESSAGE, true);
    }

    @Test
    public void testDivideOperatorIntervals() {
        this.tester.checkScalar("interval '-2:2' hour to minute / 3", "-0:41", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.tester.checkScalar("interval '2:5:12' hour to second / 2 / -3", "-0:20:52.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkNull("interval '2' day / cast(null as bigint)");
        this.tester.checkNull("cast(null as interval month) / 2");
    }

    @Test
    public void testEqualsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EQUALS, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1=1", Boolean.TRUE);
        this.tester.checkBoolean("1=1.0", Boolean.TRUE);
        this.tester.checkBoolean("1.34=1.34", Boolean.TRUE);
        this.tester.checkBoolean("1=1.34", Boolean.FALSE);
        this.tester.checkBoolean("1e2=100e0", Boolean.TRUE);
        this.tester.checkBoolean("1e2=101", Boolean.FALSE);
        this.tester.checkBoolean("cast(1e2 as real)=cast(101 as bigint)", Boolean.FALSE);
        this.tester.checkBoolean("'a'='b'", Boolean.FALSE);
        this.tester.checkBoolean("true = true", Boolean.TRUE);
        this.tester.checkBoolean("true = false", Boolean.FALSE);
        this.tester.checkBoolean("false = true", Boolean.FALSE);
        this.tester.checkBoolean("false = false", Boolean.TRUE);
        this.tester.checkBoolean("cast('a' as varchar(30))=cast('a' as varchar(30))", Boolean.TRUE);
        this.tester.checkBoolean("cast('a ' as varchar(30))=cast('a' as varchar(30))", Boolean.TRUE);
        this.tester.checkBoolean("cast('a' as varchar(30))=cast('b' as varchar(30))", Boolean.FALSE);
        this.tester.checkBoolean("cast('a' as varchar(30))=cast('a' as varchar(15))", Boolean.TRUE);
        this.tester.checkNull("cast(null as boolean)=cast(null as boolean)");
        this.tester.checkNull("cast(null as integer)=1");
        this.tester.checkNull("cast(null as varchar(10))='a'");
    }

    @Test
    public void testEqualsOperatorInterval() {
        this.tester.checkBoolean("interval '2' day = interval '1' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day = interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2:2:2' hour to second = interval '2' hour", Boolean.FALSE);
        this.tester.checkNull("cast(null as interval hour) = interval '2' minute");
    }

    @Test
    public void testGreaterThanOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1>2", Boolean.FALSE);
        this.tester.checkBoolean("cast(-1 as TINYINT)>cast(1 as TINYINT)", Boolean.FALSE);
        this.tester.checkBoolean("cast(1 as SMALLINT)>cast(1 as SMALLINT)", Boolean.FALSE);
        this.tester.checkBoolean("2>1", Boolean.TRUE);
        this.tester.checkBoolean("1.1>1.2", Boolean.FALSE);
        this.tester.checkBoolean("-1.1>-1.2", Boolean.TRUE);
        this.tester.checkBoolean("1.1>1.1", Boolean.FALSE);
        this.tester.checkBoolean("1.2>1", Boolean.TRUE);
        this.tester.checkBoolean("1.1e1>1.2e1", Boolean.FALSE);
        this.tester.checkBoolean("cast(-1.1 as real) > cast(-1.2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("1.1e2>1.1e2", Boolean.FALSE);
        this.tester.checkBoolean("1.2e0>1", Boolean.TRUE);
        this.tester.checkBoolean("cast(1.2e0 as real)>1", Boolean.TRUE);
        this.tester.checkBoolean("true>false", Boolean.TRUE);
        this.tester.checkBoolean("true>true", Boolean.FALSE);
        this.tester.checkBoolean("false>false", Boolean.FALSE);
        this.tester.checkBoolean("false>true", Boolean.FALSE);
        this.tester.checkNull("3.0>cast(null as double)");
        this.tester.checkBoolean("DATE '2013-02-23' > DATE '1945-02-24'", Boolean.TRUE);
        this.tester.checkBoolean("DATE '2013-02-23' > CAST(NULL AS DATE)", null);
    }

    @Test
    public void testGreaterThanOperatorIntervals() {
        this.tester.checkBoolean("interval '2' day > interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day > interval '5' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2 2:2:2' day to second > interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day > interval '2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day > interval '-2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day > interval '2' hour", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' minute > interval '2' hour", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' second > interval '2' minute", Boolean.FALSE);
        this.tester.checkNull("cast(null as interval hour) > interval '2' minute");
        this.tester.checkNull("interval '2:2' hour to minute > cast(null as interval second)");
    }

    @Test
    public void testIsDistinctFromOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, VM_EXPAND);
        this.tester.checkBoolean("1 is distinct from 1", Boolean.FALSE);
        this.tester.checkBoolean("1 is distinct from 1.0", Boolean.FALSE);
        this.tester.checkBoolean("1 is distinct from 2", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as integer) is distinct from 2", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as integer) is distinct from cast(null as integer)", Boolean.FALSE);
        this.tester.checkBoolean("1.23 is distinct from 1.23", Boolean.FALSE);
        this.tester.checkBoolean("1.23 is distinct from 5.23", Boolean.TRUE);
        this.tester.checkBoolean("-23e0 is distinct from -2.3e1", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day is distinct from interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '10' hour is distinct from interval '10' hour", Boolean.FALSE);
    }

    @Test
    public void testIsNotDistinctFromOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, VM_EXPAND);
        this.tester.checkBoolean("1 is not distinct from 1", Boolean.TRUE);
        this.tester.checkBoolean("1 is not distinct from 1.0", Boolean.TRUE);
        this.tester.checkBoolean("1 is not distinct from 2", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as integer) is not distinct from 2", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as integer) is not distinct from cast(null as integer)", Boolean.TRUE);
        this.tester.checkBoolean("1.23 is not distinct from 1.23", Boolean.TRUE);
        this.tester.checkBoolean("1.23 is not distinct from 5.23", Boolean.FALSE);
        this.tester.checkBoolean("-23e0 is not distinct from -2.3e1", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day is not distinct from interval '1' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '10' hour is not distinct from interval '10' hour", Boolean.TRUE);
    }

    @Test
    public void testGreaterThanOrEqualOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1>=2", Boolean.FALSE);
        this.tester.checkBoolean("-1>=1", Boolean.FALSE);
        this.tester.checkBoolean("1>=1", Boolean.TRUE);
        this.tester.checkBoolean("2>=1", Boolean.TRUE);
        this.tester.checkBoolean("1.1>=1.2", Boolean.FALSE);
        this.tester.checkBoolean("-1.1>=-1.2", Boolean.TRUE);
        this.tester.checkBoolean("1.1>=1.1", Boolean.TRUE);
        this.tester.checkBoolean("1.2>=1", Boolean.TRUE);
        this.tester.checkBoolean("1.2e4>=1e5", Boolean.FALSE);
        this.tester.checkBoolean("1.2e4>=cast(1e5 as real)", Boolean.FALSE);
        this.tester.checkBoolean("1.2>=cast(1e5 as double)", Boolean.FALSE);
        this.tester.checkBoolean("120000>=cast(1e5 as real)", Boolean.TRUE);
        this.tester.checkBoolean("true>=false", Boolean.TRUE);
        this.tester.checkBoolean("true>=true", Boolean.TRUE);
        this.tester.checkBoolean("false>=false", Boolean.TRUE);
        this.tester.checkBoolean("false>=true", Boolean.FALSE);
        this.tester.checkNull("cast(null as real)>=999");
    }

    @Test
    public void testGreaterThanOrEqualOperatorIntervals() {
        this.tester.checkBoolean("interval '2' day >= interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '5' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2 2:2:2' day to second >= interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '-2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '2' hour", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' minute >= interval '2' hour", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' second >= interval '2' minute", Boolean.FALSE);
        this.tester.checkNull("cast(null as interval hour) >= interval '2' minute");
        this.tester.checkNull("interval '2:2' hour to minute >= cast(null as interval second)");
    }

    @Test
    public void testInOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IN, VM_EXPAND);
        this.tester.checkBoolean("1 in (0, 1, 2)", true);
        this.tester.checkBoolean("3 in (0, 1, 2)", false);
        this.tester.checkBoolean("cast(null as integer) in (0, 1, 2)", null);
        this.tester.checkBoolean("cast(null as integer) in (0, cast(null as integer), 2)", null);
        if (!this.enable) {
            return;
        }
        this.tester.checkBoolean("false and true in (false, false)", false);
    }

    @Test
    public void testNotInOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_IN, VM_EXPAND);
        this.tester.checkBoolean("1 not in (0, 1, 2)", false);
        this.tester.checkBoolean("3 not in (0, 1, 2)", true);
        if (!this.enable) {
            return;
        }
        this.tester.checkBoolean("cast(null as integer) not in (0, 1, 2)", null);
        this.tester.checkBoolean("cast(null as integer) not in (0, cast(null as integer), 2)", null);
        this.tester.checkBoolean("true and false not in (true, true)", true);
    }

    @Test
    public void testOverlapsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OVERLAPS, VM_EXPAND);
    }

    @Test
    public void testLessThanOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LESS_THAN, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1<2", Boolean.TRUE);
        this.tester.checkBoolean("-1<1", Boolean.TRUE);
        this.tester.checkBoolean("1<1", Boolean.FALSE);
        this.tester.checkBoolean("2<1", Boolean.FALSE);
        this.tester.checkBoolean("1.1<1.2", Boolean.TRUE);
        this.tester.checkBoolean("-1.1<-1.2", Boolean.FALSE);
        this.tester.checkBoolean("1.1<1.1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<1.1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<cast(1.2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("-1.1e-1<-1.2e-1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<cast(1.1 as double)", Boolean.FALSE);
        this.tester.checkBoolean("true<false", Boolean.FALSE);
        this.tester.checkBoolean("true<true", Boolean.FALSE);
        this.tester.checkBoolean("false<false", Boolean.FALSE);
        this.tester.checkBoolean("false<true", Boolean.TRUE);
        this.tester.checkNull("123<cast(null as bigint)");
        this.tester.checkNull("cast(null as tinyint)<123");
        this.tester.checkNull("cast(null as integer)<1.32");
    }

    @Test
    public void testLessThanOperatorInterval() {
    }

    @Test
    public void testLessThanOrEqualOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1<=2", Boolean.TRUE);
        this.tester.checkBoolean("1<=1", Boolean.TRUE);
        this.tester.checkBoolean("-1<=1", Boolean.TRUE);
        this.tester.checkBoolean("2<=1", Boolean.FALSE);
        this.tester.checkBoolean("1.1<=1.2", Boolean.TRUE);
        this.tester.checkBoolean("-1.1<=-1.2", Boolean.FALSE);
        this.tester.checkBoolean("1.1<=1.1", Boolean.TRUE);
        this.tester.checkBoolean("1.2<=1", Boolean.FALSE);
        this.tester.checkBoolean("1<=cast(1e2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("1000<=cast(1e2 as real)", Boolean.FALSE);
        this.tester.checkBoolean("1.2e1<=1e2", Boolean.TRUE);
        this.tester.checkBoolean("1.2e1<=cast(1e2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("true<=false", Boolean.FALSE);
        this.tester.checkBoolean("true<=true", Boolean.TRUE);
        this.tester.checkBoolean("false<=false", Boolean.TRUE);
        this.tester.checkBoolean("false<=true", Boolean.TRUE);
        this.tester.checkNull("cast(null as real)<=cast(1 as real)");
        this.tester.checkNull("cast(null as integer)<=3");
        this.tester.checkNull("3<=cast(null as smallint)");
        this.tester.checkNull("cast(null as integer)<=1.32");
    }

    @Test
    public void testLessThanOrEqualOperatorInterval() {
        this.tester.checkBoolean("interval '2' day <= interval '1' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day <= interval '5' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2 2:2:2' day to second <= interval '2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day <= interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day <= interval '-2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day <= interval '2' hour", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' minute <= interval '2' hour", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' second <= interval '2' minute", Boolean.TRUE);
        this.tester.checkNull("cast(null as interval hour) <= interval '2' minute");
        this.tester.checkNull("interval '2:2' hour to minute <= cast(null as interval second)");
    }

    @Test
    public void testMinusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MINUS, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("-2-1", "-3");
        this.tester.checkScalarExact("-2-1-5", "-8");
        this.tester.checkScalarExact("2-1", "1");
        this.tester.checkScalarApprox("cast(2.0 as double) -1", "DOUBLE NOT NULL", 1.0, 0.0);
        this.tester.checkScalarApprox("cast(1 as smallint)-cast(2.0 as real)", "REAL NOT NULL", -1.0, 0.0);
        this.tester.checkScalarApprox("2.4-cast(2.0 as real)", "DOUBLE NOT NULL", 0.4, 1.0E-8);
        this.tester.checkScalarExact("1-2", "-1");
        this.tester.checkScalarExact("10.0 - 5.0", "DECIMAL(4, 1) NOT NULL", "5.0");
        this.tester.checkScalarExact("19.68 - 4.2", "DECIMAL(5, 2) NOT NULL", "15.48");
        this.tester.checkNull("1e1-cast(null as double)");
        this.tester.checkNull("cast(null as tinyint) - cast(null as smallint)");
    }

    @Test
    public void testMinusIntervalOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MINUS, new SqlTester.VmName[0]);
        this.tester.checkScalar("interval '2' day - interval '1' day", "+1", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("interval '2' day - interval '1' minute", "+1 23:59", "INTERVAL DAY TO MINUTE NOT NULL");
        this.tester.checkScalar("interval '2' year - interval '1' month", "+1-11", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("interval '2' year - interval '1' month - interval '3' year", "-1-01", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("cast(null as interval day) + interval '2' hour");
        this.tester.checkScalar("time '12:03:01' - interval '1:1' hour to minute", "11:02:01", "TIME(0) NOT NULL");
    }

    @Test
    public void testMinusDateOperator() {
        this.tester.setFor(SqlStdOperatorTable.MINUS_DATE, new SqlTester.VmName[0]);
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("(time '12:03:34' - time '11:57:23') minute to second", "+6:11", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.tester.checkScalar("(time '12:03:23' - time '11:57:23') minute", "+6", "INTERVAL MINUTE NOT NULL");
        this.tester.checkScalar("(time '12:03:34' - time '11:57:23') minute", "+6", "INTERVAL MINUTE NOT NULL");
        this.tester.checkScalar("(timestamp '2004-05-01 12:03:34' - timestamp '2004-04-29 11:57:23') day to second", "+2 00:06:11", "INTERVAL DAY TO SECOND NOT NULL");
        this.tester.checkScalar("(timestamp '2004-05-01 12:03:34' - timestamp '2004-04-29 11:57:23') day to hour", "+2 00", "INTERVAL DAY TO HOUR NOT NULL");
        this.tester.checkScalar("(date '2004-12-02' - date '2003-12-01') day", "+367", "INTERVAL DAY NOT NULL");
        this.tester.checkNull("(cast(null as date) - date '2003-12-01') day");
        this.tester.checkScalar("timestamp '1969-04-29 0:0:0' + (timestamp '2008-07-15 15:28:00' -   timestamp '1969-04-29 0:0:0') day to second / 2", "1988-12-06 07:44:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("date '1969-04-29' + (date '2008-07-15' -   date '1969-04-29') day / 2", "1988-12-06", "DATE NOT NULL");
        this.tester.checkScalar("time '01:23:44' + (time '15:28:00' -   time '01:23:44') hour to second / 2", "08:25:52", "TIME(0) NOT NULL");
    }

    @Test
    public void testMultiplyOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MULTIPLY, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("2*3", "6");
        this.tester.checkScalarExact("2*-3", "-6");
        this.tester.checkScalarExact("+2*3", "6");
        this.tester.checkScalarExact("2*0", "0");
        this.tester.checkScalarApprox("cast(2.0 as float)*3", "FLOAT NOT NULL", 6.0, 0.0);
        this.tester.checkScalarApprox("3*cast(2.0 as real)", "REAL NOT NULL", 6.0, 0.0);
        this.tester.checkScalarApprox("cast(2.0 as real)*3.2", "DOUBLE NOT NULL", 6.4, 0.0);
        this.tester.checkScalarExact("10.0 * 5.0", "DECIMAL(5, 2) NOT NULL", "50.00");
        this.tester.checkScalarExact("19.68 * 4.2", "DECIMAL(6, 3) NOT NULL", "82.656");
        this.tester.checkNull("cast(1 as real)*cast(null as real)");
        this.tester.checkNull("2e-3*cast(null as integer)");
        this.tester.checkNull("cast(null as tinyint) * cast(4 as smallint)");
    }

    @Test
    public void testMultiplyIntervals() {
        this.tester.checkScalar("interval '2:2' hour to minute * 3", "+6:06", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.tester.checkScalar("3 * 2 * interval '2:5:12' hour to second", "+12:31:12.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkNull("interval '2' day * cast(null as bigint)");
        this.tester.checkNull("cast(null as interval month) * 2");
    }

    @Test
    public void testNotEqualsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1<>1", Boolean.FALSE);
        this.tester.checkBoolean("'a'<>'A'", Boolean.TRUE);
        this.tester.checkBoolean("1e0<>1e1", Boolean.TRUE);
        this.tester.checkNull("'a'<>cast(null as varchar(1))");
    }

    @Test
    public void testNotEqualsOperatorIntervals() {
        this.tester.checkBoolean("interval '2' day <> interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day <> interval '2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2:2:2' hour to second <> interval '2' hour", Boolean.TRUE);
        this.tester.checkNull("cast(null as interval hour) <> interval '2' minute");
        this.tester.checkFails("1 ^!^= 1", "(?s).*Encountered: \"!\" \\(33\\).*", false);
    }

    @Test
    public void testOrOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OR, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true or false", Boolean.TRUE);
        this.tester.checkBoolean("false or false", Boolean.FALSE);
        this.tester.checkBoolean("true or cast(null as boolean)", Boolean.TRUE);
        this.tester.checkNull("false or cast(null as boolean)");
    }

    @Test
    public void testOrOperatorLazy() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OR, new SqlTester.VmName[0]);
        this.tester.check("values 1 < cast(null as integer) or sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, new ValueOrExceptionResultChecker(null, INVALID_ARG_FOR_POWER, CODE_2201F));
        this.tester.check("values 1 < 2 or sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, new ValueOrExceptionResultChecker(Boolean.TRUE, INVALID_ARG_FOR_POWER, CODE_2201F));
        this.tester.check("values 1 < cast(null as integer) or sqrt(4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, new ValueOrExceptionResultChecker(null, INVALID_ARG_FOR_POWER, CODE_2201F));
        this.tester.checkBoolean("1 < cast(null as integer) or sqrt(4) = 2", Boolean.TRUE);
    }

    @Test
    public void testPlusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PLUS, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("1+2", "3");
        this.tester.checkScalarExact("-1+2", "1");
        this.tester.checkScalarExact("1+2+3", "6");
        this.tester.checkScalarApprox("1+cast(2.0 as double)", "DOUBLE NOT NULL", 3.0, 0.0);
        this.tester.checkScalarApprox("1+cast(2.0 as double)+cast(6.0 as float)", "DOUBLE NOT NULL", 9.0, 0.0);
        this.tester.checkScalarExact("10.0 + 5.0", "DECIMAL(4, 1) NOT NULL", "15.0");
        this.tester.checkScalarExact("19.68 + 4.2", "DECIMAL(5, 2) NOT NULL", "23.88");
        this.tester.checkScalarExact("19.68 + 4.2 + 6", "DECIMAL(13, 2) NOT NULL", "29.88");
        this.tester.checkScalarApprox("19.68 + cast(4.2 as float)", "DOUBLE NOT NULL", 23.88, 0.02);
        this.tester.checkNull("cast(null as tinyint)+1");
        this.tester.checkNull("1e-2+cast(null as double)");
    }

    @Test
    public void testPlusOperatorAny() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PLUS, new SqlTester.VmName[0]);
        this.tester.checkScalar("1+CAST(2 AS ANY)", "3", "ANY NOT NULL");
    }

    @Test
    public void testPlusIntervalOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PLUS, new SqlTester.VmName[0]);
        this.tester.checkScalar("interval '2' day + interval '1' day", "+3", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("interval '2' day + interval '1' minute", "+2 00:01", "INTERVAL DAY TO MINUTE NOT NULL");
        this.tester.checkScalar("interval '2' day + interval '5' minute + interval '-3' second", "+2 00:04:57.000000", "INTERVAL DAY TO SECOND NOT NULL");
        this.tester.checkScalar("interval '2' year + interval '1' month", "+2-01", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("interval '2' year + cast(null as interval month)");
        this.tester.checkScalar("time '12:03:01' + interval '1:1' hour to minute", "13:04:01", "TIME(0) NOT NULL");
    }

    @Test
    public void testDescendingOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DESC, VM_EXPAND);
    }

    @Test
    public void testIsNotNullOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is not null", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not null", Boolean.FALSE);
    }

    @Test
    public void testIsNullOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NULL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is null", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is null", Boolean.TRUE);
    }

    @Test
    public void testIsNotTrueOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is not true", Boolean.FALSE);
        this.tester.checkBoolean("false is not true", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not true", Boolean.TRUE);
        this.tester.checkFails("select ^'a string' is not true^ from (values (1))", "(?s)Cannot apply 'IS NOT TRUE' to arguments of type '<CHAR\\(8\\)> IS NOT TRUE'. Supported form\\(s\\): '<BOOLEAN> IS NOT TRUE'.*", false);
    }

    @Test
    public void testIsTrueOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_TRUE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is true", Boolean.TRUE);
        this.tester.checkBoolean("false is true", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is true", Boolean.FALSE);
    }

    @Test
    public void testIsNotFalseOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("false is not false", Boolean.FALSE);
        this.tester.checkBoolean("true is not false", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not false", Boolean.TRUE);
    }

    @Test
    public void testIsFalseOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_FALSE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("false is false", Boolean.TRUE);
        this.tester.checkBoolean("true is false", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is false", Boolean.FALSE);
    }

    @Test
    public void testIsNotUnknownOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_UNKNOWN, VM_EXPAND);
        this.tester.checkBoolean("false is not unknown", Boolean.TRUE);
        this.tester.checkBoolean("true is not unknown", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not unknown", Boolean.FALSE);
        this.tester.checkBoolean("unknown is not unknown", Boolean.FALSE);
        this.tester.checkFails("^'abc' IS NOT UNKNOWN^", "(?s).*Cannot apply 'IS NOT UNKNOWN'.*", false);
    }

    @Test
    public void testIsUnknownOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_UNKNOWN, VM_EXPAND);
        this.tester.checkBoolean("false is unknown", Boolean.FALSE);
        this.tester.checkBoolean("true is unknown", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is unknown", Boolean.TRUE);
        this.tester.checkBoolean("unknown is unknown", Boolean.TRUE);
        this.tester.checkFails("0 = 1 AND ^2 IS UNKNOWN^ AND 3 > 4", "(?s).*Cannot apply 'IS UNKNOWN'.*", false);
    }

    @Test
    public void testIsASetOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_A_SET, VM_EXPAND);
    }

    @Test
    public void testExistsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXISTS, VM_EXPAND);
    }

    @Test
    public void testNotOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT, new SqlTester.VmName[0]);
        this.tester.checkBoolean("not true", Boolean.FALSE);
        this.tester.checkBoolean("not false", Boolean.TRUE);
        this.tester.checkBoolean("not unknown", null);
        this.tester.checkNull("not cast(null as boolean)");
    }

    @Test
    public void testPrefixMinusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, new SqlTester.VmName[0]);
        this.tester.checkFails("'a' + ^- 'b'^ + 'c'", "(?s)Cannot apply '-' to arguments of type '-<CHAR\\(1\\)>'.*", false);
        this.tester.checkScalarExact("-1", "-1");
        this.tester.checkScalarExact("-1.23", "DECIMAL(3, 2) NOT NULL", "-1.23");
        this.tester.checkScalarApprox("-1.0e0", "DOUBLE NOT NULL", -1.0, 0.0);
        this.tester.checkNull("-cast(null as integer)");
        this.tester.checkNull("-cast(null as tinyint)");
    }

    @Test
    public void testPrefixMinusOperatorIntervals() {
        this.tester.checkScalar("-interval '-6:2:8' hour to second", "+6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("- -interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("-interval '5' month", "-5", "INTERVAL MONTH NOT NULL");
        this.tester.checkNull("-cast(null as interval day to minute)");
    }

    @Test
    public void testPrefixPlusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.UNARY_PLUS, VM_EXPAND);
        this.tester.checkScalarExact("+1", "1");
        this.tester.checkScalarExact("+1.23", "DECIMAL(3, 2) NOT NULL", "1.23");
        this.tester.checkScalarApprox("+1.0e0", "DOUBLE NOT NULL", 1.0, 0.0);
        this.tester.checkNull("+cast(null as integer)");
        this.tester.checkNull("+cast(null as tinyint)");
    }

    @Test
    public void testPrefixPlusOperatorIntervals() {
        this.tester.checkScalar("+interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("++interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("+interval '5' month", "+5", "INTERVAL MONTH NOT NULL");
        this.tester.checkNull("+cast(null as interval day to minute)");
    }

    @Test
    public void testExplicitTableOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXPLICIT_TABLE, VM_EXPAND);
    }

    @Test
    public void testValuesOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VALUES, VM_EXPAND);
        this.tester.check("select 'abc' from (values(true))", new SqlTests.StringTypeChecker("CHAR(3) NOT NULL"), "abc", 0.0);
    }

    @Test
    public void testNotLikeOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_LIKE, VM_EXPAND);
        this.tester.checkBoolean("'abc' not like '_b_'", Boolean.FALSE);
    }

    @Test
    public void testLikeOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LIKE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("''  like ''", Boolean.TRUE);
        this.tester.checkBoolean("'a' like 'a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' like 'b'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like 'A'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like '_a'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like '%a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' like '%a%'", Boolean.TRUE);
        this.tester.checkBoolean("'a' like 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   like 'a_'", Boolean.TRUE);
        this.tester.checkBoolean("'abc'  like 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' like 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   like '_b'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' like '_d'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' like '%d'", Boolean.TRUE);
    }

    @Test
    public void testNotSimilarToOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_SIMILAR_TO, VM_EXPAND);
        this.tester.checkBoolean("'ab' not similar to 'a_'", false);
        this.tester.checkBoolean("'aabc' not similar to 'ab*c+d'", true);
        this.tester.checkBoolean("'ab' not similar to 'a' || '_'", false);
        this.tester.checkBoolean("'ab' not similar to 'ba_'", true);
        this.tester.checkBoolean("cast(null as varchar(2)) not similar to 'a_'", null);
        this.tester.checkBoolean("cast(null as varchar(3)) not similar to cast(null as char(2))", null);
    }

    @Test
    public void testSimilarToOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SIMILAR_TO, new SqlTester.VmName[0]);
        this.tester.checkBoolean("''  similar to ''", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'b'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to 'A'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to '_a'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to '%a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to '%a%'", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   similar to 'a_'", Boolean.TRUE);
        this.tester.checkBoolean("'abc'  similar to 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' similar to 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   similar to '_b'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' similar to '_d'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' similar to '%d'", Boolean.TRUE);
        this.tester.checkBoolean("'acd'    similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd'   similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'acccd'  similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'abcccd' similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'abd'    similar to 'ab*c+d'", Boolean.FALSE);
        this.tester.checkBoolean("'aabc'   similar to 'ab*c+d'", Boolean.FALSE);
        this.tester.checkBoolean("'xy'      similar to 'x(ab|c)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'xccy'    similar to 'x(ab|c)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'xababcy' similar to 'x(ab|c)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'xbcy'    similar to 'x(ab|c)*y'", Boolean.FALSE);
        this.tester.checkBoolean("'xy'      similar to 'x(ab|c)+y'", Boolean.FALSE);
        this.tester.checkBoolean("'xccy'    similar to 'x(ab|c)+y'", Boolean.TRUE);
        this.tester.checkBoolean("'xababcy' similar to 'x(ab|c)+y'", Boolean.TRUE);
        this.tester.checkBoolean("'xbcy'    similar to 'x(ab|c)+y'", Boolean.FALSE);
        this.tester.checkBoolean("'ab' similar to 'a%' ", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a%' ", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' similar to 'a_' ", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' similar to 'a%' ", Boolean.TRUE);
        this.tester.checkBoolean("'1a' similar to '_a' ", Boolean.TRUE);
        this.tester.checkBoolean("'123aXYZ' similar to '%a%'", Boolean.TRUE);
        this.tester.checkBoolean("'123aXYZ' similar to '_%_a%_' ", Boolean.TRUE);
        this.tester.checkBoolean("'xy' similar to '(xy)' ", Boolean.TRUE);
        this.tester.checkBoolean("'abd' similar to '[ab][bcde]d' ", Boolean.TRUE);
        this.tester.checkBoolean("'bdd' similar to '[ab][bcde]d' ", Boolean.TRUE);
        this.tester.checkBoolean("'abd' similar to '[ab]d' ", Boolean.FALSE);
        this.tester.checkBoolean("'cd' similar to '[a-e]d' ", Boolean.TRUE);
        this.tester.checkBoolean("'amy' similar to 'amy|fred' ", Boolean.TRUE);
        this.tester.checkBoolean("'fred' similar to 'amy|fred' ", Boolean.TRUE);
        this.tester.checkBoolean("'mike' similar to 'amy|fred' ", Boolean.FALSE);
        this.tester.checkBoolean("'acd' similar to 'ab*c+d' ", Boolean.TRUE);
        this.tester.checkBoolean("'accccd' similar to 'ab*c+d' ", Boolean.TRUE);
        this.tester.checkBoolean("'abd' similar to 'ab*c+d' ", Boolean.FALSE);
        this.tester.checkBoolean("'aabc' similar to 'ab*c+d' ", Boolean.FALSE);
        this.tester.checkBoolean("'abb' similar to 'a(b{3})' ", Boolean.FALSE);
        this.tester.checkBoolean("'abbb' similar to 'a(b{3})' ", Boolean.TRUE);
        this.tester.checkBoolean("'abbbbb' similar to 'a(b{3})' ", Boolean.FALSE);
        this.tester.checkBoolean("'abbbbb' similar to 'ab{3,6}' ", Boolean.TRUE);
        this.tester.checkBoolean("'abbbbbbbb' similar to 'ab{3,6}' ", Boolean.FALSE);
        this.tester.checkBoolean("'' similar to 'ab?' ", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to 'ab?' ", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a(b?)' ", Boolean.TRUE);
        this.tester.checkBoolean("'ab' similar to 'ab?' ", Boolean.TRUE);
        this.tester.checkBoolean("'ab' similar to 'a(b?)' ", Boolean.TRUE);
        this.tester.checkBoolean("'abb' similar to 'ab?' ", Boolean.FALSE);
        this.tester.checkBoolean("'ab' similar to 'a\\_' ESCAPE '\\' ", Boolean.FALSE);
        this.tester.checkBoolean("'ab' similar to 'a\\%' ESCAPE '\\' ", Boolean.FALSE);
        this.tester.checkBoolean("'a_' similar to 'a\\_' ESCAPE '\\' ", Boolean.TRUE);
        this.tester.checkBoolean("'a%' similar to 'a\\%' ESCAPE '\\' ", Boolean.TRUE);
        this.tester.checkBoolean("'a(b{3})' similar to 'a(b{3})' ", Boolean.FALSE);
        this.tester.checkBoolean("'a(b{3})' similar to 'a\\(b\\{3\\}\\)' ESCAPE '\\' ", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[a-ey]d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[^a-ey]d'", Boolean.FALSE);
        this.tester.checkBoolean("'yd' similar to '[^a-ex-z]d'", Boolean.FALSE);
        this.tester.checkBoolean("'yd' similar to '[a-ex-z]d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[x-za-e]d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[^a-ey]?d'", Boolean.FALSE);
        this.tester.checkBoolean("'yyyd' similar to '[a-ey]*d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to 'x-zd'", Boolean.FALSE);
        this.tester.checkBoolean("'y' similar to 'x-z'", Boolean.FALSE);
        this.tester.checkBoolean("'cd' similar to '([a-e])d'", Boolean.TRUE);
        this.tester.checkBoolean("'xy' similar to 'x*?y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to 'x*?y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to '(x?)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to 'x+?y'", Boolean.FALSE);
        this.tester.checkBoolean("'y' similar to 'x?+y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to 'x*+y'", Boolean.TRUE);
        if (this.enable) {
            this.tester.checkBoolean("'y' similar to 'x+*y'", Boolean.TRUE);
            this.tester.checkBoolean("'y' similar to 'x?*y'", Boolean.TRUE);
        }
        this.tester.checkFails("'yd' similar to '[x-ze-a]d'", "Illegal character range near index 6\n\\[x-ze-a\\]d\n      \\^", true);
        this.tester.checkFails("'yd3223' similar to '[:LOWER:]{2}[:DIGIT:]{,5}'", "Illegal repetition near index 20\n\\[\\:LOWER\\:\\]\\{2\\}\\[\\:DIGIT\\:\\]\\{,5\\}\n                    \\^", true);
        this.tester.checkFails("'cd' similar to '[(a-e)]d' ", "Invalid regular expression: \\[\\(a-e\\)\\]d at 1", true);
        this.tester.checkFails("'yd' similar to '[(a-e)]d' ", "Invalid regular expression: \\[\\(a-e\\)\\]d at 1", true);
    }

    @Test
    public void testEscapeOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ESCAPE, VM_EXPAND);
    }

    @Test
    public void testConvertFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CONVERT, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testTranslateFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TRANSLATE, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testOverlayFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OVERLAY, new SqlTester.VmName[0]);
        this.tester.checkString("overlay('ABCdef' placing 'abc' from 1)", "abcdef", "VARCHAR(9) NOT NULL");
        this.tester.checkString("overlay('ABCdef' placing 'abc' from 1 for 2)", "abcCdef", "VARCHAR(9) NOT NULL");
        if (this.enable) {
            this.tester.checkString("overlay(cast('ABCdef' as varchar(10)) placing cast('abc' as char(5)) from 1 for 2)", "abc  Cdef", "VARCHAR(15) NOT NULL");
        }
        if (this.enable) {
            this.tester.checkString("overlay(cast('ABCdef' as char(10)) placing cast('abc' as char(5)) from 1 for 2)", "abc  Cdef    ", "VARCHAR(15) NOT NULL");
        }
        this.tester.checkNull("overlay('ABCdef' placing 'abc' from 1 for cast(null as integer))");
        this.tester.checkNull("overlay(cast(null as varchar(1)) placing 'abc' from 1)");
        this.tester.checkString("overlay(x'ABCdef' placing x'abcd' from 1)", "abcdef", "VARBINARY(5) NOT NULL");
        this.tester.checkString("overlay(x'ABCDEF1234' placing x'2345' from 1 for 2)", "2345ef1234", "VARBINARY(7) NOT NULL");
        if (this.enable) {
            this.tester.checkString("overlay(cast(x'ABCdef' as varbinary(5)) placing cast(x'abcd' as binary(3)) from 1 for 2)", "abc  Cdef", "VARBINARY(8) NOT NULL");
        }
        if (this.enable) {
            this.tester.checkString("overlay(cast(x'ABCdef' as binary(5)) placing cast(x'abcd' as binary(3)) from 1 for 2)", "abc  Cdef    ", "VARBINARY(8) NOT NULL");
        }
        this.tester.checkNull("overlay(x'ABCdef' placing x'abcd' from 1 for cast(null as integer))");
        this.tester.checkNull("overlay(cast(null as varbinary(1)) placing x'abcd' from 1)");
        this.tester.checkNull("overlay(x'abcd' placing x'abcd' from cast(null as integer))");
    }

    @Test
    public void testPositionFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.POSITION, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("position('b' in 'abc')", "2");
        this.tester.checkScalarExact("position('' in 'abc')", "1");
        this.tester.checkScalarExact("position('tra' in 'fdgjklewrtra')", "10");
        this.tester.checkNull("position(cast(null as varchar(1)) in '0010')");
        this.tester.checkNull("position('a' in cast(null as varchar(1)))");
        this.tester.checkScalar("position(cast('a' as char) in cast('bca' as varchar))", 0, "INTEGER NOT NULL");
    }

    @Test
    public void testCharLengthFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("char_length('abc')", "3");
        this.tester.checkNull("char_length(cast(null as varchar(1)))");
    }

    @Test
    public void testCharacterLengthFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("CHARACTER_LENGTH('abc')", "3");
        this.tester.checkNull("CHARACTER_LENGTH(cast(null as varchar(1)))");
    }

    @Test
    public void testUpperFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.UPPER, new SqlTester.VmName[0]);
        this.tester.checkString("upper('a')", "A", "CHAR(1) NOT NULL");
        this.tester.checkString("upper('A')", "A", "CHAR(1) NOT NULL");
        this.tester.checkString("upper('1')", "1", "CHAR(1) NOT NULL");
        this.tester.checkString("upper('aa')", "AA", "CHAR(2) NOT NULL");
        this.tester.checkNull("upper(cast(null as varchar(1)))");
    }

    @Test
    public void testLowerFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOWER, new SqlTester.VmName[0]);
        this.tester.checkString("lower('A')", "a", "CHAR(1) NOT NULL");
        this.tester.checkString("lower('a')", "a", "CHAR(1) NOT NULL");
        this.tester.checkString("lower('1')", "1", "CHAR(1) NOT NULL");
        this.tester.checkString("lower('AA')", "aa", "CHAR(2) NOT NULL");
        this.tester.checkNull("lower(cast(null as varchar(1)))");
    }

    @Test
    public void testInitcapFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.INITCAP, VM_FENNEL);
        this.tester.checkString("initcap('aA')", "Aa", "CHAR(2) NOT NULL");
        this.tester.checkString("initcap('Aa')", "Aa", "CHAR(2) NOT NULL");
        this.tester.checkString("initcap('1a')", "1a", "CHAR(2) NOT NULL");
        this.tester.checkString("initcap('ab cd Ef 12')", "Ab Cd Ef 12", "CHAR(11) NOT NULL");
        this.tester.checkNull("initcap(cast(null as varchar(1)))");
        this.tester.checkFails("^initcap(cast(null as date))^", "Cannot apply 'INITCAP' to arguments of type 'INITCAP\\(<DATE>\\)'\\. Supported form\\(s\\): 'INITCAP\\(<CHARACTER>\\)'", false);
    }

    @Test
    public void testPowerFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.POWER, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("power(2,-2)", "DOUBLE NOT NULL", 0.25, 0.0);
        this.tester.checkNull("power(cast(null as integer),2)");
        this.tester.checkNull("power(2,cast(null as double))");
        this.tester.checkFails("^pow(2,-2)^", "No match found for function signature POW\\(<NUMERIC>, <NUMERIC>\\)", false);
    }

    @Test
    public void testSqrtFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SQRT, SqlTester.VmName.EXPAND);
        this.tester.checkType("sqrt(2)", "DOUBLE NOT NULL");
        this.tester.checkType("sqrt(cast(2 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("sqrt(case when false then 2 else null end)", "DOUBLE");
        this.tester.checkFails("^sqrt('abc')^", "Cannot apply 'SQRT' to arguments of type 'SQRT\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SQRT\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("sqrt(2)", "DOUBLE NOT NULL", 1.4142, 1.0E-4);
        this.tester.checkNull("sqrt(cast(null as integer))");
        this.tester.checkNull("sqrt(cast(null as double))");
    }

    @Test
    public void testExpFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXP, VM_FENNEL);
        this.tester.checkScalarApprox("exp(2)", "DOUBLE NOT NULL", 7.389056, 1.0E-6);
        this.tester.checkScalarApprox("exp(-2)", "DOUBLE NOT NULL", 0.1353, 1.0E-4);
        this.tester.checkNull("exp(cast(null as integer))");
        this.tester.checkNull("exp(cast(null as double))");
    }

    @Test
    public void testModFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MOD, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("mod(4,2)", "0");
        this.tester.checkScalarExact("mod(8,5)", "3");
        this.tester.checkScalarExact("mod(-12,7)", "-5");
        this.tester.checkScalarExact("mod(-12,-7)", "-5");
        this.tester.checkScalarExact("mod(12,-7)", "5");
        this.tester.checkScalarExact("mod(cast(12 as tinyint), cast(-7 as tinyint))", "TINYINT NOT NULL", "5");
        this.tester.checkScalarExact("mod(cast(9 as decimal(2, 0)), 7)", "INTEGER NOT NULL", "2");
        this.tester.checkScalarExact("mod(7, cast(9 as decimal(2, 0)))", "DECIMAL(2, 0) NOT NULL", "7");
        this.tester.checkScalarExact("mod(cast(-9 as decimal(2, 0)), cast(7 as decimal(1, 0)))", "DECIMAL(1, 0) NOT NULL", "-2");
        this.tester.checkNull("mod(cast(null as integer),2)");
        this.tester.checkNull("mod(4,cast(null as tinyint))");
        this.tester.checkNull("mod(4,cast(null as decimal(12,0)))");
    }

    @Test
    public void testModFuncDivByZero() {
        this.tester.checkFails("mod(3,case 'a' when 'a' then 0 end)", DIVISION_BY_ZERO_MESSAGE, true);
    }

    @Test
    public void testLnFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LN, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("ln(2.71828)", "DOUBLE NOT NULL", 1.0, 1.0E-6);
        this.tester.checkScalarApprox("ln(2.71828)", "DOUBLE NOT NULL", 0.999999327, 1.0E-7);
        this.tester.checkNull("ln(cast(null as tinyint))");
    }

    @Test
    public void testLogFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOG10, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("log10(10)", "DOUBLE NOT NULL", 1.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(100.0)", "DOUBLE NOT NULL", 2.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(cast(10e8 as double))", "DOUBLE NOT NULL", 9.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(cast(10e2 as float))", "DOUBLE NOT NULL", 3.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(cast(10e-3 as real))", "DOUBLE NOT NULL", -2.0, 1.0E-6);
        this.tester.checkNull("log10(cast(null as real))");
    }

    @Test
    public void testAbsFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ABS, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("abs(-1)", "1");
        this.tester.checkScalarExact("abs(cast(10 as TINYINT))", "TINYINT NOT NULL", "10");
        this.tester.checkScalarExact("abs(cast(-20 as SMALLINT))", "SMALLINT NOT NULL", "20");
        this.tester.checkScalarExact("abs(cast(-100 as INT))", "INTEGER NOT NULL", "100");
        this.tester.checkScalarExact("abs(cast(1000 as BIGINT))", "BIGINT NOT NULL", "1000");
        this.tester.checkScalarExact("abs(54.4)", "DECIMAL(3, 1) NOT NULL", "54.4");
        this.tester.checkScalarExact("abs(-54.4)", "DECIMAL(3, 1) NOT NULL", "54.4");
        this.tester.checkScalarApprox("abs(-9.32E-2)", "DOUBLE NOT NULL", 0.0932, 0.0);
        this.tester.checkScalarApprox("abs(cast(-3.5 as double))", "DOUBLE NOT NULL", 3.5, 0.0);
        this.tester.checkScalarApprox("abs(cast(-3.5 as float))", "FLOAT NOT NULL", 3.5, 0.0);
        this.tester.checkScalarApprox("abs(cast(3.5 as real))", "REAL NOT NULL", 3.5, 0.0);
        this.tester.checkNull("abs(cast(null as double))");
    }

    @Test
    public void testAbsFuncIntervals() {
        this.tester.checkScalar("abs(interval '-2' day)", "+2", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("abs(interval '-5-03' year to month)", "+5-03", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("abs(cast(null as interval hour))");
    }

    @Test
    public void testNullifFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NULLIF, VM_EXPAND);
        this.tester.checkNull("nullif(1,1)");
        this.tester.checkScalarExact("nullif(1.5, 13.56)", "DECIMAL(2, 1)", "1.5");
        this.tester.checkScalarExact("nullif(13.56, 1.5)", "DECIMAL(4, 2)", "13.56");
        this.tester.checkScalarExact("nullif(1.5, 3)", "DECIMAL(2, 1)", "1.5");
        this.tester.checkScalarExact("nullif(3, 1.5)", "INTEGER", "3");
        this.tester.checkScalarApprox("nullif(1.5e0, 3e0)", "DOUBLE", 1.5, 0.0);
        this.tester.checkScalarApprox("nullif(1.5, cast(3e0 as REAL))", "DECIMAL(2, 1)", 1.5, 0.0);
        this.tester.checkScalarExact("nullif(3, 1.5e0)", "INTEGER", "3");
        this.tester.checkScalarExact("nullif(3, cast(1.5e0 as REAL))", "INTEGER", "3");
        this.tester.checkScalarApprox("nullif(1.5e0, 3.4)", "DOUBLE", 1.5, 0.0);
        this.tester.checkScalarExact("nullif(3.4, 1.5e0)", "DECIMAL(2, 1)", "3.4");
        this.tester.checkString("nullif('a','bc')", "a", "CHAR(1)");
        this.tester.checkString("nullif('a',cast(null as varchar(1)))", "a", "CHAR(1)");
        this.tester.checkNull("nullif(cast(null as varchar(1)),'a')");
        this.tester.checkNull("nullif(cast(null as numeric(4,3)), 4.3)");
        this.tester.checkFails("1 + ^nullif(1, date '2005-8-4')^ + 2", "(?s)Cannot apply '=' to arguments of type '<INTEGER> = <DATE>'\\..*", false);
        this.tester.checkFails("1 + ^nullif(1, 2, 3)^ + 2", "Invalid number of arguments to function 'NULLIF'\\. Was expecting 2 arguments", false);
    }

    @Test
    public void testNullIfOperatorIntervals() {
        this.tester.checkScalar("nullif(interval '2' month, interval '3' year)", "+2", "INTERVAL MONTH");
    }

    @Test
    public void testCoalesceFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COALESCE, VM_EXPAND);
        this.tester.checkString("coalesce('a','b')", "a", "CHAR(1) NOT NULL");
        this.tester.checkScalarExact("coalesce(null,null,3)", "3");
        this.tester.checkFails("1 + ^coalesce('a', 'b', 1, null)^ + 2", "Illegal mixing of types in CASE or COALESCE statement", false);
    }

    @Test
    public void testUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.USER, VM_FENNEL);
        this.tester.checkString("USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_USER, VM_FENNEL);
        this.tester.checkString("CURRENT_USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testSessionUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SESSION_USER, VM_FENNEL);
        this.tester.checkString("SESSION_USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testSystemUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SYSTEM_USER, VM_FENNEL);
        String user = System.getProperty("user.name");
        this.tester.checkString("SYSTEM_USER", user, "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentPathFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_PATH, VM_FENNEL);
        this.tester.checkString("CURRENT_PATH", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentRoleFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_ROLE, VM_FENNEL);
        this.tester.checkString("CURRENT_ROLE", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testLocalTimeFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOCALTIME, new SqlTester.VmName[0]);
        this.tester.checkScalar("LOCALTIME", TIME_PATTERN, "TIME(0) NOT NULL");
        this.tester.checkFails("^LOCALTIME()^", "No match found for function signature LOCALTIME\\(\\)", false);
        this.tester.checkScalar("LOCALTIME(1)", TIME_PATTERN, "TIME(1) NOT NULL");
        this.tester.checkScalar("CAST(LOCALTIME AS VARCHAR(30))", Pattern.compile(SqlOperatorBaseTest.currentTimeString(LOCAL_TZ).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("LOCALTIME", Pattern.compile(SqlOperatorBaseTest.currentTimeString(LOCAL_TZ).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "TIME(0) NOT NULL");
    }

    @Test
    public void testLocalTimestampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, new SqlTester.VmName[0]);
        this.tester.checkScalar("LOCALTIMESTAMP", TIMESTAMP_PATTERN, "TIMESTAMP(0) NOT NULL");
        this.tester.checkFails("^LOCALTIMESTAMP()^", "No match found for function signature LOCALTIMESTAMP\\(\\)", false);
        this.tester.checkFails("LOCALTIMESTAMP(^4000000000^)", LITERAL_OUT_OF_RANGE_MESSAGE, false);
        this.tester.checkScalar("LOCALTIMESTAMP(1)", TIMESTAMP_PATTERN, "TIMESTAMP(1) NOT NULL");
        this.tester.checkScalar("CAST(LOCALTIMESTAMP AS VARCHAR(30))", Pattern.compile(SqlOperatorBaseTest.currentTimeString(LOCAL_TZ) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("LOCALTIMESTAMP", Pattern.compile(SqlOperatorBaseTest.currentTimeString(LOCAL_TZ) + "[0-9][0-9]:[0-9][0-9]"), "TIMESTAMP(0) NOT NULL");
    }

    @Test
    public void testCurrentTimeFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, new SqlTester.VmName[0]);
        this.tester.checkScalar("CURRENT_TIME", TIME_PATTERN, "TIME(0) NOT NULL");
        this.tester.checkFails("^CURRENT_TIME()^", "No match found for function signature CURRENT_TIME\\(\\)", false);
        this.tester.checkScalar("CURRENT_TIME(1)", TIME_PATTERN, "TIME(1) NOT NULL");
        this.tester.checkScalar("CAST(CURRENT_TIME AS VARCHAR(30))", Pattern.compile(SqlOperatorBaseTest.currentTimeString(CURRENT_TZ).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("CURRENT_TIME", Pattern.compile(SqlOperatorBaseTest.currentTimeString(CURRENT_TZ).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "TIME(0) NOT NULL");
    }

    @Test
    public void testCurrentTimestampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, new SqlTester.VmName[0]);
        this.tester.checkScalar("CURRENT_TIMESTAMP", TIMESTAMP_PATTERN, "TIMESTAMP(0) NOT NULL");
        this.tester.checkFails("^CURRENT_TIMESTAMP()^", "No match found for function signature CURRENT_TIMESTAMP\\(\\)", false);
        this.tester.checkFails("CURRENT_TIMESTAMP(^4000000000^)", LITERAL_OUT_OF_RANGE_MESSAGE, false);
        this.tester.checkScalar("CURRENT_TIMESTAMP(1)", TIMESTAMP_PATTERN, "TIMESTAMP(1) NOT NULL");
        this.tester.checkScalar("CAST(CURRENT_TIMESTAMP AS VARCHAR(30))", Pattern.compile(SqlOperatorBaseTest.currentTimeString(CURRENT_TZ) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("CURRENT_TIMESTAMP", Pattern.compile(SqlOperatorBaseTest.currentTimeString(CURRENT_TZ) + "[0-9][0-9]:[0-9][0-9]"), "TIMESTAMP(0) NOT NULL");
    }

    protected static String currentTimeString(TimeZone tz) {
        Calendar calendar = SqlOperatorBaseTest.getCalendarNotTooNear(11);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:");
        sdf.setTimeZone(tz);
        return sdf.format(calendar.getTime());
    }

    @Test
    public void testCurrentDateFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, VM_FENNEL);
        this.tester.checkScalar("CURRENT_DATE", DATE_PATTERN, "DATE NOT NULL");
        this.tester.checkScalar("(CURRENT_DATE - CURRENT_DATE) DAY", "+0", "INTERVAL DAY NOT NULL");
        this.tester.checkBoolean("CURRENT_DATE IS NULL", false);
        this.tester.checkBoolean("CURRENT_DATE IS NOT NULL", true);
        this.tester.checkBoolean("NOT (CURRENT_DATE IS NULL)", true);
        this.tester.checkFails("^CURRENT_DATE()^", "No match found for function signature CURRENT_DATE\\(\\)", false);
        this.tester.checkScalar("CAST(CURRENT_DATE AS VARCHAR(30))", SqlOperatorBaseTest.currentTimeString(LOCAL_TZ).substring(0, 10), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("CURRENT_DATE", SqlOperatorBaseTest.currentTimeString(LOCAL_TZ).substring(0, 10), "DATE NOT NULL");
    }

    @Test
    public void testSubstringFunction() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SUBSTRING, new SqlTester.VmName[0]);
        this.tester.checkString("substring('abc' from 1 for 2)", "ab", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 2)", "bc", "VARCHAR(3) NOT NULL");
        this.tester.checkNull("substring(cast(null as varchar(1)),1,2)");
    }

    @Test
    public void testTrimFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TRIM, new SqlTester.VmName[0]);
        this.tester.checkString("trim('a' from 'aAa')", "A", "VARCHAR(3) NOT NULL");
        this.tester.checkString("trim(both 'a' from 'aAa')", "A", "VARCHAR(3) NOT NULL");
        this.tester.checkString("trim(leading 'a' from 'aAa')", "Aa", "VARCHAR(3) NOT NULL");
        this.tester.checkString("trim(trailing 'a' from 'aAa')", "aA", "VARCHAR(3) NOT NULL");
        this.tester.checkNull("trim(cast(null as varchar(1)) from 'a')");
        this.tester.checkNull("trim('a' from cast(null as varchar(1)))");
    }

    @Test
    public void testWindow() {
        if (!this.enable) {
            return;
        }
        this.tester.check("select sum(1) over (order by x) from (select 1 as x, 2 as y from (values (true)))", new SqlTests.StringTypeChecker("INTEGER"), "1", 0.0);
    }

    @Test
    public void testElementFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ELEMENT, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testCardinalityFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CARDINALITY, VM_FENNEL, VM_JAVA);
        if (!this.enable) {
            return;
        }
        this.tester.checkScalarExact("cardinality(array['foo', 'bar'])", "2");
        this.tester.checkScalarExact("cardinality(map['foo', 1, 'bar', 2])", "2");
    }

    @Test
    public void testMemberOfOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MEMBER_OF, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testCollectFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COLLECT, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testFusionFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.FUSION, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testExtractFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(day from interval '2 3:4:5.678' day to second)", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(day from interval '23456 3:4:5.678' day(5) to second)", "23456", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(hour from interval '2 3:4:5.678' day to second)", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from interval '2 3:4:5.678' day to second)", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(second from interval '2 3:4:5.678' day to second)", "5", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(year from interval '4-2' year to month)", "4", "BIGINT NOT NULL");
    }

    @Test
    public void testExtractFuncFromDateTime() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(year from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(month from date '2008-2-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(month from timestamp '2008-2-23 12:34:56')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from timestamp '2008-2-23 12:34:56')", "34", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from time '12:23:34')", "23", "BIGINT NOT NULL");
        this.tester.checkNull("extract(month from cast(null as timestamp))");
        this.tester.checkNull("extract(month from cast(null as date))");
        this.tester.checkNull("extract(second from cast(null as time))");
    }

    @Test
    public void testArrayValueConstructor() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, new SqlTester.VmName[0]);
        this.tester.checkScalar("Array['foo', 'bar']", "[foo, bar]", "CHAR(3) NOT NULL ARRAY NOT NULL");
        this.tester.checkFails("^Array[]^", "Require at least 1 argument", false);
    }

    @Test
    public void testItemOp() {
        this.tester.setFor(SqlStdOperatorTable.ITEM, new SqlTester.VmName[0]);
        this.tester.checkScalar("ARRAY ['foo', 'bar'][1]", "foo", "CHAR(3)");
        this.tester.checkScalar("ARRAY ['foo', 'bar'][0]", null, "CHAR(3)");
        this.tester.checkScalar("ARRAY ['foo', 'bar'][2]", "bar", "CHAR(3)");
        this.tester.checkScalar("ARRAY ['foo', 'bar'][3]", null, "CHAR(3)");
        this.tester.checkNull("ARRAY ['foo', 'bar'][1 + CAST(NULL AS INTEGER)]");
        this.tester.checkFails("^ARRAY ['foo', 'bar']['baz']^", "Cannot apply 'ITEM' to arguments of type 'ITEM\\(<CHAR\\(3\\) ARRAY>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): <ARRAY>\\[<INTEGER>\\]\n<MAP>\\[<VALUE>\\]", false);
        this.tester.checkScalar("ARRAY [2, 4, 6][2]", "4", "INTEGER");
        this.tester.checkScalar("ARRAY [2, 4, 6][4]", null, "INTEGER");
        this.tester.checkScalarExact("map['foo', 3, 'bar', 7]['bar']", "INTEGER", "7");
        this.tester.checkScalarExact("map['foo', CAST(NULL AS INTEGER), 'bar', 7]['bar']", "INTEGER", "7");
        this.tester.checkScalarExact("map['foo', CAST(NULL AS INTEGER), 'bar', 7]['baz']", "INTEGER", null);
    }

    @Test
    public void testMapValueConstructor() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, VM_JAVA);
        this.tester.checkFails("^Map[]^", "Map requires at least 2 arguments", false);
        this.tester.checkFails("^Map[1, 'x', 2]^", "Map requires an even number of arguments", false);
        this.tester.checkFails("^map[1, 1, 2, 'x']^", "Parameters must be of the same type", false);
        this.tester.checkScalarExact("map['washington', 1, 'obama', 44]", "(CHAR(10) NOT NULL, INTEGER NOT NULL) MAP NOT NULL", "{washington=1, obama=44}");
    }

    @Test
    public void testCeilFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CEIL, VM_FENNEL);
        if (!this.enable) {
            return;
        }
        this.tester.checkScalarApprox("ceil(10.1e0)", "DOUBLE NOT NULL", 11.0, 0.0);
        this.tester.checkScalarApprox("ceil(cast(-11.2e0 as real))", "REAL NOT NULL", -11.0, 0.0);
        this.tester.checkScalarExact("ceil(100)", "INTEGER NOT NULL", "100");
        this.tester.checkScalarExact("ceil(1.3)", "DECIMAL(2, 0) NOT NULL", "2");
        this.tester.checkScalarExact("ceil(-1.7)", "DECIMAL(2, 0) NOT NULL", "-1");
        this.tester.checkNull("ceiling(cast(null as decimal(2,0)))");
        this.tester.checkNull("ceiling(cast(null as double))");
    }

    @Test
    public void testCeilFuncInterval() {
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("ceil(interval '3:4:5' hour to second)", "+4:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("ceil(interval '-6.3' second)", "-6.000000", "INTERVAL SECOND NOT NULL");
        this.tester.checkScalar("ceil(interval '5-1' year to month)", "+6-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("ceil(interval '-5-1' year to month)", "-5-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("ceil(cast(null as interval year))");
    }

    @Test
    public void testFloorFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.FLOOR, VM_FENNEL);
        if (!this.enable) {
            return;
        }
        this.tester.checkScalarApprox("floor(2.5e0)", "DOUBLE NOT NULL", 2.0, 0.0);
        this.tester.checkScalarApprox("floor(cast(-1.2e0 as real))", "REAL NOT NULL", -2.0, 0.0);
        this.tester.checkScalarExact("floor(100)", "INTEGER NOT NULL", "100");
        this.tester.checkScalarExact("floor(1.7)", "DECIMAL(2, 0) NOT NULL", "1");
        this.tester.checkScalarExact("floor(-1.7)", "DECIMAL(2, 0) NOT NULL", "-2");
        this.tester.checkNull("floor(cast(null as decimal(2,0)))");
        this.tester.checkNull("floor(cast(null as real))");
    }

    @Test
    public void testFloorFuncInterval() {
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("floor(interval '3:4:5' hour to second)", "+3:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("floor(interval '-6.3' second)", "-7.000000", "INTERVAL SECOND NOT NULL");
        this.tester.checkScalar("floor(interval '5-1' year to month)", "+5-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("floor(interval '-5-1' year to month)", "-6-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("floor(cast(null as interval year))");
    }

    @Test
    public void testDenseRankFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DENSE_RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testPercentRankFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PERCENT_RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testRankFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testCumeDistFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CUME_DIST, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testRowNumberFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ROW_NUMBER, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testCountFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COUNT, VM_EXPAND);
        this.tester.checkType("count(*)", "BIGINT NOT NULL");
        this.tester.checkType("count('name')", "BIGINT NOT NULL");
        this.tester.checkType("count(1)", "BIGINT NOT NULL");
        this.tester.checkType("count(1.2)", "BIGINT NOT NULL");
        this.tester.checkType("COUNT(DISTINCT 'x')", "BIGINT NOT NULL");
        this.tester.checkFails("^COUNT()^", "Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments", false);
        this.tester.checkFails("^COUNT(1, 2)^", "Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "1", "0"};
        this.tester.checkAgg("COUNT(x)", values, 3, 0.0);
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("COUNT(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 2, 0.0);
        this.tester.checkAgg("COUNT(DISTINCT x)", values, 2, 0.0);
        String[] stringValues = new String[]{"'a'", "CAST(NULL AS VARCHAR(1))", "''"};
        this.tester.checkAgg("COUNT(*)", stringValues, 3, 0.0);
        this.tester.checkAgg("COUNT(x)", stringValues, 2, 0.0);
        this.tester.checkAgg("COUNT(DISTINCT x)", stringValues, 2, 0.0);
        this.tester.checkAgg("COUNT(DISTINCT 123)", stringValues, 1, 0.0);
    }

    @Test
    public void testSumFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SUM, VM_EXPAND);
        this.tester.checkFails("sum(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^sum('name')^", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<CHAR\\(4\\)>\\)'\\. Supported form\\(s\\): 'SUM\\(<NUMERIC>\\)'.*", false);
        this.checkAggType(this.tester, "sum(1)", "INTEGER NOT NULL");
        this.checkAggType(this.tester, "sum(1.2)", "DECIMAL(2, 1) NOT NULL");
        this.checkAggType(this.tester, "sum(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        this.tester.checkFails("^sum()^", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments", false);
        this.tester.checkFails("^sum(1, 2)^", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments", false);
        this.tester.checkFails("^sum(cast(null as varchar(2)))^", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'SUM\\(<NUMERIC>\\)'.*", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        this.tester.checkAgg("sum(x)", values, 4, 0.0);
        Integer result1 = -3;
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("sum(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result1, 0.0);
        Integer result = -1;
        this.tester.checkAgg("sum(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result, 0.0);
        this.tester.checkAgg("sum(DISTINCT x)", values, 2, 0.0);
    }

    protected void checkAggType(SqlTester tester, String expr, String type) {
        tester.checkColumnType(SqlTesterImpl.buildQueryAgg(expr), type);
    }

    @Test
    public void testAvgFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.AVG, VM_EXPAND);
        this.tester.checkFails("avg(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^avg(cast(null as varchar(2)))^", "(?s)Cannot apply 'AVG' to arguments of type 'AVG\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'AVG\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("AVG(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "AVG(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        this.checkAggType(this.tester, "avg(1)", "INTEGER NOT NULL");
        this.checkAggType(this.tester, "avg(1.2)", "DECIMAL(2, 1) NOT NULL");
        this.checkAggType(this.tester, "avg(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        if (!this.enable) {
            return;
        }
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        this.tester.checkAgg("AVG(x)", values, 2.0, 0.0);
        this.tester.checkAgg("AVG(DISTINCT x)", values, 1.5, 0.0);
        Integer result = -1;
        this.tester.checkAgg("avg(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result, 0.0);
    }

    @Test
    public void testStddevPopFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.STDDEV_POP, VM_EXPAND);
        this.tester.checkFails("stddev_pop(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^stddev_pop(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV_POP' to arguments of type 'STDDEV_POP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV_POP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("stddev_pop(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "stddev_pop(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("stddev_pop(x)", values, 1.414213562373095, 1.0E-15);
        this.tester.checkAgg("stddev_pop(DISTINCT x)", values, 1.5, 0.0);
        this.tester.checkAgg("stddev_pop(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 0, 0.0);
        this.tester.checkAgg("stddev_pop(x)", new String[]{"5"}, 0, 0.0);
        this.tester.checkAgg("stddev_pop(x)", new String[0], null, 0.0);
    }

    @Test
    public void testStddevSampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.STDDEV_SAMP, VM_EXPAND);
        this.tester.checkFails("stddev_samp(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^stddev_samp(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV_SAMP' to arguments of type 'STDDEV_SAMP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV_SAMP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("stddev_samp(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "stddev_samp(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("stddev_samp(x)", values, 1.732050807568877, 1.0E-15);
        this.tester.checkAgg("stddev_samp(DISTINCT x)", values, 2.121320343559642, 1.0E-15);
        this.tester.checkAgg("stddev_samp(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, null, 0.0);
        this.tester.checkAgg("stddev_samp(x)", new String[]{"5"}, null, 0.0);
        this.tester.checkAgg("stddev_samp(x)", new String[0], null, 0.0);
    }

    @Test
    public void testVarPopFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VAR_POP, VM_EXPAND);
        this.tester.checkFails("var_pop(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^var_pop(cast(null as varchar(2)))^", "(?s)Cannot apply 'VAR_POP' to arguments of type 'VAR_POP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VAR_POP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("var_pop(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "var_pop(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("var_pop(x)", values, 2.0, 0.0);
        this.tester.checkAgg("var_pop(DISTINCT x)", values, 2.25, 1.0E-4);
        this.tester.checkAgg("var_pop(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 0, 0.0);
        this.tester.checkAgg("var_pop(x)", new String[]{"5"}, 0, 0.0);
        this.tester.checkAgg("var_pop(x)", new String[0], null, 0.0);
    }

    @Test
    public void testVarSampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VAR_SAMP, VM_EXPAND);
        this.tester.checkFails("var_samp(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^var_samp(cast(null as varchar(2)))^", "(?s)Cannot apply 'VAR_SAMP' to arguments of type 'VAR_SAMP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VAR_SAMP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("var_samp(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "var_samp(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("var_samp(x)", values, 3.0, 0.0);
        this.tester.checkAgg("var_samp(DISTINCT x)", values, 4.5, 1.0E-4);
        this.tester.checkAgg("var_samp(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, null, 0.0);
        this.tester.checkAgg("var_samp(x)", new String[]{"5"}, null, 0.0);
        this.tester.checkAgg("var_samp(x)", new String[0], null, 0.0);
    }

    @Test
    public void testMinFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MIN, VM_EXPAND);
        this.tester.checkFails("min(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("min(1)", "INTEGER NOT NULL");
        this.tester.checkType("min(1.2)", "DECIMAL(2, 1) NOT NULL");
        this.tester.checkType("min(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        this.tester.checkFails("^min()^", "Invalid number of arguments to function 'MIN'. Was expecting 1 arguments", false);
        this.tester.checkFails("^min(1, 2)^", "Invalid number of arguments to function 'MIN'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("min(x)", values, "0", 0.0);
        this.tester.checkAgg("min(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("min(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("min(DISTINCT x)", values, "0", 0.0);
    }

    @Test
    public void testMaxFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MAX, VM_EXPAND);
        this.tester.checkFails("max(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("max(1)", "INTEGER NOT NULL");
        this.tester.checkType("max(1.2)", "DECIMAL(2, 1) NOT NULL");
        this.tester.checkType("max(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        this.tester.checkFails("^max()^", "Invalid number of arguments to function 'MAX'. Was expecting 1 arguments", false);
        this.tester.checkFails("^max(1, 2)^", "Invalid number of arguments to function 'MAX'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("max(x)", values, "2", 0.0);
        this.tester.checkAgg("max(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("max(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("max(DISTINCT x)", values, "2", 0.0);
    }

    @Test
    public void testLastValueFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LAST_VALUE, VM_EXPAND);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkWinAgg("last_value(x)", values, "ROWS 3 PRECEDING", "INTEGER", Arrays.asList("3", "0"), 0.0);
        String[] values2 = new String[]{"1.6", "1.2"};
        this.tester.checkWinAgg("last_value(x)", values2, "ROWS 3 PRECEDING", "DECIMAL(2, 1) NOT NULL", Arrays.asList("1.6", "1.2"), 0.0);
        String[] values3 = new String[]{"'foo'", "'bar'", "'name'"};
        this.tester.checkWinAgg("last_value(x)", values3, "ROWS 3 PRECEDING", "CHAR(4) NOT NULL", Arrays.asList("foo ", "bar ", "name"), 0.0);
    }

    @Test
    public void testFirstValueFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.FIRST_VALUE, VM_EXPAND);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkWinAgg("first_value(x)", values, "ROWS 3 PRECEDING", "INTEGER", Arrays.asList("0"), 0.0);
        String[] values2 = new String[]{"1.6", "1.2"};
        this.tester.checkWinAgg("first_value(x)", values2, "ROWS 3 PRECEDING", "DECIMAL(2, 1) NOT NULL", Arrays.asList("1.6"), 0.0);
        String[] values3 = new String[]{"'foo'", "'bar'", "'name'"};
        this.tester.checkWinAgg("first_value(x)", values3, "ROWS 3 PRECEDING", "CHAR(4) NOT NULL", Arrays.asList("foo "), 0.0);
    }

    @Test
    public void testLiteralAtLimit() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        if (!this.enable) {
            return;
        }
        for (BasicSqlType type : SqlLimitsTest.getTypes()) {
            for (Object o : this.getValues(type, true)) {
                SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
                SqlString literalString = literal.toSqlString(SqlDialect.DUMMY);
                String expr = "CAST(" + literalString + " AS " + type + ")";
                try {
                    this.tester.checkType(expr, type.getFullTypeString());
                    if (type.getSqlTypeName() == SqlTypeName.BINARY) continue;
                    this.tester.checkScalar(expr + " = " + literalString, true, "BOOLEAN NOT NULL");
                }
                catch (Error e) {
                    System.out.println("Failed for expr=[" + expr + "]");
                    throw e;
                }
                catch (RuntimeException e) {
                    System.out.println("Failed for expr=[" + expr + "]");
                    throw e;
                }
            }
        }
    }

    @Test
    public void testLiteralBeyondLimit() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        for (BasicSqlType type : SqlLimitsTest.getTypes()) {
            for (Object o : this.getValues(type, false)) {
                SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
                SqlString literalString = literal.toSqlString(SqlDialect.DUMMY);
                if (type.getSqlTypeName() == SqlTypeName.BIGINT || type.getSqlTypeName() == SqlTypeName.DECIMAL && type.getPrecision() == 19) {
                    this.tester.checkFails("CAST(^" + literalString + "^ AS " + type + ")", "Numeric literal '.*' out of range", false);
                    continue;
                }
                if (type.getSqlTypeName() == SqlTypeName.CHAR || type.getSqlTypeName() == SqlTypeName.VARCHAR || type.getSqlTypeName() == SqlTypeName.BINARY || type.getSqlTypeName() == SqlTypeName.VARBINARY) continue;
                this.tester.checkFails("CAST(" + literalString + " AS " + type + ")", "(?s).*(Overflow during calculation or cast\\.|Code=22003).*", true);
            }
        }
    }

    @Test
    public void testCastTruncates() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalar("CAST('ABCD' AS CHAR(2))", "AB", "CHAR(2) NOT NULL");
        this.tester.checkScalar("CAST('ABCD' AS VARCHAR(2))", "AB", "VARCHAR(2) NOT NULL");
        this.tester.checkScalar("CAST(x'ABCDEF12' AS BINARY(2))", "abcd", "BINARY(2) NOT NULL");
        this.tester.checkScalar("CAST(x'ABCDEF12' AS VARBINARY(2))", "abcd", "VARBINARY(2) NOT NULL");
        if (!this.enable) {
            return;
        }
        this.tester.checkBoolean("CAST(X'' AS BINARY(3)) = X'000000'", true);
        this.tester.checkBoolean("CAST(X'' AS BINARY(3)) = X''", false);
    }

    private List<Object> getValues(BasicSqlType type, boolean inBound) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (boolean sign : FALSE_TRUE) {
            for (SqlTypeName.Limit limit : SqlTypeName.Limit.values()) {
                Object o = type.getLimit(sign, limit, !inBound);
                if (o == null || values.contains(o)) continue;
                values.add(o);
            }
        }
        return values;
    }

    public static SqlTester tester(Connection connection) {
        return new TesterImpl(connection);
    }

    static {
        CURRENT_TZ = LOCAL_TZ = TimeZone.getDefault();
        INVALID_ARG_FOR_POWER = Pattern.compile("(?s).*Invalid argument\\(s\\) for 'POWER' function.*");
        CODE_2201F = Pattern.compile("(?s).*could not calculate results for the following row.*PC=5 Code=2201F.*");
    }

    protected static class TesterImpl
    extends SqlTesterImpl {
        final Connection connection;

        public TesterImpl(Connection connection) {
            super(DefaultSqlTestFactory.INSTANCE);
            this.connection = connection;
        }

        public void check(String query, SqlTester.TypeChecker typeChecker, SqlTester.ResultChecker resultChecker) {
            super.check(query, typeChecker, resultChecker);
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery(query);
                resultChecker.checkResult(resultSet);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ValueOrExceptionResultChecker
    implements SqlTester.ResultChecker {
        private final Object expected;
        private final Pattern[] patterns;

        public ValueOrExceptionResultChecker(Object expected, Pattern ... patterns) {
            this.expected = expected;
            this.patterns = patterns;
        }

        public void checkResult(ResultSet result) throws Exception {
            SQLException thrown = null;
            try {
                if (!result.next()) {
                    return;
                }
                Object actual = result.getObject(1);
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (SQLException e) {
                thrown = e;
            }
            if (thrown != null) {
                String stack = Util.getStackTrace((Throwable)thrown);
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(stack).matches()) continue;
                    return;
                }
                Assert.fail((String)("Stack did not match any pattern; " + stack));
            }
        }
    }

    private static class ExceptionResultChecker
    implements SqlTester.ResultChecker {
        private final Pattern[] patterns;

        public ExceptionResultChecker(Pattern ... patterns) {
            this.patterns = patterns;
        }

        public void checkResult(ResultSet result) throws Exception {
            SQLException thrown = null;
            try {
                result.next();
                Assert.fail((String)"expected exception");
            }
            catch (SQLException e) {
                thrown = e;
            }
            String stack = Util.getStackTrace((Throwable)thrown);
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(stack).matches()) continue;
                return;
            }
            Assert.fail((String)("Stack did not match any pattern; " + stack));
        }
    }
}

