/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcFrontLinqBackTest {
    @Test
    public void testSelect() {
        OptiqAssert.that().query("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\nwhere s.\"cust_id\" = 100").returns("cust_id=100; prod_id=10\n");
    }

    @Test
    public void testJoin() {
        OptiqAssert.that().query("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"hr\".\"emps\" as e\non e.\"empid\" = s.\"cust_id\"").returns("cust_id=100; prod_id=10; empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\ncust_id=150; prod_id=20; empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\n");
    }

    @Test
    public void testGroupBy() {
        OptiqAssert.that().query("select \"deptno\", sum(\"empid\") as s, count(*) as c\nfrom \"hr\".\"emps\" as e\ngroup by \"deptno\"").returns("deptno=20; S=200; C=1\ndeptno=10; S=360; C=3\n");
    }

    @Test
    public void testOrderBy() {
        OptiqAssert.that().query("select upper(\"name\") as un, \"deptno\"\nfrom \"hr\".\"emps\" as e\norder by \"deptno\", \"name\" desc").returns("UN=THEODORE; deptno=10\nUN=SEBASTIAN; deptno=10\nUN=BILL; deptno=10\nUN=ERIC; deptno=20\n");
    }

    @Test
    public void testUnionAllOrderBy() {
        OptiqAssert.that().query("select \"name\"\nfrom \"hr\".\"emps\" as e\nunion all\nselect \"name\"\nfrom \"hr\".\"depts\"\norder by 1 desc").returns("name=Theodore\nname=Sebastian\nname=Sales\nname=Marketing\nname=HR\nname=Eric\nname=Bill\n");
    }

    @Test
    public void testUnion() {
        OptiqAssert.that().query("select substring(\"name\" from 1 for 1) as x\nfrom \"hr\".\"emps\" as e\nunion\nselect substring(\"name\" from 1 for 1) as y\nfrom \"hr\".\"depts\"").returnsUnordered("X=T", "X=E", "X=S", "X=B", "X=M", "X=H");
    }

    @Ignore
    @Test
    public void testIntersect() {
        OptiqAssert.that().query("select substring(\"name\" from 1 for 1) as x\nfrom \"hr\".\"emps\" as e\nintersect\nselect substring(\"name\" from 1 for 1) as y\nfrom \"hr\".\"depts\"").returns("X=S\n");
    }

    @Ignore
    @Test
    public void testExcept() {
        OptiqAssert.that().query("select substring(\"name\" from 1 for 1) as x\nfrom \"hr\".\"emps\" as e\nexcept\nselect substring(\"name\" from 1 for 1) as y\nfrom \"hr\".\"depts\"").returnsUnordered("X=T", "X=E", "X=B");
    }

    @Test
    public void testWhereBad() {
        OptiqAssert.that().query("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\nwhere empid > 120").throws_("Column 'EMPID' not found in any table");
    }

    @Test
    public void testWhereOr() {
        OptiqAssert.that().query("select * from \"hr\".\"emps\"\nwhere (\"empid\" = 100 or \"empid\" = 200)\nand \"deptno\" = 10").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testWhereLike() {
        OptiqAssert.that().query("select *\nfrom \"hr\".\"emps\" as e\nwhere e.\"empid\" < 120 or e.\"name\" like 'S%'").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
    }

    @Test
    public void testInsert() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        OptiqAssert.AssertThat with = this.mutable(employees);
        with.query("select * from \"foo\".\"bar\"").returns("empid=0; deptno=0; name=first; salary=0.0; commission=null\n");
        with.query("insert into \"foo\".\"bar\" select * from \"hr\".\"emps\"").returns("ROWCOUNT=4\n");
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=5\n");
        with.query("insert into \"foo\".\"bar\" select * from \"hr\".\"emps\" where \"deptno\" = 10").returns("ROWCOUNT=3\n");
        with.query("select \"name\", count(*) as c from \"foo\".\"bar\" group by \"name\"").returnsUnordered("name=Bill; C=2", "name=Eric; C=1", "name=Theodore; C=2", "name=first; C=1", "name=Sebastian; C=2");
    }

    private OptiqAssert.AssertThat mutable(final List<JdbcTest.Employee> employees) {
        employees.add(new JdbcTest.Employee(0, 0, "first", 0.0f, null));
        return OptiqAssert.that().with(new OptiqAssert.ConnectionFactory(){

            public OptiqConnection createConnection() throws Exception {
                OptiqConnection connection = OptiqAssert.getConnection("hr", "foodmart");
                OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
                SchemaPlus rootSchema = optiqConnection.getRootSchema();
                SchemaPlus mapSchema = rootSchema.add("foo", (Schema)new AbstractSchema());
                String tableName = "bar";
                JdbcTest.AbstractModifiableTable table = new JdbcTest.AbstractModifiableTable("bar"){

                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        return ((JavaTypeFactory)typeFactory).createType(JdbcTest.Employee.class);
                    }

                    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                            public Enumerator<T> enumerator() {
                                return Linq4j.enumerator((Collection)employees);
                            }
                        };
                    }

                    public Type getElementType() {
                        return JdbcTest.Employee.class;
                    }

                    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
                        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
                    }

                    public Collection getModifiableCollection() {
                        return employees;
                    }
                };
                mapSchema.add("bar", (Table)table);
                return optiqConnection;
            }
        });
    }

    @Test
    public void testInsert2() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        OptiqAssert.AssertThat with = this.mutable(employees);
        with.query("insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)").returns("ROWCOUNT=1\n");
        with.query("insert into \"foo\".\"bar\"\nvalues (1, 3, 'third', 0, 3), (1, 4, 'fourth', 0, 4), (1, 5, 'fifth ', 0, 3)").returns("ROWCOUNT=3\n");
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=5\n");
        with.query("insert into \"foo\".\"bar\" values (1, 6, null, 0, null)").returns("ROWCOUNT=1\n");
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=6\n");
    }

    @Test
    public void testInsertMultipleRowMismatch() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        OptiqAssert.AssertThat with = this.mutable(employees);
        with.query("insert into \"foo\".\"bar\" values\n (1, 3, 'third'),\n (1, 4, 'fourth'),\n (1, 5, 'fifth ', 3)").throws_("Incompatible types");
    }
}

