/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.clone;

import java.util.Arrays;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.optiq.impl.clone.ArrayTable;
import net.hydromatic.optiq.impl.clone.ColumnLoader;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.junit.Assert;
import org.junit.Test;

public class ArrayTableTest {
    @Test
    public void testPrimitiveArray() {
        int i;
        long[] values = new long[]{0L, 0L};
        ArrayTable.BitSlicedPrimitiveArray.orLong((int)4, (long[])values, (int)0, (long)15L);
        Assert.assertEquals((long)15L, (long)values[0]);
        ArrayTable.BitSlicedPrimitiveArray.orLong((int)4, (long[])values, (int)2, (long)15L);
        Assert.assertEquals((long)3855L, (long)values[0]);
        values = new long[]{1302406798037686297L, 2532189736284989738L, 3761972674532293179L};
        Assert.assertEquals((long)804L, (long)ArrayTable.BitSlicedPrimitiveArray.getLong((int)12, (long[])values, (int)9));
        Assert.assertEquals((long)2619L, (long)ArrayTable.BitSlicedPrimitiveArray.getLong((int)12, (long[])values, (int)10));
        Arrays.fill(values, 0L);
        for (i = 0; i < 10; ++i) {
            ArrayTable.BitSlicedPrimitiveArray.orLong((int)10, (long[])values, (int)i, (long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)ArrayTable.BitSlicedPrimitiveArray.getLong((int)10, (long[])values, (int)i));
        }
    }

    @Test
    public void testNextPowerOf2() {
        Assert.assertEquals((long)1L, (long)ColumnLoader.nextPowerOf2((int)1));
        Assert.assertEquals((long)2L, (long)ColumnLoader.nextPowerOf2((int)2));
        Assert.assertEquals((long)4L, (long)ColumnLoader.nextPowerOf2((int)3));
        Assert.assertEquals((long)4L, (long)ColumnLoader.nextPowerOf2((int)4));
        Assert.assertEquals((long)0x40000000L, (long)ColumnLoader.nextPowerOf2((int)878082202));
        Assert.assertEquals((long)0x40000000L, (long)ColumnLoader.nextPowerOf2((int)0x40000000));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)ColumnLoader.nextPowerOf2((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)ColumnLoader.nextPowerOf2((int)0x7FFFFFFE));
    }

    @Test
    public void testLog2() {
        Assert.assertEquals((long)0L, (long)ColumnLoader.log2((int)0));
        Assert.assertEquals((long)0L, (long)ColumnLoader.log2((int)1));
        Assert.assertEquals((long)1L, (long)ColumnLoader.log2((int)2));
        Assert.assertEquals((long)2L, (long)ColumnLoader.log2((int)4));
        Assert.assertEquals((long)16L, (long)ColumnLoader.log2((int)65536));
        Assert.assertEquals((long)15L, (long)ColumnLoader.log2((int)65535));
        Assert.assertEquals((long)16L, (long)ColumnLoader.log2((int)65537));
        Assert.assertEquals((long)30L, (long)ColumnLoader.log2((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)30L, (long)ColumnLoader.log2((int)0x7FFFFFFE));
        Assert.assertEquals((long)29L, (long)ColumnLoader.log2((int)0x3FFFFFFF));
        Assert.assertEquals((long)30L, (long)ColumnLoader.log2((int)0x40000000));
    }

    @Test
    public void testValueSetInt() {
        ColumnLoader.ValueSet valueSet = new ColumnLoader.ValueSet(Integer.TYPE);
        valueSet.add((Comparable)Integer.valueOf(0));
        valueSet.add((Comparable)Integer.valueOf(1));
        valueSet.add((Comparable)Integer.valueOf(10));
        ArrayTable.Column pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.BitSlicedPrimitiveArray));
        ArrayTable.BitSlicedPrimitiveArray representation = (ArrayTable.BitSlicedPrimitiveArray)pair.representation;
        Assert.assertEquals((long)4L, (long)representation.bitCount);
        Assert.assertFalse((boolean)representation.signed);
        Assert.assertEquals((long)0L, (long)representation.getInt(pair.dataSet, 0));
        Assert.assertEquals((long)1L, (long)representation.getInt(pair.dataSet, 1));
        Assert.assertEquals((long)10L, (long)representation.getInt(pair.dataSet, 2));
        Assert.assertEquals((Object)10, (Object)representation.getObject(pair.dataSet, 2));
        valueSet.add((Comparable)Integer.valueOf(-32));
        pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.BitSlicedPrimitiveArray));
        representation = (ArrayTable.BitSlicedPrimitiveArray)pair.representation;
        Assert.assertEquals((long)6L, (long)representation.bitCount);
        Assert.assertTrue((boolean)representation.signed);
        Assert.assertEquals((long)10L, (long)representation.getInt(pair.dataSet, 2));
        Assert.assertEquals((Object)10, (Object)representation.getObject(pair.dataSet, 2));
        Assert.assertEquals((long)-32L, (long)representation.getInt(pair.dataSet, 3));
        Assert.assertEquals((Object)-32, (Object)representation.getObject(pair.dataSet, 3));
        valueSet.add((Comparable)Integer.valueOf(63));
        pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.BitSlicedPrimitiveArray));
        representation = (ArrayTable.BitSlicedPrimitiveArray)pair.representation;
        Assert.assertEquals((long)7L, (long)representation.bitCount);
        Assert.assertTrue((boolean)representation.signed);
        valueSet.add((Comparable)Integer.valueOf(64));
        pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.PrimitiveArray));
        ArrayTable.PrimitiveArray representation2 = (ArrayTable.PrimitiveArray)pair.representation;
        Assert.assertEquals((long)0L, (long)representation2.getInt(pair.dataSet, 0));
        Assert.assertEquals((long)-32L, (long)representation2.getInt(pair.dataSet, 3));
        Assert.assertEquals((Object)-32, (Object)representation2.getObject(pair.dataSet, 3));
        Assert.assertEquals((long)64L, (long)representation2.getInt(pair.dataSet, 5));
        Assert.assertEquals((Object)64, (Object)representation2.getObject(pair.dataSet, 5));
    }

    @Test
    public void testValueSetBoolean() {
        ColumnLoader.ValueSet valueSet = new ColumnLoader.ValueSet(Boolean.TYPE);
        valueSet.add((Comparable)Integer.valueOf(0));
        valueSet.add((Comparable)Integer.valueOf(1));
        valueSet.add((Comparable)Integer.valueOf(1));
        valueSet.add((Comparable)Integer.valueOf(0));
        ArrayTable.Column pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.BitSlicedPrimitiveArray));
        ArrayTable.BitSlicedPrimitiveArray representation = (ArrayTable.BitSlicedPrimitiveArray)pair.representation;
        Assert.assertEquals((long)1L, (long)representation.bitCount);
        Assert.assertEquals((long)0L, (long)representation.getInt(pair.dataSet, 0));
        Assert.assertEquals((long)1L, (long)representation.getInt(pair.dataSet, 1));
        Assert.assertEquals((long)1L, (long)representation.getInt(pair.dataSet, 2));
        Assert.assertEquals((long)0L, (long)representation.getInt(pair.dataSet, 3));
    }

    @Test
    public void testValueSetZero() {
        ColumnLoader.ValueSet valueSet = new ColumnLoader.ValueSet(Boolean.TYPE);
        valueSet.add((Comparable)Integer.valueOf(0));
        ArrayTable.Column pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.Constant));
        ArrayTable.Constant representation = (ArrayTable.Constant)pair.representation;
        Assert.assertEquals((long)0L, (long)representation.getInt(pair.dataSet, 0));
        Assert.assertEquals((long)1L, (long)pair.cardinality);
    }

    @Test
    public void testStrings() {
        ColumnLoader.ValueSet valueSet = new ColumnLoader.ValueSet(String.class);
        valueSet.add((Comparable)((Object)"foo"));
        valueSet.add((Comparable)((Object)"foo"));
        ArrayTable.Column pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.ObjectArray));
        ArrayTable.ObjectArray representation = (ArrayTable.ObjectArray)pair.representation;
        Assert.assertEquals((Object)"foo", (Object)representation.getObject(pair.dataSet, 0));
        Assert.assertEquals((Object)"foo", (Object)representation.getObject(pair.dataSet, 1));
        Assert.assertEquals((long)1L, (long)pair.cardinality);
        for (int i = 0; i < 2000; ++i) {
            valueSet.add((Comparable)((Object)"foo"));
        }
        pair = valueSet.freeze(0, null);
        ArrayTable.ObjectDictionary representation2 = (ArrayTable.ObjectDictionary)pair.representation;
        Assert.assertTrue((boolean)(representation2.representation instanceof ArrayTable.Constant));
        Assert.assertEquals((Object)"foo", (Object)representation2.getObject(pair.dataSet, 0));
        Assert.assertEquals((Object)"foo", (Object)representation2.getObject(pair.dataSet, 1000));
        Assert.assertEquals((long)1L, (long)pair.cardinality);
        valueSet.add((Comparable)((Object)"bar"));
        pair = valueSet.freeze(0, null);
        ArrayTable.ObjectDictionary representation3 = (ArrayTable.ObjectDictionary)pair.representation;
        Assert.assertTrue((boolean)(representation3.representation instanceof ArrayTable.BitSlicedPrimitiveArray));
        ArrayTable.BitSlicedPrimitiveArray representation4 = (ArrayTable.BitSlicedPrimitiveArray)representation3.representation;
        Assert.assertEquals((long)1L, (long)representation4.bitCount);
        Assert.assertFalse((boolean)representation4.signed);
        Assert.assertEquals((Object)"foo", (Object)representation3.getObject(pair.dataSet, 0));
        Assert.assertEquals((Object)"foo", (Object)representation3.getObject(pair.dataSet, 1000));
        Assert.assertEquals((Object)"bar", (Object)representation3.getObject(pair.dataSet, 2003));
        Assert.assertEquals((long)2L, (long)pair.cardinality);
    }

    @Test
    public void testAllNull() {
        ColumnLoader.ValueSet valueSet = new ColumnLoader.ValueSet(String.class);
        valueSet.add(null);
        ArrayTable.Column pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.ObjectArray));
        ArrayTable.ObjectArray representation = (ArrayTable.ObjectArray)pair.representation;
        Assert.assertNull((Object)representation.getObject(pair.dataSet, 0));
        Assert.assertEquals((long)1L, (long)pair.cardinality);
        for (int i = 0; i < 3000; ++i) {
            valueSet.add(null);
        }
        pair = valueSet.freeze(0, null);
        ArrayTable.ObjectDictionary representation2 = (ArrayTable.ObjectDictionary)pair.representation;
        Assert.assertTrue((boolean)(representation2.representation instanceof ArrayTable.Constant));
        Assert.assertEquals((long)1L, (long)pair.cardinality);
    }

    @Test
    public void testOneValueOneNull() {
        ColumnLoader.ValueSet valueSet = new ColumnLoader.ValueSet(String.class);
        valueSet.add(null);
        valueSet.add((Comparable)((Object)"foo"));
        ArrayTable.Column pair = valueSet.freeze(0, null);
        Assert.assertTrue((boolean)(pair.representation instanceof ArrayTable.ObjectArray));
        ArrayTable.ObjectArray representation = (ArrayTable.ObjectArray)pair.representation;
        Assert.assertNull((Object)representation.getObject(pair.dataSet, 0));
        Assert.assertEquals((long)2L, (long)pair.cardinality);
        for (int i = 0; i < 3000; ++i) {
            valueSet.add(null);
        }
        pair = valueSet.freeze(0, null);
        ArrayTable.ObjectDictionary representation2 = (ArrayTable.ObjectDictionary)pair.representation;
        Assert.assertEquals((long)1L, (long)((ArrayTable.BitSlicedPrimitiveArray)representation2.representation).bitCount);
        Assert.assertEquals((Object)"foo", (Object)representation2.getObject(pair.dataSet, 1));
        Assert.assertNull((Object)representation2.getObject(pair.dataSet, 10));
        Assert.assertEquals((long)2L, (long)pair.cardinality);
    }

    @Test
    public void testLoadSorted() {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RelDataType rowType = typeFactory.builder().add("empid", typeFactory.createType(Integer.TYPE)).add("deptno", typeFactory.createType(Integer.TYPE)).add("name", typeFactory.createType(String.class)).build();
        Enumerable enumerable = Linq4j.asEnumerable(Arrays.asList({100, 10, "Bill"}, {200, 20, "Eric"}, {150, 10, "Sebastian"}, {160, 10, "Theodore"}));
        ColumnLoader loader = new ColumnLoader((JavaTypeFactory)typeFactory, enumerable, RelDataTypeImpl.proto((RelDataType)rowType), null);
        this.checkColumn((ArrayTable.Column)loader.representationValues.get(0), ArrayTable.RepresentationType.BIT_SLICED_PRIMITIVE_ARRAY, "Column(representation=BitSlicedPrimitiveArray(ordinal=0, bitCount=8, primitive=INT, signed=false), value=[100, 150, 160, 200, 0, 0, 0, 0])");
        this.checkColumn((ArrayTable.Column)loader.representationValues.get(1), ArrayTable.RepresentationType.BIT_SLICED_PRIMITIVE_ARRAY, "Column(representation=BitSlicedPrimitiveArray(ordinal=1, bitCount=5, primitive=INT, signed=false), value=[10, 10, 10, 20, 0, 0, 0, 0, 0, 0, 0, 0])");
        this.checkColumn((ArrayTable.Column)loader.representationValues.get(2), ArrayTable.RepresentationType.OBJECT_ARRAY, "Column(representation=ObjectArray(ordinal=2), value=[Bill, Sebastian, Theodore, Eric])");
    }

    @Test
    public void testLoadSorted2() {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RelDataType rowType = typeFactory.builder().add("deptno", typeFactory.createType(Integer.TYPE)).add("empid", typeFactory.createType(Integer.TYPE)).add("name", typeFactory.createType(String.class)).build();
        Enumerable enumerable = Linq4j.asEnumerable(Arrays.asList({10, 100, "Bill"}, {20, 200, "Eric"}, {30, 150, "Sebastian"}, {10, 160, "Theodore"}));
        ColumnLoader loader = new ColumnLoader((JavaTypeFactory)typeFactory, enumerable, RelDataTypeImpl.proto((RelDataType)rowType), null);
        this.checkColumn((ArrayTable.Column)loader.representationValues.get(0), ArrayTable.RepresentationType.BIT_SLICED_PRIMITIVE_ARRAY, "Column(representation=BitSlicedPrimitiveArray(ordinal=0, bitCount=5, primitive=INT, signed=false), value=[10, 30, 10, 20, 0, 0, 0, 0, 0, 0, 0, 0])");
        this.checkColumn((ArrayTable.Column)loader.representationValues.get(1), ArrayTable.RepresentationType.BIT_SLICED_PRIMITIVE_ARRAY, "Column(representation=BitSlicedPrimitiveArray(ordinal=1, bitCount=8, primitive=INT, signed=false), value=[100, 150, 160, 200, 0, 0, 0, 0])");
        this.checkColumn((ArrayTable.Column)loader.representationValues.get(2), ArrayTable.RepresentationType.OBJECT_ARRAY, "Column(representation=ObjectArray(ordinal=2), value=[Bill, Sebastian, Theodore, Eric])");
    }

    private void checkColumn(ArrayTable.Column x, ArrayTable.RepresentationType expectedRepresentationType, String expectedString) {
        Assert.assertEquals((Object)expectedRepresentationType, (Object)x.representation.getType());
        Assert.assertEquals((Object)expectedString, (Object)x.toString());
    }
}

