/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import java.math.BigDecimal;
import java.sql.ResultSet;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import net.hydromatic.optiq.materialize.MaterializationService;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import org.eigenbase.relopt.SubstitutionVisitor;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationTest {
    private static final Function1<ResultSet, Void> CONTAINS_M0 = OptiqAssert.checkResultContains("EnumerableTableAccessRel(table=[[hr, m0]])");
    final JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
    final RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);

    @Test
    public void testFilter() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).withMaterializations(JdbcTest.HR_MODEL, "m0", "select * from \"emps\" where \"deptno\" = 10").query("select \"empid\" + 1 from \"emps\" where \"deptno\" = 10").enableMaterializations(true).explainContains("EnumerableTableAccessRel(table=[[hr, m0]])").sameResultWithMaterializationsDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterQueryOnProjectView() {
        try {
            Prepare.trim = true;
            MaterializationService.setThreadLocal();
            OptiqAssert.that().with(OptiqAssert.Config.REGULAR).withMaterializations(JdbcTest.HR_MODEL, "m0", "select \"deptno\", \"empid\" from \"emps\"").query("select \"empid\" + 1 as x from \"emps\" where \"deptno\" = 10").enableMaterializations(true).explainContains("EnumerableTableAccessRel(table=[[hr, m0]])").sameResultWithMaterializationsDisabled();
        }
        finally {
            Prepare.trim = false;
        }
    }

    private void checkMaterialize(String materialize, String query) {
        this.checkMaterialize(materialize, query, JdbcTest.HR_MODEL, CONTAINS_M0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMaterialize(String materialize, String query, String model, Function1<ResultSet, Void> checker) {
        try {
            Prepare.trim = true;
            MaterializationService.setThreadLocal();
            OptiqAssert.that().with(OptiqAssert.Config.REGULAR).withMaterializations(model, "m0", materialize).query(query).enableMaterializations(true).explainMatches(checker).sameResultWithMaterializationsDisabled();
        }
        finally {
            Prepare.trim = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNoMaterialize(String materialize, String query, String model) {
        try {
            Prepare.trim = true;
            MaterializationService.setThreadLocal();
            OptiqAssert.that().with(OptiqAssert.Config.REGULAR).withMaterializations(model, "m0", materialize).query(query).enableMaterializations(true).explainContains("EnumerableTableAccessRel(table=[[hr, emps]])");
        }
        finally {
            Prepare.trim = false;
        }
    }

    @Test
    public void testFilterQueryOnProjectView0() {
        this.checkMaterialize("select \"deptno\", \"empid\" from \"emps\"", "select \"empid\" + 1 as x from \"emps\" where \"deptno\" = 10");
    }

    @Test
    public void testFilterQueryOnProjectView1() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\"", "select \"empid\" + 1 as x from \"emps\" where \"deptno\" = 10");
    }

    @Test
    public void testFilterQueryOnProjectView2() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\"", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10");
    }

    @Test
    public void testFilterQueryOnProjectView3() {
        this.checkMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\" from \"emps\" where \"deptno\" - 10 = 0");
    }

    @Test
    public void testFilterQueryOnProjectView4() {
        this.checkNoMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\" from \"emps\" where \"deptno\" + 10 = 20", JdbcTest.HR_MODEL);
    }

    @Ignore(value="fix project expr on filter - plans, but wrong results")
    @Test
    public void testFilterQueryOnProjectView5() {
        this.checkMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\", \"empid\" + 1 from \"emps\" where \"deptno\" - 10 = 0");
    }

    @Ignore(value="fix project expr on filter")
    @Test
    public void testFilterQueryOnProjectView6() {
        this.checkNoMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\", \"empid\" + 2 from \"emps\" where \"deptno\" - 10 = 0", JdbcTest.HR_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\" where \"deptno\" = 10", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10");
    }

    @Ignore
    @Test
    public void testFilterQueryOnFilterView2() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\" where \"deptno\" = 10", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10 and \"empid\" < 150");
    }

    @Ignore(value="not implemented")
    @Test
    public void testFilterQueryOnFilterView3() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\" where \"deptno\" = 10 or \"deptno\" = 20 or \"empid\" < 160", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10", JdbcTest.HR_MODEL, OptiqAssert.checkResultContains("EnumerableCalcRel(expr#0..2=[{inputs}], expr#3=[1], expr#4=[+($t1, $t3)], X=[$t4], name=[$t2], condition=?)\n  EnumerableTableAccessRel(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregate() {
        this.checkMaterialize("select \"deptno\", count(*) as c, sum(\"empid\") as s from \"emps\" group by \"deptno\"", "select count(*) + 1 as c, \"deptno\" from \"emps\" group by \"deptno\"");
    }

    @Test
    public void testAggregateRollUp() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s from \"emps\" group by \"empid\", \"deptno\"", "select count(*) + 1 as c, \"deptno\" from \"emps\" group by \"deptno\"", JdbcTest.HR_MODEL, OptiqAssert.checkResultContains("EnumerableCalcRel(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], C=[$t3], deptno=[$t0])\n  EnumerableAggregateRel(group=[{1}], agg#0=[COUNT($1)])\n    EnumerableTableAccessRel(table=[[hr, m0]])"));
    }

    @Ignore(value="work in progress")
    @Test
    public void testAggregateProject() {
        this.checkMaterialize("select \"deptno\", count(*) as c, \"empid\" + 2, sum(\"empid\") as s from \"emps\" group by \"empid\", \"deptno\"", "select count(*) + 1 as c, \"deptno\" from \"emps\" group by \"deptno\"", JdbcTest.HR_MODEL, OptiqAssert.checkResultContains("xxx"));
    }

    @Ignore
    @Test
    public void testSwapJoin() {
        String q1 = "select count(*) as c from \"foodmart\".\"sales_fact_1997\" as s join \"foodmart\".\"time_by_day\" as t on s.\"time_id\" = t.\"time_id\"";
        String q2 = "select count(*) as c from \"foodmart\".\"time_by_day\" as t join \"foodmart\".\"sales_fact_1997\" as s on t.\"time_id\" = s.\"time_id\"";
    }

    @Ignore
    @Test
    public void testDifferentColumnNames() {
    }

    @Ignore
    @Test
    public void testDifferentType() {
    }

    @Ignore
    @Test
    public void testPartialUnion() {
    }

    @Ignore
    @Test
    public void testNonDisjointUnion() {
    }

    @Ignore
    @Test
    public void testMaterializationReferencesTableInOtherSchema() {
    }

    @Test
    public void testSatisfiable() {
        this.checkSatisfiable((RexNode)this.rexBuilder.makeLiteral(true), "true");
        this.checkNotSatisfiable((RexNode)this.rexBuilder.makeLiteral(false));
        RexNode i0_eq_0 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createType(Integer.TYPE), 0), this.rexBuilder.makeExactLiteral(BigDecimal.ZERO)});
        this.checkSatisfiable(i0_eq_0, "=($0, 0)");
        RexNode e0 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeLiteral(true)});
        this.checkSatisfiable(e0, "=($0, 0)");
        RexNode e1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeLiteral(false)});
        this.checkNotSatisfiable(e1);
        RexNode e2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})});
        this.checkNotSatisfiable(e2);
        RexNode e3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder.makeLiteral(true), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})});
        this.checkSatisfiable(e3, "NOT(=($0, 0))");
        RexNode i1_eq_1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createType(Integer.TYPE), 1), this.rexBuilder.makeExactLiteral(BigDecimal.ONE)});
        RexNode e4 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i1_eq_1, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})})});
        this.checkNotSatisfiable(e4);
        RexNode e5 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i1_eq_1})});
        this.checkSatisfiable(e5, "AND(=($0, 0), NOT(=($1, 1)))");
        RexNode e6 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, i1_eq_1})})});
        this.checkSatisfiable(e6, "AND(=($0, 0), NOT(AND(=($0, 0), =($1, 1))))");
        RexNode e7 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i1_eq_1, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})})});
        this.checkNotSatisfiable(e7);
        RexInputRef i2 = this.rexBuilder.makeInputRef(this.typeFactory.createType(Boolean.TYPE), 2);
        RexInputRef i3 = this.rexBuilder.makeInputRef(this.typeFactory.createType(Boolean.TYPE), 3);
        RexInputRef i4 = this.rexBuilder.makeInputRef(this.typeFactory.createType(Boolean.TYPE), 4);
        RexNode e8 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i2, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i3, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i2, i3, i4})}), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i4})})})});
        this.checkSatisfiable(e8, "AND(=($0, 0), $2, $3, NOT(AND($2, $3, $4)), NOT($4))");
    }

    private void checkNotSatisfiable(RexNode e) {
        Assert.assertFalse((boolean)SubstitutionVisitor.mayBeSatisfiable((RexNode)e));
        RexNode simple = SubstitutionVisitor.simplify((RexBuilder)this.rexBuilder, (RexNode)e);
        Assert.assertFalse((boolean)RexLiteral.booleanValue((RexNode)simple));
    }

    private void checkSatisfiable(RexNode e, String s) {
        Assert.assertTrue((boolean)SubstitutionVisitor.mayBeSatisfiable((RexNode)e));
        RexNode simple = SubstitutionVisitor.simplify((RexBuilder)this.rexBuilder, (RexNode)e);
        Assert.assertEquals((Object)s, (Object)simple.toString());
    }

    @Test
    public void testSplitFilter() {
        RexLiteral i1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral i2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral i3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        RelDataType intType = this.typeFactory.createType(Integer.TYPE);
        RexInputRef x = this.rexBuilder.makeInputRef(intType, 0);
        RexInputRef y = this.rexBuilder.makeInputRef(intType, 1);
        RexInputRef z = this.rexBuilder.makeInputRef(intType, 2);
        RexNode x_eq_1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{x, i1});
        RexNode x_eq_1_b = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{x, i1});
        RexNode y_eq_2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{y, i2});
        RexNode z_eq_3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{z, i3});
        RexNode newFilter = SubstitutionVisitor.splitFilter((RexBuilder)this.rexBuilder, (RexNode)x_eq_1, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, z_eq_3}));
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"NOT(=($2, 3))"));
        newFilter = SubstitutionVisitor.splitFilter((RexBuilder)this.rexBuilder, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2, z_eq_3}));
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"NOT(=($2, 3))"));
        newFilter = SubstitutionVisitor.splitFilter((RexBuilder)this.rexBuilder, (RexNode)x_eq_1, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2, z_eq_3}));
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"AND(NOT(=($1, 2)), NOT(=($2, 3)))"));
        newFilter = SubstitutionVisitor.splitFilter((RexBuilder)this.rexBuilder, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{y_eq_2, x_eq_1}));
        Assert.assertThat((Object)newFilter.isAlwaysTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
        newFilter = SubstitutionVisitor.splitFilter((RexBuilder)this.rexBuilder, (RexNode)x_eq_1, (RexNode)x_eq_1_b);
        Assert.assertThat((Object)newFilter.isAlwaysTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Ignore
    @Test
    public void testFilterGroupQueryOnStar() {
        this.checkMaterialize("select p.\"product_name\", t.\"the_year\", sum(f.\"unit_sales\") as \"sum_unit_sales\", count(*) as \"c\"\nfrom \"foodmart\".\"sales_fact_1997\" as f\njoin (\n    select \"time_id\", \"the_year\", \"the_month\"\n    from \"foodmart\".\"time_by_day\") as t\n  on f.\"time_id\" = t.\"time_id\"\njoin \"foodmart\".\"product\" as p\n  on f.\"product_id\" = p.\"product_id\"\njoin \"foodmart\".\"product_class\" as pc  on p.\"product_class_id\" = pc.\"product_class_id\"\ngroup by t.\"the_year\",\n t.\"the_month\",\n pc.\"product_department\",\n pc.\"product_category\",\n p.\"product_name\"", "select t.\"the_month\", count(*) as x\nfrom (\n  select \"time_id\", \"the_year\", \"the_month\"\n  from \"foodmart\".\"time_by_day\") as t,\n \"foodmart\".\"sales_fact_1997\" as f\nwhere t.\"the_year\" = 1997\nand t.\"time_id\" = f.\"time_id\"\ngroup by t.\"the_year\",\n t.\"the_month\"\n", JdbcTest.FOODMART_MODEL, CONTAINS_M0);
    }

    @Ignore
    @Test
    public void testQueryOnStar() {
        String q = "select *\nfrom \"foodmart\".\"sales_fact_1997\" as f\njoin \"foodmart\".\"time_by_day\" as t on f.\"time_id\" = t.\"time_id\"\njoin \"foodmart\".\"product\" as p on f.\"product_id\" = p.\"product_id\"\njoin \"foodmart\".\"product_class\" as pc on p.\"product_class_id\" = pc.\"product_class_id\"\n";
        this.checkMaterialize(q, q + "where t.\"month_of_year\" = 10", JdbcTest.FOODMART_MODEL, CONTAINS_M0);
    }

    @Ignore
    @Test
    public void testJoinOnUnionMaterialization() {
        String q = "select *\nfrom (select * from \"emps\" union all select * from \"emps\")\njoin \"depts\" using (\"deptno\")";
        this.checkNoMaterialize(q, q, JdbcTest.HR_MODEL);
    }
}

