/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.validate.AggChecker;
import org.eigenbase.sql.validate.AggregatingScope;
import org.eigenbase.sql.validate.DelegatingScope;
import org.eigenbase.sql.validate.SelectScope;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;
    private final List<SqlNode> groupExprList;

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select, boolean distinct) {
        super(selectScope);
        this.select = select;
        this.distinct = distinct;
        if (distinct) {
            this.groupExprList = null;
        } else if (select.getGroup() != null) {
            SqlNodeList sqlNodeList = (SqlNodeList)this.select.getGroup().accept(new SqlValidatorUtil.DeepCopier(this.parent));
            this.groupExprList = sqlNodeList.getList();
        } else {
            this.groupExprList = null;
        }
    }

    private List<SqlNode> getGroupExprs() {
        if (this.distinct) {
            assert (this.select.isDistinct());
            ArrayList<SqlNode> groupExprs = new ArrayList<SqlNode>();
            for (SqlNode selectItem : ((SelectScope)this.parent).getExpandedSelectList()) {
                if (SqlUtil.isCallTo(selectItem, SqlStdOperatorTable.AS)) {
                    groupExprs.add((SqlNode)((SqlCall)selectItem).operand(0));
                    continue;
                }
                groupExprs.add(selectItem);
            }
            return groupExprs;
        }
        if (this.select.getGroup() != null) {
            return this.groupExprList;
        }
        return Collections.emptyList();
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        List<SqlNode> groupExprs = this.getGroupExprs();
        AggChecker aggChecker = new AggChecker(this.validator, this, groupExprs, this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public void addGroupExpr(SqlNode expr) {
        this.groupExprList.add(expr);
    }
}

