/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import java.util.Arrays;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.util.Static;

public class MultisetOperandTypeChecker
implements SqlOperandTypeChecker {
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlCall call = callBinding.getCall();
        Object op0 = call.operand(0);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)op0, 0, throwOnFailure)) {
            return false;
        }
        Object op1 = call.operand(1);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)op1, 0, throwOnFailure)) {
            return false;
        }
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive(Arrays.asList(callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)op0).getComponentType(), callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)op1).getComponentType()));
        if (null == biggest) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(((SqlNode)op0).getParserPosition().toString(), ((SqlNode)op1).getParserPosition().toString()));
            }
            return false;
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<MULTISET> " + opName + " <MULTISET>";
    }
}

