/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import java.util.HashMap;
import java.util.Map;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;

public class RelOptQuery {
    public static final String CORREL_PREFIX = "$cor";
    final Map<String, RelNode> mapCorrelToRel = new HashMap<String, RelNode>();
    private final RelOptPlanner planner;
    private int nextCorrel = 0;

    public RelOptQuery(RelOptPlanner planner) {
        this.planner = planner;
    }

    public static int getCorrelOrdinal(String correlName) {
        assert (correlName.startsWith(CORREL_PREFIX));
        return Integer.parseInt(correlName.substring(CORREL_PREFIX.length()));
    }

    public RelOptCluster createCluster(RelDataTypeFactory typeFactory, RexBuilder rexBuilder) {
        return new RelOptCluster(this, this.planner, typeFactory, rexBuilder);
    }

    public String createCorrel() {
        int n = this.nextCorrel++;
        return CORREL_PREFIX + n;
    }

    public RelNode lookupCorrel(String name) {
        return this.mapCorrelToRel.get(name);
    }

    public void mapCorrel(String name, RelNode rel) {
        this.mapCorrelToRel.put(name, rel);
    }
}

