/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.AvaticaFactory;
import net.hydromatic.avatica.AvaticaParameter;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.ConnectionConfigImpl;
import net.hydromatic.avatica.Helper;
import net.hydromatic.avatica.InternalProperty;
import net.hydromatic.avatica.Meta;
import net.hydromatic.avatica.Quoting;
import net.hydromatic.avatica.UnregisteredDriver;
import net.hydromatic.linq4j.BaseQueryable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.config.OptiqConnectionProperty;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.Driver;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import net.hydromatic.optiq.jdbc.MetaImpl;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqPreparedStatement;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.jdbc.OptiqStatement;
import net.hydromatic.optiq.server.OptiqServer;
import net.hydromatic.optiq.server.OptiqServerStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OptiqConnectionImpl
extends AvaticaConnection
implements OptiqConnection,
QueryProvider {
    public final JavaTypeFactory typeFactory;
    final OptiqRootSchema rootSchema;
    final Function0<OptiqPrepare> prepareFactory;
    final OptiqServer server = new OptiqServerImpl();
    static final AvaticaConnection.Trojan TROJAN = OptiqConnectionImpl.createTrojan();

    protected OptiqConnectionImpl(Driver driver, AvaticaFactory factory, String url, Properties info, OptiqRootSchema rootSchema, JavaTypeFactory typeFactory) {
        super((UnregisteredDriver)driver, factory, url, info);
        this.prepareFactory = driver.prepareFactory;
        this.typeFactory = typeFactory != null ? typeFactory : new JavaTypeFactoryImpl();
        this.rootSchema = rootSchema != null ? rootSchema : OptiqSchema.createRootSchema();
        OptiqConnectionConfigImpl cfg = new OptiqConnectionConfigImpl(info);
        this.properties.put(InternalProperty.CASE_SENSITIVE, cfg.caseSensitive());
        this.properties.put(InternalProperty.UNQUOTED_CASING, cfg.unquotedCasing());
        this.properties.put(InternalProperty.QUOTED_CASING, cfg.quotedCasing());
        this.properties.put(InternalProperty.QUOTING, cfg.quoting());
    }

    protected Meta createMeta() {
        return new MetaImpl(this);
    }

    MetaImpl meta() {
        return (MetaImpl)this.meta;
    }

    @Override
    public OptiqConnectionConfig config() {
        return new OptiqConnectionConfigImpl(this.info);
    }

    public AvaticaStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        OptiqStatement statement = (OptiqStatement)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.server.addStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            OptiqPrepare.PrepareResult prepareResult = this.parseQuery(sql, new ContextImpl(this), -1);
            OptiqPreparedStatement statement = (OptiqPreparedStatement)this.factory.newPreparedStatement((AvaticaConnection)this, prepareResult, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.server.addStatement(statement);
            return statement;
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", (Exception)e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> OptiqPrepare.PrepareResult<T> parseQuery(String sql, OptiqPrepare.Context prepareContext, int maxRowCount) {
        OptiqPrepare.Dummy.push(prepareContext);
        try {
            OptiqPrepare prepare = (OptiqPrepare)this.prepareFactory.apply();
            OptiqPrepare.PrepareResult prepareResult = prepare.prepareSql(prepareContext, sql, null, (Type)((Object)Object[].class), maxRowCount);
            return prepareResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(prepareContext);
        }
    }

    @Override
    public SchemaPlus getRootSchema() {
        return this.rootSchema.plus();
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public Properties getProperties() {
        return this.info;
    }

    public <T> Queryable<T> createQuery(Expression expression, Class<T> rowType) {
        return new OptiqQueryable(this, rowType, expression);
    }

    public <T> Queryable<T> createQuery(Expression expression, Type rowType) {
        return new OptiqQueryable(this, rowType, expression);
    }

    public <T> T execute(Expression expression, Type type) {
        return null;
    }

    public <T> T execute(Expression expression, Class<T> type) {
        return null;
    }

    public <T> Enumerator<T> executeQuery(Queryable<T> queryable) {
        try {
            OptiqStatement statement = (OptiqStatement)this.createStatement();
            OptiqPrepare.PrepareResult<T> enumerable = statement.prepare(queryable);
            DataContext dataContext = this.createDataContext(Collections.<Object>emptyList());
            return enumerable.enumerator(dataContext);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public DataContext createDataContext(List<Object> parameterValues) {
        if (this.config().spark()) {
            return new SlimDataContext();
        }
        return new DataContextImpl(this, parameterValues);
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    private static class OptiqConnectionConfigImpl
    extends ConnectionConfigImpl
    implements OptiqConnectionConfig {
        public OptiqConnectionConfigImpl(Properties properties) {
            super(properties);
        }

        public boolean autoTemp() {
            return OptiqConnectionProperty.AUTO_TEMP.wrap(this.properties).getBoolean();
        }

        public boolean materializationsEnabled() {
            return OptiqConnectionProperty.MATERIALIZATIONS_ENABLED.wrap(this.properties).getBoolean();
        }

        public String model() {
            return OptiqConnectionProperty.MODEL.wrap(this.properties).getString();
        }

        public Lex lex() {
            return (Lex)OptiqConnectionProperty.LEX.wrap(this.properties).getEnum(Lex.class);
        }

        public Quoting quoting() {
            return (Quoting)OptiqConnectionProperty.QUOTING.wrap(this.properties).getEnum(Quoting.class, (Enum)this.lex().quoting);
        }

        public Casing unquotedCasing() {
            return (Casing)OptiqConnectionProperty.UNQUOTED_CASING.wrap(this.properties).getEnum(Casing.class, (Enum)this.lex().unquotedCasing);
        }

        public Casing quotedCasing() {
            return (Casing)OptiqConnectionProperty.QUOTED_CASING.wrap(this.properties).getEnum(Casing.class, (Enum)this.lex().quotedCasing);
        }

        public boolean caseSensitive() {
            return OptiqConnectionProperty.CASE_SENSITIVE.wrap(this.properties).getBoolean(this.lex().caseSensitive);
        }

        public boolean spark() {
            return OptiqConnectionProperty.SPARK.wrap(this.properties).getBoolean();
        }
    }

    private static class SlimDataContext
    implements DataContext,
    Serializable {
        private SlimDataContext() {
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextImpl
    implements OptiqPrepare.Context {
        private final OptiqConnectionImpl connection;

        public ContextImpl(OptiqConnectionImpl connection) {
            this.connection = connection;
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.connection.typeFactory;
        }

        @Override
        public OptiqRootSchema getRootSchema() {
            return this.connection.rootSchema;
        }

        @Override
        public List<String> getDefaultSchemaPath() {
            String schemaName = this.connection.getSchema();
            return schemaName == null ? Collections.emptyList() : Collections.singletonList(schemaName);
        }

        @Override
        public OptiqConnectionConfig config() {
            return this.connection.config();
        }

        @Override
        public DataContext getDataContext() {
            return this.connection.createDataContext((List<Object>)ImmutableList.of());
        }

        @Override
        public OptiqPrepare.SparkHandler spark() {
            boolean enable = this.config().spark();
            return OptiqPrepare.Dummy.getSparkHandler(enable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DataContextImpl
    implements DataContext {
        private final ImmutableMap<Object, Object> map;
        private final OptiqSchema rootSchema;
        private final QueryProvider queryProvider;
        private final JavaTypeFactory typeFactory;

        DataContextImpl(OptiqConnectionImpl connection, List<Object> parameterValues) {
            long localOffset;
            this.queryProvider = connection;
            this.typeFactory = connection.getTypeFactory();
            this.rootSchema = connection.rootSchema;
            long time = System.currentTimeMillis();
            TimeZone timeZone = connection.getTimeZone();
            long currentOffset = localOffset = (long)timeZone.getOffset(time);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"utcTimestamp", (Object)time).put((Object)"currentTimestamp", (Object)(time + currentOffset)).put((Object)"localTimestamp", (Object)(time + localOffset)).put((Object)"timeZone", (Object)timeZone);
            for (Ord value : Ord.zip(parameterValues)) {
                Object e = value.e;
                if (e == null) {
                    e = AvaticaParameter.DUMMY_VALUE;
                }
                builder.put((Object)("?" + value.i), e);
            }
            this.map = builder.build();
        }

        @Override
        public synchronized Object get(String name) {
            Object o = this.map.get((Object)name);
            if (o == AvaticaParameter.DUMMY_VALUE) {
                return null;
            }
            return o;
        }

        @Override
        public SchemaPlus getRootSchema() {
            return this.rootSchema.plus();
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return this.queryProvider;
        }
    }

    static class RootSchema
    extends AbstractSchema {
        RootSchema() {
        }

        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltinMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
        }
    }

    private static class OptiqServerImpl
    implements OptiqServer {
        final List<OptiqServerStatement> statementList = new ArrayList<OptiqServerStatement>();

        private OptiqServerImpl() {
        }

        public void removeStatement(OptiqServerStatement optiqServerStatement) {
            this.statementList.add(optiqServerStatement);
        }

        public void addStatement(OptiqServerStatement statement) {
            this.statementList.add(statement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OptiqQueryable<T>
    extends BaseQueryable<T> {
        public OptiqQueryable(OptiqConnection connection, Type elementType, Expression expression) {
            super((QueryProvider)connection, elementType, expression);
        }

        public OptiqConnection getConnection() {
            return (OptiqConnection)this.provider;
        }
    }
}

