/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import java.lang.reflect.Type;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.ViewTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.MaterializationKey;
import net.hydromatic.optiq.materialize.MaterializationService;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.reltype.RelProtoDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewTable
extends ViewTable {
    private final MaterializationKey key;
    public static final OptiqConnection MATERIALIZATION_CONNECTION;

    public MaterializedViewTable(Type elementType, RelProtoDataType relDataType, String viewSql, List<String> viewSchemaPath, MaterializationKey key) {
        super(elementType, relDataType, viewSql, viewSchemaPath);
        this.key = key;
    }

    public static MaterializedViewTableMacro create(OptiqSchema schema, String viewSql, List<String> viewSchemaPath, String tableName) {
        return new MaterializedViewTableMacro(schema, viewSql, viewSchemaPath, tableName);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        Table materializeTable;
        OptiqSchema.TableEntry tableEntry = MaterializationService.instance().checkValid(this.key);
        if (tableEntry != null && (materializeTable = tableEntry.getTable()) instanceof TranslatableTable) {
            TranslatableTable table = (TranslatableTable)materializeTable;
            return table.toRel(context, relOptTable);
        }
        return super.toRel(context, relOptTable);
    }

    static {
        try {
            MATERIALIZATION_CONNECTION = DriverManager.getConnection("jdbc:optiq:").unwrap(OptiqConnection.class);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MaterializedViewTableMacro
    extends ViewTable.ViewTableMacro {
        private final MaterializationKey key;

        private MaterializedViewTableMacro(OptiqSchema schema, String viewSql, List<String> viewSchemaPath, String tableName) {
            super(schema, viewSql, viewSchemaPath);
            this.key = MaterializationService.instance().defineMaterialization(schema, viewSql, this.schemaPath, tableName);
        }

        @Override
        public Table apply(List<Object> arguments) {
            assert (arguments.isEmpty());
            OptiqPrepare.ParseResult parsed = Schemas.parse(MATERIALIZATION_CONNECTION, this.schema, this.schemaPath, this.viewSql);
            List<String> schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
            JavaTypeFactory typeFactory = MATERIALIZATION_CONNECTION.getTypeFactory();
            return new MaterializedViewTable(typeFactory.getJavaClass(parsed.rowType), RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1, this.key);
        }
    }
}

