/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import java.util.Arrays;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchReturnTypeInference
implements SqlReturnTypeInference {
    private final int start;
    private final List<SqlTypeName> typeNames;

    public MatchReturnTypeInference(int start, SqlTypeName ... typeName) {
        this(start, Arrays.asList(typeName));
    }

    public MatchReturnTypeInference(int start, List<SqlTypeName> typeNames) {
        assert (start >= 0);
        assert (null != typeNames);
        assert (typeNames.size() > 0);
        this.start = start;
        this.typeNames = typeNames;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (int i = this.start; i < opBinding.getOperandCount(); ++i) {
            RelDataType argType = opBinding.getOperandType(i);
            if (!SqlTypeUtil.isOfSameTypeName(this.typeNames, argType)) continue;
            return argType;
        }
        return null;
    }
}

