/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.TimeZone;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.AvaticaResultSet;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.Handler;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqPrepare;

public class OptiqResultSet
extends AvaticaResultSet {
    OptiqResultSet(AvaticaStatement statement, OptiqPrepare.PrepareResult prepareResult, ResultSetMetaData resultSetMetaData, TimeZone timeZone) {
        super(statement, (AvaticaPrepareResult)prepareResult, resultSetMetaData, timeZone);
    }

    protected OptiqResultSet execute() throws SQLException {
        OptiqConnectionImpl connection = this.getOptiqConnection();
        boolean autoTemp = connection.config().autoTemp();
        Handler.ResultSink resultSink = null;
        if (autoTemp) {
            resultSink = new Handler.ResultSink(){

                public void toBeCompleted() {
                }
            };
        }
        connection.getDriver().handler.onStatementExecute(this.statement, resultSink);
        super.execute();
        return this;
    }

    OptiqPrepare.PrepareResult getPrepareResult() {
        return (OptiqPrepare.PrepareResult)this.prepareResult;
    }

    OptiqConnectionImpl getOptiqConnection() {
        return (OptiqConnectionImpl)this.statement.getConnection();
    }
}

