/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Arrays;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExplain
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("EXPLAIN", SqlKind.EXPLAIN);
    SqlNode explicandum;
    SqlLiteral detailLevel;
    SqlLiteral depth;
    SqlLiteral asXml;
    private final int dynamicParameterCount;

    public SqlExplain(SqlParserPos pos, SqlNode explicandum, SqlLiteral detailLevel, SqlLiteral depth, SqlLiteral asXml, int dynamicParameterCount) {
        super(pos);
        this.explicandum = explicandum;
        this.detailLevel = detailLevel;
        this.depth = depth;
        this.asXml = asXml;
        this.dynamicParameterCount = dynamicParameterCount;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.EXPLAIN;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.explicandum, this.detailLevel, this.depth, this.asXml);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.explicandum = operand;
                break;
            }
            case 1: {
                this.detailLevel = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.depth = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.asXml = (SqlLiteral)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getExplicandum() {
        return this.explicandum;
    }

    public SqlExplainLevel getDetailLevel() {
        return (SqlExplainLevel)this.detailLevel.symbolValue();
    }

    public Depth getDepth() {
        return (Depth)this.depth.symbolValue();
    }

    public int getDynamicParamCount() {
        return this.dynamicParameterCount;
    }

    public boolean withImplementation() {
        return this.getDepth() == Depth.PHYSICAL;
    }

    public boolean withType() {
        return this.getDepth() == Depth.TYPE;
    }

    public boolean isXml() {
        return this.asXml.booleanValue();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("EXPLAIN PLAN");
        switch (this.getDetailLevel()) {
            case NO_ATTRIBUTES: {
                writer.keyword("EXCLUDING ATTRIBUTES");
                break;
            }
            case EXPPLAN_ATTRIBUTES: {
                writer.keyword("INCLUDING ATTRIBUTES");
                break;
            }
            case ALL_ATTRIBUTES: {
                writer.keyword("INCLUDING ALL ATTRIBUTES");
            }
        }
        switch (this.getDepth()) {
            case TYPE: {
                writer.keyword("WITH TYPE");
                break;
            }
            case LOGICAL: {
                writer.keyword("WITHOUT IMPLEMENTATION");
                break;
            }
            case PHYSICAL: {
                writer.keyword("WITH IMPLEMENTATION");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.isXml()) {
            writer.keyword("AS XML");
        }
        writer.keyword("FOR");
        writer.newlineAndIndent();
        this.explicandum.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Depth implements SqlLiteral.SqlSymbol
    {
        TYPE,
        LOGICAL,
        PHYSICAL;


        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

