/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodDeclaration;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.runtime.Utilities;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.Scanner;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexExecutorImpl
implements RelOptPlanner.Executor {
    private static final RexToLixTranslator.InputGetter BAD_GETTER = new RexToLixTranslator.InputGetter(){

        public Expression field(BlockBuilder list, int index) {
            throw new UnsupportedOperationException();
        }
    };
    private final DataContext dataContext;

    public RexExecutorImpl(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    @Override
    public void execute(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelDataType emptyRowType = typeFactory.builder().build();
        RexProgramBuilder programBuilder = new RexProgramBuilder(emptyRowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl();
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, (String)"root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add((Statement)Expressions.declare((int)16, (ParameterExpression)root_, (Expression)Expressions.convert_((Expression)root0_, DataContext.class)));
        List<Expression> expressions = RexToLixTranslator.translateProjects(programBuilder.getProgram(), javaTypeFactory, blockBuilder, BAD_GETTER);
        blockBuilder.add((Statement)Expressions.return_(null, (Expression)Expressions.newArrayInit(Object[].class, expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl((int)1, Object[].class, (String)BuiltinMethod.FUNCTION1_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)root0_), (BlockStatement)blockBuilder.toBlock());
        String s = Expressions.toString((Node)methodDecl);
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println(s);
        }
        try {
            Function1 function = (Function1)ClassBodyEvaluator.createFastClassBodyEvaluator((Scanner)new Scanner(null, (Reader)new StringReader(s)), (String)"Reducer", Utilities.class, (Class[])new Class[]{Function1.class}, (ClassLoader)this.getClass().getClassLoader());
            Object[] values = (Object[])function.apply((Object)this.dataContext);
            assert (values.length == constExps.size());
            List<Object> valueList = Arrays.asList(values);
            for (Pair<RexNode, Object> value : Pair.zip(constExps, valueList)) {
                reducedValues.add(rexBuilder.makeLiteral(value.right, ((RexNode)value.left).getType(), true));
            }
            Hook.EXPRESSION_REDUCER.run(Pair.of(s, values));
        }
        catch (CompileException e) {
            throw new RuntimeException("While evaluating " + constExps, e);
        }
        catch (IOException e) {
            throw new RuntimeException("While evaluating " + constExps, e);
        }
    }
}

