/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqCatalogReader;
import net.hydromatic.optiq.prepare.OptiqSqlValidator;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.ValidationException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql2rel.SqlToRelConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlannerImpl
implements Planner {
    private final Function1<SchemaPlus, Schema> schemaFactory;
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<RuleSet> ruleSets;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final Lex lex;
    private final SqlParserImplFactory parserFactory;
    private boolean caseSensitive = true;
    private State state;
    private boolean open;
    private SchemaPlus rootSchema;
    private SchemaPlus defaultSchema;
    private JavaTypeFactory typeFactory;
    private RelOptPlanner planner;
    private OptiqSqlValidator validator;
    private SqlNode validatedSqlNode;
    private SqlToRelConverter sqlToRelConverter;
    private RelNode rel;

    public PlannerImpl(Lex lex, SqlParserImplFactory parserFactory, Function1<SchemaPlus, Schema> schemaFactory, SqlOperatorTable operatorTable, ImmutableList<RuleSet> ruleSets, ImmutableList<RelTraitDef> traitDefs) {
        this.schemaFactory = schemaFactory;
        this.operatorTable = operatorTable;
        this.ruleSets = ruleSets;
        this.lex = lex;
        this.parserFactory = parserFactory;
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = traitDefs;
        this.reset();
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    @Override
    public RelTraitSet getEmptyTraitSet() {
        return this.planner.emptyTraitSet();
    }

    @Override
    public void close() {
        this.open = false;
        this.rootSchema = null;
        this.defaultSchema = null;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    @Override
    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
            }
        }
        this.ensure(State.STATE_1_RESET);
        Frameworks.withPlanner(new Frameworks.PlannerAction<Void>(){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                PlannerImpl.this.rootSchema = rootSchema;
                Schema schema = (Schema)PlannerImpl.this.schemaFactory.apply((Object)PlannerImpl.this.rootSchema);
                PlannerImpl.this.defaultSchema = rootSchema.add(this.getName(schema), schema);
                PlannerImpl.this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
                PlannerImpl.this.planner = cluster.getPlanner();
                return null;
            }

            private String getName(Schema schema) {
                try {
                    Method method = schema.getClass().getMethod("getName", new Class[0]);
                    return (String)method.invoke((Object)schema, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    return "DUMMY";
                }
                catch (InvocationTargetException e) {
                    return "DUMMY";
                }
                catch (IllegalAccessException e) {
                    return "DUMMY";
                }
            }
        });
        this.state = State.STATE_2_READY;
        if (this.traitDefs != null) {
            this.planner.clearRelTraitDefs();
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
    }

    @Override
    public SqlNode parse(String sql) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create(this.parserFactory, sql, this.lex.quoting, this.lex.unquotedCasing, this.lex.quotedCasing);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    @Override
    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        this.validator = new OptiqSqlValidator(this.operatorTable, this.createCatalogReader(), this.typeFactory);
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    @Override
    public RelNode convert(SqlNode sql) throws RelConversionException {
        this.ensure(State.STATE_4_VALIDATED);
        assert (this.validatedSqlNode != null);
        this.sqlToRelConverter = new SqlToRelConverter(null, this.validator, this.createCatalogReader(), this.planner, this.createRexBuilder());
        this.sqlToRelConverter.setTrimUnusedFields(false);
        this.rel = this.sqlToRelConverter.convertQuery(this.validatedSqlNode, false, true);
        this.rel = this.sqlToRelConverter.decorrelate(this.validatedSqlNode, this.rel);
        this.state = State.STATE_5_CONVERTED;
        return this.rel;
    }

    private OptiqCatalogReader createCatalogReader() {
        return new OptiqCatalogReader(OptiqSchema.from(this.rootSchema), this.caseSensitive, OptiqSchema.from(this.defaultSchema).path(null), this.typeFactory);
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.typeFactory);
    }

    @Override
    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) throws RelConversionException {
        this.ensure(State.STATE_5_CONVERTED);
        RuleSet ruleSet = (RuleSet)this.ruleSets.get(ruleSetIndex);
        this.planner.clear();
        for (RelOptRule rule : ruleSet) {
            this.planner.addRule(rule);
        }
        if (!rel.getTraitSet().equals(requiredOutputTraits)) {
            rel = this.planner.changeTraits(rel, requiredOutputTraits);
        }
        this.planner.setRoot(rel);
        return this.planner.findBestExp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STATE_0_CLOSED{

            void from(PlannerImpl planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            void from(PlannerImpl planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            void from(PlannerImpl planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(PlannerImpl planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }
}

