/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlUserDefinedFunction;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptiqCatalogReader
implements Prepare.CatalogReader,
SqlOperatorTable {
    final OptiqSchema rootSchema;
    final JavaTypeFactory typeFactory;
    private final List<String> defaultSchema;
    private final boolean caseSensitive;

    public OptiqCatalogReader(OptiqSchema rootSchema, boolean caseSensitive, List<String> defaultSchema, JavaTypeFactory typeFactory) {
        assert (rootSchema != defaultSchema);
        this.rootSchema = rootSchema;
        this.caseSensitive = caseSensitive;
        this.defaultSchema = defaultSchema;
        this.typeFactory = typeFactory;
    }

    @Override
    public OptiqCatalogReader withSchemaPath(List<String> schemaPath) {
        return new OptiqCatalogReader(this.rootSchema, this.caseSensitive, schemaPath, this.typeFactory);
    }

    @Override
    public OptiqPrepareImpl.RelOptTableImpl getTable(List<String> names) {
        OptiqPrepareImpl.RelOptTableImpl table;
        if (this.defaultSchema != null && (table = this.getTableFrom(names, this.defaultSchema)) != null) {
            return table;
        }
        return this.getTableFrom(names, (List<String>)ImmutableList.of());
    }

    private OptiqPrepareImpl.RelOptTableImpl getTableFrom(List<String> names, List<String> schemaNames) {
        OptiqSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)));
        if (schema == null) {
            return null;
        }
        String name = Util.last(names);
        Table table = schema.getTable(name, this.caseSensitive);
        if (table != null) {
            return new OptiqPrepareImpl.RelOptTableImpl(this, table.getRowType(this.typeFactory), schema.add(name, table));
        }
        return null;
    }

    private Collection<Function> getFunctionsFrom(List<String> names, List<String> schemaNames) {
        OptiqSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)));
        if (schema == null) {
            return ImmutableList.of();
        }
        String name = Util.last(names);
        return schema.compositeFunctionMap.get((Object)name);
    }

    private OptiqSchema getSchema(Iterable<String> schemaNames) {
        OptiqSchema schema = this.rootSchema;
        for (String schemaName : schemaNames) {
            if ((schema = schema.getSubSchema(schemaName, this.caseSensitive)) != null) continue;
            return null;
        }
        return schema;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        return null;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public OptiqPrepareImpl.RelOptTableImpl getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return SqlValidatorUtil.lookupField(this.caseSensitive, rowType, alias);
    }

    @Override
    public int fieldOrdinal(RelDataType rowType, String alias) {
        RelDataTypeField field = this.field(rowType, alias);
        return field != null ? field.getIndex() : -1;
    }

    @Override
    public int match(List<String> strings, String name) {
        return Util.match2(strings, name, this.caseSensitive);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.caseSensitive);
    }

    @Override
    public List<SqlOperator> lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax) {
        if (syntax != SqlSyntax.FUNCTION) {
            return ImmutableList.of();
        }
        Collection<Function> functions = this.getFunctionsFrom((List<String>)opName.names, (List<String>)ImmutableList.of());
        if (functions.isEmpty()) {
            return ImmutableList.of();
        }
        String name = Util.last(opName.names);
        return this.toOps(name, (ImmutableList<Function>)ImmutableList.copyOf(functions));
    }

    private List<SqlOperator> toOps(final String name, final ImmutableList<Function> functions) {
        return new AbstractList<SqlOperator>(){

            @Override
            public SqlOperator get(int index) {
                return OptiqCatalogReader.this.toOp(name, (Function)functions.get(index));
            }

            @Override
            public int size() {
                return functions.size();
            }
        };
    }

    private SqlOperator toOp(String name, Function function) {
        Table table;
        RelDataType returnType;
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        ArrayList<Object> dummyArguments = new ArrayList<Object>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
            typeFamilies.add(SqlTypeFamily.ANY);
            dummyArguments.add(this.zero(type));
        }
        if (function instanceof ScalarFunction) {
            returnType = ((ScalarFunction)function).getReturnType(this.typeFactory);
            table = null;
        } else if (function instanceof TableMacro) {
            table = ((TableMacro)function).apply(dummyArguments);
            returnType = this.typeFactory.createSqlType(SqlTypeName.CURSOR);
        } else {
            throw new AssertionError((Object)("unknown function type " + function));
        }
        return new SqlUserDefinedFunction(name, returnType, argTypes, typeFamilies, function, table);
    }

    private Object zero(RelDataType type) {
        RelDataTypeFactoryImpl.JavaType javaType;
        Primitive primitive;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (primitive = Primitive.of((Type)(javaType = (RelDataTypeFactoryImpl.JavaType)type).getJavaClass())) != null) {
            return primitive.defaultValue;
        }
        return null;
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }
}

