/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.ExplicitOperatorBinding;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlOperator {
    public static final String NL = System.getProperty("line.separator");
    protected static final int MDX_PRECEDENCE = 200;
    private final String name;
    public final SqlKind kind;
    private final int leftPrec;
    private final int rightPrec;
    private final SqlReturnTypeInference returnTypeInference;
    private final SqlOperandTypeInference operandTypeInference;
    private final SqlOperandTypeChecker operandTypeChecker;

    protected SqlOperator(String name, SqlKind kind, int leftPrecedence, int rightPrecedence, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        assert (kind != null);
        this.name = name;
        this.kind = kind;
        this.leftPrec = leftPrecedence;
        this.rightPrec = rightPrecedence;
        this.returnTypeInference = returnTypeInference;
        this.operandTypeInference = operandTypeInference;
        this.operandTypeChecker = operandTypeChecker;
    }

    protected SqlOperator(String name, SqlKind kind, int prec, boolean leftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        this(name, kind, SqlOperator.leftPrec(prec, leftAssoc), SqlOperator.rightPrec(prec, leftAssoc), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    protected static int leftPrec(int prec, boolean leftAssoc) {
        assert (prec % 2 == 0);
        if (!leftAssoc) {
            ++prec;
        }
        return prec;
    }

    protected static int rightPrec(int prec, boolean leftAssoc) {
        assert (prec % 2 == 0);
        if (leftAssoc) {
            ++prec;
        }
        return prec;
    }

    public SqlOperandTypeChecker getOperandTypeChecker() {
        return this.operandTypeChecker;
    }

    public SqlOperandCountRange getOperandCountRange() {
        if (this.operandTypeChecker != null) {
            return this.operandTypeChecker.getOperandCountRange();
        }
        throw Util.needToImplement(this);
    }

    public String getName() {
        return this.name;
    }

    public SqlKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.name;
    }

    public int getLeftPrec() {
        return this.leftPrec;
    }

    public int getRightPrec() {
        return this.rightPrec;
    }

    public abstract SqlSyntax getSyntax();

    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        pos = pos.plusAll(operands);
        return new SqlBasicCall(this, operands, pos, false, functionQualifier);
    }

    public final SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
        return this.createCall(null, pos, operands);
    }

    public final SqlCall createCall(SqlNodeList nodeList) {
        return this.createCall(null, nodeList.getParserPosition(), nodeList.toArray());
    }

    public final SqlCall createCall(SqlParserPos pos, List<? extends SqlNode> operandList) {
        return this.createCall(null, pos, operandList.toArray(new SqlNode[operandList.size()]));
    }

    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        return call;
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    protected void unparseListClause(SqlWriter writer, SqlNode clause) {
        this.unparseListClause(writer, clause, null);
    }

    protected void unparseListClause(SqlWriter writer, SqlNode clause, SqlKind sepKind) {
        if (clause instanceof SqlNodeList) {
            if (sepKind != null) {
                ((SqlNodeList)clause).andOrList(writer, sepKind);
            } else {
                ((SqlNodeList)clause).commaList(writer);
            }
        } else {
            clause.unparse(writer, 0, 0);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SqlOperator)) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        SqlOperator other = (SqlOperator)obj;
        return this.name.equals(other.name) && this.kind == other.kind;
    }

    public boolean isName(String testName) {
        return this.name.equals(testName);
    }

    public int hashCode() {
        return this.kind.hashCode() + this.name.hashCode();
    }

    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        for (SqlNode operand : call.getOperandList()) {
            operand.validateExpr(validator, operandScope);
        }
    }

    public final RelDataType validateOperands(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.preValidateCall(validator, scope, call);
        this.checkOperandCount(validator, this.operandTypeChecker, call);
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, call);
        this.checkOperandTypes(opBinding, true);
        RelDataType ret = this.inferReturnType(opBinding);
        validator.setValidatedNodeType(call, ret);
        return ret;
    }

    protected void preValidateCall(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        if (this.returnTypeInference != null) {
            return this.returnTypeInference.inferReturnType(opBinding);
        }
        throw Util.needToImplement(this);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            assert (nodeType != null);
        }
        RelDataType type = this.validateOperands(validator, scope, call);
        type = this.adjustType(validator, call, type);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        return type;
    }

    public final RelDataType inferReturnType(RelDataTypeFactory typeFactory, List<RelDataType> operandTypes) {
        return this.inferReturnType(new ExplicitOperatorBinding(typeFactory, this, operandTypes));
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (null == this.operandTypeChecker) {
            throw Util.needToImplement(this);
        }
        return this.operandTypeChecker.checkOperandTypes(callBinding, throwOnFailure);
    }

    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argType, SqlCall call) {
        SqlOperandCountRange od = call.getOperator().getOperandCountRange();
        if (od.isValidCount(call.operandCount())) {
            return;
        }
        if (od.getMin() == od.getMax()) {
            throw validator.newValidationError(call, Static.RESOURCE.invalidArgCount(call.getOperator().getName(), od.getMin()));
        }
        throw validator.newValidationError(call, Static.RESOURCE.wrongNumOfArguments());
    }

    public boolean validRexOperands(int count, boolean fail) {
        return true;
    }

    public String getSignatureTemplate(int operandsCount) {
        return null;
    }

    public final String getAllowedSignatures() {
        return this.getAllowedSignatures(this.name);
    }

    public String getAllowedSignatures(String opNameToUse) {
        assert (this.operandTypeChecker != null) : "If you see this, assign operandTypeChecker a value or override this function";
        return this.operandTypeChecker.getAllowedSignatures(this, opNameToUse).trim();
    }

    public SqlOperandTypeInference getOperandTypeInference() {
        return this.operandTypeInference;
    }

    public boolean isAggregator() {
        return this instanceof SqlAggFunction;
    }

    public <R> R acceptCall(SqlVisitor<R> visitor, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            if (operand == null) continue;
            operand.accept(visitor);
        }
        return null;
    }

    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        List<SqlNode> operands = call.getOperandList();
        for (int i = 0; i < operands.size(); ++i) {
            argHandler.visitChild(visitor, call, i, operands.get(i));
        }
    }

    public SqlReturnTypeInference getReturnTypeInference() {
        return this.returnTypeInference;
    }

    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean isDynamicFunction() {
        return false;
    }

    public boolean requiresDecimalExpansion() {
        return true;
    }

    public boolean argumentMustBeScalar(int ordinal) {
        return true;
    }
}

